/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ASTParserQueryTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTParserQueryTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.query");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseQueryValid() {
        String content = this.getContentFromPath("/data/ast/query/queryValid.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryDocumentation() {
        String content = this.getContentFromPath("/data/ast/query/queryDocumentation.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryDocumentation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryDocumentationDeprecated() {
        String content = this.getContentFromPath("/data/ast/query/queryDocumentationDeprecated.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryDocumentationDeprecated.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryTODO() {
        String content = this.getContentFromPath("/data/ast/query/queryDocumentationTODO.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryDocumentationTODO.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 1, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 0);
            this.checkASTDocumentationResolution(1, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryFIXME() {
        String content = this.getContentFromPath("/data/ast/query/queryDocumentationFIXME.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryDocumentationFIXME.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 1, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 0);
            this.checkASTDocumentationResolution(1, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryTODOFIXME() {
        String content = this.getContentFromPath("/data/ast/query/queryDocumentationTODOFIXME.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryDocumentationTODOFIXME.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 2, 0, 0);
            this.checkCST2ASTConvertion(2, 0, 0);
            this.checkASTResolution(2, 0, 0);
            this.checkASTDocumentationResolution(2, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMultipleDefinedTwice() {
        String content = this.getContentFromPath("/data/ast/query/queryMultipleDefinedTwice.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMultipleDefinedTwice.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMultipleDefinedTwiceWithDifferentReturnType() {
        String content = this.getContentFromPath("/data/ast/query/queryMultipleDefinedTwiceWithDifferentReturnType.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMultipleDefinedTwiceWithDifferentReturnType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMultipleDefinedTwiceWithDifferentBody() {
        String content = this.getContentFromPath("/data/ast/query/queryMultipleDefinedTwiceWithDifferentBody.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMultipleDefinedTwiceWithDifferentBody.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMultipleWithSameName() {
        String content = this.getContentFromPath("/data/ast/query/queryMultipleWithSameName.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMultipleWithSameName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidHeader() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidHeader.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidHeader.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
        content = this.getContentFromPath("/data/ast/query/queryInvalidHeader2.mtl");
        moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidHeader2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
        content = this.getContentFromPath("/data/ast/query/queryInvalidHeader3.mtl");
        moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidHeader3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingVisibility() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingVisibility.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingVisibility.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidVisibility() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidVisibility.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidVisibility.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingName() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingName.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryNamedQuery() {
        String content = this.getContentFromPath("/data/ast/query/queryNamedQuery.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryNamedQuery.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMultipleParametersWithSameName() {
        String content = this.getContentFromPath("/data/ast/query/queryMultipleParametersWithSameName.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMultipleParametersWithSameName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidParameterType() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidParameterType.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidParameterType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingParameterType() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingParameterType.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingParameterType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidParameterArea() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidParameterArea.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidParameterArea.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingColon() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingColon.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingColon.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidReturnType() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidReturnType.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidReturnType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingReturnType() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingReturnType.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingReturnType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingEqual() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingEqual.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingEqual.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryNameKeyword() {
        String content = this.getContentFromPath("/data/ast/query/queryNameKeyword.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryNameKeyword.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryParameterNameKeyword() {
        String content = this.getContentFromPath("/data/ast/query/queryParameterNameKeyword.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryParameterNameKeyword.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidForm() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidForm.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidForm.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidName() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidName.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryInvalidName2() {
        String content = this.getContentFromPath("/data/ast/query/queryInvalidName2.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryInvalidName2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 2);
            this.checkASTDocumentationResolution(0, 1, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingParenthesis() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingParenthesis.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingParenthesis.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 2);
            this.checkCST2ASTConvertion(0, 0, 2);
            this.checkASTResolution(0, 0, 3);
            this.checkASTDocumentationResolution(0, 0, 3);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingParenthesis2() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingParenthesis2.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingParenthesis2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryMissingParenthesis3() {
        String content = this.getContentFromPath("/data/ast/query/queryMissingParenthesis3.mtl");
        IFile moduleFile = ASTParserQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/query/files"), project, "queryMissingParenthesis3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }
}

