/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ASTParserMacroTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTParserMacroTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.macro");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseMacroValid() {
        String content = this.getContentFromPath("/data/ast/macro/macroValid.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroValid2() {
        String content = this.getContentFromPath("/data/ast/macro/macroValid2.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroValid2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroDocumentation() {
        String content = this.getContentFromPath("/data/ast/macro/macroDocumentation.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroDocumentation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroDocumentationDeprecated() {
        String content = this.getContentFromPath("/data/ast/macro/macroDocumentationDeprecated.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroDocumentationDeprecated.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidName() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidName.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroNamedMacro() {
        String content = this.getContentFromPath("/data/ast/macro/macroNamedMacro.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroNamedMacro.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroNameKeyword() {
        String content = this.getContentFromPath("/data/ast/macro/macroNameKeyword.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroNameKeyword.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroParamNameKeyword() {
        String content = this.getContentFromPath("/data/ast/macro/macroParamNameKeyword.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroParamNameKeyword.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidHeader() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidHeader.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidHeader.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidHeader2() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidHeader2.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidHeader2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidReturnType() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidReturnType.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidReturnType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidParamType() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidParamType.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidParamType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidParamName() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidParamName.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidParamName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingVisibility() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingVisibility.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingVisibility.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroInvalidVisibility() {
        String content = this.getContentFromPath("/data/ast/macro/macroInvalidVisibility.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroInvalidVisibility.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingName() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingName.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingReturnType() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingReturnType.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingReturnType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingParamName() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingParamName.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingParamName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingParamType() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingParamType.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingParamType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingParenthesis() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingParenthesis.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingParenthesis.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 2);
            this.checkASTDocumentationResolution(0, 1, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingParenthesis2() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingParenthesis2.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingParenthesis2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 2);
            this.checkCST2ASTConvertion(0, 0, 2);
            this.checkASTResolution(0, 0, 3);
            this.checkASTDocumentationResolution(0, 0, 3);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseMacroMissingParenthesis3() {
        String content = this.getContentFromPath("/data/ast/macro/macroMissingParenthesis3.mtl");
        IFile moduleFile = ASTParserMacroTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/macro/files"), project, "macroMissingParenthesis3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }
}

