/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ASTContextForTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTContextForTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.context.for");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParserContextForValid() {
        String content = this.getContentFromPath("/data/ast/context/forContextValid.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForValid2() {
        String content = this.getContentFromPath("/data/ast/context/forContextValid2.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextValid2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForValid3() {
        String content = this.getContentFromPath("/data/ast/context/forContextValid3.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextValid3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForValid4() {
        String content = this.getContentFromPath("/data/ast/context/forContextValid4.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextValid4.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForInvalid() {
        String content = this.getContentFromPath("/data/ast/context/forContextInvalid.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextInvalid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForInvalid2() {
        String content = this.getContentFromPath("/data/ast/context/forContextInvalid2.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextInvalid2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForInvalid3() {
        String content = this.getContentFromPath("/data/ast/context/forContextInvalid3.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextInvalid3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForInvalid4() {
        String content = this.getContentFromPath("/data/ast/context/forContextInvalid4.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextInvalid4.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForInvalid5() {
        String content = this.getContentFromPath("/data/ast/context/forContextInvalid5.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextInvalid5.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextForInvalid6() {
        String content = this.getContentFromPath("/data/ast/context/forContextInvalid6.mtl");
        IFile moduleFile = ASTContextForTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/for/files"), project, "forContextInvalid6.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }
}

