/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.maven;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParser;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProjectClasspathEntry;
import org.eclipse.acceleo.internal.parser.compiler.IAcceleoParserURIHandler;
import org.eclipse.acceleo.internal.parser.compiler.IParserListener;
import org.eclipse.acceleo.maven.AcceleoProject;
import org.eclipse.acceleo.maven.Entry;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoParserMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean useBinaryResources;
    private String uriHandler;
    private List<String> packagesToRegister;
    private AcceleoProject acceleoProject;
    private boolean usePlatformResourcePath;
    private boolean trimPosition;
    private boolean failOnError = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Acceleo maven stand alone build...");
        log.info((CharSequence)"Starting packages registration...");
        URLClassLoader newLoader = null;
        try {
            String str;
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            List compileClasspathElements = this.project.getCompileClasspathElements();
            URL[] runtimeUrls = new URL[runtimeClasspathElements.size() + compileClasspathElements.size()];
            int i = 0;
            for (Object e : runtimeClasspathElements) {
                if (e instanceof String) {
                    str = (String)e;
                    log.debug((CharSequence)("Adding the runtime dependency " + str + " to the classloader for the package resolution"));
                    runtimeUrls[i] = new File(str).toURI().toURL();
                    ++i;
                    continue;
                }
                log.debug((CharSequence)("Runtime classpath entry is not a string: " + e));
            }
            for (Object e : compileClasspathElements) {
                if (e instanceof String) {
                    str = (String)e;
                    log.debug((CharSequence)("Adding the compilation dependency " + str + " to the classloader for the package resolution"));
                    runtimeUrls[i] = new File(str).toURI().toURL();
                    ++i;
                    continue;
                }
                log.debug((CharSequence)("Runtime classpath entry is not a string: " + e));
            }
            newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            log.error((Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((Throwable)e);
        }
        for (String packageToRegister : this.packagesToRegister) {
            try {
                if (newLoader == null) continue;
                Class<?> forName = Class.forName(packageToRegister, true, newLoader);
                Field nsUri = forName.getField("eNS_URI");
                Field eInstance = forName.getField("eINSTANCE");
                Object object = nsUri.get(null);
                if (object instanceof String) {
                    log.info((CharSequence)("Registering package '" + packageToRegister + "'."));
                    AcceleoPackageRegistry.INSTANCE.put((String)object, eInstance.get(null));
                    continue;
                }
                log.error((CharSequence)"The URI field is not a string.");
            }
            catch (ClassNotFoundException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
            catch (SecurityException e) {
                log.error((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                log.error((Throwable)e);
            }
        }
        log.info((CharSequence)("Starting the build sequence for the project '" + this.acceleoProject.getRoot() + "'..."));
        log.info((CharSequence)"Mapping the pom.xml to AcceleoProject...");
        Preconditions.checkNotNull((Object)this.acceleoProject);
        Preconditions.checkNotNull((Object)this.acceleoProject.getRoot());
        Preconditions.checkNotNull(this.acceleoProject.getEntries());
        Preconditions.checkState((this.acceleoProject.getEntries().size() >= 1 ? 1 : 0) != 0);
        File root = this.acceleoProject.getRoot();
        org.eclipse.acceleo.internal.parser.compiler.AcceleoProject aProject = new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject(root);
        List<Entry> entries = this.acceleoProject.getEntries();
        LinkedHashSet<AcceleoProjectClasspathEntry> classpathEntries = new LinkedHashSet<AcceleoProjectClasspathEntry>();
        for (Entry entry : entries) {
            File inputDirectory = new File(root, entry.getInput());
            File outputDirectory = new File(root, entry.getOutput());
            log.debug((CharSequence)("Input: " + inputDirectory.getAbsolutePath()));
            log.debug((CharSequence)("Output: " + outputDirectory.getAbsolutePath()));
            AcceleoProjectClasspathEntry classpathEntry = new AcceleoProjectClasspathEntry(inputDirectory, outputDirectory);
            classpathEntries.add(classpathEntry);
        }
        aProject.addClasspathEntries(classpathEntries);
        List<AcceleoProject> dependencies = this.acceleoProject.getDependencies();
        if (dependencies != null) {
            for (AcceleoProject dependingAcceleoProject : dependencies) {
                File dependingProjectRoot = dependingAcceleoProject.getRoot();
                Preconditions.checkNotNull((Object)dependingProjectRoot);
                org.eclipse.acceleo.internal.parser.compiler.AcceleoProject aDependingProject = new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject(dependingProjectRoot);
                List<Entry> dependingProjectEntries = dependingAcceleoProject.getEntries();
                LinkedHashSet<AcceleoProjectClasspathEntry> dependingClasspathEntries = new LinkedHashSet<AcceleoProjectClasspathEntry>();
                for (Entry entry : dependingProjectEntries) {
                    File inputDirectory = new File(root, entry.getInput());
                    File outputDirectory = new File(root, entry.getOutput());
                    AcceleoProjectClasspathEntry classpathEntry = new AcceleoProjectClasspathEntry(inputDirectory, outputDirectory);
                    dependingClasspathEntries.add(classpathEntry);
                }
                aDependingProject.addClasspathEntries(dependingClasspathEntries);
                aProject.addProjectDependencies((Set)Sets.newHashSet((Object[])new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject[]{aDependingProject}));
            }
        }
        log.info((CharSequence)"Adding jar dependencies...");
        List<String> list = this.acceleoProject.getJars();
        if (list != null) {
            LinkedHashSet<URI> newDependencies = new LinkedHashSet<URI>();
            for (String jar : list) {
                log.info((CharSequence)("Resolving jar: '" + jar + "'..."));
                boolean jarFound = false;
                File jarFile = new File(jar);
                if (jarFile.isFile()) {
                    URI uri = URI.createFileURI((String)jar);
                    newDependencies.add(uri);
                    jarFound = true;
                    log.info((CharSequence)("Found jar for '" + jar + "' on the filesystem: '" + jarFile.getAbsolutePath() + "'."));
                } else {
                    StringTokenizer tok = new StringTokenizer(jar, ":");
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    int c = 0;
                    while (tok.hasMoreTokens()) {
                        String nextToken = tok.nextToken();
                        if (c == 0) {
                            groupId = nextToken;
                        } else if (c == 1) {
                            artifactId = nextToken;
                        } else if (c == 2) {
                            version = nextToken;
                        }
                        ++c;
                    }
                    List<URI> urisFromArtifacts = this.getURIsFromArtifacts(groupId, artifactId, version, jar);
                    if (urisFromArtifacts.size() > 0) {
                        jarFound = true;
                    }
                    newDependencies.addAll(urisFromArtifacts);
                    List<URI> urisFromDependencies = this.getURIsFromDependencies(groupId, artifactId, version, jar);
                    if (urisFromDependencies.size() > 0) {
                        jarFound = true;
                    }
                    newDependencies.addAll(urisFromDependencies);
                    this.getLog().debug((CharSequence)"Additional dependencies added from jars...");
                    for (URI uri : newDependencies) {
                        this.getLog().debug((CharSequence)uri.toString());
                    }
                }
                if (jarFound) continue;
                throw new MojoExecutionException("The jar " + jar + " has not been found on the dependencies available.");
            }
            aProject.addDependencies(newDependencies);
        }
        log.info((CharSequence)"Starting parsing...");
        AcceleoParser parser = new AcceleoParser(aProject, this.useBinaryResources, this.usePlatformResourcePath, this.trimPosition);
        AcceleoParserListener listener = new AcceleoParserListener();
        parser.addListeners(new IParserListener[]{listener});
        if (this.uriHandler != null && newLoader != null) {
            try {
                Class<?> forName = Class.forName(this.uriHandler, true, newLoader);
                Object newInstance = forName.newInstance();
                if (newInstance instanceof IAcceleoParserURIHandler) {
                    IAcceleoParserURIHandler resolver = (IAcceleoParserURIHandler)newInstance;
                    parser.setURIHandler(resolver);
                }
            }
            catch (ClassNotFoundException e) {
                log.error((Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
        }
        Set builtFiles = parser.buildAll((Monitor)new BasicMonitor());
        boolean errorFound = false;
        for (File builtFile : builtFiles) {
            Collection problems = parser.getProblems(builtFile);
            Collection warnings = parser.getWarnings(builtFile);
            if (problems.size() > 0) {
                log.info((CharSequence)("Errors for file '" + builtFile.getName() + "': " + problems));
                errorFound = true;
            }
            if (warnings.size() <= 0) continue;
            log.info((CharSequence)("Warnings for file '" + builtFile.getName() + "': " + warnings));
        }
        if (errorFound && this.failOnError) {
            throw new MojoExecutionException("Errors have been found during the build of the generator");
        }
        AcceleoPackageRegistry.INSTANCE.clear();
        log.info((CharSequence)"Build completed.");
    }

    private List<URI> getURIsFromArtifacts(String groupId, String artifactId, String version, String jar) {
        ArrayList<URI> dependencies = new ArrayList<URI>();
        Set artifacts = this.project.getArtifacts();
        for (Object object : artifacts) {
            URI uri;
            File artifactFile;
            if (!(object instanceof Artifact)) continue;
            Artifact artifact = (Artifact)object;
            this.getLog().debug((CharSequence)("Trying to match the jar required with " + artifact.getGroupId() + " : " + artifact.getArtifactId()));
            if (groupId == null || !groupId.equals(artifact.getGroupId()) || artifactId == null || !artifactId.equals(artifact.getArtifactId())) continue;
            if (version != null && version.equals(artifact.getVersion())) {
                artifactFile = artifact.getFile();
                if (artifactFile == null || !artifactFile.exists()) continue;
                uri = URI.createFileURI((String)artifactFile.getAbsolutePath());
                dependencies.add(uri);
                this.getLog().info((CharSequence)("Found jar for '" + jar + "' on the filesystem: '" + uri.toString() + "'."));
                continue;
            }
            if (version != null || (artifactFile = artifact.getFile()) == null || !artifactFile.exists()) continue;
            uri = URI.createFileURI((String)artifactFile.getAbsolutePath());
            dependencies.add(uri);
            this.getLog().info((CharSequence)("Found jar for '" + jar + "' on the filesystem: '" + uri.toString() + "'."));
        }
        return dependencies;
    }

    private List<URI> getURIsFromDependencies(String groupId, String artifactId, String version, String jar) {
        ArrayList<URI> dependencies = new ArrayList<URI>();
        List mavenDependencies = this.project.getDependencies();
        for (Object object : mavenDependencies) {
            URI uri;
            String systemPath;
            if (!(object instanceof Dependency)) continue;
            Dependency dependency = (Dependency)object;
            this.getLog().debug((CharSequence)("Trying to match the jar required with " + dependency.getGroupId() + " : " + dependency.getArtifactId()));
            if (groupId == null || !groupId.equals(dependency.getGroupId()) || artifactId == null || !artifactId.equals(dependency.getArtifactId())) continue;
            if (version != null && version.equals(dependency.getVersion())) {
                systemPath = dependency.getSystemPath();
                if (systemPath == null || !new File(systemPath).exists()) continue;
                uri = URI.createFileURI((String)systemPath);
                dependencies.add(uri);
                this.getLog().info((CharSequence)("Found jar for '" + jar + "' on the filesystem: '" + uri.toString() + "'."));
                continue;
            }
            if (version != null || (systemPath = dependency.getSystemPath()) == null || !new File(systemPath).exists()) continue;
            uri = URI.createFileURI((String)systemPath);
            dependencies.add(uri);
            this.getLog().info((CharSequence)("Found jar for '" + jar + "' on the filesystem: '" + uri.toString() + "'."));
        }
        return dependencies;
    }

    private class AcceleoParserListener
    implements IParserListener {
        private AcceleoParserListener() {
        }

        public void endBuild(File arg0) {
        }

        public void fileSaved(File arg0) {
            AcceleoParserMojo.this.getLog().info((CharSequence)("Saving ouput file for '" + arg0.getAbsolutePath() + "'."));
        }

        public void loadDependency(File arg0) {
        }

        public void loadDependency(URI arg0) {
        }

        public void startBuild(File arg0) {
        }
    }
}

