/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.maven.launcher.compatibility;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class AcceleoLauncherMojo
extends AbstractMojo {
    private MavenProject project;
    private String generatorClass;
    private String model;
    private String outputFolder;
    private List<String> parameters;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Acceleo maven stand alone generation...");
        log.info((CharSequence)"Starting generator class loading...");
        URLClassLoader newLoader = null;
        try {
            String str;
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            List compileClasspathElements = this.project.getCompileClasspathElements();
            URL[] runtimeUrls = new URL[runtimeClasspathElements.size() + compileClasspathElements.size()];
            int i = 0;
            for (Object object : runtimeClasspathElements) {
                if (object instanceof String) {
                    str = (String)object;
                    log.debug((CharSequence)("Adding the runtime dependency " + str + " to the classloader for the package resolution"));
                    runtimeUrls[i] = new File(str).toURI().toURL();
                    ++i;
                    continue;
                }
                log.debug((CharSequence)("Runtime classpath entry is not a string: " + object));
            }
            for (Object object : compileClasspathElements) {
                if (object instanceof String) {
                    str = (String)object;
                    log.debug((CharSequence)("Adding the compilation dependency " + str + " to the classloader for the package resolution"));
                    runtimeUrls[i] = new File(str).toURI().toURL();
                    ++i;
                    continue;
                }
                log.debug((CharSequence)("Runtime classpath entry is not a string: " + object));
            }
            newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            log.error((Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((Throwable)e);
        }
        try {
            if (newLoader != null) {
                Class<?> generatorClazz = Class.forName(this.generatorClass, true, newLoader);
                log.info((CharSequence)("Starting the generation sequence for the generator '" + this.generatorClass + "'..."));
                Method mainMethod = generatorClazz.getMethod("main", String[].class);
                ArrayList<String> arguments = new ArrayList<String>(this.parameters.size() + 2);
                log.info((CharSequence)("Model: '" + this.model + "'"));
                arguments.add(this.model);
                log.info((CharSequence)("Output folder: '" + this.outputFolder + "'"));
                arguments.add(this.outputFolder);
                for (String parameter : this.parameters) {
                    log.info((CharSequence)("Parameter: '" + parameter + "'"));
                    arguments.add(parameter);
                }
                log.info((CharSequence)"Invoking generator.");
                mainMethod.invoke(null, new Object[]{arguments.toArray(new String[arguments.size()])});
                log.info((CharSequence)"Generation completed.");
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Throwable)e);
        }
    }
}

