/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.actions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ComputeGenerationStatisticsAction
implements IObjectActionDelegate {
    private IStructuredSelection structuredSelection;

    public void run(IAction action) {
        final ArrayList<IContainer> containerToAnalyze = new ArrayList<IContainer>();
        for (Object next : this.structuredSelection) {
            if (next instanceof IContainer) {
                containerToAnalyze.add((IContainer)next);
                continue;
            }
            if (!(next instanceof IFile)) continue;
            containerToAnalyze.add(((IFile)next).getParent());
        }
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                for (IContainer iContainer : containerToAnalyze) {
                    final ArrayList<IContainer> containers = new ArrayList<IContainer>();
                    try {
                        iContainer.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource instanceof IContainer) {
                                    containers.add((IContainer)resource);
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                    ComputeGenerationStatisticsAction.this.computeStatisticReport(iContainer, containers, monitor);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (InterruptedException e) {
            AcceleoUIActivator.log(e, true);
        }
    }

    private void computeStatisticReport(IContainer outputFolder, List<IContainer> containersToAnalyze, IProgressMonitor monitor) {
        ArrayList<StatisticEntry> statisticEntries = new ArrayList<StatisticEntry>();
        Collections.sort(containersToAnalyze, new Comparator<IContainer>(){

            @Override
            public int compare(IContainer arg0, IContainer arg1) {
                return arg0.getFullPath().toString().compareTo(arg1.getFullPath().toString());
            }
        });
        for (IContainer iContainer : containersToAnalyze) {
            String path = iContainer.getFullPath().toString();
            int linesOfCode = 0;
            int linesOfUserCode = 0;
            IResource[] members = new IResource[]{};
            try {
                members = iContainer.members();
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
            int numerOfFiles = 0;
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                block32: {
                    IResource iResource = iResourceArray[n2];
                    if (iResource instanceof IFile) {
                        IFile iFile = (IFile)iResource;
                        ++numerOfFiles;
                        FileInputStream fileInputStream = null;
                        InputStreamReader inputStreamReader = null;
                        BufferedReader bufferedReader = null;
                        try {
                            fileInputStream = new FileInputStream(iFile.getLocation().toFile());
                            inputStreamReader = new InputStreamReader(fileInputStream);
                            bufferedReader = new BufferedReader(inputStreamReader);
                            boolean isUserCode = false;
                            String strLine = "";
                            while ((strLine = bufferedReader.readLine()) != null) {
                                ++linesOfCode;
                                if (strLine.contains(AcceleoEngineMessages.getString((String)"usercode.start"))) {
                                    isUserCode = true;
                                } else if (strLine.contains(AcceleoEngineMessages.getString((String)"usercode.end"))) {
                                    isUserCode = false;
                                }
                                if (!isUserCode || strLine.contains(AcceleoEngineMessages.getString((String)"usercode.start"))) continue;
                                ++linesOfUserCode;
                            }
                        }
                        catch (FileNotFoundException e) {
                            AcceleoUIActivator.log(e, true);
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (IOException e2) {
                                    AcceleoUIActivator.log(e2, true);
                                }
                            }
                            break block32;
                        }
                        catch (IOException e) {
                            try {
                                AcceleoUIActivator.log(e, true);
                                break block32;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (bufferedReader != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (IOException e3) {
                                        AcceleoUIActivator.log(e3, true);
                                    }
                                }
                            }
                        }
                        if (bufferedReader == null) break block32;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e) {
                            AcceleoUIActivator.log(e, true);
                        }
                    }
                }
                ++n2;
            }
            if (numerOfFiles <= 0) continue;
            statisticEntries.add(new StatisticEntry(path, linesOfCode, linesOfUserCode));
        }
        if (!monitor.isCanceled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Path,Lines of code,Lines of code generated,Lines of user code, Percentage of generated code");
            buffer.append(System.getProperty("line.separator"));
            for (StatisticEntry statisticEntry : statisticEntries) {
                buffer.append(String.valueOf(statisticEntry.toString()) + System.getProperty("line.separator"));
            }
            IFile csvFile = outputFolder.getFile((IPath)new Path("acceleo_statistics.csv"));
            try {
                if (!csvFile.exists()) {
                    csvFile.create((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, monitor);
                } else {
                    csvFile.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, true, monitor);
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public class StatisticEntry {
        private String path;
        private int linesOfCode;
        private int linesOfUserCode;

        public StatisticEntry(String path, int linesOfCode, int linesOfUserCode) {
            this.path = path;
            this.linesOfCode = linesOfCode;
            this.linesOfUserCode = linesOfUserCode;
        }

        public String getPath() {
            return this.path;
        }

        public int getLinesOfCode() {
            return this.linesOfCode;
        }

        public int getLinesOfCodeGenerated() {
            return this.linesOfCode - this.linesOfUserCode;
        }

        public int getLinesOfUserCode() {
            return this.linesOfUserCode;
        }

        public double getPercentageOfGeneratedCode() {
            if (Double.valueOf(this.linesOfCode) * Double.valueOf(this.getLinesOfCodeGenerated()) > 0.0) {
                return 100.0 / Double.valueOf(this.linesOfCode) * Double.valueOf(this.getLinesOfCodeGenerated());
            }
            return 0.0;
        }

        public String toString() {
            return String.valueOf(this.getPath()) + ',' + this.getLinesOfCode() + ',' + this.getLinesOfCodeGenerated() + ',' + this.getLinesOfUserCode() + ",\"" + String.format("%.2f", this.getPercentageOfGeneratedCode()) + "\"";
        }
    }
}

