/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicTemplatesEclipseUtil;
import org.eclipse.acceleo.engine.internal.utils.DynamicModuleContribution;

public final class AcceleoDynamicTemplatesRegistry {
    public static final AcceleoDynamicTemplatesRegistry INSTANCE = new AcceleoDynamicTemplatesRegistry();
    private final Set<URL> registeredModules = new CompactLinkedHashSet();

    private AcceleoDynamicTemplatesRegistry() {
    }

    public boolean addModule(URL module) {
        return this.registeredModules.add(module);
    }

    public boolean addModules(Collection<URL> modules) {
        return this.registeredModules.addAll(modules);
    }

    public void addModulesFrom(File file) {
        if (file.exists() && file.canRead()) {
            if (file.isDirectory()) {
                File[] children;
                File[] fileArray = children = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.getAbsolutePath().matches("^.*(CVS|\\\\.svn)$");
                    }
                });
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.addModulesFrom(child);
                    ++n2;
                }
            } else if ("emtl".equals(file.getPath().substring(file.getPath().lastIndexOf(46) + 1))) {
                try {
                    this.addModule(file.toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void clearRegistryResourceSet() {
        this.registeredModules.clear();
    }

    public Set<URL> getRegisteredModules() {
        CompactLinkedHashSet compound = new CompactLinkedHashSet();
        Set<DynamicModuleContribution> modules = AcceleoDynamicTemplatesEclipseUtil.getRegisteredModules();
        for (DynamicModuleContribution dynamicModuleContribution : modules) {
            compound.addAll(dynamicModuleContribution.getFiles());
        }
        compound.addAll(this.registeredModules);
        return compound;
    }

    public Set<URL> getRegisteredModules(String generatorID) {
        CompactLinkedHashSet compound = new CompactLinkedHashSet();
        Set<DynamicModuleContribution> modules = AcceleoDynamicTemplatesEclipseUtil.getRegisteredModules(generatorID);
        for (DynamicModuleContribution dynamicModuleContribution : modules) {
            List<String> generatorIDs = dynamicModuleContribution.getGeneratorIDs();
            if (generatorIDs.size() > 0) {
                for (String genID : generatorIDs) {
                    if (!genID.equals(generatorID)) continue;
                    compound.addAll(dynamicModuleContribution.getFiles());
                }
                continue;
            }
            compound.addAll(dynamicModuleContribution.getFiles());
        }
        compound.addAll(this.registeredModules);
        return compound;
    }

    public boolean removeModule(File module) {
        return this.registeredModules.remove(module);
    }

    public boolean removeModules(Collection<File> modules) {
        return this.registeredModules.removeAll(modules);
    }
}

