/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.statements;

import org.eclipse.acceleo.compatibility.model.mt.expressions.Call;
import org.eclipse.acceleo.compatibility.model.mt.expressions.CallSet;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Parenthesis;
import org.eclipse.acceleo.compatibility.model.mt.statements.If;
import org.eclipse.acceleo.compatibility.model.mt.statements.Text;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.IfParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class IfParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyString() {
        String buffer = "";
        try {
            IfParser.createIf((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException.");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testIfThenString() {
        String buffer = " (call) {%>text<%}%>";
        try {
            If eIf = IfParser.createIf((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"Should have a Parenthesis containing a CallSet containing a Call named \"call\" as condition.", (Object)"call", (Object)((Call)((CallSet)((Parenthesis)eIf.getCondition()).getExpression()).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Should have a Text with value \"text\" as then statement.", (Object)"text", (Object)((Text)eIf.getThenStatements().get(0)).getValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)eIf.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)eIf.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIfThenElseString() {
        String buffer = " (call) {%>text<%}else{%>textElse<%}%>";
        try {
            If eIf = IfParser.createIf((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"Should have a Parenthesis containing a CallSet containing a Call named \"call\" as condition.", (Object)"call", (Object)((Call)((CallSet)((Parenthesis)eIf.getCondition()).getExpression()).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Should have a Text with value \"text\" as then statement.", (Object)"text", (Object)((Text)eIf.getThenStatements().get(0)).getValue());
            Assert.assertEquals((String)"Should have a Text with value \"textElse\" as else statement.", (Object)"textElse", (Object)((Text)eIf.getElseStatements().get(0)).getValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)eIf.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)eIf.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIfThenElseElseIfString() {
        String buffer = " (call) {%>text<%}else if (call2){%>textElseIf<%}else{%>textElse<%}%>";
        try {
            If eIf = IfParser.createIf((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"Should have a Parenthesis containing a CallSet containing a Call named \"call\" as condition.", (Object)"call", (Object)((Call)((CallSet)((Parenthesis)eIf.getCondition()).getExpression()).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Should have a Text with value \"text\" as then statement.", (Object)"text", (Object)((Text)eIf.getThenStatements().get(0)).getValue());
            Assert.assertEquals((String)"Should have a Text with value \"textElse\" as else statement.", (Object)"textElse", (Object)((Text)eIf.getElseStatements().get(0)).getValue());
            If eElseIf = (If)eIf.getElseIf().get(0);
            Assert.assertEquals((String)"ElseIf should have a Parenthesis containing a CallSet containing a Call named \"call2\" as condition.", (Object)"call2", (Object)((Call)((CallSet)((Parenthesis)eElseIf.getCondition()).getExpression()).getCalls().get(0)).getName());
            Assert.assertEquals((String)"ElseIf should have a Text with value \"textElseIf\" as then statement.", (Object)"textElseIf", (Object)((Text)eElseIf.getThenStatements().get(0)).getValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)eIf.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)eIf.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

