/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.expressions.Operator;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.OperatorParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class OperatorParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyString() {
        String buffer = "";
        try {
            OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testNoOperands() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = TemplateConstants.getDefault().getOperators()[i];
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)"Should be null.", null, (Object)op);
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testOneBeforOperand() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = "1" + TemplateConstants.getDefault().getOperators()[i];
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)"Should be null.", null, (Object)op);
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testOneAfterOperand() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = String.valueOf(TemplateConstants.getDefault().getOperators()[i]) + "1";
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)"Should be null.", null, (Object)op);
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testWithOperands() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = "1" + TemplateConstants.getDefault().getOperators()[i] + "1" + TemplateConstants.getDefault().getOperators()[i] + "1";
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)("Should be an " + TemplateConstants.getDefault().getOperators()[i] + "."), (Object)TemplateConstants.getDefault().getOperators()[i], (Object)op.getOperator());
                Assert.assertEquals((String)"Should have 3 operands.", (long)3L, (long)op.getOperands().size());
                Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)op.getBegin());
                Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)op.getEnd());
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testMissingLastOperand() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = "1" + TemplateConstants.getDefault().getOperators()[i] + "1" + TemplateConstants.getDefault().getOperators()[i];
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)("Should be an " + TemplateConstants.getDefault().getOperators()[i] + "."), (Object)TemplateConstants.getDefault().getOperators()[i], (Object)op.getOperator());
                Assert.assertEquals((String)"Should have 2 operands.", (long)2L, (long)op.getOperands().size());
                Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)op.getBegin());
                Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)op.getEnd());
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testMissingFirstOperand() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = String.valueOf(TemplateConstants.getDefault().getOperators()[i]) + "1" + TemplateConstants.getDefault().getOperators()[i] + "1";
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)("Should be an " + TemplateConstants.getDefault().getOperators()[i] + "."), (Object)TemplateConstants.getDefault().getOperators()[i], (Object)op.getOperator());
                Assert.assertEquals((String)"Should have 2 operands.", (long)2L, (long)op.getOperands().size());
                Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)op.getBegin());
                Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)op.getEnd());
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testMissingMiddleOperand() {
        int i = 0;
        while (i < TemplateConstants.getDefault().getOperators().length) {
            String buffer = "1" + TemplateConstants.getDefault().getOperators()[i] + TemplateConstants.getDefault().getOperators()[i] + "1";
            try {
                Operator op = OperatorParser.createOperator((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
                Assert.assertEquals((String)("Should be an " + TemplateConstants.getDefault().getOperators()[i] + "."), (Object)TemplateConstants.getDefault().getOperators()[i], (Object)op.getOperator());
                Assert.assertEquals((String)"Should have 2 operands.", (long)2L, (long)op.getOperands().size());
                Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)op.getBegin());
                Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)op.getEnd());
            }
            catch (TemplateSyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }
}

