/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.expressions.Call;
import org.eclipse.acceleo.compatibility.model.mt.expressions.CallSet;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.CallSetParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class CallSetParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyCallSet() {
        String buffer = "";
        try {
            CallSetParser.createCallSet((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testCallSetWithEmptyCall() {
        String buffer = "call1..call3";
        try {
            CallSet calls = CallSetParser.createCallSet((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"The callSet should contain 2 calls.", (long)2L, (long)calls.getCalls().size());
            Assert.assertEquals((String)"Call #1 should be \"call1\"", (Object)"call1", (Object)((Call)calls.getCalls().get(0)).getName());
            Assert.assertEquals((String)"Call #2 should be \"call3\"", (Object)"call3", (Object)((Call)calls.getCalls().get(1)).getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)calls.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)calls.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCallSetWithOutEmptyCall() {
        String buffer = "call1.call2.call3";
        try {
            CallSet calls = CallSetParser.createCallSet((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"The callSet should contain 3 calls.", (long)3L, (long)calls.getCalls().size());
            Assert.assertEquals((String)"Call #1 should be \"call1\"", (Object)"call1", (Object)((Call)calls.getCalls().get(0)).getName());
            Assert.assertEquals((String)"Call #2 should be \"call2\"", (Object)"call2", (Object)((Call)calls.getCalls().get(1)).getName());
            Assert.assertEquals((String)"Call #3 should be \"call3\"", (Object)"call3", (Object)((Call)calls.getCalls().get(2)).getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)calls.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)calls.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

