/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import org.eclipse.acceleo.internal.compatibility.mtl.gen.Mt2mtl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public abstract class AbstractAcceleoTest {
    protected final Bundle bundle = Platform.getBundle((String)"org.eclipse.acceleo.compatibility.tests");
    protected String errorMessageForCompareDirectoriesMethod = "I/O exception while comparing reference and generated directories";
    protected String emtlModel;
    protected String mtlExpected;
    protected File generationRoot;
    protected File emtlModelRoot;
    protected File mtlExpectedRoot;
    protected final URL pluginRoot = this.bundle.getEntry("/");
    protected File expectedRoot;
    protected String referenceRootPath;
    protected final ResourceSet resourceSet = new ResourceSetImpl();

    protected static String getAbsoluteFileContent(String fileName) throws IOException {
        return AbstractAcceleoTest.getAbsoluteFileContent(fileName, null);
    }

    protected static String getAbsoluteFileContent(String fileName, String charset) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            InputStreamReader reader;
            if (charset != null) {
                FileInputStream inputStream = new FileInputStream(fileName);
                reader = new InputStreamReader((InputStream)inputStream, charset);
            } else {
                reader = new FileReader(fileName);
            }
            bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            while (line != null) {
                buffer.append(line);
                line = bufferedReader.readLine();
            }
        }
        return buffer.toString();
    }

    public abstract String getTestName();

    public String getResultPath() {
        return "/data/" + this.getTestName() + "/mtlGenerated";
    }

    public String getMtlExpectedPath() {
        return "/data/" + this.getTestName() + "/mtlExpected";
    }

    public String getEmtlModelPath() {
        return "/data/" + this.getTestName() + "/emt/chain.emt";
    }

    protected void cleanMtlGenerationRoot() {
        try {
            File file = new File(this.getMtlTargetRootPath());
            if (file.isDirectory()) {
                File[] children;
                File[] fileArray = children = this.getFiles(file);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.deleteFile(child);
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected void generateEmt() {
        URI model = null;
        File folder = this.generationRoot;
        try {
            model = URI.createFileURI((String)this.getEmtlModelRootPath());
            ArrayList arguments = new ArrayList();
            Mt2mtl mt2mtl = new Mt2mtl(model, folder, arguments);
            mt2mtl.doGenerate(null);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void genericTest() throws IOException {
        this.generationRoot = new File(this.getMtlTargetRootPath());
        this.mtlExpectedRoot = new File(this.getMtlExpectedRootPath());
        this.cleanMtlGenerationRoot();
        try {
            this.generateEmt();
            this.compareDirectories(this.mtlExpectedRoot, this.generationRoot);
        }
        catch (IOException e) {
            Assert.fail((String)this.errorMessageForCompareDirectoriesMethod);
        }
    }

    protected File[] getFiles(File directory) {
        if (!directory.exists()) {
            return new File[0];
        }
        File[] children = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getAbsolutePath().matches("^.*(CVS|\\\\.svn)$");
            }
        });
        return children;
    }

    protected void compareDirectories(File refDir, File genDir) throws IOException {
        boolean compared = false;
        File[] children = this.getFiles(refDir);
        File refDirChild = null;
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                String dir2fileName = String.valueOf(genDir.getAbsolutePath()) + File.separator + child.getName();
                if (child.isDirectory()) {
                    refDirChild = new File(dir2fileName);
                    if (refDirChild.exists()) {
                        this.compareDirectories(child, refDirChild);
                        compared = true;
                    } else {
                        compared = false;
                    }
                } else if (!child.getName().endsWith("emtl")) {
                    Assert.assertEquals((String)dir2fileName, (Object)this.deleteWhitespaces(AbstractAcceleoTest.getAbsoluteFileContent(child.getAbsolutePath())), (Object)this.deleteWhitespaces(AbstractAcceleoTest.getAbsoluteFileContent(dir2fileName)));
                    compared = true;
                } else {
                    compared = true;
                }
                ++n2;
            }
        }
        if (!compared) {
            Assert.fail((String)("The reference at " + refDir.getAbsolutePath() + " isn't the same of result at " + genDir.getAbsolutePath()));
        }
    }

    private String deleteWhitespaces(String text) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    protected File createFile(String pathName) {
        try {
            String fileLocation = FileLocator.resolve((URL)this.bundle.getEntry(pathName)).getPath();
            return new File(fileLocation);
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.getMessage());
        }
    }

    protected URI createFileURI(String pathName) {
        try {
            String fileLocation = FileLocator.resolve((URL)this.bundle.getEntry(pathName)).getPath();
            return URI.createFileURI((String)fileLocation);
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.getMessage());
        }
    }

    protected String getMtlTargetRootPath() throws IOException {
        return String.valueOf(FileLocator.resolve((URL)this.pluginRoot).getFile()) + this.getResultPath();
    }

    protected String getMtlExpectedRootPath() throws IOException {
        return String.valueOf(FileLocator.resolve((URL)this.pluginRoot).getFile()) + this.getMtlExpectedPath();
    }

    protected String getEmtlModelRootPath() throws IOException {
        return String.valueOf(FileLocator.resolve((URL)this.pluginRoot).getFile()) + "/" + this.getEmtlModelPath();
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = this.getFiles(file);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteFile(child);
                ++n2;
            }
        } else {
            file.delete();
        }
    }
}

