/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.expressions.Call;
import org.eclipse.acceleo.compatibility.model.mt.expressions.CallSet;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Parenthesis;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ParenthesisParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class ParenthesisParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyString() {
        String buffer = "";
        try {
            ParenthesisParser.createParenthesis((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testNotParenthesisExpression() {
        String buffer = "call";
        try {
            Parenthesis parenthesis = ParenthesisParser.createParenthesis((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"Should be null.", null, (Object)parenthesis);
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParenthesisExpression() {
        String buffer = String.valueOf(TemplateConstants.getDefault().getParenth()[0]) + "call" + TemplateConstants.getDefault().getParenth()[1];
        try {
            Parenthesis parenthesis = ParenthesisParser.createParenthesis((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"Should containt a call named \"call\".", (Object)"call", (Object)((Call)((CallSet)parenthesis.getExpression()).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)parenthesis.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)parenthesis.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

