/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.expressions.BooleanLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.DoubleLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.IntegerLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Literal;
import org.eclipse.acceleo.compatibility.model.mt.expressions.NullLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.StringLiteral;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.LiteralParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class LiteralParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyString() {
        String buffer = "";
        try {
            LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyLiteral() {
        String buffer = String.valueOf(TemplateConstants.getDefault().getLiteral()[0]) + TemplateConstants.getDefault().getLiteral()[1];
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a StringLiteral", (boolean)StringLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be an empty string.", (Object)"", (Object)((StringLiteral)literal).getValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStringLiteral() {
        String buffer = String.valueOf(TemplateConstants.getDefault().getLiteral()[0]) + "MyString" + TemplateConstants.getDefault().getLiteral()[1];
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a StringLiteral", (boolean)StringLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be \"MyString\".", (Object)"MyString", (Object)((StringLiteral)literal).getValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNullLiteral() {
        String buffer = "null";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a NullLiteral", (boolean)NullLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIntegerLiteral() {
        String buffer = "1234";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an IntegerLiteral", (boolean)IntegerLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be 1234.", (long)1234L, (long)((IntegerLiteral)literal).getValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDoubleDotLiteral() {
        String buffer = "12.34";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an DoubleLiteral", (boolean)DoubleLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be 12.34.", (double)12.34, (double)((DoubleLiteral)literal).getValue(), (double)1.0E-4);
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDoubleNoDigitBeforTheDotLiteral() {
        String buffer = ".34";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an DoubleLiteral", (boolean)DoubleLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be 0.34.", (double)0.34, (double)((DoubleLiteral)literal).getValue(), (double)1.0E-4);
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDoubleNoDigitAfterTheDotLiteral() {
        String buffer = "12.";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an DoubleLiteral", (boolean)DoubleLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be 12.0.", (double)12.0, (double)((DoubleLiteral)literal).getValue(), (double)1.0E-4);
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDoubleCommaLiteral() {
        String buffer = "12,34";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((String)"Literal should be null.", null, (Object)literal);
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBooleanTrueLiteral() {
        String buffer = "true";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an DoubleLiteral", (boolean)BooleanLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be true.", (Object)true, (Object)((BooleanLiteral)literal).isValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBooleanFalseLiteral() {
        String buffer = "false";
        try {
            Literal literal = LiteralParser.createLiteral((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an DoubleLiteral", (boolean)BooleanLiteral.class.isAssignableFrom(literal.getClass()));
            Assert.assertEquals((String)"Value should be false.", (Object)false, (Object)((BooleanLiteral)literal).isValue());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)literal.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)literal.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

