/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.expressions.BooleanLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.CallSet;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Expression;
import org.eclipse.acceleo.compatibility.model.mt.expressions.IntegerLiteral;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Not;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Operator;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Parenthesis;
import org.eclipse.acceleo.compatibility.model.mt.expressions.StringLiteral;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ExpressionParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyString() {
        String buffer = "";
        try {
            ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testCallSet() {
        String buffer = "call";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a CallSet", (boolean)CallSet.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStringLiteral() {
        String buffer = "\"MyString\"";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a StringLiteral", (boolean)StringLiteral.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIntegerLiteral() {
        String buffer = "13";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a IntegerLiteral", (boolean)IntegerLiteral.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBooleanLiteral() {
        String buffer = "false";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a BooleanLiteral", (boolean)BooleanLiteral.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNot() {
        String buffer = "!true";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be a Not", (boolean)Not.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOperator() {
        String buffer = "0 + 0";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an Operator", (boolean)Operator.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParenthesis() {
        String buffer = "(call)";
        try {
            Expression exp = ExpressionParser.createExpression((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertTrue((String)"Should be an Parenthesis", (boolean)Parenthesis.class.isAssignableFrom(exp.getClass()));
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)exp.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)exp.getEnd());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

