/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.compatibility.tests.unit.parser.mt.ast.expressions;

import org.eclipse.acceleo.compatibility.model.mt.expressions.Call;
import org.eclipse.acceleo.compatibility.model.mt.expressions.CallSet;
import org.eclipse.acceleo.compatibility.tests.unit.parser.AbstractAcceleoTest;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.CallParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class CallParserTest
extends AbstractAcceleoTest {
    @Test
    public void testEmptyCall() {
        String buffer = "";
        try {
            CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.fail((String)"Should raise a TemplateSyntaxException");
        }
        catch (TemplateSyntaxException templateSyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testNumericIdentifierCall() {
        String buffer = "1243413";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer, (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStringIdentifierCall() {
        String buffer = "azerty";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer, (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStringWithCallSepIdentifierCall() {
        String buffer = "aze" + TemplateConstants.getDefault().getCallSep() + "rty";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer, (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStringWithArgSepIdentifierCall() {
        String buffer = "aze" + TemplateConstants.getDefault().getArgSep() + "rty";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer, (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithPrefixMetamodelCall() {
        String buffer = String.valueOf(TemplateConstants.getDefault().getLinkPrefixMetamodel()) + TemplateConstants.getDefault().getLinkPrefixSeparator() + "azerty";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer.substring(buffer.indexOf(TemplateConstants.getDefault().getLinkPrefixSeparator()) + TemplateConstants.getDefault().getLinkPrefixSeparator().length()), (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be TemplateConstants.getDefault().getLinkPrefixMetamodel().", (Object)TemplateConstants.getDefault().getLinkPrefixMetamodel(), (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithMultiPrefixMetamodelCall() {
        String buffer = String.valueOf(TemplateConstants.getDefault().getLinkPrefixMetamodel()) + TemplateConstants.getDefault().getLinkPrefixSeparator() + TemplateConstants.getDefault().getLinkPrefixMetamodel() + TemplateConstants.getDefault().getLinkPrefixSeparator() + "azerty";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer.substring(buffer.indexOf(TemplateConstants.getDefault().getLinkPrefixSeparator()) + TemplateConstants.getDefault().getLinkPrefixSeparator().length()), (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be TemplateConstants.getDefault().LINK_PREFIX_METAMODEL.", (Object)TemplateConstants.getDefault().getLinkPrefixMetamodel(), (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithEmptyArgsCall() {
        String buffer = "azerty()";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer.substring(0, buffer.indexOf(TemplateConstants.getDefault().getParenth()[0])), (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithEmptyFilterCall() {
        String buffer = "azerty[filter]";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer.substring(0, buffer.indexOf(TemplateConstants.getDefault().getBrackets()[0])), (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at TemplateConstants.getDefault().BRACKETS[0] index.", (long)buffer.indexOf(TemplateConstants.getDefault().getBrackets()[0]), (long)call.getEnd());
            Assert.assertEquals((String)"Arguments should be empty.", (long)0L, (long)call.getArguments().size());
            Assert.assertEquals((String)"Filter should be \"filter\".", (Object)"filter", (Object)((Call)((CallSet)call.getFilter()).getCalls().get(0)).getName());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithArgsCall() {
        String buffer = "azerty(arg1, arg2, arg3)";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer.substring(0, buffer.indexOf(TemplateConstants.getDefault().getParenth()[0])), (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Should have 3 arguments.", (long)3L, (long)call.getArguments().size());
            Assert.assertEquals((String)"Argument #1 should be \"arg1\".", (Object)"arg1", (Object)((Call)((CallSet)call.getArguments().get(0)).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Argument #2 should be \"arg2\".", (Object)"arg2", (Object)((Call)((CallSet)call.getArguments().get(1)).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Argument #3 should be \"arg3\".", (Object)"arg3", (Object)((Call)((CallSet)call.getArguments().get(2)).getCalls().get(0)).getName());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be an empty string.", (Object)"", (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithPrefixAndArgsCall() {
        String buffer = String.valueOf(TemplateConstants.getDefault().getLinkPrefixMetamodel()) + TemplateConstants.getDefault().getLinkPrefixSeparator() + "azerty(arg1, arg2, arg3)";
        try {
            Call call = CallParser.createCall((int)0, (String)buffer, (Region)new Region(0, buffer.length()), null);
            Assert.assertEquals((Object)buffer.substring(buffer.indexOf(TemplateConstants.getDefault().getLinkPrefixSeparator()) + TemplateConstants.getDefault().getLinkPrefixSeparator().length(), buffer.indexOf(TemplateConstants.getDefault().getParenth()[0])), (Object)call.getName());
            Assert.assertEquals((String)"Should begin at 0 index.", (long)0L, (long)call.getBegin());
            Assert.assertEquals((String)"Should end at buffer.length() index.", (long)buffer.length(), (long)call.getEnd());
            Assert.assertEquals((String)"Should have 3 arguments.", (long)3L, (long)call.getArguments().size());
            Assert.assertEquals((String)"Argument #1 should be \"arg1\".", (Object)"arg1", (Object)((Call)((CallSet)call.getArguments().get(0)).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Argument #2 should be \"arg2\".", (Object)"arg2", (Object)((Call)((CallSet)call.getArguments().get(1)).getCalls().get(0)).getName());
            Assert.assertEquals((String)"Argument #3 should be \"arg3\".", (Object)"arg3", (Object)((Call)((CallSet)call.getArguments().get(2)).getCalls().get(0)).getName());
            Assert.assertNull((String)"Filter should be null.", (Object)call.getFilter());
            Assert.assertEquals((String)"prefix should be TemplateConstants.getDefault().LINK_PREFIX_METAMODEL.", (Object)TemplateConstants.getDefault().getLinkPrefixMetamodel(), (Object)call.getPrefix());
        }
        catch (TemplateSyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

