/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils.modelutils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.acceleo.common.tests.AcceleoCommonTestPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Version;

public class SaveSerializeTest {
    private static final String INPUT_DIRECTORY = "/data/modelutils";
    private List<EObject> models;
    private String outputDirectory;
    private boolean isKepler;

    public SaveSerializeTest() {
        Version emfVersion;
        File inputDir;
        block4: {
            this.models = new ArrayList<EObject>();
            inputDir = null;
            try {
                inputDir = new File(FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry(INPUT_DIRECTORY)).getFile());
                this.outputDirectory = FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry("/data")).getFile();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        File[] directories = SaveSerializeTest.listDirectories(inputDir);
        if (directories != null) {
            int i = 0;
            while (i < directories.length) {
                this.scanForModels(directories[i]);
                ++i;
            }
        }
        this.isKepler = (emfVersion = Platform.getBundle((String)"org.eclipse.emf.common").getVersion()).getMajor() == 2 && emfVersion.getMinor() == 9;
    }

    @Test
    public void testSaveNullRoot() {
        if (this.isKepler) {
            return;
        }
        try {
            ModelUtils.save(null, (String)this.outputDirectory);
            Assert.fail((String)"Expected NullPointerException hasn't been thrown by save().");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException has been thrown by save().");
        }
    }

    @Test
    public void testSaveValidEObject() {
        if (this.isKepler) {
            return;
        }
        for (EObject modelRoot : this.models) {
            FileInputStream fsInput = null;
            File savedFile = null;
            try {
                try {
                    String filePath = modelRoot.eResource().getURI().toFileString();
                    String filename = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
                    ModelUtils.save((EObject)modelRoot, (String)(String.valueOf(this.outputDirectory) + File.separatorChar + filename));
                    savedFile = new File(String.valueOf(this.outputDirectory) + File.separatorChar + filename);
                    Assert.assertTrue((String)"File hasn't been saved.", (savedFile.exists() && savedFile.isFile() ? 1 : 0) != 0);
                    fsInput = new FileInputStream(savedFile);
                    Assert.assertNotSame((String)"Saved file is empty.", (Object)-1, (Object)fsInput.read());
                }
                catch (IOException e) {
                    Assert.fail((String)"Unexpected IOException has been thrown by a valid call to save().");
                    if (fsInput != null) {
                        try {
                            fsInput.close();
                        }
                        catch (IOException e2) {
                            Assert.fail((String)"Unexpected IOException has been thrown by a valid call to save().");
                        }
                    }
                    if (savedFile == null) continue;
                    savedFile.delete();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (fsInput != null) {
                    try {
                        fsInput.close();
                    }
                    catch (IOException e) {
                        Assert.fail((String)"Unexpected IOException has been thrown by a valid call to save().");
                    }
                }
                if (savedFile != null) {
                    savedFile.delete();
                }
                throw throwable;
            }
            if (fsInput != null) {
                try {
                    fsInput.close();
                }
                catch (IOException e) {
                    Assert.fail((String)"Unexpected IOException has been thrown by a valid call to save().");
                }
            }
            if (savedFile == null) continue;
            savedFile.delete();
        }
    }

    @Test
    public void testSaveValidEObjectNullPath() {
        if (this.isKepler) {
            return;
        }
        for (EObject modelRoot : this.models) {
            try {
                ModelUtils.save((EObject)modelRoot, null);
                Assert.fail((String)"Expected NullPointerException hasn't been thrown by save().");
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException has been thrown by save().");
            }
        }
    }

    @Test
    public void testSerializeNullRoot() {
        if (this.isKepler) {
            return;
        }
        try {
            ModelUtils.serialize(null);
            Assert.fail((String)"Expected NullPointerException hasn't been thrown by serialize() operation.");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException has been thrown by serialize() operation.");
        }
    }

    @Test
    public void testSerializeValidEObject() {
        if (this.isKepler) {
            return;
        }
        for (EObject modelRoot : this.models) {
            try {
                String result = ModelUtils.serialize((EObject)modelRoot);
                Assert.assertNotNull((String)"EObject hasn't been serialized by serialize().", (Object)result);
                Assert.assertFalse((String)"EObject has been serialized as an empty String", (boolean)"".equals(result));
                Assert.assertTrue((String)"EObject hasn't been serialized as an XML object.", (boolean)result.startsWith("<?xml"));
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException has been thrown by a valid call to save().");
            }
        }
    }

    private void scanForModels(File folder) {
        block7: {
            File[] files;
            block6: {
                File[] subFolders = SaveSerializeTest.listDirectories(folder);
                if (subFolders.length == 0) break block6;
                File[] fileArray = subFolders;
                int n = subFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    File aSubFolder = fileArray[n2];
                    this.scanForModels(aSubFolder);
                    ++n2;
                }
                break block7;
            }
            if (!folder.exists() || !folder.isDirectory()) break block7;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                block5: {
                    File aFile = fileArray[n3];
                    if (!aFile.isDirectory() && !aFile.getName().startsWith(".")) {
                        try {
                            this.models.add(ModelUtils.load((File)aFile, (ResourceSet)new ResourceSetImpl()));
                        }
                        catch (IOException e) {
                            if ($assertionsDisabled) break block5;
                            throw new AssertionError();
                        }
                    }
                }
                ++n3;
            }
        }
    }

    public static File[] listDirectories(File aDirectory) {
        File[] directories = null;
        if (aDirectory.exists() && aDirectory.isDirectory()) {
            directories = aDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().startsWith(".") && !"CVS".equals(file.getName());
                }
            });
        }
        Arrays.sort(directories);
        return directories;
    }
}

