/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils.modelutils;

import java.io.File;
import java.io.IOException;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Test;

public class LoadFromStringTest {
    private static final String[] INVALID_PATHS = new String[]{"/etc/shadow", "/etc/sudoers", "/inputs/attribute/attributeChange/v1.ecore", String.valueOf(File.listRoots()[0].getAbsolutePath()) + "projectname/modelname.extension"};
    private static final String MESSAGE_IOEXCEPTION_UNEXPECTED = "Unexpected IOException has been thrown.";
    private static final String MESSAGE_NPE_UNEXPECTED = "Unexpected NullPointerException has been thrown.";
    private static final String PATH_PREFIX = "/org.eclipse.acceleo.common.tests/data/modelutils";
    private static final String[] VALID_PATHS = new String[]{"/org.eclipse.acceleo.common.tests/data/modelutils/testModels/attribute.ecore", "/org.eclipse.acceleo.common.tests/data/modelutils/testModels/volatileAttribute.ecore", "platform:/plugin/org.eclipse.acceleo.model/model/mtl.ecore"};

    @Test
    public void testLoadInvalidPathNullResourceSet() {
        String[] stringArray = INVALID_PATHS;
        int n = INVALID_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                ModelUtils.load((String)path, null);
                Assert.fail((String)"Expected NullPointerException hasn't been thrown.");
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
            ++n2;
        }
    }

    @Test
    public void testLoadInvalidPathValidResourceSet() {
        String[] stringArray = INVALID_PATHS;
        int n = INVALID_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String path = stringArray[n2];
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                try {
                    ModelUtils.load((String)path, (ResourceSet)resourceSet);
                    Assert.fail((String)"Expected IOException hasn't been thrown.");
                }
                catch (IOException iOException) {
                }
                catch (WrappedException e) {
                    if (e.getCause() instanceof IOException) break block4;
                    throw e;
                }
            }
            ++n2;
        }
    }

    @Test
    public void testLoadNullPath() {
        String errMsg = "Expected IllegalArgumentException hasn't been thrown.";
        try {
            ModelUtils.load(null, null);
            Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown.");
        }
        catch (NullPointerException e) {
            Assert.fail((String)MESSAGE_NPE_UNEXPECTED);
        }
        catch (IOException e) {
            Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ModelUtils.load((String)"", null);
            Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown.");
        }
        catch (NullPointerException e) {
            Assert.fail((String)MESSAGE_NPE_UNEXPECTED);
        }
        catch (IOException e) {
            Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadValidPathNullResourceSet() {
        String errMsg = "Expected NullPointerException hasn't been thrown.";
        String[] stringArray = VALID_PATHS;
        int n = VALID_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                ModelUtils.load((String)path, null);
                Assert.fail((String)"Expected NullPointerException hasn't been thrown.");
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
            ++n2;
        }
    }

    @Test
    public void testLoadValidPathValidResourceSet() {
        String[] stringArray = VALID_PATHS;
        int n = VALID_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                EObject result = ModelUtils.load((String)path, (ResourceSet)resourceSet);
                Assert.assertNotNull((String)"ModelUtils didn't load the expected model.", (Object)result);
                Assert.assertEquals((String)"Loaded model hasn't been associated with the expected resourceSet.", (Object)resourceSet, (Object)result.eResource().getResourceSet());
                Assert.assertTrue((String)"Loaded model isn't the expected one.", (boolean)result.eResource().getURI().toString().endsWith(path));
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
            ++n2;
        }
    }
}

