/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils.modelutils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.acceleo.common.tests.AcceleoCommonTestPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Test;

public class LoadFromFileTest {
    private static final String INPUT_DIRECTORY = "/data/modelutils";
    private static final String MESSAGE_IOEXCEPTION_UNEXPECTED = "Unexpected IOException has been thrown.";
    private static final String MESSAGE_NULLPOINTER_EXPECTED = "Expected NullPointerException hasn't been thrown.";
    private String[] invalidFiles;
    private List<File> models;

    public LoadFromFileTest() {
        File inputDir;
        block4: {
            this.invalidFiles = new String[]{"", "/etc/shadow", "/etc/sudoers", "\r\n", String.valueOf(File.listRoots()[0].getAbsolutePath()) + "nofolder"};
            this.models = new ArrayList<File>();
            inputDir = null;
            try {
                inputDir = new File(FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry(INPUT_DIRECTORY)).getFile());
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        File[] directories = LoadFromFileTest.listDirectories(inputDir);
        if (directories != null) {
            int i = 0;
            while (i < directories.length) {
                this.scanForModels(directories[i]);
                ++i;
            }
        }
    }

    @Test
    public void testLoadModelFromInvalidFileNullResourceSet() {
        String[] stringArray = this.invalidFiles;
        int n = this.invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String modelFile = stringArray[n2];
            try {
                ModelUtils.load((File)new File(modelFile), null);
                Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
            ++n2;
        }
    }

    @Test
    public void testLoadModelFromInvalidFileValidResourceSet() {
        String[] stringArray = this.invalidFiles;
        int n = this.invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String modelFile = stringArray[n2];
                String errMsg = "Resource '" + modelFile + "' does not exist.";
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    ModelUtils.load((File)new File(modelFile), (ResourceSet)resourceSet);
                    Assert.fail((String)"Expected IOException hasn't been thrown.");
                }
                catch (NullPointerException e) {
                    Assert.fail((String)"Unexpected NullPointerException thrown when loading models from invalid files.");
                }
                catch (IOException e) {
                }
                catch (WrappedException e) {
                    if (e.getCause() instanceof IOException || e.getCause() instanceof CoreException && errMsg.equals(e.getCause().getMessage())) break block5;
                    throw e;
                }
            }
            ++n2;
        }
    }

    @Test
    public void testLoadModelFromNullFile() {
        try {
            ModelUtils.load(null, null);
            Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
        }
    }

    @Test
    public void testLoadModelFromValidFileNullResourceSet() {
        for (File modelFile : this.models) {
            try {
                ModelUtils.load((File)modelFile, null);
                Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
        }
    }

    @Test
    public void testLoadModelFromValidFileValidResourceSet() {
        for (File modelFile : this.models) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                EObject result = ModelUtils.load((File)modelFile, (ResourceSet)resourceSet);
                Assert.assertNotNull((String)"ModelUtils didn't load its target model.", (Object)result);
                Assert.assertEquals((String)"Loaded object was associated to an unexpected resourceSet.", (Object)resourceSet, (Object)result.eResource().getResourceSet());
                Assert.assertEquals((String)"Loaded model isn't the expected one.", (Object)modelFile.getPath(), (Object)result.eResource().getURI().toFileString());
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
        }
    }

    private void scanForModels(File folder) {
        block4: {
            File[] files;
            block3: {
                File[] subFolders = LoadFromFileTest.listDirectories(folder);
                if (subFolders.length == 0) break block3;
                File[] fileArray = subFolders;
                int n = subFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    File aSubFolder = fileArray[n2];
                    this.scanForModels(aSubFolder);
                    ++n2;
                }
                break block4;
            }
            if (!folder.exists() || !folder.isDirectory()) break block4;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File aFile = fileArray[n3];
                if (!aFile.isDirectory() && !aFile.getName().startsWith(".")) {
                    this.models.add(aFile);
                }
                ++n3;
            }
        }
    }

    public static File[] listDirectories(File aDirectory) {
        File[] directories = null;
        if (aDirectory.exists() && aDirectory.isDirectory()) {
            directories = aDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().startsWith(".") && !"CVS".equals(file.getName());
                }
            });
        }
        Arrays.sort(directories);
        return directories;
    }
}

