/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils.modelutils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.common.tests.AcceleoCommonTestPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class AttachResourceTest {
    private static final String INPUT_DIRECTORY = "/data/modelutils/testModels";
    private static final List<EObject> INPUT_MODELS;
    private static final String[] TEST_URIS;

    static {
        TEST_URIS = new String[]{"data", "\u00e9", "\r\n", ""};
        List temp = Collections.emptyList();
        try {
            temp = ModelUtils.getModelsFrom((File)new File(FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry(INPUT_DIRECTORY)).getFile()), (ResourceSet)new ResourceSetImpl());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        INPUT_MODELS = Collections.unmodifiableList(temp);
    }

    @Test
    public void testAttachResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        for (EObject model : INPUT_MODELS) {
            String[] stringArray = TEST_URIS;
            int n = TEST_URIS.length;
            int n2 = 0;
            while (n2 < n) {
                String uriPath = stringArray[n2];
                EObject test = EcoreUtil.copy((EObject)model);
                Assert.assertNull((String)"A copy should have no resource, EMF's API has been changed.", (Object)test.eResource());
                ModelUtils.attachResource((URI)URI.createFileURI((String)uriPath), (ResourceSet)resourceSet, (EObject)test);
                Assert.assertNotNull((String)"attachResource() did not attach a resource as expected.", (Object)test.eResource());
                Assert.assertEquals((String)"attachResource() did not attach a resource with the expected URI.", (Object)test.eResource().getURI(), (Object)URI.createFileURI((String)uriPath));
                Assert.assertEquals((String)"attachResource() did not attach a resource of the expected resourceSet.", (Object)resourceSet, (Object)test.eResource().getResourceSet());
                ++n2;
            }
        }
    }

    @Test
    public void testAttachResourceNoResourceSet() {
        for (EObject model : INPUT_MODELS) {
            String[] stringArray = TEST_URIS;
            int n = TEST_URIS.length;
            int n2 = 0;
            while (n2 < n) {
                String uriPath = stringArray[n2];
                EObject test = EcoreUtil.copy((EObject)model);
                Assert.assertNull((String)"A copy should have no resource, EMF's API has been changed.", (Object)test.eResource());
                ModelUtils.attachResource((URI)URI.createFileURI((String)uriPath), (EObject)test);
                Assert.assertNotNull((String)"attachResource() did not attach a resource as expected.", (Object)test.eResource());
                Assert.assertEquals((String)"attachResource() did not attach a resource with the expected URI.", (Object)test.eResource().getURI(), (Object)URI.createFileURI((String)uriPath));
                ++n2;
            }
        }
    }

    @Test
    public void testAttachResourceNullEObject() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String[] stringArray = TEST_URIS;
        int n = TEST_URIS.length;
        int n2 = 0;
        while (n2 < n) {
            String uriPath = stringArray[n2];
            try {
                ModelUtils.attachResource((URI)URI.createFileURI((String)uriPath), null);
                Assert.fail((String)"attachResource() didn't throw the expected NPE");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                ModelUtils.attachResource((URI)URI.createFileURI((String)uriPath), (ResourceSet)resourceSet, null);
                Assert.fail((String)"attachResource() didn't throw the expected NPE");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n2;
        }
    }

    @Test
    public void testAttachResourceNullResourceSet() {
        for (EObject model : INPUT_MODELS) {
            String[] stringArray = TEST_URIS;
            int n = TEST_URIS.length;
            int n2 = 0;
            while (n2 < n) {
                String uriPath = stringArray[n2];
                EObject test = EcoreUtil.copy((EObject)model);
                Assert.assertNull((String)"A copy should have no resource, EMF's API changed.", (Object)test.eResource());
                try {
                    ModelUtils.attachResource((URI)URI.createFileURI((String)uriPath), null, (EObject)test);
                    Assert.fail((String)"attachResource() didn't throw the expected NPE");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    @Test
    public void testAttachResourceNullURI() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        for (EObject model : INPUT_MODELS) {
            EObject test = EcoreUtil.copy((EObject)model);
            Assert.assertNull((String)"A copy should have no resource, EMF's API changed.", (Object)test.eResource());
            try {
                ModelUtils.attachResource(null, (EObject)test);
                Assert.fail((String)"attachResource() didn't throw the expected NPE");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                ModelUtils.attachResource(null, (ResourceSet)resourceSet, (EObject)test);
                Assert.fail((String)"attachResource() didn't throw the expected NPE");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

