/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.junit.Assert;
import org.junit.Test;

public class MessagesTest {
    private final String[] expectedForParameterisable = new String[]{"Couldn't load class {0}. Check that its containing package is exported.", "No library connector to handle {0}", "Unexpected exception while trying to install workspace-defined bundle {0} : {1}"};
    private final String[] expectedForValidKeys = new String[]{"Required element not found.", "Status to be logged cannot be null.", "Path cannot be null or empty.", "Couldn't load the Acceleo standard library."};
    private final String[] invalidKeys = new String[]{"invalidKey", "AcceleoEvaluationContext.CleanUpError1", "", "\u00ec"};
    private final Object[] messageParameters;
    private final String[] parameterisableKeys;
    private final String[] validKeys;

    public MessagesTest() {
        Object[] objectArray = new Object[8];
        objectArray[1] = "";
        objectArray[2] = "Foehn";
        objectArray[3] = -1;
        objectArray[4] = new Long(10L);
        objectArray[5] = Character.valueOf('C');
        objectArray[6] = new HashSet();
        objectArray[7] = "0x6c9a.^\\/";
        this.messageParameters = objectArray;
        this.parameterisableKeys = new String[]{"BundleClassLookupFailure", "AcceleoLogger.MissingHandle", "WorkspaceUtil.InstallationFailure"};
        this.validKeys = new String[]{"AcceleoLogger.ElementNotFound", "AcceleoLogger.LogNullStatus", "ModelUtils.NullPath", "AcceleoStandardLibrary.LoadFailure"};
    }

    @Test
    public void testFormattedGetStringInvalidKey() {
        int i = 0;
        while (i < this.messageParameters.length) {
            int j = i;
            while (j < this.messageParameters.length) {
                Object[] parameters = this.partialArrayCopy(this.messageParameters, i, j);
                String[] stringArray = this.invalidKeys;
                int n = this.invalidKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String invalidKey = stringArray[n2];
                    Assert.assertEquals((String)"Unexpected result of getString() with an invalid key.", (Object)(String.valueOf('!') + invalidKey + '!'), (Object)AcceleoCommonMessages.getString((String)invalidKey, (Object[])parameters));
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testFormattedGetStringNullKey() {
        int i = 0;
        while (i < this.messageParameters.length) {
            int j = i;
            while (j < this.messageParameters.length) {
                Object[] parameters = this.partialArrayCopy(this.messageParameters, i, j);
                try {
                    AcceleoCommonMessages.getString(null, (Object[])parameters);
                    Assert.fail((String)"Calling getString() with null key did not throw NullPointerException.");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testFormattedGetStringValidKey() {
        int i = 0;
        while (i < this.messageParameters.length) {
            int j = i;
            while (j < this.messageParameters.length) {
                Object[] parameters = this.partialArrayCopy(this.messageParameters, i, j);
                int k = 0;
                while (k < this.parameterisableKeys.length) {
                    String expectedResult = this.expectedForParameterisable[k];
                    int parameterCount = 0;
                    while (expectedResult.matches(".*\\{[0-9]+\\}.*") && parameterCount < parameters.length) {
                        expectedResult = parameters[parameterCount] == null ? expectedResult.replaceFirst("\\{[0-9]+\\}", "null") : expectedResult.replaceFirst("\\{[0-9]+\\}", parameters[parameterCount].toString());
                        ++parameterCount;
                    }
                    Locale previousLocale = null;
                    if (Locale.getDefault() != Locale.ENGLISH) {
                        previousLocale = Locale.getDefault();
                    }
                    Locale.setDefault(Locale.ENGLISH);
                    Assert.assertEquals((String)"Unexpected formatted String returned by getString(String, Object...).", (Object)expectedResult, (Object)AcceleoCommonMessages.getString((String)this.parameterisableKeys[k], (Object[])parameters));
                    if (previousLocale != null) {
                        Locale.setDefault(previousLocale);
                    } else {
                        Locale.setDefault(Locale.FRENCH);
                    }
                    String result = AcceleoCommonMessages.getString((String)this.parameterisableKeys[k], (Object[])parameters);
                    Assert.assertFalse((String)"Message class did not find an existing parameterisable key.", (boolean)result.equals(String.valueOf('!') + this.parameterisableKeys[k] + '!'));
                    int l = 0;
                    while (l < parameterCount) {
                        if (parameters[l] != null) {
                            Assert.assertTrue((String)"Message class did not substitute the parameter in the result.", (boolean)result.contains(parameters[l].toString()));
                        } else {
                            Assert.assertTrue((String)"Message class did not substitute the parameter in the result.", (boolean)result.contains("null"));
                        }
                        ++l;
                    }
                    if (previousLocale == null) {
                        Locale.setDefault(Locale.ENGLISH);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testFormattedGetStringValidKeyNullParameter() {
        int i = 0;
        while (i < this.parameterisableKeys.length) {
            Assert.assertEquals((String)"Unexpected formatted String returned by getString(String, Object...).", (Object)AcceleoCommonMessages.getString((String)this.parameterisableKeys[i]), (Object)AcceleoCommonMessages.getString((String)this.parameterisableKeys[i], null));
            ++i;
        }
    }

    @Test
    public void testUnFormattedGetStringInvalidKey() {
        String[] stringArray = this.invalidKeys;
        int n = this.invalidKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String invalidKey = stringArray[n2];
            Assert.assertEquals((String)"Unexpected result of getString() with an invalid key.", (Object)(String.valueOf('!') + invalidKey + '!'), (Object)AcceleoCommonMessages.getString((String)invalidKey));
            ++n2;
        }
    }

    @Test
    public void testUnFormattedGetStringNullKey() {
        try {
            AcceleoCommonMessages.getString(null);
            Assert.fail((String)"Calling getString() with null argument did not throw NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testUnFormattedGetStringValidKey() {
        int i = 0;
        while (i < this.validKeys.length) {
            Locale previousLocale = null;
            if (Locale.getDefault() != Locale.ENGLISH) {
                previousLocale = Locale.getDefault();
            }
            Locale.setDefault(Locale.ENGLISH);
            String result = AcceleoCommonMessages.getString((String)this.validKeys[i]);
            Assert.assertEquals((String)"Unexpected String returned by getString(String).", (Object)this.expectedForValidKeys[i], (Object)result);
            if (previousLocale != null) {
                Locale.setDefault(previousLocale);
            } else {
                Locale.setDefault(Locale.FRENCH);
            }
            Assert.assertFalse((String)"Message class did not find an existing parameterisable key.", (boolean)result.equals(String.valueOf('!') + this.validKeys[i] + '!'));
            if (previousLocale == null) {
                Locale.setDefault(Locale.ENGLISH);
            }
            ++i;
        }
    }

    private <T> T[] partialArrayCopy(T[] original, int start, int end) {
        int range = end - start;
        if (range < 0) {
            throw new IllegalArgumentException("Illegal copy range.");
        }
        Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), range);
        System.arraycopy(original, start, copy, 0, Math.min(original.length - start, range));
        return copy;
    }
}

