/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils.modelutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.acceleo.common.tests.AcceleoCommonTestPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.junit.Assert;
import org.junit.Test;

public class LoadFromInputStreamTest {
    private static final String INPUT_DIRECTORY = "/data/modelutils";
    private static final String[] INVALID_FILENAMES = new String[]{"", "model", "ecaure"};
    private static final String MESSAGE_FILENOTFOUNDEXCEPTION_UNEXPECTED = "Unexpected FileNotFoundException has been thrown while loading models from stream.";
    private static final String MESSAGE_IOEXCEPTION_UNEXPECTED = "Unexpected IOException has been thrown.";
    private static final String MESSAGE_NULLPOINTER_EXPECTED = "Expected NullPointerException hasn't been thrown.";
    private List<File> models;

    public LoadFromInputStreamTest() {
        File inputDir;
        block4: {
            this.models = new ArrayList<File>();
            inputDir = null;
            try {
                inputDir = new File(FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry(INPUT_DIRECTORY)).getFile());
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        File[] directories = LoadFromInputStreamTest.listDirectories(inputDir);
        if (directories != null) {
            int i = 0;
            while (i < directories.length) {
                this.scanForModels(directories[i]);
                ++i;
            }
        }
    }

    @Test
    public void testLoadModelFromNullInputStream() {
        String[] stringArray = INVALID_FILENAMES;
        int n = INVALID_FILENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String invalidFileName = stringArray[n2];
            try {
                ModelUtils.load(null, (String)invalidFileName, null);
                Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                ModelUtils.load(null, (String)invalidFileName, (ResourceSet)resourceSet);
                Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                Assert.fail((String)MESSAGE_IOEXCEPTION_UNEXPECTED);
            }
            ++n2;
        }
    }

    @Test
    public void testLoadModelFromValidInputInvalidExtension() throws IOException {
        for (File model : this.models) {
            try {
                String[] stringArray = INVALID_FILENAMES;
                int n = INVALID_FILENAMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String invalidFileName = stringArray[n2];
                    FileInputStream fsInput = new FileInputStream(model);
                    BufferedInputStream buffInput = new BufferedInputStream(fsInput);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    EObject result = ModelUtils.load((InputStream)buffInput, (String)invalidFileName, (ResourceSet)resourceSet);
                    Assert.assertNotNull((String)"ModelUtils didn't load its target model.", (Object)result);
                    Assert.assertEquals((String)"Loaded object was associated to an unexpected resourceSet.", (Object)resourceSet, (Object)result.eResource().getResourceSet());
                    Assert.assertTrue((String)"Model loaded as an unexpected type of resource.", (boolean)(result.eResource() instanceof XMIResource));
                    buffInput.close();
                    fsInput.close();
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)MESSAGE_FILENOTFOUNDEXCEPTION_UNEXPECTED);
            }
        }
    }

    @Test
    public void testLoadModelFromValidInputNullResourceSet() throws IOException {
        for (File model : this.models) {
            FileInputStream fsInput = null;
            BufferedInputStream buffInput = null;
            try {
                try {
                    fsInput = new FileInputStream(model);
                    buffInput = new BufferedInputStream(fsInput);
                    String[] stringArray = INVALID_FILENAMES;
                    int n = INVALID_FILENAMES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String invalidFileName = stringArray[n2];
                        try {
                            ModelUtils.load((InputStream)buffInput, (String)invalidFileName, null);
                            Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    try {
                        ModelUtils.load((InputStream)buffInput, (String)model.getName(), null);
                        Assert.fail((String)MESSAGE_NULLPOINTER_EXPECTED);
                    }
                    catch (NullPointerException invalidFileName) {}
                }
                catch (FileNotFoundException e) {
                    Assert.fail((String)MESSAGE_FILENOTFOUNDEXCEPTION_UNEXPECTED);
                    if (buffInput == null || fsInput == null) continue;
                    buffInput.close();
                    fsInput.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (buffInput != null && fsInput != null) {
                    buffInput.close();
                    fsInput.close();
                }
                throw throwable;
            }
            if (buffInput == null || fsInput == null) continue;
            buffInput.close();
            fsInput.close();
        }
    }

    @Test
    public void testLoadModelFromValidInputValidExtension() throws IOException {
        for (File model : this.models) {
            try {
                FileInputStream fsInput = new FileInputStream(model);
                BufferedInputStream buffInput = new BufferedInputStream(fsInput);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                EObject result = ModelUtils.load((InputStream)buffInput, (String)model.getName(), (ResourceSet)resourceSet);
                Assert.assertNotNull((String)"ModelUtils didn't load its target model.", (Object)result);
                Assert.assertEquals((String)"Loaded object was associated to an unexpected resourceSet.", (Object)resourceSet, (Object)result.eResource().getResourceSet());
                buffInput.close();
                fsInput.close();
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)MESSAGE_FILENOTFOUNDEXCEPTION_UNEXPECTED);
            }
        }
    }

    private void scanForModels(File folder) {
        block4: {
            File[] files;
            block3: {
                File[] subFolders = LoadFromInputStreamTest.listDirectories(folder);
                if (subFolders.length == 0) break block3;
                File[] fileArray = subFolders;
                int n = subFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    File aSubFolder = fileArray[n2];
                    this.scanForModels(aSubFolder);
                    ++n2;
                }
                break block4;
            }
            if (!folder.exists() || !folder.isDirectory()) break block4;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File aFile = fileArray[n3];
                if (!aFile.isDirectory() && !aFile.getName().startsWith(".")) {
                    this.models.add(aFile);
                }
                ++n3;
            }
        }
    }

    public static File[] listDirectories(File aDirectory) {
        File[] directories = null;
        if (aDirectory.exists() && aDirectory.isDirectory()) {
            directories = aDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().startsWith(".") && !"CVS".equals(file.getName());
                }
            });
        }
        Arrays.sort(directories);
        return directories;
    }
}

