/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils.modelutils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.common.tests.AcceleoCommonTestPlugin;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GetModelsFromTest {
    private static final String INPUT_DIRECTORY = "/data/modelutils";
    private ArrayList<File> invalidDirectories = new ArrayList();
    private ArrayList<File> modelDirectories = new ArrayList();
    private String[] unreadableDirectories = new String[]{"", "\r\n", "/lost+found/"};

    @Test
    public void testGetModelsFromInvalidDirectory() {
        List expectedResult = Collections.emptyList();
        for (File invalidDirectory : this.invalidDirectories) {
            try {
                Assert.assertEquals((String)"Unexpected result of getModelsFrom() with invalid directory.", expectedResult, (Object)ModelUtils.getModelsFrom((File)invalidDirectory, (ResourceSet)new ResourceSetImpl()));
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException thrown while loading models from an invalid directory.");
            }
        }
    }

    @Test
    public void testGetModelsFromNullDirectory() {
        try {
            ModelUtils.getModelsFrom(null, (ResourceSet)new ResourceSetImpl());
            Assert.fail((String)"Expected NullPointerException hasn't been thrown.");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException has been thrown.");
        }
    }

    @Test
    public void testGetModelsFromUnreadableDirectory() {
        List expectedResult = Collections.emptyList();
        String[] stringArray = this.unreadableDirectories;
        int n = this.unreadableDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            String unreadableDirectory = stringArray[n2];
            try {
                Assert.assertEquals((String)"Unexpected result of getModelsFrom() with unreadable directory.", expectedResult, (Object)ModelUtils.getModelsFrom((File)new File(unreadableDirectory), (ResourceSet)new ResourceSetImpl()));
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException has been thrown.");
            }
            ++n2;
        }
    }

    @Test
    public void testGetModelsFromValidDirectory() {
        for (File modelDirectory : this.modelDirectories) {
            List result = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                result = ModelUtils.getModelsFrom((File)modelDirectory, (ResourceSet)resourceSet);
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException thrown while loading models from a valid folder.");
            }
            assert (result != null);
            int expectedSize = 0;
            File[] fileArray = modelDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File aFile = fileArray[n2];
                if (!aFile.isDirectory() && !aFile.getName().startsWith(String.valueOf('.'))) {
                    ++expectedSize;
                }
                ++n2;
            }
            Assert.assertSame((String)"The returned list doesn't contain the expected number of objects.", (Object)expectedSize, (Object)result.size());
            for (EObject loadedModel : result) {
                Assert.assertNotNull((String)"Loaded EObject isn't associated to a resource.", (Object)loadedModel.eResource());
                Assert.assertEquals((String)"Model hasn't been loaded in the accurate resource set.", (Object)resourceSet, (Object)loadedModel.eResource().getResourceSet());
            }
        }
    }

    @Test
    public void testGetModelsFromValidDirectoryInvalidExtension() {
        for (File modelDirectory : this.modelDirectories) {
            List result = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                result = ModelUtils.getModelsFrom((File)modelDirectory, (String)"ThisCannotBeAValidExtension", (ResourceSet)resourceSet);
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException thrown while loading models with invalid extensions.");
            }
            assert (result != null);
            Assert.assertSame((String)"Resulting list doesn't contain the expected number of objects.", (Object)0, (Object)result.size());
        }
    }

    @Test
    public void testGetModelsFromValidDirectoryNullResourceSet() {
        for (File modelDirectory : this.modelDirectories) {
            List result = null;
            try {
                result = ModelUtils.getModelsFrom((File)modelDirectory, null);
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException thrown while loading models.");
            }
            assert (result != null);
            int expectedSize = 0;
            File[] fileArray = modelDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File aFile = fileArray[n2];
                if (!aFile.isDirectory() && !aFile.getName().startsWith(String.valueOf('.'))) {
                    ++expectedSize;
                }
                ++n2;
            }
            Assert.assertSame((String)"Resulting list doesn't contain the expected number of objects.", (Object)expectedSize, (Object)result.size());
            ResourceSet resourceSet = null;
            for (EObject loadedModel : result) {
                Assert.assertNotNull((String)"Loaded EObject hasn't been associated to a resource.", (Object)loadedModel.eResource());
                if (resourceSet == null) {
                    resourceSet = loadedModel.eResource().getResourceSet();
                    continue;
                }
                Assert.assertEquals((String)"Model hasn't been loaded in the accurate resource set.", (Object)resourceSet, (Object)loadedModel.eResource().getResourceSet());
            }
        }
    }

    @Test
    public void testGetModelsFromValidDirectoryValidExtension() {
        for (File modelDirectory : this.modelDirectories) {
            List result = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            String fileExtension = "ecore";
            try {
                result = ModelUtils.getModelsFrom((File)modelDirectory, (String)"ecore", (ResourceSet)resourceSet);
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected IOException thrown while loading models.");
            }
            assert (result != null);
            int expectedSize = 0;
            File[] fileArray = modelDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File aFile = fileArray[n2];
                if (!aFile.isDirectory() && !aFile.getName().startsWith(String.valueOf('.')) && aFile.getName().endsWith("ecore")) {
                    ++expectedSize;
                }
                ++n2;
            }
            Assert.assertSame((String)"Resulting list doesn't contain the expected number of objects for this extension.", (Object)expectedSize, (Object)result.size());
            for (EObject loadedModel : result) {
                Assert.assertNotNull((String)"Loaded EObject isn't associated to a resource.", (Object)loadedModel.eResource());
                Assert.assertEquals((String)"Model hasn't been loaded in the expected resource set.", (Object)resourceSet, (Object)loadedModel.eResource().getResourceSet());
            }
        }
    }

    @Before
    public void setUp() {
        File inputDir;
        block4: {
            inputDir = null;
            try {
                inputDir = new File(FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry(INPUT_DIRECTORY)).getFile());
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        File[] directories = GetModelsFromTest.listDirectories(inputDir);
        if (directories != null) {
            int i = 0;
            while (i < directories.length) {
                this.scanForModels(directories[i]);
                ++i;
            }
        }
    }

    @After
    public void tearDown() {
        this.invalidDirectories.clear();
        this.modelDirectories.clear();
    }

    private void scanForModels(File folder) {
        block3: {
            File[] files;
            block5: {
                block4: {
                    File[] subFolders = GetModelsFromTest.listDirectories(folder);
                    if (subFolders.length == 0) break block4;
                    this.invalidDirectories.add(folder);
                    File[] fileArray = subFolders;
                    int n = subFolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File aSubFolder = fileArray[n2];
                        this.scanForModels(aSubFolder);
                        ++n2;
                    }
                    break block3;
                }
                if (folder.listFiles().length != 0) break block5;
                this.invalidDirectories.add(folder);
                break block3;
            }
            if (!folder.exists() || !folder.isDirectory()) break block3;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File aFile = fileArray[n3];
                if (!aFile.isDirectory() && !aFile.getName().startsWith(String.valueOf('.'))) {
                    this.modelDirectories.add(folder);
                    break;
                }
                ++n3;
            }
        }
    }

    public static File[] listDirectories(File aDirectory) {
        File[] directories = null;
        if (aDirectory.exists() && aDirectory.isDirectory()) {
            directories = aDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().startsWith(".") && !"CVS".equals(file.getName());
                }
            });
        }
        Arrays.sort(directories);
        return directories;
    }
}

