/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.common.tests.unit.utils.CompactHashSetTest;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.Deque;
import org.junit.Assert;
import org.junit.Test;

public class CompactLinkedHashSetTest
extends CompactHashSetTest {
    @Test
    public void testIteratorOrder() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        Set<Object> set = this.createSet();
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        Iterator listIterator = listInt10.iterator();
        Iterator setIterator = setString20.iterator();
        Iterator dequeIterator = dequeString40.iterator();
        Iterator<Object> containedValues = set.iterator();
        while (listIterator.hasNext()) {
            Assert.assertEquals(listIterator.next(), (Object)containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (setIterator.hasNext()) {
            Assert.assertEquals(setIterator.next(), (Object)containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), (Object)containedValues.next());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
        for (Integer val : listInt10) {
            set.remove(val);
            Assert.assertFalse((boolean)set.contains(val));
        }
        set.addAll(listInt10);
        listIterator = listInt10.iterator();
        setIterator = setString20.iterator();
        dequeIterator = dequeString40.iterator();
        containedValues = set.iterator();
        while (setIterator.hasNext()) {
            Assert.assertEquals(setIterator.next(), (Object)containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), (Object)containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (listIterator.hasNext()) {
            Assert.assertEquals(listIterator.next(), (Object)containedValues.next());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
    }

    @Override
    protected Set<Object> createSet() {
        return new CompactLinkedHashSet();
    }

    @Override
    protected Set<Object> createSet(Collection<? extends Object> collection) {
        return new CompactLinkedHashSet(collection);
    }

    @Override
    protected Set<Object> createSet(int elementCount) {
        return new CompactLinkedHashSet(elementCount);
    }

    @Override
    protected Set<Object> createSet(int elementCount, float loadFactor) {
        return new CompactLinkedHashSet(elementCount, loadFactor);
    }
}

