/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.Deque;
import org.junit.Assert;
import org.junit.Test;

public class CompactHashSetTest {
    @Test
    public void testAdd() {
        boolean modified;
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = (i / 2 + 1) * 100001;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        Set<Object> set = this.createSet();
        int size = 0;
        for (Integer integer : listInt10) {
            modified = set.add(integer);
            Assert.assertTrue((boolean)modified);
            Assert.assertTrue((boolean)set.contains(integer));
            Assert.assertEquals((long)(++size), (long)set.size());
        }
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.contains(null));
        for (String string : setString20) {
            modified = set.add(string);
            Assert.assertTrue((boolean)modified);
            Assert.assertTrue((boolean)set.contains(string));
            Assert.assertEquals((long)(++size), (long)set.size());
        }
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.contains(null));
        for (String string : dequeString40) {
            modified = set.add(string);
            Assert.assertTrue((boolean)modified);
            Assert.assertTrue((boolean)set.contains(string));
            Assert.assertEquals((long)(++size), (long)set.size());
        }
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.contains(null));
        for (Object o : duplicatesList) {
            if (set.contains(o)) {
                modified = set.add(o);
                Assert.assertFalse((boolean)modified);
                Assert.assertTrue((boolean)set.contains(o));
                Assert.assertEquals((long)size, (long)set.size());
                continue;
            }
            modified = set.add(o);
            Assert.assertTrue((boolean)modified);
            Assert.assertTrue((boolean)set.contains(o));
            Assert.assertEquals((long)(++size), (long)set.size());
        }
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        Assert.assertTrue((boolean)set.contains(null));
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size() + duplicatesList.size() / 2), (long)set.size());
    }

    @Test
    public void testAddAll() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = (i / 2 + 1) * 100001;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        Set<Object> set = this.createSet();
        boolean modified = set.addAll(listInt10);
        int expectedCapacity = 16;
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)listInt10.size(), (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        modified = set.addAll(setString20);
        expectedCapacity = 64;
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size()), (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        modified = set.addAll((Collection<Object>)dequeString40);
        expectedCapacity = 128;
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        modified = set.addAll(duplicatesList);
        expectedCapacity = 256;
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size() + duplicatesList.size() / 2), (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
        set.removeAll(setString20);
        Assert.assertEquals((long)(listInt10.size() + dequeString40.size() + duplicatesList.size() / 2), (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
        set.addAll(setString20);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size() + duplicatesList.size() / 2), (long)set.size());
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
    }

    @Test
    public void testClear() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = (i / 2 + 1) * 100001;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        Set<Object> set = this.createSet();
        int expectedCapacity = 16;
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(listInt10);
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(listInt10);
        set.addAll(setString20);
        expectedCapacity = 64;
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        expectedCapacity = 128;
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        set.addAll(duplicatesList);
        expectedCapacity = 256;
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity(set));
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
    }

    @Test
    public void testContains() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = (i / 2 + 1) * 100001;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        Set<Object> set = this.createSet();
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(listInt10);
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(setString20);
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll((Collection<Object>)dequeString40);
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(duplicatesList);
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
        set.removeAll(setString20);
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
        set.clear();
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        set.addAll(duplicatesList);
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
        set.removeAll(listInt10);
        set.removeAll(setString20);
        set.removeAll((Collection<?>)dequeString40);
        set.removeAll(duplicatesList);
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)set.contains(integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)set.contains(string));
        }
        for (Object o : duplicatesList) {
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.contains(null));
    }

    @Test
    public void testContainsAll() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = (i / 2 + 1) * 100001;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        Set<Object> set = this.createSet();
        Assert.assertFalse((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        set.addAll(listInt10);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        set.addAll(setString20);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        set.addAll((Collection<Object>)dequeString40);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        set.addAll(duplicatesList);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        set.removeAll(setString20);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        set.clear();
        Assert.assertFalse((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        set.addAll(duplicatesList);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        Assert.assertTrue((boolean)set.containsAll(setString20));
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        set.removeAll(listInt10);
        set.removeAll(setString20);
        set.removeAll((Collection<?>)dequeString40);
        set.removeAll(duplicatesList);
        Assert.assertFalse((boolean)set.containsAll(listInt10));
        Assert.assertFalse((boolean)set.containsAll(setString20));
        Assert.assertFalse((boolean)set.containsAll((Collection<?>)dequeString40));
        Assert.assertFalse((boolean)set.containsAll(duplicatesList));
    }

    @Test
    public void testEquals() {
        Set<Object> set1 = this.createSet();
        Set<Object> set2 = this.createSet();
        ArrayList<String> objects1 = new ArrayList<String>();
        objects1.add(null);
        objects1.addAll((Collection<String>)this.randomStringDequeNotIn(40, Collections.emptySet()));
        objects1.add(null);
        Assert.assertSame((Object)42, (Object)objects1.size());
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertTrue((boolean)set2.equals(set1));
        set1.addAll(objects1);
        set2.addAll(objects1);
        Set<Object> set3 = this.createSet(set1);
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertTrue((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertTrue((boolean)set2.equals(set3));
        Assert.assertTrue((boolean)set3.equals(set1));
        Assert.assertTrue((boolean)set3.equals(set2));
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (set1.contains(rand)) {
                rand = this.getRandomString();
            }
            set1.add(rand);
            set2.add(rand);
            ++i;
        }
        set1.add(null);
        set2.add(null);
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertFalse((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertFalse((boolean)set2.equals(set3));
        Assert.assertFalse((boolean)set3.equals(set1));
        Assert.assertFalse((boolean)set3.equals(set2));
        set1.remove(null);
        Assert.assertFalse((boolean)set1.equals(set2));
        Assert.assertFalse((boolean)set1.equals(set3));
        Assert.assertFalse((boolean)set2.equals(set1));
        Assert.assertFalse((boolean)set2.equals(set3));
        Assert.assertFalse((boolean)set3.equals(set1));
        Assert.assertFalse((boolean)set3.equals(set2));
        set1.add(null);
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertFalse((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertFalse((boolean)set2.equals(set3));
        Assert.assertFalse((boolean)set3.equals(set1));
        Assert.assertFalse((boolean)set3.equals(set2));
        set1.remove(null);
        set2.remove(null);
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertFalse((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertFalse((boolean)set2.equals(set3));
        Assert.assertFalse((boolean)set3.equals(set1));
        Assert.assertFalse((boolean)set3.equals(set2));
        set1.clear();
        set2.clear();
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertFalse((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertFalse((boolean)set2.equals(set3));
        Assert.assertFalse((boolean)set3.equals(set1));
        Assert.assertFalse((boolean)set3.equals(set2));
        set1.addAll(objects1);
        set2.addAll(objects1);
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertTrue((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertTrue((boolean)set2.equals(set3));
        Assert.assertTrue((boolean)set3.equals(set1));
        Assert.assertTrue((boolean)set3.equals(set2));
        set1.clear();
        set2.clear();
        set3.clear();
        Assert.assertTrue((boolean)set1.equals(set2));
        Assert.assertTrue((boolean)set1.equals(set3));
        Assert.assertTrue((boolean)set2.equals(set1));
        Assert.assertTrue((boolean)set2.equals(set3));
        Assert.assertTrue((boolean)set3.equals(set1));
        Assert.assertTrue((boolean)set3.equals(set2));
    }

    @Test
    public void testHashCode() {
        Set<Object> set1 = this.createSet();
        Set<Object> set2 = this.createSet();
        ArrayList<String> objects1 = new ArrayList<String>();
        objects1.add(null);
        objects1.addAll((Collection<String>)this.randomStringDequeNotIn(40, Collections.emptySet()));
        objects1.add(null);
        Assert.assertSame((Object)42, (Object)objects1.size());
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        set1.addAll(objects1);
        set2.addAll(objects1);
        Set<Object> set3 = this.createSet(set1);
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (set1.contains(rand)) {
                rand = this.getRandomString();
            }
            set1.add(rand);
            set2.add(rand);
            ++i;
        }
        set1.add(null);
        set2.add(null);
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        set1.remove(null);
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        set1.add(null);
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        set1.remove(null);
        set2.remove(null);
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        set1.clear();
        set2.clear();
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        set1.addAll(objects1);
        set2.addAll(objects1);
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        set1.clear();
        set2.clear();
        set3.clear();
        Assert.assertTrue((set1.hashCode() == set2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set1.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set2.hashCode() == set3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set3.hashCode() == set1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((set3.hashCode() == set2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testInstantiationCopy() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = i / 2;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        Set<Object> set = this.createSet(listInt10);
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertSame((Object)listInt10.size(), (Object)set.size());
        Assert.assertSame((Object)this.getNextPowerOfTwo(listInt10.size()), (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        Assert.assertTrue((boolean)set.containsAll(listInt10));
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)set.contains(integer));
        }
        set = this.createSet(setString20);
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertSame((Object)setString20.size(), (Object)set.size());
        Assert.assertSame((Object)this.getNextPowerOfTwo(setString20.size()), (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        Assert.assertTrue((boolean)set.containsAll(setString20));
        for (String string : setString20) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        set = this.createSet((Collection<? extends Object>)dequeString40);
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertSame((Object)dequeString40.size(), (Object)set.size());
        Assert.assertSame((Object)this.getNextPowerOfTwo(dequeString40.size()), (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        Assert.assertTrue((boolean)set.containsAll((Collection<?>)dequeString40));
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)set.contains(string));
        }
        set = this.createSet(duplicatesList);
        int expectedSize = duplicatesList.size() / 2;
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertSame((Object)expectedSize, (Object)set.size());
        Assert.assertEquals((long)this.getNextPowerOfTwo(duplicatesList.size()), (long)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        Assert.assertTrue((boolean)set.containsAll(duplicatesList));
        for (Object o : duplicatesList) {
            Assert.assertTrue((boolean)set.contains(o));
        }
        Assert.assertTrue((boolean)set.contains(null));
    }

    @Test
    public void testInstantiationEmpty() {
        Set<Object> set = this.createSet();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
    }

    @Test
    public void testInstantiationLoadFactor() {
        float loadFactor;
        int n;
        int n2;
        float[] fArray;
        int capacity;
        int[] nArray = new int[5];
        nArray[0] = 10;
        nArray[2] = 1023;
        nArray[3] = Integer.MIN_VALUE;
        nArray[4] = -10;
        int[] validCapacities = nArray;
        float[] validLoadFactors = new float[]{1.0E-6f, 0.5f, 0.75f, 1.0f, Float.MIN_VALUE};
        int[] invalidCapacities = new int[]{Integer.MAX_VALUE, 0x40000001};
        float[] invalidLoadFactors = new float[]{0.0f, -1.0f, 1.000001f, 5.0f, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NaN, Float.MAX_VALUE};
        int[] nArray2 = validCapacities;
        int n3 = validCapacities.length;
        int n4 = 0;
        while (n4 < n3) {
            capacity = nArray2[n4];
            fArray = validLoadFactors;
            n2 = validLoadFactors.length;
            n = 0;
            while (n < n2) {
                loadFactor = fArray[n];
                Set<Object> set = this.createSet(capacity, loadFactor);
                Assert.assertTrue((boolean)set.isEmpty());
                Assert.assertSame((Object)0, (Object)set.size());
                Assert.assertEquals((long)Math.max(4, this.getNextPowerOfTwo(capacity)), (long)this.getInternalCapacity(set));
                Assert.assertEquals((double)loadFactor, (double)this.getInternalLoadFactor(set), (double)0.001);
                ++n;
            }
            fArray = invalidLoadFactors;
            n2 = invalidLoadFactors.length;
            n = 0;
            while (n < n2) {
                loadFactor = fArray[n];
                try {
                    this.createSet(capacity, loadFactor);
                    if (loadFactor <= 0.0f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
                        Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
                    } else {
                        Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++n;
            }
            ++n4;
        }
        nArray2 = invalidCapacities;
        n3 = invalidCapacities.length;
        n4 = 0;
        while (n4 < n3) {
            capacity = nArray2[n4];
            fArray = validLoadFactors;
            n2 = validLoadFactors.length;
            n = 0;
            while (n < n2) {
                loadFactor = fArray[n];
                try {
                    this.createSet(capacity, loadFactor);
                    Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
            fArray = invalidLoadFactors;
            n2 = invalidLoadFactors.length;
            n = 0;
            while (n < n2) {
                loadFactor = fArray[n];
                try {
                    this.createSet(capacity, loadFactor);
                    if (loadFactor <= 0.0f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
                        Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
                    } else {
                        Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++n;
            }
            ++n4;
        }
    }

    @Test
    public void testInstantiationSize() {
        Set<Object> set = this.createSet(10);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        set = this.createSet(0);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertSame((Object)4, (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        set = this.createSet(1023);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertEquals((long)1024L, (long)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        set = this.createSet(Integer.MIN_VALUE);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertSame((Object)4, (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        set = this.createSet(-10);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertSame((Object)0, (Object)set.size());
        Assert.assertSame((Object)4, (Object)this.getInternalCapacity(set));
        Assert.assertEquals((double)0.75, (double)this.getInternalLoadFactor(set), (double)0.001);
        try {
            set = this.createSet(Integer.MAX_VALUE);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            set = this.createSet(0x40000001);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEmpty() {
        Set<Object> set = this.createSet();
        Assert.assertTrue((boolean)set.isEmpty());
        set.add(null);
        Assert.assertFalse((boolean)set.isEmpty());
        ArrayList<String> elements = new ArrayList<String>();
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            elements.add(rand);
            set.add(rand);
            Assert.assertFalse((boolean)set.isEmpty());
            ++i;
        }
        for (String rand : elements) {
            set.remove(rand);
            Assert.assertFalse((boolean)set.isEmpty());
        }
        set.remove(null);
        Assert.assertTrue((boolean)set.isEmpty());
        i = 0;
        while (i < 100) {
            set.add(this.getRandomString());
            Assert.assertFalse((boolean)set.isEmpty());
            ++i;
        }
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testIterator() {
        Object next;
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        Set<Object> set = this.createSet();
        Iterator<Object> emptyIterator = set.iterator();
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Iterator<Object> concurrentIterator = set.iterator();
        set.add(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        set.clear();
        set.add(null);
        concurrentIterator = set.iterator();
        Assert.assertNull((Object)concurrentIterator.next());
        set.add(new Object());
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        set.clear();
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        Iterator<Object> containedValues = set.iterator();
        while (containedValues.hasNext()) {
            next = containedValues.next();
            Assert.assertTrue((listInt10.contains(next) || setString20.contains(next) || dequeString40.contains(next) ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
        for (Integer val : listInt10) {
            set.remove(val);
        }
        set.addAll(listInt10);
        containedValues = set.iterator();
        while (containedValues.hasNext()) {
            next = containedValues.next();
            Assert.assertTrue((listInt10.contains(next) || setString20.contains(next) || dequeString40.contains(next) ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
        try {
            containedValues.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        set.clear();
        Assert.assertFalse((boolean)set.iterator().hasNext());
        containedValues = set.iterator();
        try {
            containedValues.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIteratorRemove() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        Set<Object> set = this.createSet();
        Iterator<Object> emptyIterator = set.iterator();
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Iterator<Object> concurrentIterator = set.iterator();
        set.add(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        set.clear();
        set.addAll(listInt10);
        set.addAll(setString20);
        set.addAll((Collection<Object>)dequeString40);
        Iterator<Object> containedValues = set.iterator();
        int size = set.size();
        while (containedValues.hasNext()) {
            Object next = containedValues.next();
            Assert.assertTrue((listInt10.contains(next) || setString20.contains(next) || dequeString40.contains(next) ? 1 : 0) != 0);
            Assert.assertSame((Object)size, (Object)set.size());
            containedValues.remove();
            Assert.assertFalse((boolean)set.contains(next));
            Assert.assertSame((Object)(--size), (Object)set.size());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
        Assert.assertSame((Object)0, (Object)set.size());
    }

    @Test
    public void testRehashing() {
        Set<Object> set1 = this.createSet();
        Set<Object> set2 = this.createSet();
        ArrayList<Integer> integers = new ArrayList<Integer>();
        int i = 1;
        while (i < 14) {
            integers.add(i);
            ++i;
        }
        Assert.assertSame((Object)0, (Object)set1.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set1));
        Assert.assertSame((Object)0, (Object)set2.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set2));
        i = 0;
        while (i < 12) {
            set1.add(integers.get(i));
            set2.add(integers.get(i));
            ++i;
        }
        Assert.assertSame((Object)12, (Object)set1.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set1));
        Assert.assertSame((Object)12, (Object)set2.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set2));
        i = 0;
        while (i < 11) {
            set1.remove(integers.get(i));
            ++i;
        }
        Assert.assertSame((Object)1, (Object)set1.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set1));
        Assert.assertSame((Object)12, (Object)set2.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set2));
        set1.add(integers.get(12));
        set2.add(integers.get(12));
        Assert.assertSame((Object)2, (Object)set1.size());
        Assert.assertSame((Object)16, (Object)this.getInternalCapacity(set1));
        Assert.assertSame((Object)13, (Object)set2.size());
        Assert.assertSame((Object)32, (Object)this.getInternalCapacity(set2));
    }

    @Test
    public void testRemove() {
        boolean removed;
        Set<Object> set = this.createSet();
        List<String> objects = this.randomStringListNotIn(20, Collections.emptySet());
        Assert.assertFalse((boolean)set.containsAll(objects));
        for (String o : objects) {
            removed = set.remove(o);
            Assert.assertFalse((boolean)removed);
            Assert.assertFalse((boolean)set.contains(o));
        }
        for (String o : objects) {
            set.add(o);
        }
        Assert.assertTrue((boolean)set.containsAll(objects));
        for (String o : objects) {
            Assert.assertTrue((boolean)set.contains(o));
            removed = set.remove(o);
            Assert.assertTrue((boolean)removed);
            Assert.assertFalse((boolean)set.contains(o));
        }
        Assert.assertFalse((boolean)set.containsAll(objects));
        for (String o : objects) {
            removed = set.remove(o);
            Assert.assertFalse((boolean)removed);
            Assert.assertFalse((boolean)set.contains(o));
        }
    }

    protected Set<Object> createSet() {
        return new CompactHashSet();
    }

    protected Set<Object> createSet(Collection<? extends Object> collection) {
        return new CompactHashSet(collection);
    }

    protected Set<Object> createSet(int elementCount) {
        return new CompactHashSet(elementCount);
    }

    protected Set<Object> createSet(int elementCount, float loadFactor) {
        return new CompactHashSet(elementCount, loadFactor);
    }

    protected List<Integer> randomIntegerListNotIn(int size, Collection<?> excluded) {
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        int i = 0;
        while (i < size) {
            Integer integer = this.getRandomInteger();
            while (list.contains(integer) || excluded.contains(integer)) {
                integer = this.getRandomInteger();
            }
            list.add(integer);
            ++i;
        }
        return list;
    }

    protected List<String> randomStringListNotIn(int size, Collection<?> excluded) {
        ArrayList<String> list = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            String string = this.getRandomString();
            while (list.contains(string) || excluded.contains(string)) {
                string = this.getRandomString();
            }
            list.add(string);
            ++i;
        }
        return list;
    }

    protected Deque<String> randomStringDequeNotIn(int size, Collection<?> excluded) {
        CircularArrayDeque deque = new CircularArrayDeque(size);
        int i = 0;
        while (i < size) {
            String s = this.getRandomString();
            while (deque.contains((Object)s) || excluded.contains(s)) {
                s = this.getRandomString();
            }
            deque.add((Object)s);
            ++i;
        }
        return deque;
    }

    protected Set<String> randomStringSetNotIn(int size, Collection<?> excluded) {
        HashSet<String> set = new HashSet<String>(size);
        int i = 0;
        while (i < size) {
            String s = this.getRandomString();
            while (set.contains(s) || excluded.contains(s)) {
                s = this.getRandomString();
            }
            set.add(s);
            ++i;
        }
        return set;
    }

    private Object[] getInternalArray(Set<?> set) {
        if (!(set instanceof CompactHashSet)) {
            Assert.fail((String)"Unexpected set implementation");
        }
        Field dataField = null;
        Field[] fieldArray = CompactHashSet.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("data")) {
                dataField = field;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(dataField);
        assert (dataField != null);
        dataField.setAccessible(true);
        Object[] data = null;
        try {
            data = (Object[])dataField.get(set);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (data == null) {
            Assert.fail((String)("could not retrieve internal data array of " + set));
        }
        return data;
    }

    private int getInternalCapacity(Set<?> set) {
        Object[] data = this.getInternalArray(set);
        return data.length;
    }

    private float getInternalLoadFactor(Set<?> set) {
        if (!(set instanceof CompactHashSet)) {
            Assert.fail((String)"Unexpected set implementation");
        }
        Field loadFactorField = null;
        Field[] fieldArray = CompactHashSet.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("loadFactor")) {
                loadFactorField = field;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(loadFactorField);
        assert (loadFactorField != null);
        loadFactorField.setAccessible(true);
        Float loadFactor = null;
        try {
            loadFactor = (Float)loadFactorField.get(set);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (loadFactor == null) {
            Assert.fail((String)("could not retrieve load factor of " + set));
        }
        assert (loadFactor != null);
        return loadFactor.floatValue();
    }

    private int getNextPowerOfTwo(int number) {
        int powerOfTwo = number--;
        powerOfTwo |= powerOfTwo >> 1;
        powerOfTwo |= powerOfTwo >> 2;
        powerOfTwo |= powerOfTwo >> 4;
        powerOfTwo |= powerOfTwo >> 8;
        powerOfTwo |= powerOfTwo >> 16;
        return ++powerOfTwo;
    }

    private Integer getRandomInteger() {
        return Double.valueOf(Math.random() * 100000.0).intValue();
    }

    private String getRandomString() {
        return this.getRandomInteger().toString();
    }
}

