/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.Deque;
import org.junit.Assert;
import org.junit.Test;

public class CircularArrayDequeTest {
    @Test
    public void testAdd() {
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        boolean modified = deque.add((Object)integer1);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        modified = deque.add((Object)integer2);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)integer2, (Object)deque.getLast());
        modified = deque.add((Object)string1);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string1, (Object)deque.getLast());
        modified = deque.add((Object)string2);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)4, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string2, (Object)deque.getLast());
        modified = deque.add(object1);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)5, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object1, (Object)deque.getLast());
        modified = deque.add(object2);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        modified = deque.add(null);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        deque.pop();
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        modified = deque.add(null);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.add((Object)rand);
            Assert.assertSame((Object)(7 + i + 1), (Object)deque.size());
            Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
            Assert.assertEquals((Object)integer1, (Object)deque.peek());
            Assert.assertSame((Object)rand, (Object)deque.getLast());
            ++i;
        }
    }

    @Test
    public void testAddAll() {
        List emptyCollection = Collections.emptyList();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque();
        boolean modified = deque.addAll(listInt10);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)listInt10.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.addAll(emptyCollection);
        Assert.assertFalse((boolean)modified);
        Assert.assertEquals((long)listInt10.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.addAll(setString20);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.addAll(dequeString40);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        int expectedCapacity = this.getNextPowerOfTwo(deque.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        for (Integer val : listInt10) {
            deque.removeFirst();
        }
        Assert.assertEquals((long)(setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertFalse((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.addAll(listInt10);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.addAll(emptyCollection);
        Assert.assertFalse((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
    }

    @Test
    public void testAddAllRandomAccess() {
        List emptyCollection = Collections.emptyList();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        int i = 0;
        while (i < 5) {
            CircularArrayDeque deque = new CircularArrayDeque();
            int insertionIndex = 0;
            if (i == 1) {
                insertionIndex = deque.size();
            } else if (i == 2) {
                insertionIndex = deque.size() / 4;
            } else if (i == 3) {
                insertionIndex = deque.size() / 4 * 3;
            } else if (i == 4) {
                insertionIndex = deque.size() / 2;
            }
            boolean modified = deque.addAll(insertionIndex, emptyCollection);
            Assert.assertFalse((boolean)modified);
            Assert.assertEquals((long)0L, (long)deque.size());
            Assert.assertEquals((long)16L, (long)this.getInternalCapacity((Deque<?>)deque));
            insertionIndex = 0;
            if (i == 1) {
                insertionIndex = deque.size();
            } else if (i == 2) {
                insertionIndex = deque.size() / 4;
            } else if (i == 3) {
                insertionIndex = deque.size() / 4 * 3;
            } else if (i == 4) {
                insertionIndex = deque.size() / 2;
            }
            modified = deque.addAll(insertionIndex, listInt10);
            Assert.assertTrue((boolean)modified);
            Assert.assertEquals((long)listInt10.size(), (long)deque.size());
            Assert.assertTrue((boolean)deque.containsAll(listInt10));
            Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
            insertionIndex = 0;
            if (i == 1) {
                insertionIndex = deque.size();
            } else if (i == 2) {
                insertionIndex = deque.size() / 4;
            } else if (i == 3) {
                insertionIndex = deque.size() / 4 * 3;
            } else if (i == 4) {
                insertionIndex = deque.size() / 2;
            }
            modified = deque.addAll(insertionIndex, setString20);
            Assert.assertTrue((boolean)modified);
            Assert.assertEquals((long)(listInt10.size() + setString20.size()), (long)deque.size());
            Assert.assertTrue((boolean)deque.containsAll(listInt10));
            Assert.assertTrue((boolean)deque.containsAll(setString20));
            Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
            insertionIndex = 0;
            if (i == 1) {
                insertionIndex = deque.size();
            } else if (i == 2) {
                insertionIndex = deque.size() / 4;
            } else if (i == 3) {
                insertionIndex = deque.size() / 4 * 3;
            } else if (i == 4) {
                insertionIndex = deque.size() / 2;
            }
            modified = deque.addAll(insertionIndex, dequeString40);
            Assert.assertTrue((boolean)modified);
            Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
            Assert.assertTrue((boolean)deque.containsAll(listInt10));
            Assert.assertTrue((boolean)deque.containsAll(setString20));
            Assert.assertTrue((boolean)deque.containsAll(dequeString40));
            Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
            ++i;
        }
    }

    @Test
    public void testAddAllRandomAccessLeftRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            ArrayList<Object> testCollection = new ArrayList<Object>();
            testCollection.add(testObjects[i]);
            testCollection.add(testObjects[testObjects.length - 1 - i]);
            this.internalTestAddAllRandomAccessLeftRotate(testCollection);
            ++i;
        }
    }

    @Test
    public void testAddAllRandomAccessRightRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            ArrayList<Object> testCollection = new ArrayList<Object>();
            testCollection.add(testObjects[i]);
            testCollection.add(testObjects[testObjects.length - 1 - i]);
            this.internalTestAddAllRandomAccessRightRotate(testCollection);
            ++i;
        }
    }

    @Test
    public void testAddAllRandomOutOfBounds() {
        CircularArrayDeque deque = new CircularArrayDeque();
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            ArrayList<Object> testCollection = new ArrayList<Object>();
            testCollection.add(testObjects[i]);
            testCollection.add(testObjects[testObjects.length - 1 - i]);
            try {
                deque.addAll(-1, testCollection);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                deque.addAll(deque.size() + 1, testCollection);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Test
    public void testAddFirst() {
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.addFirst((Object)integer1);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst((Object)integer2);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertEquals((Object)integer2, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst((Object)string1);
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)string1, (Object)deque.getFirst());
        Assert.assertEquals((Object)string1, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst((Object)string2);
        Assert.assertSame((Object)4, (Object)deque.size());
        Assert.assertEquals((Object)string2, (Object)deque.getFirst());
        Assert.assertEquals((Object)string2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst(object1);
        Assert.assertSame((Object)5, (Object)deque.size());
        Assert.assertEquals((Object)object1, (Object)deque.getFirst());
        Assert.assertEquals((Object)object1, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst(object2);
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)object2, (Object)deque.getFirst());
        Assert.assertEquals((Object)object2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertSame(null, (Object)deque.getFirst());
        Assert.assertSame(null, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.removeFirst();
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)object2, (Object)deque.getFirst());
        Assert.assertEquals((Object)object2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.addFirst(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertSame(null, (Object)deque.getFirst());
        Assert.assertSame(null, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            Assert.assertSame((Object)(7 + i + 1), (Object)deque.size());
            Assert.assertEquals((Object)rand, (Object)deque.getFirst());
            Assert.assertEquals((Object)rand, (Object)deque.peek());
            Assert.assertSame((Object)integer1, (Object)deque.getLast());
            ++i;
        }
    }

    @Test
    public void testAddLast() {
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.addLast((Object)integer1);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        deque.addLast((Object)integer2);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)integer2, (Object)deque.getLast());
        deque.addLast((Object)string1);
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string1, (Object)deque.getLast());
        deque.addLast((Object)string2);
        Assert.assertSame((Object)4, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string2, (Object)deque.getLast());
        deque.addLast(object1);
        Assert.assertSame((Object)5, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object1, (Object)deque.getLast());
        deque.addLast(object2);
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        deque.addLast(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        deque.pop();
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        deque.addLast(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addLast((Object)rand);
            Assert.assertSame((Object)(7 + i + 1), (Object)deque.size());
            Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
            Assert.assertEquals((Object)integer1, (Object)deque.peek());
            Assert.assertSame((Object)rand, (Object)deque.getLast());
            ++i;
        }
    }

    @Test
    public void testAddRandomAccessLeftRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            this.internalTestAddRandomAccessLeftRotate(testObjects[i]);
            ++i;
        }
    }

    @Test
    public void testAddRandomAccessOutOfBounds() {
        CircularArrayDeque deque = new CircularArrayDeque();
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            try {
                deque.add(-1, testObjects[i]);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                deque.add(deque.size() + 1, testObjects[i]);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Test
    public void testAddRandomAccessRightRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            this.internalTestAddRandomAccessRightRotate(testObjects[i]);
            ++i;
        }
    }

    @Test
    public void testClear() {
        CircularArrayDeque deque = new CircularArrayDeque();
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertEquals((long)16L, (long)this.getInternalCapacity((Deque<?>)deque));
        deque.clear();
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertEquals((long)16L, (long)this.getInternalCapacity((Deque<?>)deque));
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            ++i;
        }
        deque.offer(null);
        Assert.assertSame((Object)101, (Object)deque.size());
        Assert.assertFalse((boolean)deque.isEmpty());
        int expectedCapacity = this.getNextPowerOfTwo(deque.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        deque.clear();
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        deque.clear();
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
    }

    @Test
    public void testContains() {
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.offer(null);
        Assert.assertTrue((boolean)deque.contains(null));
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertTrue((boolean)deque.contains(null));
            Assert.assertTrue((boolean)deque.contains((Object)rand));
            ++i;
        }
        CircularArrayDeque dequeCopy = new CircularArrayDeque((Collection)deque);
        Assert.assertTrue((boolean)deque.contains(null));
        for (Object o : dequeCopy) {
            Assert.assertTrue((boolean)deque.contains(o));
        }
        deque.clear();
        Assert.assertFalse((boolean)deque.contains(null));
        for (Object o : dequeCopy) {
            Assert.assertFalse((boolean)deque.contains(o));
        }
    }

    @Test
    public void testContainsAll() {
        CircularArrayDeque deque = new CircularArrayDeque();
        ArrayList<String> objects1 = new ArrayList<String>();
        objects1.add(null);
        objects1.addAll((Collection<String>)this.randomStringDequeNotIn(40, Collections.emptySet()));
        objects1.add(null);
        Assert.assertSame((Object)42, (Object)objects1.size());
        Assert.assertFalse((boolean)deque.containsAll(objects1));
        deque.addAll(objects1);
        Assert.assertSame((Object)42, (Object)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(objects1));
        ArrayList<String> objects2 = new ArrayList<String>();
        objects2.add(null);
        objects2.addAll(this.randomStringSetNotIn(40, objects1));
        objects2.add(null);
        Assert.assertSame((Object)42, (Object)objects2.size());
        Assert.assertFalse((boolean)deque.containsAll(objects2));
        deque.addAll(objects2);
        Assert.assertSame((Object)(objects1.size() + objects2.size()), (Object)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(objects1));
        Assert.assertTrue((boolean)deque.containsAll(objects2));
        deque.clear();
        Assert.assertFalse((boolean)deque.containsAll(objects1));
        Assert.assertFalse((boolean)deque.containsAll(objects2));
    }

    @Test
    public void testElement() {
        CircularArrayDeque deque = new CircularArrayDeque();
        try {
            deque.element();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.offer(null);
        Assert.assertSame(null, (Object)deque.element());
        int i = 0;
        while (i < 20) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertSame(null, (Object)deque.element());
            ++i;
        }
        ArrayList<String> lastAdded = new ArrayList<String>();
        int i2 = 0;
        while (i2 < 20) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            lastAdded.add(rand);
            Assert.assertEquals((Object)rand, (Object)deque.element());
            ++i2;
        }
        i2 = 0;
        while (i2 < 20) {
            deque.removeFirst();
            if (i2 < 19) {
                Assert.assertEquals(lastAdded.get(lastAdded.size() - i2 - 2), (Object)deque.element());
            } else {
                Assert.assertSame(null, (Object)deque.element());
            }
            ++i2;
        }
        deque.clear();
        try {
            deque.element();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() {
        CircularArrayDeque deque1 = new CircularArrayDeque();
        CircularArrayDeque deque2 = new CircularArrayDeque();
        ArrayList<String> objects1 = new ArrayList<String>();
        objects1.add(null);
        objects1.addAll((Collection<String>)this.randomStringDequeNotIn(40, Collections.emptySet()));
        objects1.add(null);
        Assert.assertSame((Object)42, (Object)objects1.size());
        deque1.addAll(objects1);
        deque2.addAll(objects1);
        CircularArrayDeque deque3 = new CircularArrayDeque((Collection)deque1);
        Assert.assertTrue((boolean)deque1.equals((Object)deque2));
        Assert.assertTrue((boolean)deque1.equals((Object)deque3));
        Assert.assertTrue((boolean)deque2.equals((Object)deque1));
        Assert.assertTrue((boolean)deque2.equals((Object)deque3));
        Assert.assertTrue((boolean)deque3.equals((Object)deque1));
        Assert.assertTrue((boolean)deque3.equals((Object)deque2));
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque1.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque1.offer((Object)rand);
            deque2.offer((Object)rand);
            ++i;
        }
        Assert.assertTrue((boolean)deque1.equals((Object)deque2));
        Assert.assertFalse((boolean)deque1.equals((Object)deque3));
        Assert.assertTrue((boolean)deque2.equals((Object)deque1));
        Assert.assertFalse((boolean)deque2.equals((Object)deque3));
        Assert.assertFalse((boolean)deque3.equals((Object)deque1));
        Assert.assertFalse((boolean)deque3.equals((Object)deque2));
        Object removed = deque1.pop();
        Assert.assertFalse((boolean)deque1.equals((Object)deque2));
        Assert.assertFalse((boolean)deque1.equals((Object)deque3));
        Assert.assertFalse((boolean)deque2.equals((Object)deque1));
        Assert.assertFalse((boolean)deque2.equals((Object)deque3));
        Assert.assertFalse((boolean)deque3.equals((Object)deque1));
        Assert.assertFalse((boolean)deque3.equals((Object)deque2));
        deque1.addFirst(removed);
        Assert.assertFalse((boolean)deque1.equals((Object)deque2));
        Assert.assertFalse((boolean)deque1.equals((Object)deque3));
        Assert.assertFalse((boolean)deque2.equals((Object)deque1));
        Assert.assertFalse((boolean)deque2.equals((Object)deque3));
        Assert.assertFalse((boolean)deque3.equals((Object)deque1));
        Assert.assertFalse((boolean)deque3.equals((Object)deque2));
        deque1.removeFirst();
        deque2.pop();
        Assert.assertTrue((boolean)deque1.equals((Object)deque2));
        Assert.assertFalse((boolean)deque1.equals((Object)deque3));
        Assert.assertTrue((boolean)deque2.equals((Object)deque1));
        Assert.assertFalse((boolean)deque2.equals((Object)deque3));
        Assert.assertFalse((boolean)deque3.equals((Object)deque1));
        Assert.assertFalse((boolean)deque3.equals((Object)deque2));
        deque1.offer(removed);
        deque2.offer(removed);
        Assert.assertTrue((boolean)deque1.equals((Object)deque2));
        Assert.assertFalse((boolean)deque1.equals((Object)deque3));
        Assert.assertTrue((boolean)deque2.equals((Object)deque1));
        Assert.assertFalse((boolean)deque2.equals((Object)deque3));
        Assert.assertFalse((boolean)deque3.equals((Object)deque1));
        Assert.assertFalse((boolean)deque3.equals((Object)deque2));
    }

    @Test
    public void testGet() {
        CircularArrayDeque deque = new CircularArrayDeque();
        ArrayList<String> objects = new ArrayList<String>();
        int max = 100000;
        try {
            deque.get(0);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i22 = 0;
        while (i22 < max) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.add((Object)rand);
            objects.add(rand);
            ++i22;
        }
        try {
            deque.get(-1);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException i22) {
            // empty catch block
        }
        int i = 0;
        while (i < max) {
            Assert.assertEquals(objects.get(i), (Object)deque.get(i));
            Assert.assertEquals(objects.get(max - 1 - i), (Object)deque.get(max - 1 - i));
            ++i;
        }
        try {
            deque.get(deque.size());
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFirst() {
        CircularArrayDeque deque = new CircularArrayDeque();
        try {
            deque.getFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.offer(null);
        Assert.assertSame(null, (Object)deque.getFirst());
        int i = 0;
        while (i < 20) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertSame(null, (Object)deque.getFirst());
            ++i;
        }
        ArrayList<String> lastAdded = new ArrayList<String>();
        int i2 = 0;
        while (i2 < 20) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            lastAdded.add(rand);
            Assert.assertEquals((Object)rand, (Object)deque.getFirst());
            ++i2;
        }
        i2 = 0;
        while (i2 < 20) {
            deque.removeFirst();
            if (i2 < 19) {
                Assert.assertEquals(lastAdded.get(lastAdded.size() - i2 - 2), (Object)deque.getFirst());
            } else {
                Assert.assertSame(null, (Object)deque.getFirst());
            }
            ++i2;
        }
        deque.clear();
        try {
            deque.getFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLast() {
        String rand;
        CircularArrayDeque deque = new CircularArrayDeque();
        try {
            deque.getLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.offer(null);
        Assert.assertSame(null, (Object)deque.getLast());
        ArrayList<String> lastAdded = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            lastAdded.add(rand);
            Assert.assertEquals((Object)rand, (Object)deque.getLast());
            ++i;
        }
        i = 0;
        while (i < 20) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            Assert.assertEquals(lastAdded.get(lastAdded.size() - 1), (Object)deque.getLast());
            ++i;
        }
        i = 0;
        while (i < 20) {
            deque.removeLast();
            if (i < 19) {
                Assert.assertEquals(lastAdded.get(lastAdded.size() - i - 2), (Object)deque.getLast());
            } else {
                Assert.assertSame(null, (Object)deque.getLast());
            }
            ++i;
        }
        deque.clear();
        try {
            deque.getLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() {
        CircularArrayDeque deque1 = new CircularArrayDeque();
        CircularArrayDeque deque2 = new CircularArrayDeque();
        ArrayList<String> objects1 = new ArrayList<String>();
        objects1.add(null);
        objects1.addAll((Collection<String>)this.randomStringDequeNotIn(40, Collections.emptySet()));
        objects1.add(null);
        Assert.assertSame((Object)42, (Object)objects1.size());
        ArrayList<String> objects2 = new ArrayList<String>();
        objects2.add(null);
        objects2.addAll(this.randomStringSetNotIn(40, objects1));
        objects2.add(null);
        Assert.assertSame((Object)42, (Object)objects2.size());
        deque1.addAll(objects1);
        deque2.addAll(objects1);
        CircularArrayDeque deque3 = new CircularArrayDeque((Collection)deque1);
        Assert.assertEquals((long)deque1.hashCode(), (long)deque2.hashCode());
        Assert.assertEquals((long)deque1.hashCode(), (long)deque3.hashCode());
        Assert.assertEquals((long)deque2.hashCode(), (long)deque1.hashCode());
        Assert.assertEquals((long)deque2.hashCode(), (long)deque3.hashCode());
        Assert.assertEquals((long)deque3.hashCode(), (long)deque1.hashCode());
        Assert.assertEquals((long)deque3.hashCode(), (long)deque2.hashCode());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque1.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque1.offer((Object)rand);
            deque2.offer((Object)rand);
            ++i;
        }
        Assert.assertEquals((long)deque1.hashCode(), (long)deque2.hashCode());
        Assert.assertFalse((deque1.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)deque2.hashCode(), (long)deque1.hashCode());
        Assert.assertFalse((deque2.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
        Object removed = deque1.pop();
        Assert.assertFalse((deque1.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque1.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque2.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque2.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
        deque1.addFirst(removed);
        Assert.assertFalse((deque1.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque1.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque2.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque2.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
        deque1.removeFirst();
        deque2.pop();
        Assert.assertEquals((long)deque1.hashCode(), (long)deque2.hashCode());
        Assert.assertFalse((deque1.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)deque2.hashCode(), (long)deque1.hashCode());
        Assert.assertFalse((deque2.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
        deque1.offer(removed);
        deque2.offer(removed);
        Assert.assertEquals((long)deque1.hashCode(), (long)deque2.hashCode());
        Assert.assertFalse((deque1.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)deque2.hashCode(), (long)deque1.hashCode());
        Assert.assertFalse((deque2.hashCode() == deque3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((deque3.hashCode() == deque2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testIndexOf() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 5.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < testObjects.length) {
            Assert.assertEquals((Object)-1, (Object)deque.indexOf(testObjects[i]));
            ++i;
        }
        Object[] objectArray2 = testObjects;
        int n = testObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray2[n2];
            deque.offer(o);
            ++n2;
        }
        Object[] expected = new Object[16];
        int i2 = 0;
        while (i2 < testObjects.length) {
            expected[i2] = testObjects[i2];
            Assert.assertEquals((Object)i2, (Object)deque.indexOf(testObjects[i2]));
            ++i2;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
        deque.clear();
        i2 = 0;
        while (i2 < testObjects.length) {
            Assert.assertEquals((Object)-1, (Object)deque.indexOf(testObjects[i2]));
            ++i2;
        }
        deque = new CircularArrayDeque();
        deque.offer((Object)"a");
        Object[] objectArray3 = testObjects;
        int n3 = testObjects.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray3[n];
            deque.offer(o);
            ++n;
        }
        deque.removeFirst();
        int offset = 1;
        expected = new Object[16];
        int i3 = 0;
        while (i3 < testObjects.length) {
            expected[i3 + offset] = testObjects[i3];
            Assert.assertEquals((Object)i3, (Object)deque.indexOf(testObjects[i3]));
            ++i3;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
        deque = new CircularArrayDeque();
        i3 = 0;
        while (i3 < 10) {
            deque.offer((Object)"a");
            ++i3;
        }
        i3 = 0;
        while (i3 < 9) {
            deque.removeFirst();
            ++i3;
        }
        Object[] objectArray4 = testObjects;
        int n4 = testObjects.length;
        n3 = 0;
        while (n3 < n4) {
            Object o = objectArray4[n3];
            deque.offer(o);
            ++n3;
        }
        deque.removeFirst();
        offset = 10;
        expected = new Object[16];
        i = 0;
        while (i < testObjects.length) {
            expected[i + offset & expected.length - 1] = testObjects[i];
            Assert.assertEquals((Object)i, (Object)deque.indexOf(testObjects[i]));
            ++i;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
        deque = new CircularArrayDeque();
        objectArray4 = testObjects;
        n4 = testObjects.length;
        n3 = 0;
        while (n3 < n4) {
            Object o = objectArray4[n3];
            deque.offer(o);
            ++n3;
        }
        objectArray4 = testObjects;
        n4 = testObjects.length;
        n3 = 0;
        while (n3 < n4) {
            Object o = objectArray4[n3];
            deque.offer(o);
            ++n3;
        }
        expected = new Object[this.getNextPowerOfTwo(testObjects.length * 2)];
        i = 0;
        while (i < testObjects.length) {
            expected[i] = testObjects[i];
            expected[i + testObjects.length] = testObjects[i];
            Assert.assertEquals((Object)i, (Object)deque.indexOf(testObjects[i]));
            Assert.assertEquals((Object)(i + testObjects.length), (Object)deque.lastIndexOf(testObjects[i]));
            ++i;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
    }

    @Test
    public void testInstantiationCopy() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque(listInt10);
        Assert.assertFalse((boolean)deque.isEmpty());
        Assert.assertEquals((long)listInt10.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertEquals((long)this.getNextPowerOfTwo(listInt10.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        deque = new CircularArrayDeque(setString20);
        Assert.assertFalse((boolean)deque.isEmpty());
        Assert.assertEquals((long)setString20.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertEquals((long)this.getNextPowerOfTwo(setString20.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        deque = new CircularArrayDeque(dequeString40);
        Assert.assertFalse((boolean)deque.isEmpty());
        Assert.assertEquals((long)dequeString40.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)this.getNextPowerOfTwo(dequeString40.size()), (long)this.getInternalCapacity((Deque<?>)deque));
    }

    @Test
    public void testInstantiationEmpty() {
        CircularArrayDeque deque = new CircularArrayDeque();
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertEquals((long)16L, (long)this.getInternalCapacity((Deque<?>)deque));
        deque = new CircularArrayDeque(1023);
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertEquals((long)1024L, (long)this.getInternalCapacity((Deque<?>)deque));
        deque = new CircularArrayDeque(Integer.MIN_VALUE);
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertEquals((long)4L, (long)this.getInternalCapacity((Deque<?>)deque));
        deque = new CircularArrayDeque(-1);
        Assert.assertTrue((boolean)deque.isEmpty());
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertEquals((long)4L, (long)this.getInternalCapacity((Deque<?>)deque));
    }

    @Test
    public void testInstantiationError() {
        try {
            new CircularArrayDeque(Integer.MAX_VALUE);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            new CircularArrayDeque(0x40000001);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEmpty() {
        String rand;
        CircularArrayDeque deque = new CircularArrayDeque();
        Assert.assertTrue((boolean)deque.isEmpty());
        deque.offer(null);
        Assert.assertFalse((boolean)deque.isEmpty());
        int i = 0;
        while (i < 100) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertFalse((boolean)deque.isEmpty());
            ++i;
        }
        i = 0;
        while (i < 100) {
            deque.pop();
            Assert.assertFalse((boolean)deque.isEmpty());
            ++i;
        }
        deque.pop();
        Assert.assertTrue((boolean)deque.isEmpty());
        i = 0;
        while (i < 100) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertFalse((boolean)deque.isEmpty());
            ++i;
        }
        deque.clear();
        Assert.assertTrue((boolean)deque.isEmpty());
    }

    @Test
    public void testIsSerializable() {
        List emptyCollection = Collections.emptyList();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        ArrayList<Object> duplicatesList = new ArrayList<Object>();
        int i = 0;
        while (i < 40) {
            int dupe = i / 2;
            duplicatesList.add(dupe);
            duplicatesList.add(String.valueOf(dupe));
            ++i;
        }
        duplicatesList.add(null);
        duplicatesList.add(null);
        CircularArrayDeque deque = new CircularArrayDeque();
        byte[] serialized = this.writeDeque((Deque<Object>)deque);
        Assert.assertTrue((serialized.length > 0 ? 1 : 0) != 0);
        Deque<Object> read = this.readDeque(serialized);
        Assert.assertNotNull(read);
        Assert.assertEquals((Object)deque, read);
        deque.addAll(emptyCollection);
        serialized = this.writeDeque((Deque<Object>)deque);
        Assert.assertTrue((serialized.length > 0 ? 1 : 0) != 0);
        read = this.readDeque(serialized);
        Assert.assertNotNull(read);
        Assert.assertEquals((Object)deque, read);
        deque.addAll(listInt10);
        serialized = this.writeDeque((Deque<Object>)deque);
        Assert.assertTrue((serialized.length > 0 ? 1 : 0) != 0);
        read = this.readDeque(serialized);
        Assert.assertNotNull(read);
        Assert.assertEquals((Object)deque, read);
        deque.addAll(setString20);
        serialized = this.writeDeque((Deque<Object>)deque);
        Assert.assertTrue((serialized.length > 0 ? 1 : 0) != 0);
        read = this.readDeque(serialized);
        Assert.assertNotNull(read);
        Assert.assertEquals((Object)deque, read);
        deque.addAll(dequeString40);
        serialized = this.writeDeque((Deque<Object>)deque);
        Assert.assertTrue((serialized.length > 0 ? 1 : 0) != 0);
        read = this.readDeque(serialized);
        Assert.assertNotNull(read);
        Assert.assertEquals((Object)deque, read);
        deque.addAll(duplicatesList);
        serialized = this.writeDeque((Deque<Object>)deque);
        Assert.assertTrue((serialized.length > 0 ? 1 : 0) != 0);
        read = this.readDeque(serialized);
        Assert.assertNotNull(read);
        Assert.assertEquals((Object)deque, read);
    }

    @Test
    public void testIterator() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque();
        Iterator emptyIterator = deque.iterator();
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Iterator concurrentIterator = deque.iterator();
        deque.addFirst(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        deque.pop();
        concurrentIterator = deque.iterator();
        deque.addLast(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        deque.pop();
        deque.addLast(null);
        concurrentIterator = deque.iterator();
        Assert.assertNull(concurrentIterator.next());
        deque.addLast(null);
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        deque.clear();
        deque.addAll(listInt10);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        Iterator listIterator = listInt10.iterator();
        Iterator setIterator = setString20.iterator();
        Iterator dequeIterator = dequeString40.iterator();
        Iterator containedValues = deque.iterator();
        while (listIterator.hasNext()) {
            Assert.assertEquals(listIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (setIterator.hasNext()) {
            Assert.assertEquals(setIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), containedValues.next());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
        for (Integer val : listInt10) {
            deque.removeFirst();
        }
        deque.addAll(listInt10);
        listIterator = listInt10.iterator();
        setIterator = setString20.iterator();
        dequeIterator = dequeString40.iterator();
        containedValues = deque.iterator();
        while (setIterator.hasNext()) {
            Assert.assertEquals(setIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (listIterator.hasNext()) {
            Assert.assertEquals(listIterator.next(), containedValues.next());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
    }

    @Test
    public void testIteratorRemove() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque();
        Iterator emptyIterator = deque.iterator();
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Iterator concurrentIterator = deque.iterator();
        deque.addFirst(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        deque.pop();
        concurrentIterator = deque.iterator();
        deque.addLast(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        deque.pop();
        deque.addAll(listInt10);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        Iterator listIterator = listInt10.iterator();
        Iterator setIterator = setString20.iterator();
        Iterator dequeIterator = dequeString40.iterator();
        Iterator containedValues = deque.iterator();
        while (listIterator.hasNext()) {
            Assert.assertEquals(listIterator.next(), containedValues.next());
            containedValues.remove();
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (setIterator.hasNext()) {
            Assert.assertEquals(setIterator.next(), containedValues.next());
            containedValues.remove();
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), containedValues.next());
            containedValues.remove();
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
    }

    @Test
    public void testLastIndexOf() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 5.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < testObjects.length) {
            Assert.assertEquals((Object)-1, (Object)deque.lastIndexOf(testObjects[i]));
            ++i;
        }
        Object[] objectArray2 = testObjects;
        int n = testObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray2[n2];
            deque.offer(o);
            ++n2;
        }
        Object[] expected = new Object[16];
        int i2 = 0;
        while (i2 < testObjects.length) {
            expected[i2] = testObjects[i2];
            Assert.assertEquals((Object)i2, (Object)deque.lastIndexOf(testObjects[i2]));
            ++i2;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
        deque.clear();
        i2 = 0;
        while (i2 < testObjects.length) {
            Assert.assertEquals((Object)-1, (Object)deque.lastIndexOf(testObjects[i2]));
            ++i2;
        }
        deque = new CircularArrayDeque();
        deque.offer((Object)"a");
        Object[] objectArray3 = testObjects;
        int n3 = testObjects.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray3[n];
            deque.offer(o);
            ++n;
        }
        deque.removeFirst();
        int offset = 1;
        expected = new Object[16];
        int i3 = 0;
        while (i3 < testObjects.length) {
            expected[i3 + offset] = testObjects[i3];
            Assert.assertEquals((Object)i3, (Object)deque.lastIndexOf(testObjects[i3]));
            ++i3;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
        deque = new CircularArrayDeque();
        i3 = 0;
        while (i3 < 10) {
            deque.offer((Object)"a");
            ++i3;
        }
        i3 = 0;
        while (i3 < 9) {
            deque.removeFirst();
            ++i3;
        }
        Object[] objectArray4 = testObjects;
        int n4 = testObjects.length;
        n3 = 0;
        while (n3 < n4) {
            Object o = objectArray4[n3];
            deque.offer(o);
            ++n3;
        }
        deque.removeFirst();
        offset = 10;
        expected = new Object[16];
        i = 0;
        while (i < testObjects.length) {
            expected[i + offset & expected.length - 1] = testObjects[i];
            Assert.assertEquals((Object)i, (Object)deque.lastIndexOf(testObjects[i]));
            ++i;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
        deque = new CircularArrayDeque();
        objectArray4 = testObjects;
        n4 = testObjects.length;
        n3 = 0;
        while (n3 < n4) {
            Object o = objectArray4[n3];
            deque.offer(o);
            ++n3;
        }
        objectArray4 = testObjects;
        n4 = testObjects.length;
        n3 = 0;
        while (n3 < n4) {
            Object o = objectArray4[n3];
            deque.offer(o);
            ++n3;
        }
        expected = new Object[this.getNextPowerOfTwo(testObjects.length * 2)];
        i = 0;
        while (i < testObjects.length) {
            expected[i] = testObjects[i];
            expected[i + testObjects.length] = testObjects[i];
            Assert.assertEquals((Object)i, (Object)deque.indexOf(testObjects[i]));
            Assert.assertEquals((Object)(i + testObjects.length), (Object)deque.lastIndexOf(testObjects[i]));
            ++i;
        }
        this.assertEqualContent(expected, this.getInternalArray((Deque<?>)deque));
    }

    @Test
    public void testListIterator() {
        CircularArrayDeque deque = new CircularArrayDeque();
        ListIterator emptyIterator = deque.listIterator();
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertFalse((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)0, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)-1, (Object)emptyIterator.previousIndex());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.previous();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.set(new Object());
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            emptyIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Object a = new Object();
        emptyIterator.add(a);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)1, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)0, (Object)emptyIterator.previousIndex());
        Assert.assertEquals((Object)a, emptyIterator.previous());
        Assert.assertTrue((boolean)emptyIterator.hasNext());
        Assert.assertFalse((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)0, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)-1, (Object)emptyIterator.previousIndex());
        Assert.assertEquals((Object)a, emptyIterator.next());
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)1, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)0, (Object)emptyIterator.previousIndex());
        Object b = new Object();
        emptyIterator.add(b);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)2, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)1, (Object)emptyIterator.previousIndex());
        Assert.assertEquals((Object)b, emptyIterator.previous());
        Assert.assertTrue((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)1, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)0, (Object)emptyIterator.previousIndex());
        Object c = new Object();
        emptyIterator.set(c);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertTrue((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)1, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)0, (Object)emptyIterator.previousIndex());
        Assert.assertEquals((Object)c, emptyIterator.next());
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)2, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)1, (Object)emptyIterator.previousIndex());
        Assert.assertEquals((Object)c, emptyIterator.previous());
        Assert.assertTrue((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)1, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)0, (Object)emptyIterator.previousIndex());
        emptyIterator.remove();
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertTrue((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)1, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)0, (Object)emptyIterator.previousIndex());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)a, emptyIterator.previous());
        Assert.assertTrue((boolean)emptyIterator.hasNext());
        Assert.assertFalse((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)0, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)-1, (Object)emptyIterator.previousIndex());
        emptyIterator.remove();
        Assert.assertSame((Object)0, (Object)deque.size());
        Assert.assertFalse((boolean)emptyIterator.hasNext());
        Assert.assertFalse((boolean)emptyIterator.hasPrevious());
        Assert.assertSame((Object)0, (Object)emptyIterator.nextIndex());
        Assert.assertSame((Object)-1, (Object)emptyIterator.previousIndex());
        try {
            emptyIterator.next();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.previous();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            emptyIterator.set(new Object());
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            emptyIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ListIterator concurrentIterator = deque.listIterator();
        deque.addFirst(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.previous();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.add(new Object());
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.set(new Object());
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        deque.pop();
        concurrentIterator = deque.listIterator();
        deque.addLast(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.previous();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.add(new Object());
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.set(new Object());
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected IllegalStateException hasn't been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        deque.pop();
        deque.addLast(null);
        concurrentIterator = deque.listIterator();
        Assert.assertNull(concurrentIterator.next());
        deque.addLast(null);
        try {
            concurrentIterator.next();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.previous();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.add(new Object());
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.set(new Object());
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            concurrentIterator.remove();
            Assert.fail((String)"Expected ConcurrentModificationException hasn't been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        deque.clear();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        deque.addAll(listInt10);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        Iterator<Integer> listIterator = listInt10.iterator();
        Iterator<String> setIterator = setString20.iterator();
        Iterator dequeIterator = dequeString40.iterator();
        ListIterator containedValues = deque.listIterator();
        while (listIterator.hasNext()) {
            Assert.assertEquals((Object)listIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (setIterator.hasNext()) {
            Assert.assertEquals((Object)setIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), containedValues.next());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
        Assert.assertTrue((boolean)containedValues.hasPrevious());
        int i = dequeString40.size() - 1;
        while (i >= 0 && containedValues.hasPrevious()) {
            Assert.assertEquals(dequeString40.get(i), containedValues.previous());
            --i;
        }
        Assert.assertTrue((boolean)containedValues.hasPrevious());
        ArrayList<String> setCopy = new ArrayList<String>(setString20);
        int i2 = setString20.size() - 1;
        while (i2 >= 0 && containedValues.hasPrevious()) {
            Assert.assertEquals(setCopy.get(i2), containedValues.previous());
            --i2;
        }
        Assert.assertTrue((boolean)containedValues.hasPrevious());
        i2 = listInt10.size() - 1;
        while (i2 >= 0 && containedValues.hasPrevious()) {
            Assert.assertEquals((Object)listInt10.get(i2), containedValues.previous());
            --i2;
        }
        Assert.assertFalse((boolean)containedValues.hasPrevious());
        for (Integer val : listInt10) {
            deque.removeFirst();
        }
        deque.addAll(listInt10);
        listIterator = listInt10.iterator();
        setIterator = setString20.iterator();
        dequeIterator = dequeString40.iterator();
        containedValues = deque.listIterator();
        while (setIterator.hasNext()) {
            Assert.assertEquals((Object)setIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (dequeIterator.hasNext()) {
            Assert.assertEquals(dequeIterator.next(), containedValues.next());
        }
        Assert.assertTrue((boolean)containedValues.hasNext());
        while (listIterator.hasNext()) {
            Assert.assertEquals((Object)listIterator.next(), containedValues.next());
        }
        Assert.assertFalse((boolean)containedValues.hasNext());
    }

    @Test
    public void testListIteratorStartAt() {
        CircularArrayDeque deque = new CircularArrayDeque();
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        try {
            deque.listIterator(-1);
            Assert.fail((String)"Expected IndexOutOfBoundsException  hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            deque.listIterator(deque.size() + 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException  hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Object[] objectArray2 = testObjects;
        int n = testObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray2[n2];
            deque.add(o);
            ++n2;
        }
        try {
            deque.listIterator(-1);
            Assert.fail((String)"Expected IndexOutOfBoundsException  hasn't been thrown");
        }
        catch (IndexOutOfBoundsException o) {
            // empty catch block
        }
        ListIterator iterator = deque.listIterator(0);
        Assert.assertFalse((boolean)iterator.hasPrevious());
        Object[] objectArray3 = testObjects;
        int n3 = testObjects.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray3[n];
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)o, iterator.next());
            ++n;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        int i = testObjects.length - 1;
        while (i >= 0) {
            Assert.assertTrue((boolean)iterator.hasPrevious());
            Assert.assertEquals((Object)testObjects[i], iterator.previous());
            --i;
        }
        Assert.assertFalse((boolean)iterator.hasPrevious());
        iterator = deque.listIterator(deque.size());
        Assert.assertFalse((boolean)iterator.hasNext());
        i = testObjects.length - 1;
        while (i >= 0) {
            Assert.assertTrue((boolean)iterator.hasPrevious());
            Assert.assertEquals((Object)testObjects[i], iterator.previous());
            --i;
        }
        Assert.assertFalse((boolean)iterator.hasPrevious());
        objectArray3 = testObjects;
        n3 = testObjects.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray3[n];
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)o, iterator.next());
            ++n;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            deque.listIterator(deque.size() + 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException  hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testOffer() {
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.offer((Object)integer1);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        deque.offer((Object)integer2);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)integer2, (Object)deque.getLast());
        deque.offer((Object)string1);
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string1, (Object)deque.getLast());
        deque.offer((Object)string2);
        Assert.assertSame((Object)4, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string2, (Object)deque.getLast());
        deque.offer(object1);
        Assert.assertSame((Object)5, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object1, (Object)deque.getLast());
        deque.offer(object2);
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        deque.offer(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        deque.pop();
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        deque.offer(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertSame((Object)(7 + i + 1), (Object)deque.size());
            Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
            Assert.assertEquals((Object)integer1, (Object)deque.peek());
            Assert.assertSame((Object)rand, (Object)deque.getLast());
            ++i;
        }
    }

    @Test
    public void testOfferAll() {
        List emptyCollection = Collections.emptyList();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.offerAll(listInt10);
        Assert.assertEquals((long)listInt10.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        deque.offerAll(emptyCollection);
        Assert.assertEquals((long)listInt10.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        deque.offerAll(setString20);
        Assert.assertEquals((long)(listInt10.size() + setString20.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        deque.offerAll(dequeString40);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        int expectedCapacity = this.getNextPowerOfTwo(deque.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        for (Integer val : listInt10) {
            deque.removeFirst();
        }
        Assert.assertEquals((long)(setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertFalse((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        deque.offerAll(listInt10);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
        deque.offerAll(emptyCollection);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)this.getNextPowerOfTwo(deque.size()), (long)this.getInternalCapacity((Deque<?>)deque));
    }

    @Test
    public void testOfferFirst() {
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.offerFirst((Object)integer1);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst((Object)integer2);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertEquals((Object)integer2, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst((Object)string1);
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)string1, (Object)deque.getFirst());
        Assert.assertEquals((Object)string1, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst((Object)string2);
        Assert.assertSame((Object)4, (Object)deque.size());
        Assert.assertEquals((Object)string2, (Object)deque.getFirst());
        Assert.assertEquals((Object)string2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst(object1);
        Assert.assertSame((Object)5, (Object)deque.size());
        Assert.assertEquals((Object)object1, (Object)deque.getFirst());
        Assert.assertEquals((Object)object1, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst(object2);
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)object2, (Object)deque.getFirst());
        Assert.assertEquals((Object)object2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertSame(null, (Object)deque.getFirst());
        Assert.assertSame(null, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.removeFirst();
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)object2, (Object)deque.getFirst());
        Assert.assertEquals((Object)object2, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        deque.offerFirst(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertSame(null, (Object)deque.getFirst());
        Assert.assertSame(null, (Object)deque.peek());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offerFirst((Object)rand);
            Assert.assertSame((Object)(7 + i + 1), (Object)deque.size());
            Assert.assertEquals((Object)rand, (Object)deque.getFirst());
            Assert.assertEquals((Object)rand, (Object)deque.peek());
            Assert.assertSame((Object)integer1, (Object)deque.getLast());
            ++i;
        }
    }

    @Test
    public void testOfferLast() {
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.offerLast((Object)integer1);
        Assert.assertSame((Object)1, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.getLast());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        deque.offerLast((Object)integer2);
        Assert.assertSame((Object)2, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)integer2, (Object)deque.getLast());
        deque.offerLast((Object)string1);
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string1, (Object)deque.getLast());
        deque.offerLast((Object)string2);
        Assert.assertSame((Object)4, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)string2, (Object)deque.getLast());
        deque.offerLast(object1);
        Assert.assertSame((Object)5, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object1, (Object)deque.getLast());
        deque.offerLast(object2);
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        deque.offerLast(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        deque.pop();
        Assert.assertSame((Object)6, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertEquals((Object)object2, (Object)deque.getLast());
        deque.offerLast(null);
        Assert.assertSame((Object)7, (Object)deque.size());
        Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
        Assert.assertEquals((Object)integer1, (Object)deque.peek());
        Assert.assertSame(null, (Object)deque.getLast());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offerLast((Object)rand);
            Assert.assertSame((Object)(7 + i + 1), (Object)deque.size());
            Assert.assertEquals((Object)integer1, (Object)deque.getFirst());
            Assert.assertEquals((Object)integer1, (Object)deque.peek());
            Assert.assertSame((Object)rand, (Object)deque.getLast());
            ++i;
        }
    }

    @Test
    public void testParameterizedToArray() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Object[] array = deque.toArray(new Object[0]);
        Assert.assertSame((Object)0, (Object)array.length);
        array = deque.toArray(new Object[21]);
        Assert.assertSame((Object)21, (Object)array.length);
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Assert.assertNull((Object)o);
            ++n2;
        }
        deque.addAll(objectsLast);
        array = deque.toArray(new Object[0]);
        Assert.assertSame((Object)deque.size(), (Object)array.length);
        Iterator dequeIterator = deque.iterator();
        int i = 0;
        while (i < deque.size()) {
            Assert.assertEquals(dequeIterator.next(), (Object)array[i]);
            ++i;
        }
        array = new String[21];
        deque.toArray(array);
        Assert.assertSame((Object)21, (Object)array.length);
        dequeIterator = deque.iterator();
        i = 0;
        while (i < deque.size()) {
            Assert.assertEquals(dequeIterator.next(), (Object)array[i]);
            ++i;
        }
        deque.clear();
        deque.addAll(objectsLast);
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        array = deque.toArray(new Object[0]);
        Assert.assertSame((Object)deque.size(), (Object)array.length);
        dequeIterator = deque.iterator();
        i = 0;
        while (i < deque.size()) {
            Assert.assertEquals(dequeIterator.next(), (Object)array[i]);
            ++i;
        }
        array = new String[41];
        deque.toArray(array);
        Assert.assertSame((Object)41, (Object)array.length);
        dequeIterator = deque.iterator();
        i = 0;
        while (i < deque.size()) {
            Assert.assertEquals(dequeIterator.next(), (Object)array[i]);
            ++i;
        }
        deque.clear();
        Assert.assertEquals((long)this.getNextPowerOfTwo(40), (long)this.getInternalCapacity((Deque<?>)deque));
        array = deque.toArray(new Object[0]);
        Assert.assertSame((Object)0, (Object)array.length);
        array = deque.toArray(new Object[41]);
        Assert.assertSame((Object)41, (Object)array.length);
        Object[] objectArray2 = array;
        int n3 = array.length;
        int n4 = 0;
        while (n4 < n3) {
            Object o = objectArray2[n4];
            Assert.assertNull((Object)o);
            ++n4;
        }
    }

    @Test
    public void testPeek() {
        String rand;
        CircularArrayDeque deque = new CircularArrayDeque();
        Assert.assertNull((Object)deque.peek());
        deque.offer(null);
        Assert.assertSame(null, (Object)deque.peek());
        ArrayList<String> lastAdded = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertSame(null, (Object)deque.peek());
            ++i;
        }
        i = 0;
        while (i < 20) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            lastAdded.add(rand);
            Assert.assertEquals((Object)rand, (Object)deque.peek());
            ++i;
        }
        i = 0;
        while (i < 20) {
            Assert.assertEquals(lastAdded.get(lastAdded.size() - i - 1), (Object)deque.peek());
            deque.removeFirst();
            ++i;
        }
        Assert.assertSame(null, (Object)deque.peek());
        deque.addAll(lastAdded);
        deque.clear();
        Assert.assertNull((Object)deque.peek());
    }

    @Test
    public void testPeekFirst() {
        CircularArrayDeque deque = new CircularArrayDeque();
        try {
            deque.peekFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.offer(null);
        Assert.assertSame(null, (Object)deque.peekFirst());
        int i = 0;
        while (i < 20) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertSame(null, (Object)deque.peekFirst());
            ++i;
        }
        ArrayList<String> lastAdded = new ArrayList<String>();
        int i2 = 0;
        while (i2 < 20) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            lastAdded.add(rand);
            Assert.assertEquals((Object)rand, (Object)deque.peekFirst());
            ++i2;
        }
        i2 = 0;
        while (i2 < 20) {
            deque.removeFirst();
            if (i2 < 19) {
                Assert.assertEquals(lastAdded.get(lastAdded.size() - i2 - 2), (Object)deque.peekFirst());
            } else {
                Assert.assertSame(null, (Object)deque.peekFirst());
            }
            ++i2;
        }
        deque.clear();
        try {
            deque.peekFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testPeekLast() {
        String rand;
        CircularArrayDeque deque = new CircularArrayDeque();
        try {
            deque.peekLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.offer(null);
        Assert.assertSame(null, (Object)deque.peekLast());
        ArrayList<String> lastAdded = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            lastAdded.add(rand);
            Assert.assertEquals((Object)rand, (Object)deque.peekLast());
            ++i;
        }
        i = 0;
        while (i < 20) {
            rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.addFirst((Object)rand);
            Assert.assertEquals(lastAdded.get(lastAdded.size() - 1), (Object)deque.peekLast());
            ++i;
        }
        i = 0;
        while (i < 20) {
            deque.removeLast();
            if (i < 19) {
                Assert.assertEquals(lastAdded.get(lastAdded.size() - i - 2), (Object)deque.peekLast());
            } else {
                Assert.assertSame(null, (Object)deque.peekLast());
            }
            ++i;
        }
        deque.clear();
        try {
            deque.peekLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testPoll() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Assert.assertFalse((boolean)deque.containsAll(objectsFirst));
        Assert.assertFalse((boolean)deque.containsAll(objectsLast));
        Assert.assertNull((Object)deque.poll());
        for (String o : objectsLast) {
            deque.offer((Object)o);
        }
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        Assert.assertTrue((boolean)deque.containsAll(objectsFirst));
        Assert.assertTrue((boolean)deque.containsAll(objectsLast));
        int i = objectsFirst.size() - 1;
        while (i >= 0) {
            Assert.assertEquals((Object)objectsFirst.get(i), (Object)deque.poll());
            --i;
        }
        for (String o : objectsLast) {
            Assert.assertEquals((Object)o, (Object)deque.poll());
        }
        Assert.assertNull((Object)deque.poll());
        deque.addAll(objectsFirst);
        deque.addAll(objectsLast);
        deque.clear();
        Assert.assertNull((Object)deque.poll());
    }

    @Test
    public void testPop() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Assert.assertFalse((boolean)deque.containsAll(objectsFirst));
        Assert.assertFalse((boolean)deque.containsAll(objectsLast));
        try {
            deque.pop();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (String o : objectsLast) {
            deque.offer((Object)o);
        }
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        Assert.assertTrue((boolean)deque.containsAll(objectsFirst));
        Assert.assertTrue((boolean)deque.containsAll(objectsLast));
        int i = objectsLast.size() - 1;
        while (i >= 0) {
            Assert.assertEquals((Object)objectsLast.get(i), (Object)deque.pop());
            --i;
        }
        for (String o : objectsFirst) {
            Assert.assertEquals((Object)o, (Object)deque.pop());
        }
        try {
            deque.pop();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.addAll(objectsFirst);
        deque.addAll(objectsLast);
        deque.clear();
        try {
            deque.pop();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() {
        boolean removed;
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objects = this.randomStringListNotIn(20, Collections.emptySet());
        Assert.assertFalse((boolean)deque.containsAll(objects));
        for (String o : objects) {
            removed = deque.remove((Object)o);
            Assert.assertFalse((boolean)removed);
            Assert.assertFalse((boolean)deque.contains((Object)o));
        }
        for (String o : objects) {
            deque.offer((Object)o);
        }
        Assert.assertTrue((boolean)deque.containsAll(objects));
        for (String o : objects) {
            Assert.assertTrue((boolean)deque.contains((Object)o));
            removed = deque.remove((Object)o);
            Assert.assertTrue((boolean)removed);
            Assert.assertFalse((boolean)deque.contains((Object)o));
        }
        Assert.assertFalse((boolean)deque.containsAll(objects));
        for (String o : objects) {
            removed = deque.remove((Object)o);
            Assert.assertFalse((boolean)removed);
            Assert.assertFalse((boolean)deque.contains((Object)o));
        }
    }

    @Test
    public void testRemoveAll() {
        List emptyCollection = Collections.emptyList();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.addAll(listInt10);
        deque.addAll(emptyCollection);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        int expectedCapacity = this.getNextPowerOfTwo(deque.size());
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        boolean modified = deque.removeAll(listInt10);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertFalse((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.removeAll(emptyCollection);
        Assert.assertFalse((boolean)modified);
        Assert.assertEquals((long)(setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertFalse((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        deque.addAll(listInt10);
        Assert.assertEquals((long)(listInt10.size() + setString20.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertTrue((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.removeAll(setString20);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)(listInt10.size() + dequeString40.size()), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertFalse((boolean)deque.containsAll(setString20));
        Assert.assertTrue((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.removeAll(dequeString40);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)listInt10.size(), (long)deque.size());
        Assert.assertTrue((boolean)deque.containsAll(listInt10));
        Assert.assertFalse((boolean)deque.containsAll(setString20));
        Assert.assertFalse((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        modified = deque.removeAll(listInt10);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)0L, (long)deque.size());
        Assert.assertFalse((boolean)deque.containsAll(listInt10));
        Assert.assertFalse((boolean)deque.containsAll(setString20));
        Assert.assertFalse((boolean)deque.containsAll(dequeString40));
        Assert.assertEquals((long)expectedCapacity, (long)this.getInternalCapacity((Deque<?>)deque));
        Assert.assertTrue((boolean)deque.isEmpty());
        modified = deque.removeAll(listInt10);
        Assert.assertFalse((boolean)modified);
        modified = deque.removeAll(setString20);
        Assert.assertFalse((boolean)modified);
        modified = deque.removeAll(dequeString40);
        Assert.assertFalse((boolean)modified);
        deque.add(null);
        Assert.assertTrue((boolean)deque.contains(null));
        Assert.assertFalse((boolean)deque.isEmpty());
        deque.removeAll(Collections.singleton(null));
        Assert.assertFalse((boolean)deque.contains(null));
        Assert.assertTrue((boolean)deque.isEmpty());
    }

    @Test
    public void testRemoveAllBothRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            ArrayList<Object> testCollection = new ArrayList<Object>();
            testCollection.add(testObjects[i]);
            testCollection.add(testObjects[testObjects.length - 1 - i]);
            this.internalTestRemoveAllBothRotate(testCollection);
            ++i;
        }
    }

    @Test
    public void testRemoveAllLeftRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            ArrayList<Object> testCollection = new ArrayList<Object>();
            testCollection.add(testObjects[i]);
            testCollection.add(testObjects[testObjects.length - 1 - i]);
            this.internalTestRemoveAllLeftRotate(testCollection);
            ++i;
        }
    }

    @Test
    public void testRemoveAllRightRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            ArrayList<Object> testCollection = new ArrayList<Object>();
            testCollection.add(testObjects[i]);
            testCollection.add(testObjects[testObjects.length - 1 - i]);
            this.internalTestRemoveAllRightRotate(testCollection);
            ++i;
        }
    }

    @Test
    public void testRemoveFirst() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Assert.assertFalse((boolean)deque.containsAll(objectsFirst));
        Assert.assertFalse((boolean)deque.containsAll(objectsLast));
        try {
            deque.removeFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (String o : objectsLast) {
            deque.offer((Object)o);
        }
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        Assert.assertTrue((boolean)deque.containsAll(objectsFirst));
        Assert.assertTrue((boolean)deque.containsAll(objectsLast));
        int i = objectsFirst.size() - 1;
        while (i >= 0) {
            Assert.assertEquals((Object)objectsFirst.get(i), (Object)deque.removeFirst());
            --i;
        }
        for (String o : objectsLast) {
            Assert.assertEquals((Object)o, (Object)deque.removeFirst());
        }
        try {
            deque.removeFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.addAll(objectsFirst);
        deque.addAll(objectsLast);
        deque.clear();
        try {
            deque.removeFirst();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLast() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Assert.assertFalse((boolean)deque.containsAll(objectsFirst));
        Assert.assertFalse((boolean)deque.containsAll(objectsLast));
        try {
            deque.removeLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (String o : objectsLast) {
            deque.offer((Object)o);
        }
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        Assert.assertTrue((boolean)deque.containsAll(objectsFirst));
        Assert.assertTrue((boolean)deque.containsAll(objectsLast));
        int i = objectsLast.size() - 1;
        while (i >= 0) {
            Assert.assertEquals((Object)objectsLast.get(i), (Object)deque.removeLast());
            --i;
        }
        for (String o : objectsFirst) {
            Assert.assertEquals((Object)o, (Object)deque.removeLast());
        }
        try {
            deque.removeLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.addAll(objectsFirst);
        deque.addAll(objectsLast);
        deque.clear();
        try {
            deque.removeLast();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLeftRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            this.internalTestRemoveLeftRotate(testObjects[i]);
            ++i;
        }
    }

    @Test
    public void testRemoveQueue() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Assert.assertFalse((boolean)deque.containsAll(objectsFirst));
        Assert.assertFalse((boolean)deque.containsAll(objectsLast));
        try {
            deque.remove();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (String o : objectsLast) {
            deque.offer((Object)o);
        }
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        Assert.assertTrue((boolean)deque.containsAll(objectsFirst));
        Assert.assertTrue((boolean)deque.containsAll(objectsLast));
        int i = objectsFirst.size() - 1;
        while (i >= 0) {
            Assert.assertEquals((Object)objectsFirst.get(i), (Object)deque.remove());
            --i;
        }
        for (String o : objectsLast) {
            Assert.assertEquals((Object)o, (Object)deque.remove());
        }
        try {
            deque.remove();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        deque.addAll(objectsFirst);
        deque.addAll(objectsLast);
        deque.clear();
        try {
            deque.remove();
            Assert.fail((String)"Expected NoSuchElementException hasn't been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveRightRotate() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "abcd";
        objectArray[1] = "";
        objectArray[2] = "*";
        objectArray[3] = "?";
        objectArray[4] = "\n";
        objectArray[5] = Character.valueOf('\'');
        objectArray[7] = 4;
        objectArray[8] = 4.3;
        objectArray[9] = 5L;
        objectArray[10] = 4.3;
        objectArray[11] = new Object();
        Object[] testObjects = objectArray;
        int i = 0;
        while (i < testObjects.length) {
            this.internalTestRemoveRightRotate(testObjects[i]);
            ++i;
        }
    }

    @Test
    public void testRetainAll() {
        List emptyCollection = Collections.emptyList();
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        Deque<String> dequeString40 = this.randomStringDequeNotIn(40, setString20);
        CircularArrayDeque deque = new CircularArrayDeque();
        deque.addAll(listInt10);
        deque.addAll(emptyCollection);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        boolean modified = deque.retainAll(dequeString40);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)dequeString40.size(), (Object)deque.size());
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)deque.contains((Object)integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)deque.contains((Object)string));
        }
        for (String string : dequeString40) {
            Assert.assertTrue((boolean)deque.contains((Object)string));
        }
        deque = new CircularArrayDeque();
        deque.addAll(listInt10);
        deque.addAll(emptyCollection);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        modified = deque.retainAll(setString20);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)setString20.size(), (Object)deque.size());
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)deque.contains((Object)integer));
        }
        for (String string : setString20) {
            Assert.assertTrue((boolean)deque.contains((Object)string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)deque.contains((Object)string));
        }
        deque = new CircularArrayDeque();
        deque.addAll(listInt10);
        deque.addAll(emptyCollection);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        modified = deque.retainAll(listInt10);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)listInt10.size(), (Object)deque.size());
        for (Integer integer : listInt10) {
            Assert.assertTrue((boolean)deque.contains((Object)integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)deque.contains((Object)string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)deque.contains((Object)string));
        }
        deque = new CircularArrayDeque();
        deque.addAll(listInt10);
        deque.addAll(emptyCollection);
        deque.addAll(setString20);
        deque.addAll(dequeString40);
        modified = deque.retainAll(emptyCollection);
        Assert.assertTrue((boolean)modified);
        Assert.assertSame((Object)0, (Object)deque.size());
        for (Integer integer : listInt10) {
            Assert.assertFalse((boolean)deque.contains((Object)integer));
        }
        for (String string : setString20) {
            Assert.assertFalse((boolean)deque.contains((Object)string));
        }
        for (String string : dequeString40) {
            Assert.assertFalse((boolean)deque.contains((Object)string));
        }
        deque = new CircularArrayDeque();
        modified = deque.retainAll(emptyCollection);
        Assert.assertFalse((boolean)modified);
        Assert.assertSame((Object)0, (Object)deque.size());
        modified = deque.retainAll(listInt10);
        Assert.assertFalse((boolean)modified);
        Assert.assertSame((Object)0, (Object)deque.size());
        modified = deque.retainAll(dequeString40);
        Assert.assertFalse((boolean)modified);
        Assert.assertSame((Object)0, (Object)deque.size());
    }

    @Test
    public void testSet() {
        int i;
        int[] invalidIndices;
        Integer integer1 = -1;
        Integer integer2 = -2;
        String string1 = "a";
        String string2 = "b";
        Object object1 = new Object();
        Object object2 = new Object();
        CircularArrayDeque deque = new CircularArrayDeque();
        int[] nArray = new int[4];
        nArray[1] = -1;
        nArray[2] = Integer.MIN_VALUE;
        nArray[3] = deque.size() + 1;
        int[] nArray2 = invalidIndices = nArray;
        int n = invalidIndices.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray2[n2];
            try {
                deque.set(i, (Object)string2);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
        deque.add((Object)integer1);
        deque.add((Object)string1);
        deque.add(object1);
        nArray2 = invalidIndices = new int[]{-1, Integer.MIN_VALUE, deque.size() + 1};
        n = invalidIndices.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray2[n2];
            try {
                deque.set(i, (Object)string2);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
        Assert.assertEquals((Object)integer1, (Object)deque.set(0, (Object)integer2));
        Assert.assertEquals((Object)integer2, (Object)deque.get(0));
        Assert.assertFalse((boolean)deque.contains((Object)integer1));
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)string1, (Object)deque.set(1, (Object)string2));
        Assert.assertEquals((Object)string2, (Object)deque.get(1));
        Assert.assertFalse((boolean)deque.contains((Object)string1));
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)object1, (Object)deque.set(2, object2));
        Assert.assertEquals((Object)object2, (Object)deque.get(2));
        Assert.assertFalse((boolean)deque.contains(object1));
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)string2, (Object)deque.set(1, (Object)integer2));
        Assert.assertEquals((Object)integer2, (Object)deque.get(1));
        Assert.assertFalse((boolean)deque.contains((Object)string2));
        Assert.assertSame((Object)3, (Object)deque.size());
        Assert.assertEquals((Object)object2, (Object)deque.set(2, (Object)integer2));
        Assert.assertEquals((Object)integer2, (Object)deque.get(2));
        Assert.assertFalse((boolean)deque.contains(object2));
        Assert.assertSame((Object)3, (Object)deque.size());
        nArray2 = invalidIndices = new int[]{-1, Integer.MIN_VALUE, deque.size() + 1};
        n = invalidIndices.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray2[n2];
            try {
                deque.set(i, (Object)string2);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
        deque.clear();
        int[] nArray3 = new int[4];
        nArray3[1] = -1;
        nArray3[2] = Integer.MIN_VALUE;
        nArray3[3] = deque.size() + 1;
        nArray2 = invalidIndices = nArray3;
        n = invalidIndices.length;
        n2 = 0;
        while (n2 < n) {
            i = nArray2[n2];
            try {
                deque.set(i, (Object)string2);
                Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n2;
        }
    }

    @Test
    public void testSize() {
        CircularArrayDeque deque = new CircularArrayDeque();
        int size = 0;
        Assert.assertSame((Object)size, (Object)deque.size());
        deque.offer(null);
        Assert.assertSame((Object)(++size), (Object)deque.size());
        int i = 0;
        while (i < 100) {
            String rand = this.getRandomString();
            while (deque.contains((Object)rand)) {
                rand = this.getRandomString();
            }
            deque.offer((Object)rand);
            Assert.assertSame((Object)(++size), (Object)deque.size());
            ++i;
        }
        i = 0;
        while (i < 100) {
            deque.pop();
            Assert.assertSame((Object)(--size), (Object)deque.size());
            ++i;
        }
    }

    @Test
    public void testSubList() {
        List<Integer> listInt10 = this.randomIntegerListNotIn(10, Collections.emptySet());
        Set<String> setString20 = this.randomStringSetNotIn(20, Collections.emptySet());
        CircularArrayDeque deque = new CircularArrayDeque();
        List subList = deque.subList(0, 0);
        Assert.assertEquals((Object)subList, (Object)deque);
        Assert.assertTrue((boolean)subList.isEmpty());
        try {
            deque.subList(0, 5);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        deque.addAll(listInt10);
        deque.addAll(setString20);
        subList = deque.subList(0, deque.size());
        Assert.assertEquals((Object)subList, (Object)deque);
        subList = deque.subList(0, listInt10.size());
        Assert.assertSame((Object)listInt10.size(), (Object)subList.size());
        Assert.assertTrue((boolean)subList.containsAll(listInt10));
        subList = deque.subList(0, listInt10.size() + setString20.size());
        Assert.assertSame((Object)(listInt10.size() + setString20.size()), (Object)subList.size());
        Assert.assertTrue((boolean)subList.containsAll(listInt10));
        Assert.assertTrue((boolean)subList.containsAll(setString20));
        try {
            deque.subList(-1, 10);
            Assert.fail((String)"Expected IndexOutOfBoundsException hasn't been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            deque.subList(5, 0);
            Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        subList = deque.subList(5, 5);
        Assert.assertSame((Object)0, (Object)subList.size());
        Assert.assertTrue((boolean)subList.isEmpty());
    }

    @Test
    public void testToArray() {
        CircularArrayDeque deque = new CircularArrayDeque();
        List<String> objectsFirst = this.randomStringListNotIn(20, Collections.emptySet());
        List<String> objectsLast = this.randomStringListNotIn(20, objectsFirst);
        Object[] array = deque.toArray();
        Assert.assertSame((Object)0, (Object)array.length);
        deque.addAll(objectsLast);
        array = deque.toArray();
        Assert.assertSame((Object)deque.size(), (Object)array.length);
        Iterator dequeIterator = deque.iterator();
        int i = 0;
        while (i < array.length) {
            Assert.assertEquals(dequeIterator.next(), (Object)array[i]);
            ++i;
        }
        deque.clear();
        deque.addAll(objectsLast);
        for (String o : objectsFirst) {
            deque.addFirst((Object)o);
        }
        array = deque.toArray();
        Assert.assertSame((Object)deque.size(), (Object)array.length);
        dequeIterator = deque.iterator();
        i = 0;
        while (i < array.length) {
            Assert.assertEquals(dequeIterator.next(), (Object)array[i]);
            ++i;
        }
        deque.clear();
        array = deque.toArray();
        Assert.assertEquals((long)this.getNextPowerOfTwo(40), (long)this.getInternalCapacity((Deque<?>)deque));
        Assert.assertSame((Object)0, (Object)array.length);
    }

    private void assertEqualContent(Object[] expected, Object[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        int i = 0;
        while (i < expected.length) {
            if (expected[i] == null) {
                Assert.assertSame((Object)expected[i], (Object)actual[i]);
            } else {
                Assert.assertEquals((Object)expected[i], (Object)actual[i]);
            }
            ++i;
        }
    }

    private Object[] getInternalArray(Deque<?> deque) {
        Field dataField = null;
        Field[] fieldArray = deque.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("data")) {
                dataField = field;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(dataField);
        assert (dataField != null);
        dataField.setAccessible(true);
        Object[] data = null;
        try {
            data = (Object[])dataField.get(deque);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (data == null) {
            Assert.fail((String)("could not retrieve capacity of " + deque));
        }
        return data;
    }

    private int getInternalCapacity(Deque<?> deque) {
        Object[] data = this.getInternalArray(deque);
        return data.length;
    }

    private int getNextPowerOfTwo(int number) {
        int powerOfTwo = number--;
        powerOfTwo |= powerOfTwo >> 1;
        powerOfTwo |= powerOfTwo >> 2;
        powerOfTwo |= powerOfTwo >> 4;
        powerOfTwo |= powerOfTwo >> 8;
        powerOfTwo |= powerOfTwo >> 16;
        return ++powerOfTwo;
    }

    private Integer getRandomInteger() {
        return Double.valueOf(Math.random() * 1.0E7).intValue();
    }

    private String getRandomString() {
        return this.getRandomInteger().toString();
    }

    private void internalTestAddAllRandomAccessLeftRotate(List<Object> collection) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 14) {
            deque.offer((Object)"a");
            ++i;
        }
        i = 0;
        while (i < 8) {
            deque.removeFirst();
            ++i;
        }
        deque.addAll(2, collection);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[6] = "a";
        objectArray[7] = "a";
        objectArray[8] = collection.get(0);
        objectArray[9] = collection.get(1);
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = "a";
        objectArray[13] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeFirst();
        deque.addAll(2, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[0] = "a";
        objectArray2[1] = collection.get(0);
        objectArray2[2] = collection.get(1);
        objectArray2[3] = "a";
        objectArray2[4] = "a";
        objectArray2[5] = "a";
        objectArray2[6] = "a";
        objectArray2[15] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(3, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = "a";
        objectArray3[1] = collection.get(0);
        objectArray3[2] = collection.get(1);
        objectArray3[3] = "a";
        objectArray3[4] = "a";
        objectArray3[5] = "a";
        objectArray3[6] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeFirst();
        deque.addAll(3, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = collection.get(0);
        objectArray4[1] = collection.get(1);
        objectArray4[2] = "a";
        objectArray4[3] = "a";
        objectArray4[4] = "a";
        objectArray4[5] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(3, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray5 = new Object[16];
        objectArray5[0] = collection.get(1);
        objectArray5[1] = "a";
        objectArray5[2] = "a";
        objectArray5[3] = "a";
        objectArray5[4] = "a";
        objectArray5[12] = "a";
        objectArray5[13] = "a";
        objectArray5[14] = "a";
        objectArray5[15] = collection.get(0);
        expected = objectArray5;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 13) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 5) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(3, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray6 = new Object[16];
        objectArray6[0] = "a";
        objectArray6[1] = "a";
        objectArray6[2] = "a";
        objectArray6[3] = "a";
        objectArray6[11] = "a";
        objectArray6[12] = "a";
        objectArray6[13] = "a";
        objectArray6[14] = collection.get(0);
        objectArray6[15] = collection.get(1);
        expected = objectArray6;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(4, collection);
        data = this.getInternalArray((Deque<?>)deque);
        expected = new Object[32];
        i2 = 0;
        while (i2 < 2) {
            expected[i2] = "a";
            ++i2;
        }
        expected[2] = collection.get(0);
        expected[3] = collection.get(1);
        i2 = 4;
        while (i2 < 15) {
            expected[i2] = "a";
            ++i2;
        }
        expected[30] = "a";
        expected[31] = "a";
        this.assertEqualContent(expected, data);
    }

    private void internalTestAddAllRandomAccessRightRotate(List<Object> collection) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 14) {
            deque.offer((Object)"a");
            ++i;
        }
        i = 0;
        while (i < 8) {
            deque.removeFirst();
            ++i;
        }
        deque.addAll(4, collection);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = collection.get(0);
        objectArray[13] = collection.get(1);
        objectArray[14] = "a";
        objectArray[15] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        deque.addAll(4, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[0] = "a";
        objectArray2[9] = "a";
        objectArray2[10] = "a";
        objectArray2[11] = "a";
        objectArray2[12] = "a";
        objectArray2[13] = collection.get(0);
        objectArray2[14] = collection.get(1);
        objectArray2[15] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.addAll(4, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = "a";
        objectArray3[1] = "a";
        objectArray3[9] = "a";
        objectArray3[10] = "a";
        objectArray3[11] = "a";
        objectArray3[12] = "a";
        objectArray3[13] = collection.get(0);
        objectArray3[14] = collection.get(1);
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.addAll(4, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[1] = "a";
        objectArray4[2] = "a";
        objectArray4[10] = "a";
        objectArray4[11] = "a";
        objectArray4[12] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = collection.get(0);
        objectArray4[15] = collection.get(1);
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 11) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.addAll(4, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray5 = new Object[16];
        objectArray5[0] = collection.get(1);
        objectArray5[1] = "a";
        objectArray5[2] = "a";
        objectArray5[3] = "a";
        objectArray5[11] = "a";
        objectArray5[12] = "a";
        objectArray5[13] = "a";
        objectArray5[14] = "a";
        objectArray5[15] = collection.get(0);
        expected = objectArray5;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.addAll(4, collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray6 = new Object[16];
        objectArray6[0] = collection.get(0);
        objectArray6[1] = collection.get(1);
        objectArray6[2] = "a";
        objectArray6[3] = "a";
        objectArray6[12] = "a";
        objectArray6[13] = "a";
        objectArray6[14] = "a";
        objectArray6[15] = "a";
        expected = objectArray6;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(11, collection);
        data = this.getInternalArray((Deque<?>)deque);
        expected = new Object[32];
        i2 = 0;
        while (i2 < 11) {
            expected[i2] = "a";
            ++i2;
        }
        expected[11] = collection.get(0);
        expected[12] = collection.get(1);
        i2 = 13;
        while (i2 < 17) {
            expected[i2] = "a";
            ++i2;
        }
        this.assertEqualContent(expected, data);
    }

    private void internalTestAddRandomAccessLeftRotate(Object element) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 15) {
            deque.offer((Object)"a");
            ++i;
        }
        i = 0;
        while (i < 8) {
            deque.removeFirst();
            ++i;
        }
        deque.add(3, element);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[7] = "a";
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = element;
        objectArray[11] = "a";
        objectArray[12] = "a";
        objectArray[13] = "a";
        objectArray[14] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.add(3, element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[0] = "a";
        objectArray2[1] = "a";
        objectArray2[2] = element;
        objectArray2[3] = "a";
        objectArray2[4] = "a";
        objectArray2[5] = "a";
        objectArray2[6] = "a";
        objectArray2[15] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.add(3, element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = element;
        objectArray3[1] = "a";
        objectArray3[2] = "a";
        objectArray3[3] = "a";
        objectArray3[4] = "a";
        objectArray3[13] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 13) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 5) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.add(3, element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[1] = "a";
        objectArray4[2] = "a";
        objectArray4[3] = "a";
        objectArray4[12] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = element;
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.add(3, element);
        data = this.getInternalArray((Deque<?>)deque);
        expected = new Object[32];
        i2 = 0;
        while (i2 < 3) {
            expected[i2] = "a";
            ++i2;
        }
        expected[3] = element;
        i2 = 4;
        while (i2 < 16) {
            expected[i2] = "a";
            ++i2;
        }
        this.assertEqualContent(expected, data);
    }

    private void internalTestAddRandomAccessRightRotate(Object element) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 15) {
            deque.offer((Object)"a");
            ++i;
        }
        i = 0;
        while (i < 8) {
            deque.removeFirst();
            ++i;
        }
        deque.add(4, element);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = element;
        objectArray[13] = "a";
        objectArray[14] = "a";
        objectArray[15] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.add(4, element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[0] = "a";
        objectArray2[9] = "a";
        objectArray2[10] = "a";
        objectArray2[11] = "a";
        objectArray2[12] = "a";
        objectArray2[13] = element;
        objectArray2[14] = "a";
        objectArray2[15] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 11) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.add(4, element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = "a";
        objectArray3[1] = "a";
        objectArray3[2] = "a";
        objectArray3[11] = "a";
        objectArray3[12] = "a";
        objectArray3[13] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = element;
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.add(4, element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = element;
        objectArray4[1] = "a";
        objectArray4[2] = "a";
        objectArray4[3] = "a";
        objectArray4[12] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.add(11, element);
        data = this.getInternalArray((Deque<?>)deque);
        expected = new Object[32];
        i2 = 0;
        while (i2 < 11) {
            expected[i2] = "a";
            ++i2;
        }
        expected[11] = element;
        i2 = 12;
        while (i2 < 16) {
            expected[i2] = "a";
            ++i2;
        }
        this.assertEqualContent(expected, data);
    }

    private void internalTestRemoveAllBothRotate(List<Object> collection) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 13) {
            deque.offer((Object)"a");
            ++i;
        }
        i = 0;
        while (i < 5) {
            deque.removeFirst();
            ++i;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[6] = "a";
        objectArray[7] = "a";
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[9] = "a";
        objectArray2[10] = "a";
        objectArray2[11] = "a";
        objectArray2[12] = "a";
        objectArray2[13] = "a";
        objectArray2[14] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[10] = "a";
        objectArray3[11] = "a";
        objectArray3[12] = "a";
        objectArray3[13] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[11] = "a";
        objectArray4[12] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 11) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray5 = new Object[16];
        objectArray5[0] = "a";
        objectArray5[1] = "a";
        objectArray5[12] = "a";
        objectArray5[13] = "a";
        objectArray5[14] = "a";
        objectArray5[15] = "a";
        expected = objectArray5;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 5) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray6 = new Object[16];
        objectArray6[0] = "a";
        objectArray6[1] = "a";
        objectArray6[2] = "a";
        objectArray6[13] = "a";
        objectArray6[14] = "a";
        objectArray6[15] = "a";
        expected = objectArray6;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 13) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray7 = new Object[16];
        objectArray7[0] = "a";
        objectArray7[1] = "a";
        objectArray7[2] = "a";
        objectArray7[3] = "a";
        objectArray7[14] = "a";
        objectArray7[15] = "a";
        expected = objectArray7;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray8 = new Object[16];
        objectArray8[0] = "a";
        objectArray8[1] = "a";
        objectArray8[2] = "a";
        objectArray8[3] = "a";
        objectArray8[4] = "a";
        objectArray8[15] = "a";
        expected = objectArray8;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeFirst();
        deque.offer((Object)"a");
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray9 = new Object[16];
        objectArray9[0] = "a";
        objectArray9[1] = "a";
        objectArray9[2] = "a";
        objectArray9[3] = "a";
        objectArray9[4] = "a";
        objectArray9[5] = "a";
        expected = objectArray9;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 8) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.set(3, collection.get(0));
        deque.set(4, collection.get(1));
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray10 = new Object[16];
        objectArray10[1] = "a";
        objectArray10[2] = "a";
        objectArray10[3] = "a";
        objectArray10[4] = "a";
        objectArray10[5] = "a";
        objectArray10[6] = "a";
        expected = objectArray10;
        this.assertEqualContent(expected, data);
    }

    private void internalTestRemoveAllLeftRotate(List<Object> collection) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 12) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.addAll(collection);
        i = 0;
        while (i < 8) {
            deque.removeFirst();
            ++i;
        }
        i = 0;
        while (i < 2) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.removeAll(collection);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = "a";
        objectArray[13] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 13) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[9] = "a";
        objectArray2[10] = "a";
        objectArray2[11] = "a";
        objectArray2[12] = "a";
        objectArray2[13] = "a";
        objectArray2[14] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 13) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 8) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[8] = "a";
        objectArray3[9] = "a";
        objectArray3[10] = "a";
        objectArray3[11] = "a";
        objectArray3[12] = "a";
        objectArray3[13] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 14) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[9] = "a";
        objectArray4[10] = "a";
        objectArray4[11] = "a";
        objectArray4[12] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            deque.removeFirst();
            ++i2;
        }
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray5 = new Object[16];
        objectArray5[0] = "a";
        objectArray5[1] = "a";
        objectArray5[10] = "a";
        objectArray5[11] = "a";
        objectArray5[12] = "a";
        objectArray5[13] = "a";
        objectArray5[14] = "a";
        objectArray5[15] = "a";
        expected = objectArray5;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 11) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.addAll(collection);
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray6 = new Object[16];
        objectArray6[0] = "a";
        objectArray6[1] = "a";
        objectArray6[11] = "a";
        objectArray6[12] = "a";
        objectArray6[13] = "a";
        objectArray6[14] = "a";
        objectArray6[15] = "a";
        expected = objectArray6;
        this.assertEqualContent(expected, data);
    }

    private void internalTestRemoveAllRightRotate(List<Object> collection) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 8) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.addAll(collection);
        i = 0;
        while (i < 4) {
            deque.offer((Object)"a");
            ++i;
        }
        i = 0;
        while (i < 6) {
            deque.removeFirst();
            ++i;
        }
        deque.removeAll(collection);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = "a";
        objectArray[13] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeFirst();
        deque.offer((Object)"a");
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[1] = "a";
        objectArray2[2] = "a";
        objectArray2[3] = "a";
        objectArray2[4] = "a";
        objectArray2[5] = "a";
        objectArray2[6] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer((Object)"a");
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = "a";
        objectArray3[1] = "a";
        objectArray3[2] = "a";
        objectArray3[3] = "a";
        objectArray3[4] = "a";
        objectArray3[5] = "a";
        objectArray3[6] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 13) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[1] = "a";
        objectArray4[2] = "a";
        objectArray4[3] = "a";
        objectArray4[4] = "a";
        objectArray4[5] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            deque.removeFirst();
            ++i2;
        }
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray5 = new Object[16];
        objectArray5[0] = "a";
        objectArray5[1] = "a";
        objectArray5[2] = "a";
        objectArray5[3] = "a";
        objectArray5[4] = "a";
        objectArray5[14] = "a";
        objectArray5[15] = "a";
        expected = objectArray5;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 14) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 11) {
            deque.removeFirst();
            ++i2;
        }
        deque.addAll(collection);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.removeAll(collection);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray6 = new Object[16];
        objectArray6[0] = "a";
        objectArray6[1] = "a";
        objectArray6[2] = "a";
        objectArray6[3] = "a";
        objectArray6[13] = "a";
        objectArray6[14] = "a";
        objectArray6[15] = "a";
        expected = objectArray6;
        this.assertEqualContent(expected, data);
    }

    private void internalTestRemoveLeftRotate(Object element) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 12) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.offer(element);
        i = 0;
        while (i < 8) {
            deque.removeFirst();
            ++i;
        }
        i = 0;
        while (i < 3) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.remove(element);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = "a";
        objectArray[13] = "a";
        objectArray[14] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 13) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.offer(element);
        i2 = 0;
        while (i2 < 9) {
            deque.removeFirst();
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.remove(element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[9] = "a";
        objectArray2[10] = "a";
        objectArray2[11] = "a";
        objectArray2[12] = "a";
        objectArray2[13] = "a";
        objectArray2[14] = "a";
        objectArray2[15] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 11) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer(element);
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.remove(element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = "a";
        objectArray3[1] = "a";
        objectArray3[11] = "a";
        objectArray3[12] = "a";
        objectArray3[13] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer(element);
        i2 = 0;
        while (i2 < 3) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.remove(element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[1] = "a";
        objectArray4[2] = "a";
        objectArray4[12] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
    }

    private void internalTestRemoveRightRotate(Object element) {
        CircularArrayDeque deque = new CircularArrayDeque();
        int i = 0;
        while (i < 10) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.offer(element);
        i = 0;
        while (i < 7) {
            deque.removeFirst();
            ++i;
        }
        i = 0;
        while (i < 4) {
            deque.offer((Object)"a");
            ++i;
        }
        deque.remove(element);
        Object[] data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray = new Object[16];
        objectArray[8] = "a";
        objectArray[9] = "a";
        objectArray[10] = "a";
        objectArray[11] = "a";
        objectArray[12] = "a";
        objectArray[13] = "a";
        objectArray[14] = "a";
        Object[] expected = objectArray;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        int i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 14) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.removeFirst();
        i2 = 0;
        while (i2 < 2) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.offer(element);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.remove(element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray2 = new Object[16];
        objectArray2[0] = "a";
        objectArray2[1] = "a";
        objectArray2[2] = "a";
        objectArray2[3] = "a";
        objectArray2[4] = "a";
        objectArray2[5] = "a";
        objectArray2[6] = "a";
        expected = objectArray2;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 13) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer((Object)"a");
        deque.offer(element);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.remove(element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray3 = new Object[16];
        objectArray3[0] = "a";
        objectArray3[1] = "a";
        objectArray3[2] = "a";
        objectArray3[3] = "a";
        objectArray3[4] = "a";
        objectArray3[14] = "a";
        objectArray3[15] = "a";
        expected = objectArray3;
        this.assertEqualContent(expected, data);
        deque = new CircularArrayDeque();
        i2 = 0;
        while (i2 < 15) {
            deque.offer((Object)"a");
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            deque.removeFirst();
            ++i2;
        }
        deque.offer(element);
        i2 = 0;
        while (i2 < 4) {
            deque.offer((Object)"a");
            ++i2;
        }
        deque.remove(element);
        data = this.getInternalArray((Deque<?>)deque);
        Object[] objectArray4 = new Object[16];
        objectArray4[0] = "a";
        objectArray4[1] = "a";
        objectArray4[2] = "a";
        objectArray4[3] = "a";
        objectArray4[13] = "a";
        objectArray4[14] = "a";
        objectArray4[15] = "a";
        expected = objectArray4;
        this.assertEqualContent(expected, data);
    }

    private List<Integer> randomIntegerListNotIn(int size, Collection<?> excluded) {
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        int i = 0;
        while (i < size) {
            Integer integer = this.getRandomInteger();
            while (list.contains(integer) || excluded.contains(integer)) {
                integer = this.getRandomInteger();
            }
            list.add(integer);
            ++i;
        }
        return list;
    }

    private List<String> randomStringListNotIn(int size, Collection<?> excluded) {
        ArrayList<String> list = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            String string = this.getRandomString();
            while (list.contains(string) || excluded.contains(string)) {
                string = this.getRandomString();
            }
            list.add(string);
            ++i;
        }
        return list;
    }

    private Deque<String> randomStringDequeNotIn(int size, Collection<?> excluded) {
        CircularArrayDeque deque = new CircularArrayDeque(size);
        int i = 0;
        while (i < size) {
            String s = this.getRandomString();
            while (deque.contains((Object)s) || excluded.contains(s)) {
                s = this.getRandomString();
            }
            deque.add((Object)s);
            ++i;
        }
        return deque;
    }

    private Set<String> randomStringSetNotIn(int size, Collection<?> excluded) {
        HashSet<String> set = new HashSet<String>(size);
        int i = 0;
        while (i < size) {
            String s = this.getRandomString();
            while (set.contains(s) || excluded.contains(s)) {
                s = this.getRandomString();
            }
            set.add(s);
            ++i;
        }
        return set;
    }

    private Deque<Object> readDeque(byte[] serialized) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
            ObjectInputStream stream = new ObjectInputStream(bais);
            Object read = stream.readObject();
            stream.close();
            if (read instanceof Deque) {
                return (Deque)read;
            }
            Assert.fail((String)"The read Object wasn't a Deque");
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"Unexpected ClassNotFoundException thrown");
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException thrown");
        }
        return null;
    }

    private byte[] writeDeque(Deque<Object> deque) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(baos);
            stream.writeObject(deque);
            stream.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException thrown");
            return new byte[0];
        }
    }
}

