/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.tests.unit.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.tests.AcceleoCommonTestPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AcceleoCommonPluginTest {
    private static final String[] ERROR_MESSAGES = new String[]{"NullPointerException has been thrown.", "failed to build.", "\u00ec", "test"};
    private static final int[] ERROR_SEVERITIES = new int[]{2, 4, 1};
    protected IStatus loggedStatus;
    private ILogListener logListener;
    private PrintStream temporaryErr;
    private File temporaryLog;

    @Test
    public void testLogExceptionArbitraryException() {
        boolean blocker = false;
        String[] stringArray = ERROR_MESSAGES;
        int n = ERROR_MESSAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            PrintStream systemErr = System.err;
            IllegalArgumentException exception = new IllegalArgumentException(message);
            System.setErr(this.temporaryErr);
            AcceleoLogger.log((Exception)exception, (boolean)blocker);
            System.setErr(systemErr);
            int expectedSeverity = blocker ? 4 : 2;
            blocker = !blocker;
            Assert.assertEquals((String)"Unexpected message of the logged exception.", (Object)exception.getMessage(), (Object)this.loggedStatus.getMessage());
            Assert.assertEquals((String)"Unexpected severity of the logged exception.", (long)expectedSeverity, (long)this.loggedStatus.getSeverity());
            Assert.assertEquals((String)"Exception logged with unexpected plug-in ID.", (Object)"org.eclipse.acceleo.common", (Object)this.loggedStatus.getPlugin());
            ++n2;
        }
    }

    @Test
    public void testLogExceptionCoreException() {
        int[] nArray = ERROR_SEVERITIES;
        int n = ERROR_SEVERITIES.length;
        int n2 = 0;
        while (n2 < n) {
            int severity = nArray[n2];
            String[] stringArray = ERROR_MESSAGES;
            int n3 = ERROR_MESSAGES.length;
            int n4 = 0;
            while (n4 < n3) {
                String message = stringArray[n4];
                Status coreExceptionStatus = new Status(severity, "org.eclipse.acceleo.common.tests", message);
                PrintStream systemErr = System.err;
                System.setErr(this.temporaryErr);
                AcceleoLogger.log((Exception)new CoreException((IStatus)coreExceptionStatus), (boolean)true);
                System.setErr(systemErr);
                Assert.assertEquals((String)"Unexpected message of the logged core exception.", (Object)message, (Object)this.loggedStatus.getMessage());
                Assert.assertEquals((String)"Unexpected severity of the logged core exception.", (long)severity, (long)this.loggedStatus.getSeverity());
                Assert.assertEquals((String)"Core exception logged with unexpected plug-in ID.", (Object)"org.eclipse.acceleo.common.tests", (Object)this.loggedStatus.getPlugin());
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testLogExceptionNullException() {
        try {
            AcceleoLogger.log(null, (boolean)true);
            Assert.fail((String)"Logging null didn't throw expected NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLogExceptionNullPointerException() {
        boolean blocker = false;
        String[] stringArray = ERROR_MESSAGES;
        int n = ERROR_MESSAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            PrintStream systemErr = System.err;
            System.setErr(this.temporaryErr);
            AcceleoLogger.log((Exception)new NullPointerException(message), (boolean)blocker);
            System.setErr(systemErr);
            String expectedMessage = AcceleoCommonMessages.getString((String)"AcceleoLogger.ElementNotFound");
            int expectedSeverity = blocker ? 4 : 2;
            blocker = !blocker;
            Assert.assertEquals((String)"Unexpected message of the logged NullPointerException.", (Object)expectedMessage, (Object)this.loggedStatus.getMessage());
            Assert.assertEquals((String)"Unexpected severity of the logged NullPointerException.", (long)expectedSeverity, (long)this.loggedStatus.getSeverity());
            Assert.assertEquals((String)"NullPointerException logged with unexpected plug-in ID.", (Object)"org.eclipse.acceleo.common", (Object)this.loggedStatus.getPlugin());
            ++n2;
        }
    }

    @Test
    public void testLogMessageNullMessage() {
        boolean blocker = false;
        int i = 0;
        while (i < ERROR_MESSAGES.length) {
            PrintStream systemErr = System.err;
            System.setErr(this.temporaryErr);
            AcceleoLogger.log(null, (boolean)blocker);
            System.setErr(systemErr);
            String expectedMessage = AcceleoCommonMessages.getString((String)"AcceleoLogger.UnexpectedException");
            int expectedSeverity = blocker ? 4 : 2;
            blocker = !blocker;
            Assert.assertEquals((String)"Unexpected message of the logged message.", (Object)expectedMessage, (Object)this.loggedStatus.getMessage());
            Assert.assertEquals((String)"Unexpected severity of the logged message.", (long)expectedSeverity, (long)this.loggedStatus.getSeverity());
            Assert.assertEquals((String)"Message logged with unexpected plug-in ID.", (Object)"org.eclipse.acceleo.common", (Object)this.loggedStatus.getPlugin());
            ++i;
        }
    }

    @Test
    public void testLogMessageValidMessage() {
        boolean blocker = false;
        String[] stringArray = ERROR_MESSAGES;
        int n = ERROR_MESSAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            PrintStream systemErr = System.err;
            System.setErr(this.temporaryErr);
            AcceleoLogger.log((String)message, (boolean)blocker);
            System.setErr(systemErr);
            int expectedSeverity = blocker ? 4 : 2;
            blocker = !blocker;
            Assert.assertEquals((String)"Unexpected message logged.", (Object)message, (Object)this.loggedStatus.getMessage());
            Assert.assertEquals((String)"Unexpected severity of the logged message.", (long)expectedSeverity, (long)this.loggedStatus.getSeverity());
            Assert.assertEquals((String)"Message logged with unexpected plug-in ID.", (Object)"org.eclipse.acceleo.common", (Object)this.loggedStatus.getPlugin());
            ++n2;
        }
    }

    @Test
    public void testLogStatusNullStatus() {
        try {
            AcceleoLogger.log(null);
            Assert.fail((String)"Logging null status didn't throw expected NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testLogStatusValidStatus() {
        int[] nArray = ERROR_SEVERITIES;
        int n = ERROR_SEVERITIES.length;
        int n2 = 0;
        while (n2 < n) {
            int severity = nArray[n2];
            String[] stringArray = ERROR_MESSAGES;
            int n3 = ERROR_MESSAGES.length;
            int n4 = 0;
            while (n4 < n3) {
                String message = stringArray[n4];
                Status status = new Status(severity, "org.eclipse.acceleo.common.tests", message);
                PrintStream systemErr = System.err;
                System.setErr(this.temporaryErr);
                AcceleoLogger.log((IStatus)status);
                System.setErr(systemErr);
                Assert.assertEquals((String)"Unexpected message of the logged exception.", (Object)message, (Object)this.loggedStatus.getMessage());
                Assert.assertEquals((String)"Unexpected severity of the logged exception.", (long)severity, (long)this.loggedStatus.getSeverity());
                Assert.assertEquals((String)"Exception logged with unexpected plug-in ID.", (Object)"org.eclipse.acceleo.common.tests", (Object)this.loggedStatus.getPlugin());
                ++n4;
            }
            ++n2;
        }
    }

    @Before
    public void setUp() {
        this.logListener = new ILogListener(){

            public void logging(IStatus status, String message) {
                AcceleoCommonPluginTest.this.loggedStatus = status;
            }
        };
        AcceleoCommonPlugin.getDefault().getLog().addLogListener(this.logListener);
        try {
            File dataDir = new File(FileLocator.toFileURL((URL)AcceleoCommonTestPlugin.getDefault().getBundle().getEntry("/data")).getFile());
            this.temporaryLog = new File(String.valueOf(dataDir.getAbsolutePath()) + "/testLogErrorLog");
            this.temporaryErr = new PrintStream(this.temporaryLog);
        }
        catch (IOException e) {
            Assert.fail((String)"Couldn't create temporary error log.");
        }
    }

    @After
    public void tearDown() {
        AcceleoCommonPlugin.getDefault().getLog().removeLogListener(this.logListener);
        if (this.temporaryErr != null) {
            this.temporaryErr.close();
        }
        if (this.temporaryLog.exists()) {
            this.temporaryLog.delete();
        }
    }
}

