/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicModulesDescriptor;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicTemplatesEclipseUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class DynamicTemplatesRegistryListener
implements IRegistryEventListener {
    public static final String DYNAMIC_TEMPLATES_EXTENSION_POINT = "org.eclipse.acceleo.engine.dynamic.templates";
    private static final String DYNAMIC_TEMPLATES_ATTRIBUTE_PATH = "path";
    private static final String DYNAMIC_TEMPLATES_TAG_TEMPLATES = "templates";
    private static final String DYNAMIC_TEMPLATES_TAG_GENERATOR = "generator";
    private static final String DYNAMIC_MODULES_TAG_GENERATOR_ID = "generatorID";

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(DYNAMIC_TEMPLATES_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        ArrayList<String> paths = new ArrayList<String>(configElements.length);
        ArrayList<String> generators = new ArrayList<String>(configElements.length);
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            String generator;
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (DYNAMIC_TEMPLATES_TAG_TEMPLATES.equals(elem.getName())) {
                String path = elem.getAttribute(DYNAMIC_TEMPLATES_ATTRIBUTE_PATH);
                if (path != null) {
                    paths.add(path);
                }
            } else if (DYNAMIC_TEMPLATES_TAG_GENERATOR.equals(elem.getName()) && (generator = elem.getAttribute(DYNAMIC_MODULES_TAG_GENERATOR_ID)) != null) {
                generators.add(generator);
            }
            ++n2;
        }
        Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
        if (bundle != null) {
            if (paths.size() == 0) {
                paths.add("/");
            }
        } else {
            bundle = new BundleAdapter(extension.getContributor());
        }
        AcceleoDynamicModulesDescriptor acceleoDynamicModulesDescriptor = new AcceleoDynamicModulesDescriptor(generators, paths);
        AcceleoDynamicTemplatesEclipseUtil.addExtendingBundle(bundle, acceleoDynamicModulesDescriptor);
    }

    protected class BundleAdapter
    implements Bundle {
        private IContributor contributor;

        public BundleAdapter(IContributor contributor) {
            this.contributor = contributor;
        }

        public int compareTo(Bundle o) {
            return 0;
        }

        public int getState() {
            return 0;
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public Dictionary<String, String> getHeaders() {
            return null;
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return null;
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return null;
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            return null;
        }

        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            String pluginID = this.contributor.getName();
            URI plPath = (URI)URIConverter.URI_MAP.get(URI.createURI((String)("platform:/plugin/" + pluginID + "/")));
            if (plPath == null) {
                plPath = (URI)URIConverter.URI_MAP.get(URI.createURI((String)("platform:/resource/" + pluginID + "/")));
            }
            if (plPath == null) {
                return null;
            }
            Collection<URL> ret = null;
            if (plPath.isFile()) {
                ret = this.findResourceRecursive(new File(plPath.toFileString()), filePattern, recurse);
            } else if (plPath.isArchive() && "jar".equals(plPath.scheme())) {
                try {
                    URL url = new URL(plPath.toString());
                    JarURLConnection urlcon = (JarURLConnection)url.openConnection();
                    JarFile jarFile = urlcon.getJarFile();
                    ret = this.findResourceInJar(url, jarFile, filePattern);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new VectorEnumeration<URL>(ret);
        }

        private Collection<URL> findResourceInJar(URL jarUrl, JarFile jarFile, String filePattern) throws MalformedURLException {
            Vector<URL> out = new Vector<URL>();
            Enumeration<JarEntry> entries = jarFile.entries();
            String regex = filePattern.substring(1);
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(regex)) continue;
                out.add(new URL(jarUrl + entry.getName()));
            }
            return out;
        }

        private final Collection<URL> findResourceRecursive(File libFolder, String regex, boolean recurse) {
            File[] directories;
            File[] jars;
            Vector<URL> out = new Vector<URL>();
            File[] fileArray = jars = libFolder.listFiles(new RegexFileFilter(regex));
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    out.add(file.toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            if (recurse && (directories = libFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) != null) {
                int i = 0;
                while (i < directories.length) {
                    out.addAll(this.findResourceRecursive(directories[i], regex, recurse));
                    ++i;
                }
            }
            return out;
        }

        public BundleContext getBundleContext() {
            return null;
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return null;
        }

        public Version getVersion() {
            return null;
        }

        public <A> A adapt(Class<A> type) {
            return null;
        }

        public File getDataFile(String filename) {
            return null;
        }
    }

    protected class RegexFileFilter
    implements FileFilter {
        private String regex;

        RegexFileFilter(String regex) {
            this.regex = regex.substring(1);
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(this.regex);
        }
    }

    protected class VectorEnumeration<E>
    implements Enumeration<E> {
        Iterator<E> it;

        VectorEnumeration(Collection<E> col) {
            this.it = col.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public E nextElement() {
            return this.it.next();
        }
    }
}

