/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.internal.utils.AcceleoDynamicModulesDescriptor;
import org.eclipse.acceleo.engine.internal.utils.DynamicModuleContribution;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public final class AcceleoDynamicTemplatesEclipseUtil {
    protected static final Map<Bundle, AcceleoDynamicModulesDescriptor> EXTENDING_BUNDLES = new HashMap<Bundle, AcceleoDynamicModulesDescriptor>();
    private static final Set<DynamicModuleContribution> REGISTERED_MODULES = new CompactLinkedHashSet();

    private AcceleoDynamicTemplatesEclipseUtil() {
    }

    public static void addExtendingBundle(Bundle bundle, List<String> paths) {
        AcceleoDynamicModulesDescriptor descriptor = EXTENDING_BUNDLES.get(bundle);
        if (descriptor == null) {
            descriptor = new AcceleoDynamicModulesDescriptor(new ArrayList<String>(), new ArrayList<String>());
        }
        descriptor.getPaths().addAll(paths);
        EXTENDING_BUNDLES.put(bundle, descriptor);
    }

    public static void addExtendingBundle(Bundle bundle, AcceleoDynamicModulesDescriptor acceleoDynamicModulesDescriptor) {
        AcceleoDynamicModulesDescriptor descriptor = EXTENDING_BUNDLES.get(bundle);
        if (descriptor == null) {
            descriptor = new AcceleoDynamicModulesDescriptor(new ArrayList<String>(), new ArrayList<String>());
        }
        descriptor.getGeneratorIDs().addAll(acceleoDynamicModulesDescriptor.getGeneratorIDs());
        descriptor.getPaths().addAll(acceleoDynamicModulesDescriptor.getPaths());
        EXTENDING_BUNDLES.put(bundle, descriptor);
    }

    public static void clearRegistry() {
        EXTENDING_BUNDLES.clear();
        REGISTERED_MODULES.clear();
    }

    public static boolean hasDynamicModulesDescriptors() {
        return EXTENDING_BUNDLES.size() > 0;
    }

    public static Set<DynamicModuleContribution> getRegisteredModules(String generatorID) {
        AcceleoDynamicTemplatesEclipseUtil.refreshModules(generatorID);
        return new CompactLinkedHashSet(REGISTERED_MODULES);
    }

    public static Set<DynamicModuleContribution> getRegisteredModules() {
        AcceleoDynamicTemplatesEclipseUtil.refreshModules(null);
        return new CompactLinkedHashSet(REGISTERED_MODULES);
    }

    private static void refreshModules(String generatorID) {
        REGISTERED_MODULES.clear();
        if (generatorID != null) {
            boolean hasDynamicModulesForGeneratorId = false;
            Collection<AcceleoDynamicModulesDescriptor> values = EXTENDING_BUNDLES.values();
            for (AcceleoDynamicModulesDescriptor acceleoDynamicModulesDescriptor : values) {
                if (acceleoDynamicModulesDescriptor.getGeneratorIDs().size() != 0 && !acceleoDynamicModulesDescriptor.getGeneratorIDs().contains(generatorID)) continue;
                hasDynamicModulesForGeneratorId = true;
                break;
            }
            if (!hasDynamicModulesForGeneratorId) {
                return;
            }
        }
        ArrayList<Bundle> uninstalledBundles = new ArrayList<Bundle>();
        String pathSeparator = "/";
        for (Map.Entry entry : new CompactLinkedHashSet(EXTENDING_BUNDLES.entrySet())) {
            Bundle bundle = (Bundle)entry.getKey();
            if (bundle.getState() == 1) {
                uninstalledBundles.add(bundle);
                continue;
            }
            AcceleoDynamicModulesDescriptor descriptor = (AcceleoDynamicModulesDescriptor)entry.getValue();
            for (String path : descriptor.getPaths()) {
                String actualPath = path;
                if (actualPath.charAt(0) != '/') {
                    actualPath = String.valueOf('/') + actualPath;
                }
                if (actualPath.length() > 1 && actualPath.charAt(actualPath.length() - 1) == '/') {
                    actualPath = actualPath.substring(0, actualPath.length() - 1);
                }
                if (actualPath.startsWith("/src") || actualPath.startsWith("/bin")) {
                    int firstFragmentEnd = actualPath.indexOf(47, 2);
                    actualPath = firstFragmentEnd > 0 ? actualPath.substring(firstFragmentEnd) : "/";
                }
                String filePattern = "*.emtl";
                Enumeration emtlFiles = bundle.findEntries("/", "*.emtl", true);
                if (emtlFiles == null) {
                    AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoDynamicTemplatesEclipseUtil.MissingDynamicTemplates", bundle.getSymbolicName(), path), false);
                    return;
                }
                try {
                    ArrayList<URL> modules = new ArrayList<URL>();
                    while (emtlFiles.hasMoreElements()) {
                        URL next = (URL)emtlFiles.nextElement();
                        if (actualPath == "/") {
                            File moduleFile = new File(FileLocator.toFileURL((URL)next).getFile());
                            modules.add(next);
                            continue;
                        }
                        modules.add(next);
                    }
                    REGISTERED_MODULES.add(new DynamicModuleContribution(descriptor.getGeneratorIDs(), modules));
                }
                catch (IOException e) {
                    AcceleoEnginePlugin.log(e, false);
                }
            }
        }
        for (Bundle uninstalledBundle : uninstalledBundles) {
            EXTENDING_BUNDLES.remove(uninstalledBundle);
        }
    }
}

