/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import com.samsarasoftware.license.licenses.ProductLicense;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final boolean writeImmediately;
    private final ByteBuffer decoderIn = ByteBuffer.allocate(128);
    private final CharBuffer decoderOut;
    private static final String a;

    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder) {
        this(writer, charsetDecoder, 1024, false);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder, int n, boolean bl) {
        this.writer = writer;
        this.decoder = charsetDecoder;
        this.writeImmediately = bl;
        this.decoderOut = CharBuffer.allocate(n);
    }

    public WriterOutputStream(Writer writer, Charset charset, int n, boolean bl) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), n, bl);
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset, 1024, false);
    }

    public WriterOutputStream(Writer writer, String string, int n, boolean bl) {
        this(writer, Charset.forName(string), n, bl);
    }

    public WriterOutputStream(Writer writer, String string) {
        this(writer, string, 1024, false);
    }

    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset(), 1024, false);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        block10: {
            WriterOutputStream writerOutputStream;
            block11: {
                boolean bl = ProductLicense.a;
                while (n2 > 0) {
                    int n3 = Math.min(n2, this.decoderIn.remaining());
                    this.decoderIn.put(byArray, n, n3);
                    this.processInput(false);
                    n2 -= n3;
                    n += n3;
                    if (!bl) {
                        if (!bl) continue;
                        break;
                    }
                    break block10;
                }
                writerOutputStream = this;
                if (bl || bl) break block11;
                if (!writerOutputStream.writeImmediately) break block10;
                writerOutputStream = this;
            }
            writerOutputStream.flushOutput();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void flush() throws IOException {
        this.flushOutput();
        this.writer.flush();
    }

    public void close() throws IOException {
        this.processInput(true);
        this.flushOutput();
        this.writer.close();
    }

    private void processInput(boolean bl) throws IOException {
        block7: {
            block6: {
                CoderResult coderResult;
                this.decoderIn.flip();
                boolean bl2 = ProductLicense.a;
                while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, bl)).isOverflow()) {
                    this.flushOutput();
                    if (!bl2) {
                        if (!bl2) continue;
                        break;
                    }
                    break block6;
                }
                if (coderResult.isUnderflow() && !bl2) break block7;
            }
            throw new IOException(a);
        }
        this.decoderIn.compact();
    }

    private void flushOutput() throws IOException {
        block6: {
            boolean bl = ProductLicense.a;
            Buffer buffer = this.decoderOut;
            if (bl || bl) break block6;
            if (buffer.position() <= 0) break block6;
            this.writer.write(this.decoderOut.array(), 0, this.decoderOut.position());
            buffer = this.decoderOut.rewind();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block11: {
                Object var0 = null;
                char[] cArray3 = "k\u001d\u0000kr1kJ\u0016\u00013a;l[\u0001Eag'}R\u0007".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 7) {
                        case 0: {
                            n6 = 62;
                            break;
                        }
                        case 1: {
                            n6 = 115;
                            break;
                        }
                        case 2: {
                            n6 = 101;
                            break;
                        }
                        case 3: {
                            n6 = 19;
                            break;
                        }
                        case 4: {
                            n6 = 2;
                            break;
                        }
                        case 5: {
                            n6 = 84;
                            break;
                        }
                        default: {
                            n6 = 8;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        a = new String(cArray).intern();
    }
}

