/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import com.samsarasoftware.license.licenses.ProductLicense;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.input.ClosedInputStream;

public class ByteArrayOutputStream
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY;
    private final List<byte[]> buffers;
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    private int count;
    private static final String a;

    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        block5: {
            block6: {
                boolean bl = ProductLicense.a;
                byteArrayOutputStream = this;
                if (bl) break block5;
                byteArrayOutputStream.buffers = new ArrayList<byte[]>();
                if (n >= 0) break block6;
                throw new IllegalArgumentException(a + n);
            }
            byteArrayOutputStream = this;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        synchronized (byteArrayOutputStream) {
            this.needNewBuffer(n);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void needNewBuffer(int var1_1) {
        block11: {
            block10: {
                var2_2 = ProductLicense.a;
                v0 = this;
                if (var2_2) break block10;
                if (v0.currentBufferIndex < this.buffers.size() - 1) {
                }
                ** GOTO lbl20
                this.filledBufferSum += this.currentBuffer.length;
                ++this.currentBufferIndex;
                v0 = this;
                do {
                    v0.currentBuffer = this.buffers.get(this.currentBufferIndex);
                    if (!var2_2) break block11;
lbl20:
                    // 2 sources

                    v0 = this;
                } while (var2_2);
            }
            v3 = v0.currentBuffer;
            if (var2_2) ** GOTO lbl36
            if (v3 == null) {
            }
            ** GOTO lbl-1000
            var3_3 = var1_1;
            v5 = this;
            v6 = v5.filledBufferSum = 0;
            while (var2_2) lbl-1000:
            // 2 sources

            {
                v3 = this.currentBuffer;
lbl36:
                // 2 sources

                var3_3 = Math.max(v3.length << 1, var1_1 - this.filledBufferSum);
                v7 = this;
                v5 = v7;
                v6 = v7.filledBufferSum + this.currentBuffer.length;
                if (var2_2) continue;
                v5.filledBufferSum = v6;
                break;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = new byte[var3_3];
            this.buffers.add(this.currentBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n, int n2) {
        int n3;
        boolean bl;
        block33: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            bl = ProductLicense.a;
                            n3 = n;
                            if (bl) break block29;
                            if (bl) break block30;
                            if (n3 < 0) throw new IndexOutOfBoundsException();
                            n3 = n;
                        }
                        if (bl) break block31;
                    }
                    if (bl) break block32;
                    if (n3 > byArray.length) throw new IndexOutOfBoundsException();
                    n3 = n2;
                }
                if (bl) break block33;
            }
            if (!bl) {
                if (n3 < 0) throw new IndexOutOfBoundsException();
                n3 = n + n2;
            }
        }
        int n4 = byArray.length;
        if (!bl && !bl) {
            if (n3 > n4) throw new IndexOutOfBoundsException();
            n3 = n;
            n4 = n2;
        }
        int n5 = n3 + n4;
        if (!bl) {
            if (n5 < 0) {
                throw new IndexOutOfBoundsException();
            }
            n5 = n2;
        }
        if (n5 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            int n6 = this.count + n2;
            int n7 = n2;
            int n8 = this.count - this.filledBufferSum;
            while (n7 > 0) {
                int n9 = Math.min(n7, this.currentBuffer.length - n8);
                System.arraycopy(byArray, n + n2 - n7, this.currentBuffer, n8, n9);
                if (bl) return;
                int n10 = n7 -= n9;
                if (!bl && !bl && n10 > 0) {
                    this.needNewBuffer(n6);
                    n10 = n8 = 0;
                }
                if (!bl) continue;
            }
            this.count = n6;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void write(int var1_1) {
        block6: {
            var3_2 = this.count - this.filledBufferSum;
            var2_3 = ProductLicense.a;
            if (var2_3) break block6;
            if (var3_2 == this.currentBuffer.length) {
            }
            ** GOTO lbl17
            this.needNewBuffer(this.count + 1);
            do {
                var3_2 = 0;
lbl17:
                // 2 sources

                this.currentBuffer[var3_2] = (byte)var1_1;
                ++this.count;
            } while (var2_3);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int write(InputStream inputStream) throws IOException {
        int n;
        boolean bl;
        block9: {
            int n2 = 0;
            int n3 = this.count - this.filledBufferSum;
            bl = ProductLicense.a;
            int n4 = inputStream.read(this.currentBuffer, n3, this.currentBuffer.length - n3);
            while (n4 != -1) {
                n2 += n4;
                this.count += n4;
                n = n3 += n4;
                if (bl) break block9;
                boolean bl2 = true;
                do {
                    block11: {
                        block10: {
                            if (!bl2 || (bl2 = false)) break block10;
                            if (bl) continue;
                            if (n != this.currentBuffer.length) break block11;
                            this.needNewBuffer(this.currentBuffer.length);
                        }
                        n3 = 0;
                    }
                    int n5 = n4 = inputStream.read(this.currentBuffer, n3, this.currentBuffer.length - n3);
                } while (bl);
                if (!bl) continue;
            }
            n = n2;
        }
        if (ProductLicense.b) {
            ProductLicense.a = !bl;
        }
        return n;
    }

    public synchronized int size() {
        return this.count;
    }

    public void close() throws IOException {
    }

    public synchronized void reset() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        this.currentBuffer = this.buffers.get(this.currentBufferIndex);
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        int n = this.count;
        Iterator<byte[]> iterator = this.buffers.iterator();
        boolean bl = ProductLicense.a;
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            int n2 = Math.min(byArray.length, n);
            outputStream.write(byArray, 0, n2);
            n -= n2;
            if (n == 0 && !bl) break;
            if (!bl) continue;
            break;
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(inputStream);
        return byteArrayOutputStream.toBufferedInputStream();
    }

    private InputStream toBufferedInputStream() {
        int n = this.count;
        boolean bl = ProductLicense.a;
        if (n == 0) {
            return new ClosedInputStream();
        }
        ArrayList<ByteArrayInputStream> arrayList = new ArrayList<ByteArrayInputStream>(this.buffers.size());
        for (byte[] byArray : this.buffers) {
            int n2 = Math.min(byArray.length, n);
            arrayList.add(new ByteArrayInputStream(byArray, 0, n2));
            n -= n2;
            if (n == 0 && !bl) break;
            if (!bl) continue;
            break;
        }
        return new SequenceInputStream(Collections.enumeration(arrayList));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] toByteArray() {
        byte[] byArray;
        byte[] byArray2;
        int n = this.count;
        boolean bl = ProductLicense.a;
        int n2 = n;
        if (!bl) {
            if (n2 == 0) {
                byArray2 = EMPTY_BYTE_ARRAY;
                return byArray2;
            }
            n2 = n;
        }
        byArray2 = new byte[n2];
        if (bl) return byArray2;
        byte[] byArray3 = byArray2;
        int n3 = 0;
        for (byte[] byArray4 : this.buffers) {
            int n4 = Math.min(byArray4.length, n);
            byArray = byArray4;
            if (bl) return byArray;
            System.arraycopy(byArray, 0, byArray3, n3, n4);
            n3 += n4;
            if (((n -= n4) != 0 || bl) && !bl) continue;
        }
        byArray = byArray3;
        return byArray;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block11: {
                Object var0 = null;
                char[] cArray3 = "5\u0017\u0000U\u0012{0\u001eR\u000eZ\u000ff/\u001a\u001eGG\u000fh#AR".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 7) {
                        case 0: {
                            n6 = 123;
                            break;
                        }
                        case 1: {
                            n6 = 114;
                            break;
                        }
                        case 2: {
                            n6 = 103;
                            break;
                        }
                        case 3: {
                            n6 = 52;
                            break;
                        }
                        case 4: {
                            n6 = 102;
                            break;
                        }
                        case 5: {
                            n6 = 18;
                            break;
                        }
                        default: {
                            n6 = 70;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        a = new String(cArray).intern();
        EMPTY_BYTE_ARRAY = new byte[0];
    }
}

