/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import com.samsarasoftware.license.ui.UIFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_PB = 0x4000000000000L;
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_ZB;
    public static final BigInteger ONE_YB;
    public static final File[] EMPTY_FILE_ARRAY;
    private static final Charset UTF8;
    private static final String[] a;
    private static final String[] b;

    public static File getFile(File file, String ... stringArray) {
        File file2;
        block8: {
            boolean bl = UIFactory.b;
            if (file == null) {
                throw new NullPointerException(FileUtils.a(-27868, -9572));
            }
            if (stringArray == null) {
                throw new NullPointerException(FileUtils.a(-27854, -26942));
            }
            File file3 = file;
            for (String string : stringArray) {
                file2 = new File(file3, string);
                if (!bl) {
                    file3 = file2;
                    if (!bl) continue;
                }
                break block8;
            }
            file2 = file3;
        }
        return file2;
    }

    /*
     * Unable to fully structure code
     */
    public static File getFile(String ... var0) {
        block12: {
            var1_1 = UIFactory.b;
            if (var0 == null) {
                throw new NullPointerException(FileUtils.a(-27854, -26942));
            }
            var2_2 = null;
            block8: for (String var6_6 : var0) {
                block13: {
                    v1 = var2_2;
                    if (var1_1) break block12;
                    if (var1_1) break block13;
                    if (v1 == null) {
                    }
                    ** GOTO lbl31
                    v4 = new File(var6_6);
                    do {
                        var2_2 = v4;
                        if (!var1_1) continue block8;
lbl31:
                        // 2 sources

                        v4 = new File(var2_2, var6_6);
                    } while (var1_1);
                }
                var2_2 = v4;
                if (!var1_1) continue;
            }
            v1 = var2_2;
        }
        return v1;
    }

    public static String getTempDirectoryPath() {
        return System.getProperty(FileUtils.a(-27902, -9468));
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty(FileUtils.a(-27782, 23387));
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        block17: {
            block14: {
                boolean bl;
                block15: {
                    block16: {
                        boolean bl2;
                        block13: {
                            bl2 = UIFactory.b;
                            bl = file.exists();
                            if (bl2 || bl2) break block13;
                            if (!bl) break block14;
                            bl = file.isDirectory();
                        }
                        if (bl2) break block15;
                        if (!bl) break block16;
                        throw new IOException(FileUtils.a(-27872, -26313) + file + FileUtils.a(-27897, 962));
                    }
                    bl = file.canRead();
                }
                if (!bl) {
                    throw new IOException(FileUtils.a(-27872, -26313) + file + FileUtils.a(-27846, 5798));
                }
                break block17;
            }
            throw new FileNotFoundException(FileUtils.a(-27872, -26313) + file + FileUtils.a(-27859, -21363));
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    /*
     * Unable to fully structure code
     */
    public static FileOutputStream openOutputStream(File var0, boolean var1_1) throws IOException {
        block29: {
            block31: {
                block30: {
                    block25: {
                        block26: {
                            var2_2 = UIFactory.b;
                            v0 = var0;
                            if (var2_2) break block25;
                            if (!v0.exists()) break block26;
                            v2 = var0;
lbl14:
                            // 2 sources

                            while (true) {
                                block27: {
                                    block28: {
                                        v4 = v2.isDirectory();
                                        if (var2_2) break block27;
                                        if (!v4) break block28;
                                        throw new IOException(FileUtils.a(-27872, -26313) + var0 + FileUtils.a(-27897, 962));
                                    }
                                    v4 = var0.canWrite();
                                }
                                if (!v4) {
                                    throw new IOException(FileUtils.a(-27872, -26313) + var0 + FileUtils.a(-27869, 12409));
                                }
                                break block29;
                                break;
                            }
                        }
                        v0 = var0.getParentFile();
                    }
                    v2 = var3_3 = v0;
                    ** while (var2_2)
lbl42:
                    // 3 sources

                    if (var2_2 || var2_2) break block30;
                    if (v2 == null) break block29;
                    v10 = var3_3;
                }
                v11 = v10.mkdirs();
                if (var2_2 || var2_2) break block31;
                if (v11) break block29;
                v11 = var3_3.isDirectory();
            }
            if (!v11) {
                throw new IOException(FileUtils.a(-27845, -25686) + var3_3 + FileUtils.a(-27852, 6812));
            }
        }
        return new FileOutputStream(var0, var1_1);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String byteCountToDisplaySize(long l) {
        String string;
        String string2;
        boolean bl = UIFactory.b;
        long l2 = l / 0x1000000000000000L - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (!bl) {
            long l4;
            if (l3 > 0) {
                string2 = String.valueOf(l / 0x1000000000000000L) + FileUtils.a(-27876, 14125);
                if (!bl) return string2;
            }
            l3 = (l4 = l / 0x4000000000000L - 0L) == 0L ? 0 : (l4 < 0L ? -1 : 1);
        }
        if (!bl) {
            long l5;
            if (l3 > 0) {
                string2 = String.valueOf(l / 0x4000000000000L) + FileUtils.a(-27881, 11957);
                if (!bl) return string2;
            }
            l3 = (l5 = l / 0x10000000000L - 0L) == 0L ? 0 : (l5 < 0L ? -1 : 1);
        }
        if (!bl) {
            long l6;
            if (l3 > 0) {
                string2 = String.valueOf(l / 0x10000000000L) + FileUtils.a(-27899, 31941);
                if (!bl) return string2;
            }
            l3 = (l6 = l / 0x40000000L - 0L) == 0L ? 0 : (l6 < 0L ? -1 : 1);
        }
        if (!bl) {
            long l7;
            if (l3 > 0) {
                string2 = String.valueOf(l / 0x40000000L) + FileUtils.a(-27841, -17442);
                if (!bl) return string2;
            }
            l3 = (l7 = l / 0x100000L - 0L) == 0L ? 0 : (l7 < 0L ? -1 : 1);
        }
        if (!bl) {
            long l8;
            if (l3 > 0) {
                string2 = String.valueOf(l / 0x100000L) + FileUtils.a(-27855, 8270);
                if (!bl) return string2;
            }
            l3 = (l8 = l / 1024L - 0L) == 0L ? 0 : (l8 < 0L ? -1 : 1);
        }
        if (l3 <= 0) {
            string = String.valueOf(l) + FileUtils.a(-27856, -5505);
            if (!bl) {
                return string;
            }
        } else {
            string = String.valueOf(l / 1024L) + FileUtils.a(-27844, -28173);
        }
        do {
            string2 = string;
            if (!bl) return string2;
            string = String.valueOf(l) + FileUtils.a(-27856, -5505);
        } while (bl);
        return string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void touch(File file) throws IOException {
        boolean bl;
        boolean bl2;
        block4: {
            File file2;
            block7: {
                boolean bl3;
                block6: {
                    block5: {
                        bl3 = UIFactory.b;
                        bl2 = file.exists();
                        if (bl3) break block4;
                        if (!bl2) break block5;
                        file2 = file;
                        if (bl3) break block6;
                        break block7;
                    }
                    file2 = file;
                }
                do {
                    FileOutputStream fileOutputStream = FileUtils.openOutputStream(file2);
                    IOUtils.closeQuietly(fileOutputStream);
                    file2 = file;
                } while (bl3);
            }
            bl2 = file2.setLastModified(System.currentTimeMillis());
        }
        if (!(bl = bl2)) {
            throw new IOException(FileUtils.a(-27866, 25730) + file);
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection<File> collection) {
        return collection.toArray(new File[collection.size()]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void innerListFiles(Collection<File> collection, File file, IOFileFilter iOFileFilter, boolean bl) {
        block9: {
            File[] fileArray;
            boolean bl2;
            block8: {
                File[] fileArray2 = file.listFiles(iOFileFilter);
                bl2 = UIFactory.b;
                fileArray = fileArray2;
                if (bl2 || bl2) break block8;
                if (fileArray == null) break block9;
                fileArray = fileArray2;
            }
            block5: for (File file2 : fileArray) {
                block12: {
                    boolean bl3;
                    boolean bl4;
                    block11: {
                        block10: {
                            bl4 = file2.isDirectory();
                            if (bl2) continue;
                            if (bl4) break block10;
                            bl4 = collection.add(file2);
                            if (bl2) break block11;
                            break block12;
                        }
                        bl3 = bl;
                    }
                    do {
                        File file3;
                        Collection<File> collection2;
                        block15: {
                            block14: {
                                block13: {
                                    if (!bl2 && bl3) break block13;
                                    collection2 = collection;
                                    file3 = file2;
                                    if (bl2) break block14;
                                    break block15;
                                }
                                collection2 = collection;
                                file3 = file2;
                            }
                            do {
                                bl3 = collection2.add(file3);
                                collection2 = collection;
                                file3 = file2;
                            } while (bl2);
                        }
                        FileUtils.innerListFiles(collection2, file3, iOFileFilter, bl);
                        if (!bl2) continue block5;
                        bl4 = collection.add(file2);
                    } while (bl2);
                }
                if (!bl2) continue;
            }
        }
    }

    public static Collection<File> listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        FileUtils.validateListFilesParameters(file, iOFileFilter);
        IOFileFilter iOFileFilter3 = FileUtils.setUpEffectiveFileFilter(iOFileFilter);
        IOFileFilter iOFileFilter4 = FileUtils.setUpEffectiveDirFilter(iOFileFilter2);
        LinkedList<File> linkedList = new LinkedList<File>();
        FileUtils.innerListFiles(linkedList, file, FileFilterUtils.or(iOFileFilter3, iOFileFilter4), false);
        return linkedList;
    }

    private static void validateListFilesParameters(File file, IOFileFilter iOFileFilter) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(FileUtils.a(-27898, 8572));
        }
        if (iOFileFilter == null) {
            throw new NullPointerException(FileUtils.a(-27867, 22253));
        }
    }

    private static IOFileFilter setUpEffectiveFileFilter(IOFileFilter iOFileFilter) {
        return FileFilterUtils.and(iOFileFilter, FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));
    }

    private static IOFileFilter setUpEffectiveDirFilter(IOFileFilter iOFileFilter) {
        IOFileFilter iOFileFilter2;
        block4: {
            block5: {
                boolean bl = UIFactory.b;
                iOFileFilter2 = iOFileFilter;
                if (bl || bl) break block4;
                if (iOFileFilter2 != null) break block5;
                iOFileFilter2 = FalseFileFilter.INSTANCE;
                break block4;
            }
            iOFileFilter2 = FileFilterUtils.and(iOFileFilter, DirectoryFileFilter.INSTANCE);
        }
        return iOFileFilter2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<File> listFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        LinkedList<File> linkedList;
        FileUtils.validateListFilesParameters(file, iOFileFilter);
        boolean bl = UIFactory.b;
        IOFileFilter iOFileFilter3 = FileUtils.setUpEffectiveFileFilter(iOFileFilter);
        IOFileFilter iOFileFilter4 = FileUtils.setUpEffectiveDirFilter(iOFileFilter2);
        LinkedList<File> linkedList2 = new LinkedList<File>();
        if (bl) {
            linkedList = linkedList2;
            if (!bl) {
                return linkedList;
            }
        } else if (!file.isDirectory()) {
            FileUtils.innerListFiles(linkedList2, file, FileFilterUtils.or(iOFileFilter3, iOFileFilter4), true);
            linkedList = linkedList2;
            if (!bl) {
                return linkedList;
            }
        } else {
            linkedList = linkedList2;
        }
        do {
            linkedList.add(file);
            FileUtils.innerListFiles(linkedList2, file, FileFilterUtils.or(iOFileFilter3, iOFileFilter4), true);
            linkedList = linkedList2;
        } while (bl);
        return linkedList;
    }

    public static Iterator<File> iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator<File> iterateFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFilesAndDirs(file, iOFileFilter, iOFileFilter2).iterator();
    }

    private static String[] toSuffixes(String[] stringArray) {
        String[] stringArray2;
        block4: {
            String[] stringArray3 = new String[stringArray.length];
            boolean bl = UIFactory.b;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2 = stringArray3;
                if (!bl) {
                    stringArray2[i] = "." + stringArray[i];
                    if (!bl) continue;
                    break;
                }
                break block4;
            }
            stringArray2 = stringArray3;
        }
        return stringArray2;
    }

    /*
     * Unable to fully structure code
     */
    public static Collection<File> listFiles(File var0, String[] var1_1, boolean var2_2) {
        var3_3 = UIFactory.b;
        v0 = var1_1;
        if (var3_3) ** GOTO lbl13
        if (v0 == null) {
        }
        ** GOTO lbl-1000
        v2 = var4_4 = TrueFileFilter.INSTANCE;
        while (var3_3) lbl-1000:
        // 2 sources

        {
            v0 = FileUtils.toSuffixes(var1_1);
lbl13:
            // 2 sources

            var5_5 = v0;
            v2 = new SuffixFileFilter(var5_5);
            if (var3_3) continue;
            var4_4 = v2;
            break;
        }
        v3 = var0;
        v4 = var4_4;
        v5 = var2_2 != false ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE;
        return FileUtils.listFiles(v3, v4, v5);
    }

    public static Iterator<File> iterateFiles(File file, String[] stringArray, boolean bl) {
        return FileUtils.listFiles(file, stringArray, bl).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contentEquals(File file, File file2) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        block25: {
            boolean bl5;
            block24: {
                boolean bl6 = file.exists();
                bl4 = UIFactory.b;
                boolean bl7 = bl6;
                if (!bl4) {
                    if (bl7 != file2.exists()) {
                        return false;
                    }
                    bl7 = bl6;
                    if (bl4) return bl7;
                }
                if (bl4) break block24;
                if (!bl7) {
                    return true;
                }
                bl5 = file.isDirectory();
                if (bl4) return bl5;
                if (bl4) break block25;
            }
            if (!bl4) {
                if (bl5) throw new IOException(FileUtils.a(-27887, -7105));
                bl3 = file2.isDirectory();
            }
        }
        if (!bl4) {
            if (bl3) {
                throw new IOException(FileUtils.a(-27887, -7105));
            }
            long l = file.length() - file2.length();
            bl3 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        }
        if (!bl4) {
            if (bl3) {
                return false;
            }
            bl3 = file.getCanonicalFile().equals(file2.getCanonicalFile());
            if (bl4) return bl3;
        }
        if (bl4) return bl2;
        if (bl3) {
            return true;
        }
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream2 = new FileInputStream(file2);
            bl = IOUtils.contentEquals(fileInputStream, fileInputStream2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(fileInputStream2);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        IOUtils.closeQuietly(fileInputStream2);
        bl2 = bl;
        if (bl4) return bl2;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean contentEqualsIgnoreEOL(File var0, File var1_1, String var2_2) throws IOException {
        block34: {
            block33: {
                block39: {
                    block32: {
                        block38: {
                            block31: {
                                block37: {
                                    block36: {
                                        block30: {
                                            block28: {
                                                block29: {
                                                    block35: {
                                                        var4_3 = var0.exists();
                                                        var3_4 = UIFactory.b;
                                                        v0 = var4_3;
                                                        if (var3_4) break block28;
                                                        if (v0 == var1_1.exists()) break block29;
                                                        break block35;
                                                        catch (IOException v1) {
                                                            throw v1;
                                                        }
                                                    }
                                                    v0 = false;
lbl16:
                                                    // 2 sources

                                                    return v0;
                                                }
                                                v0 = var4_3;
                                                ** while (var3_4)
                                            }
                                            if (!var3_4) {
                                                if (v0) break block30;
                                            }
                                            ** GOTO lbl38
                                            v4 = true;
lbl30:
                                            // 2 sources

                                            return v4;
                                        }
                                        v4 = var0.isDirectory();
                                        ** while (var3_4)
lbl36:
                                        // 2 sources

                                        if (var3_4) break block31;
lbl38:
                                        // 3 sources

                                        if (var3_4) break block31;
                                        break block36;
                                        catch (IOException v5) {
                                            throw v5;
                                        }
                                    }
                                    if (v4) ** GOTO lbl61
                                    break block37;
                                    catch (IOException v6) {
                                        throw v6;
                                    }
                                }
                                v7 = var1_1.isDirectory();
                            }
                            if (var3_4) ** GOTO lbl70
                            if (!v7) break block32;
                            break block38;
                            catch (IOException v9) {
                                throw v9;
                            }
                        }
                        throw new IOException(FileUtils.a(-27887, -7105));
                    }
                    v7 = var0.getCanonicalFile().equals(var1_1.getCanonicalFile());
                    if (var3_4) break block33;
lbl70:
                    // 3 sources

                    if (var3_4) break block33;
                    break block39;
                    catch (IOException v11) {
                        throw v11;
                    }
                }
                if (!v7) break block34;
                v7 = true;
            }
            return v7;
        }
        var5_5 = null;
        var6_6 = null;
        try {
            if (var2_2 == null) {
                var5_5 = new InputStreamReader(new FileInputStream(var0));
                v13 = new InputStreamReader(new FileInputStream(var1_1));
                while (true) {
                    var6_6 = v13;
                    break;
                }
            } else {
                var5_5 = new InputStreamReader((InputStream)new FileInputStream(var0), var2_2);
                v13 = new InputStreamReader((InputStream)new FileInputStream(var1_1), var2_2);
                if (var3_4) ** continue;
                var6_6 = v13;
            }
            var7_7 = IOUtils.contentEqualsIgnoreEOL(var5_5, var6_6);
        }
        catch (Throwable var8_8) {
            IOUtils.closeQuietly(var5_5);
            IOUtils.closeQuietly(var6_6);
            throw var8_8;
        }
        IOUtils.closeQuietly(var5_5);
        IOUtils.closeQuietly(var6_6);
        return var7_7;
    }

    public static File toFile(URL uRL) {
        String string;
        block7: {
            block8: {
                block6: {
                    boolean bl = UIFactory.b;
                    if (uRL == null) break block6;
                    string = FileUtils.a(-27894, 31569);
                    if (bl) break block7;
                    if (string.equalsIgnoreCase(uRL.getProtocol())) break block8;
                }
                return null;
            }
            string = uRL.getFile().replace('/', File.separatorChar);
        }
        String string2 = string;
        string2 = FileUtils.decodeUrl(string2);
        return new File(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String decodeUrl(String var0) {
        var2_1 = var0;
        var1_2 = UIFactory.b;
        v0 = var0;
        if (var1_2) ** GOTO lbl65
        if (v0 == null) ** GOTO lbl62
        v0 = var0;
        block17: while (!var1_2) {
            if (v0.indexOf(37) < 0) ** GOTO lbl62
            v1 = var0;
            block18: while (true) {
                var3_3 = v1.length();
                var4_4 = new StringBuffer();
                var5_5 = ByteBuffer.allocate(var3_3);
                var6_6 = 0;
                block19: while (true) {
                    v2 = var6_6;
                    do {
                        block26: {
                            block29: {
                                block28: {
                                    block27: {
                                        block30: {
                                            if (v2 >= var3_3) break block28;
                                            v3 = var0;
                                            if (var1_2) break block29;
                                            v4 = v3.charAt(var6_6);
                                            if (var1_2 || var1_2) ** GOTO lbl27
                                            if (v4 != 37) break block30;
                                            try {
                                                while (true) {
                                                    v4 = (byte)Integer.parseInt(var0.substring(var6_6 + 1, var6_6 + 3), 16);
lbl27:
                                                    // 2 sources

                                                    var7_7 = v4;
                                                    var5_5.put(var7_7);
                                                    if ((var6_6 += 3) < var3_3) {
                                                        v5 = var0.charAt(var6_6);
                                                        break block26;
                                                    }
                                                    ** GOTO lbl69
                                                    break;
                                                }
                                            }
                                            catch (RuntimeException var7_8) {
                                                if (var1_2) break block27;
                                                v6 /* !! */  = var5_5;
                                                if (!var1_2 && v6 /* !! */ .position() > 0) {
                                                    var5_5.flip();
                                                    var4_4.append(FileUtils.UTF8.decode(var5_5).toString());
                                                    v6 /* !! */  = var5_5.clear();
                                                }
                                                catch (Throwable var8_9) {
                                                    v7 /* !! */  = var5_5;
                                                    if (!var1_2 && !var1_2 && v7 /* !! */ .position() > 0) {
                                                        var5_5.flip();
                                                        var4_4.append(FileUtils.UTF8.decode(var5_5).toString());
                                                        v7 /* !! */  = var5_5.clear();
                                                    }
                                                    throw var8_9;
                                                }
                                            }
                                        }
                                        var4_4.append(var0.charAt(var6_6++));
                                    }
                                    if (!var1_2) continue block19;
                                }
                                v3 = var4_4.toString();
                            }
                            var2_1 = v3;
lbl62:
                            // 3 sources

                            v0 = var2_1;
                            if (var1_2) continue block17;
                            if (var1_2) continue block18;
lbl65:
                            // 3 sources

                            return v0;
                        }
                        do {
                            if (v5 == 37) ** continue;
lbl69:
                            // 2 sources

                            v8 /* !! */  = var5_5;
                            if (var1_2) continue block19;
                            v5 = v8 /* !! */ .position();
                        } while (var1_2);
                    } while (var1_2);
                    if (v5 <= 0) continue;
                    var5_5.flip();
                    var4_4.append(FileUtils.UTF8.decode(var5_5).toString());
                    v8 /* !! */  = var5_5.clear();
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File[] toFiles(URL[] uRLArray) {
        File[] fileArray;
        int n;
        boolean bl;
        block16: {
            block17: {
                block15: {
                    URL[] uRLArray2;
                    block14: {
                        bl = UIFactory.b;
                        uRLArray2 = uRLArray;
                        if (bl || bl) break block14;
                        if (uRLArray2 == null) break block15;
                        uRLArray2 = uRLArray;
                    }
                    n = uRLArray2.length;
                    if (bl) break block16;
                    if (n != 0) break block17;
                }
                fileArray = EMPTY_FILE_ARRAY;
                return fileArray;
            }
            n = uRLArray.length;
        }
        fileArray = new File[n];
        if (bl) return fileArray;
        File[] fileArray2 = fileArray;
        int n2 = 0;
        while (n2 < uRLArray.length) {
            block18: {
                block20: {
                    URL uRL;
                    URL uRL2;
                    block19: {
                        uRL2 = uRLArray[n2];
                        if (bl) break block18;
                        uRL = uRL2;
                        if (bl) break block19;
                        if (uRL == null) break block20;
                        uRL = uRL2;
                    }
                    if (!uRL.getProtocol().equals(FileUtils.a(-27894, 31569))) {
                        throw new IllegalArgumentException(FileUtils.a(-27864, 17763) + uRL2);
                    }
                    fileArray2[n2] = FileUtils.toFile(uRL2);
                }
                ++n2;
            }
            if (!bl) continue;
        }
        return fileArray2;
    }

    public static URL[] toURLs(File[] fileArray) throws IOException {
        URL[] uRLArray;
        block4: {
            URL[] uRLArray2 = new URL[fileArray.length];
            boolean bl = UIFactory.b;
            for (int i = 0; i < uRLArray2.length; ++i) {
                uRLArray = uRLArray2;
                if (!bl) {
                    uRLArray[i] = fileArray[i].toURI().toURL();
                    if (!bl) continue;
                    break;
                }
                break block4;
            }
            uRLArray = uRLArray2;
        }
        return uRLArray;
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void copyFileToDirectory(File var0, File var1_1, boolean var2_2) throws IOException {
        block14: {
            block15: {
                var3_3 = UIFactory.b;
                v0 = var1_1;
                if (var3_3) break block14;
                if (v0 != null) break block15;
                throw new NullPointerException(FileUtils.a(-27850, 11417));
            }
            v0 = var1_1;
        }
        if (var3_3) ** GOTO lbl38
        if (v0.exists()) {
        }
        ** GOTO lbl37
        v0 = var1_1;
        do {
            block16: {
                if (!var3_3) {
                    if (!v0.isDirectory()) {
                        throw new IllegalArgumentException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27853, -32438));
                    }
                }
                break block16;
lbl37:
                // 2 sources

                v0 = new File(var1_1, var0.getName());
            }
            var4_4 = v0;
            v6 = var0;
        } while (var3_3);
        FileUtils.copyFile(v6, var4_4, var2_2);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void copyFile(File var0, File var1_1, boolean var2_2) throws IOException {
        block49: {
            block48: {
                block46: {
                    block47: {
                        block44: {
                            block45: {
                                block42: {
                                    block43: {
                                        block40: {
                                            block41: {
                                                var3_3 = UIFactory.b;
                                                v0 = var0;
                                                if (var3_3) break block40;
                                                if (v0 != null) break block41;
                                                throw new NullPointerException(FileUtils.a(-27865, -8986));
                                            }
                                            v0 = var1_1;
                                        }
                                        if (var3_3) break block42;
                                        if (v0 != null) break block43;
                                        throw new NullPointerException(FileUtils.a(-27850, 11417));
                                    }
                                    v0 = var0;
                                }
                                v5 = v0.exists();
                                if (var3_3) break block44;
                                if (v5) break block45;
                                throw new FileNotFoundException(FileUtils.a(-27878, -27348) + var0 + FileUtils.a(-27859, -21363));
                            }
                            v5 = var0.isDirectory();
                        }
                        if (var3_3) break block46;
                        if (!v5) break block47;
                        throw new IOException(FileUtils.a(-27878, -27348) + var0 + FileUtils.a(-27897, 962));
                    }
                    v10 = var0;
                    if (var3_3) break block48;
                    v5 = v10.getCanonicalPath().equals(var1_1.getCanonicalPath());
                }
                if (v5) {
                    throw new IOException(FileUtils.a(-27878, -27348) + var0 + FileUtils.a(-27890, 3417) + var1_1 + FileUtils.a(-27891, 30699));
                }
                v10 = var1_1.getParentFile();
            }
            var4_4 = v10;
            v13 = var4_4;
            if (var3_3) ** GOTO lbl101
            if (v13 != null) {
            }
            ** GOTO lbl99
            v15 = var4_4.mkdirs();
            block32: while (!var3_3) {
                if (!v15) {
                    v15 = var4_4.isDirectory();
                }
                ** GOTO lbl99
                while (!var3_3) {
                    if (!v15) {
                        throw new IOException(FileUtils.a(-27901, -2427) + var4_4 + FileUtils.a(-27871, -23521));
                    }
lbl99:
                    // 3 sources

                    v13 = var1_1;
lbl101:
                    // 3 sources

                    if (var3_3) break block49;
                    v15 = v13.exists();
                    if (var3_3) continue block32;
                    if (var3_3) continue;
                }
                break block32;
            }
            if (!v15) ** GOTO lbl117
            v13 = var1_1;
            while (!var3_3) {
                if (!v13.canWrite()) {
                    throw new IOException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27882, 6963));
                }
lbl117:
                // 2 sources

                v13 = var0;
                if (var3_3) continue;
            }
        }
        FileUtils.doCopyFile(v13, var1_1, var2_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File file, OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            long l = IOUtils.copyLarge(fileInputStream, outputStream);
            return l;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doCopyFile(File file, File file2, boolean bl) throws IOException {
        block34: {
            long l;
            boolean bl2;
            block33: {
                block26: {
                    block29: {
                        boolean bl3;
                        block28: {
                            bl2 = UIFactory.b;
                            bl3 = file2.exists();
                            if (bl2 || bl2) break block28;
                            if (!bl3) break block29;
                            bl3 = file2.isDirectory();
                        }
                        if (bl3) {
                            throw new IOException(FileUtils.a(-27901, -2427) + file2 + FileUtils.a(-27897, 962));
                        }
                    }
                    FileInputStream fileInputStream = null;
                    FileOutputStream fileOutputStream = null;
                    FileChannel fileChannel = null;
                    FileChannel fileChannel2 = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        fileOutputStream = new FileOutputStream(file2);
                        fileChannel = fileInputStream.getChannel();
                        fileChannel2 = fileOutputStream.getChannel();
                        long l2 = fileChannel.size();
                        long l3 = 0L;
                        for (long i = 0L; i < l2; i += fileChannel2.transferFrom(fileChannel, i, l3)) {
                            long l4;
                            block32: {
                                long l5;
                                block30: {
                                    block31: {
                                        l4 = l2 - i;
                                        l5 = 0x1E00000L;
                                        if (bl2) break block30;
                                        long l6 = l4 - l5;
                                        l = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
                                        if (bl2) break block26;
                                        if (l <= 0) break block31;
                                        l4 = 0x1E00000L;
                                        break block32;
                                    }
                                    l4 = l2;
                                    if (bl2) break block32;
                                    l5 = i;
                                }
                                l4 = l4 - l5;
                            }
                            l3 = l4;
                            if (!bl2) continue;
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileChannel2);
                        IOUtils.closeQuietly(fileOutputStream);
                        IOUtils.closeQuietly(fileChannel);
                        IOUtils.closeQuietly(fileInputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(fileChannel2);
                    IOUtils.closeQuietly(fileOutputStream);
                    IOUtils.closeQuietly(fileChannel);
                    IOUtils.closeQuietly(fileInputStream);
                    long l7 = file.length() - file2.length();
                    l = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                }
                if (bl2) break block33;
                if (l != false) {
                    throw new IOException(FileUtils.a(-27879, 31498) + file + FileUtils.a(-27842, -12205) + file2 + "'");
                }
                l = (long)bl;
                if (bl2) break block34;
            }
            if (!bl2 && l != false) {
                l = (long)file2.setLastModified(file.lastModified());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void copyDirectoryToDirectory(File var0, File var1_1) throws IOException {
        block31: {
            block29: {
                block30: {
                    block28: {
                        block26: {
                            block27: {
                                var2_2 = UIFactory.b;
                                v0 = var0;
                                if (var2_2) break block26;
                                if (v0 != null) break block27;
                                throw new NullPointerException(FileUtils.a(-27865, -8986));
                            }
                            v0 = var0;
                        }
                        if (var2_2) break block28;
                        if (v0.exists()) {
                        }
                        ** GOTO lbl35
                        v0 = var0;
                        while (!var2_2) {
                            if (!v0.isDirectory()) {
                                throw new IllegalArgumentException(FileUtils.a(-27878, -27348) + var1_1 + FileUtils.a(-27853, -32438));
                            }
lbl35:
                            // 2 sources

                            v0 = var1_1;
                            if (var2_2) continue;
                        }
                    }
                    if (var2_2) break block29;
                    if (v0 != null) break block30;
                    throw new NullPointerException(FileUtils.a(-27850, 11417));
                }
                v8 = var1_1;
            }
            if (var2_2) break block31;
            if (v8.exists()) {
            }
            ** GOTO lbl70
            v8 = var1_1;
            while (!var2_2) {
                if (!v8.isDirectory()) {
                    throw new IllegalArgumentException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27853, -32438));
                }
lbl70:
                // 2 sources

                v8 = var0;
                if (var2_2) continue;
            }
        }
        FileUtils.copyDirectory(v8, new File(var1_1, var0.getName()), true);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        FileUtils.copyDirectory(file, file2, null, bl);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void copyDirectory(File var0, File var1_1, FileFilter var2_2, boolean var3_3) throws IOException {
        block45: {
            block41: {
                block44: {
                    block43: {
                        block42: {
                            block39: {
                                block40: {
                                    block37: {
                                        block38: {
                                            block35: {
                                                block36: {
                                                    block33: {
                                                        block34: {
                                                            var4_4 = UIFactory.b;
                                                            v0 = var0;
                                                            if (var4_4) break block33;
                                                            if (v0 != null) break block34;
                                                            throw new NullPointerException(FileUtils.a(-27865, -8986));
                                                        }
                                                        v0 = var1_1;
                                                    }
                                                    if (var4_4) break block35;
                                                    if (v0 != null) break block36;
                                                    throw new NullPointerException(FileUtils.a(-27850, 11417));
                                                }
                                                v0 = var0;
                                            }
                                            v5 = v0.exists();
                                            if (var4_4) break block37;
                                            if (v5) break block38;
                                            throw new FileNotFoundException(FileUtils.a(-27878, -27348) + var0 + FileUtils.a(-27859, -21363));
                                        }
                                        v5 = var0.isDirectory();
                                    }
                                    if (var4_4) break block39;
                                    if (v5) break block40;
                                    throw new IOException(FileUtils.a(-27878, -27348) + var0 + FileUtils.a(-27862, 3977));
                                }
                                v5 = var0.getCanonicalPath().equals(var1_1.getCanonicalPath());
                            }
                            if (v5) {
                                throw new IOException(FileUtils.a(-27878, -27348) + var0 + FileUtils.a(-27890, 3417) + var1_1 + FileUtils.a(-27891, 30699));
                            }
                            var5_5 = null;
                            if (!var1_1.getCanonicalPath().startsWith(var0.getCanonicalPath())) break block41;
                            if (var2_2 != null) break block42;
                            v12 = var0;
lbl74:
                            // 2 sources

                            while (true) {
                                v14 = v12.listFiles();
                                break block43;
                                break;
                            }
                        }
                        v12 = var0;
                        ** while (var4_4)
lbl80:
                        // 1 sources

                        v14 = v12.listFiles(var2_2);
                    }
                    var6_6 = v14;
                    v15 = var6_6;
                    if (var4_4 || var4_4) break block44;
                    if (v15 == null) break block41;
                    v15 = var6_6;
                }
                if (v15.length > 0) {
                    var5_5 = new ArrayList<String>(var6_6.length);
                    for (File var10_10 : var6_6) {
                        var11_11 = new File(var1_1, var10_10.getName());
                        var5_5.add(var11_11.getCanonicalPath());
                        if (!var4_4) {
                            if (!var4_4) continue;
                            break;
                        }
                        break block45;
                    }
                }
            }
            FileUtils.doCopyDirectory(var0, var1_1, var2_2, var3_3, var5_5);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doCopyDirectory(File var0, File var1_1, FileFilter var2_2, boolean var3_3, List<String> var4_4) throws IOException {
        block57: {
            block55: {
                block53: {
                    block54: {
                        block52: {
                            block51: {
                                var5_5 = UIFactory.b;
                                if (var2_2 != null) break block51;
                                v0 = var0;
lbl8:
                                // 2 sources

                                while (true) {
                                    v2 = v0.listFiles();
                                    break block52;
                                    break;
                                }
                            }
                            v0 = var0;
                            ** while (var5_5)
lbl14:
                            // 1 sources

                            v2 = v0.listFiles(var2_2);
                        }
                        var6_6 = v2;
                        if (var6_6 == null) {
                            throw new IOException(FileUtils.a(-27870, -12475) + var0);
                        }
                        v4 = var1_1.exists();
                        if (var5_5) break block53;
                        if (!v4) break block54;
                        v4 = var1_1.isDirectory();
lbl35:
                        // 2 sources

                        while (true) {
                            if (var5_5) break block55;
                            if (!v4) {
                            }
                            ** GOTO lbl71
                            throw new IOException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27862, 3977));
                            break;
                        }
                    }
                    v4 = var1_1.mkdirs();
                    ** while (var5_5)
                }
                if (var5_5) break block55;
                if (!v4) {
                }
                ** GOTO lbl71
                v4 = var1_1.isDirectory();
                do {
                    block56: {
                        if (var5_5) break;
                        if (v4) break block56;
                        throw new IOException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27871, -23521));
                    }
                    v4 = var1_1.canWrite();
                } while (var5_5);
            }
            if (!v4) {
                throw new IOException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27869, 12409));
            }
            block41: for (File var10_10 : var6_6) {
                block58: {
                    var11_11 = new File(var1_1, var10_10.getName());
                    if (var5_5) break block57;
                    v13 = var4_4;
                    if (var5_5) break block58;
                    if (v13 != null) {
                    }
                    ** GOTO lbl108
                    v13 = var4_4;
                }
                v16 = v13.contains(var10_10.getCanonicalPath());
                while (!var5_5) {
                    if (var5_5) break;
                    if (v16) continue block41;
lbl108:
                    // 2 sources

                    v18 = var10_10;
                    if (!var5_5) {
                    }
                    ** GOTO lbl131
                    v16 = v18.isDirectory();
                    if (var5_5) continue;
                    break;
                }
                if (v16) {
                    v18 = var10_10;
                    v21 = var11_11;
                }
                ** GOTO lbl130
                do {
                    FileUtils.doCopyDirectory(v18, v21, var2_2, var3_3, var4_4);
                    if (!var5_5) continue block41;
lbl130:
                    // 2 sources

                    v18 = var10_10;
lbl131:
                    // 2 sources

                    v21 = var11_11;
                } while (var5_5);
                FileUtils.doCopyFile(v18, v21, var3_3);
                if (!var5_5) continue;
            }
            v23 = var3_3;
            if (var5_5 || var5_5) break block57;
            if (!v23) break block57;
            v23 = var1_1.setLastModified(var0.lastModified());
        }
    }

    public static void copyURLToFile(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        FileUtils.copyInputStreamToFile(inputStream, file);
    }

    public static void copyURLToFile(URL uRL, File file, int n, int n2) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(n);
        uRLConnection.setReadTimeout(n2);
        InputStream inputStream = uRLConnection.getInputStream();
        FileUtils.copyInputStreamToFile(inputStream, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try {
            FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
            try {
                IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            finally {
                IOUtils.closeQuietly(fileOutputStream);
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteDirectory(File file) throws IOException {
        boolean bl;
        block6: {
            File file2;
            block9: {
                boolean bl2;
                block8: {
                    block7: {
                        bl2 = UIFactory.b;
                        bl = file.exists();
                        if (!bl2) {
                            if (!bl) {
                                return;
                            }
                            bl = FileUtils.isSymlink(file);
                        }
                        if (bl2) break block6;
                        if (!bl) break block7;
                        file2 = file;
                        if (bl2) break block8;
                        break block9;
                    }
                    file2 = file;
                }
                do {
                    FileUtils.cleanDirectory(file2);
                    file2 = file;
                } while (bl2);
            }
            bl = file2.delete();
        }
        if (!bl) {
            String string = FileUtils.a(-27875, -12462) + file + ".";
            throw new IOException(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean deleteQuietly(File var0) {
        block15: {
            block13: {
                var1_1 = UIFactory.b;
                v0 = var0;
                if (!var1_1) {
                    if (v0 != null) break block13;
                }
                ** GOTO lbl19
                v2 = false;
                return v2;
            }
            try {
                block14: {
                    block16: {
                        v0 = var0;
                        if (var1_1) break block14;
lbl19:
                        // 3 sources

                        if (var1_1) break block14;
                        break block16;
                        catch (Exception v3) {
                            throw v3;
                        }
                    }
                    v2 = v0.isDirectory();
                    if (var1_1) ** continue;
                    if (!v2) break block15;
                    v0 = var0;
                }
                FileUtils.cleanDirectory(v0);
            }
            catch (Exception var2_2) {
                // empty catch block
            }
        }
        try {
            return var0.delete();
        }
        catch (Exception var2_3) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean directoryContains(File var0, File var1_1) throws IOException {
        block26: {
            block24: {
                block25: {
                    block22: {
                        block23: {
                            block20: {
                                block21: {
                                    var2_2 = UIFactory.b;
                                    v0 = var0;
                                    if (var2_2) break block20;
                                    if (v0 != null) break block21;
                                    throw new IllegalArgumentException(FileUtils.a(-27877, 13327));
                                }
                                v0 = var0;
                            }
                            if (var2_2) break block22;
                            if (v0.isDirectory()) break block23;
                            throw new IllegalArgumentException(FileUtils.a(-27873, -17884) + var0);
                        }
                        v0 = var1_1;
                    }
                    if (var2_2) break block24;
                    if (v0 != null) break block25;
                    v6 = false;
lbl36:
                    // 2 sources

                    return v6;
                }
                v0 = var0;
            }
            v6 = v0.exists();
            ** while (var2_2)
lbl46:
            // 4 sources

            if (var2_2) ** GOTO lbl64
            if (v6) {
            }
            ** GOTO lbl-1000
            v8 = var1_1;
            if (var2_2) break block26;
            v10 = v8.exists();
            while (!v10) lbl-1000:
            // 2 sources

            {
                v10 = false;
                if (var2_2) continue;
lbl64:
                // 3 sources

                return v10;
            }
            v8 = var0;
        }
        var3_3 = v8.getCanonicalPath();
        var4_4 = var1_1.getCanonicalPath();
        v10 = FilenameUtils.directoryContains(var3_3, var4_4);
        ** while (var2_2)
lbl72:
        // 1 sources

        return v10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanDirectory(File file) throws IOException {
        File[] fileArray;
        File file2;
        boolean bl;
        block18: {
            boolean bl2;
            block17: {
                bl = UIFactory.b;
                bl2 = file.exists();
                if (bl) break block17;
                if (!bl2) {
                    String string = file + FileUtils.a(-27889, 6032);
                    throw new IllegalArgumentException(string);
                }
                file2 = file;
                if (bl) break block18;
                bl2 = file2.isDirectory();
            }
            if (!bl2) {
                String string = file + FileUtils.a(-27860, 31222);
                throw new IllegalArgumentException(string);
            }
            file2 = file;
        }
        if ((fileArray = file2.listFiles()) == null) {
            throw new IOException(FileUtils.a(-27870, -12475) + file);
        }
        IOException iOException = null;
        for (File file3 : fileArray) {
            try {
                FileUtils.forceDelete(file3);
                if (bl) return;
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (!bl) continue;
        }
        if (null == iOException) return;
        throw iOException;
    }

    /*
     * Exception decompiling
     */
    public static boolean waitFor(File var0, int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            String string2 = IOUtils.toString(fileInputStream, string);
            return string2;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)fileInputStream, file.length());
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            List<String> list = IOUtils.readLines(fileInputStream, string);
            return list;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    public static List<String> readLines(File file) throws IOException {
        return FileUtils.readLines(file, null);
    }

    public static LineIterator lineIterator(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            return IOUtils.lineIterator(fileInputStream, string);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(fileInputStream);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(fileInputStream);
            throw runtimeException;
        }
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return FileUtils.lineIterator(file, null);
    }

    public static void writeStringToFile(File file, String string, String string2) throws IOException {
        FileUtils.writeStringToFile(file, string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String string, String string2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file, bl);
            IOUtils.write(string, (OutputStream)fileOutputStream, string2);
            ((OutputStream)fileOutputStream).close();
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileUtils.writeStringToFile(file, string, null, false);
    }

    public static void writeStringToFile(File file, String string, boolean bl) throws IOException {
        FileUtils.writeStringToFile(file, string, null, bl);
    }

    public static void write(File file, CharSequence charSequence) throws IOException {
        FileUtils.write(file, charSequence, null, false);
    }

    public static void write(File file, CharSequence charSequence, boolean bl) throws IOException {
        FileUtils.write(file, charSequence, null, bl);
    }

    public static void write(File file, CharSequence charSequence, String string) throws IOException {
        FileUtils.write(file, charSequence, string, false);
    }

    public static void write(File file, CharSequence charSequence, String string, boolean bl) throws IOException {
        String string2;
        block6: {
            CharSequence charSequence2;
            block4: {
                block5: {
                    boolean bl2 = UIFactory.b;
                    charSequence2 = charSequence;
                    if (bl2) break block4;
                    if (charSequence2 != null) break block5;
                    string2 = null;
                    break block6;
                }
                charSequence2 = charSequence;
            }
            string2 = ((Object)charSequence2).toString();
        }
        String string3 = string2;
        FileUtils.writeStringToFile(file, string3, string, bl);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) throws IOException {
        FileUtils.writeByteArrayToFile(file, byArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] byArray, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file, bl);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    public static void writeLines(File file, String string, Collection<?> collection) throws IOException {
        FileUtils.writeLines(file, string, collection, null, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, boolean bl) throws IOException {
        FileUtils.writeLines(file, string, collection, null, bl);
    }

    public static void writeLines(File file, Collection<?> collection) throws IOException {
        FileUtils.writeLines(file, null, collection, null, false);
    }

    public static void writeLines(File file, Collection<?> collection, boolean bl) throws IOException {
        FileUtils.writeLines(file, null, collection, null, bl);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2) throws IOException {
        FileUtils.writeLines(file, string, collection, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, String string, Collection<?> collection, String string2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file, bl);
            IOUtils.writeLines(collection, string2, fileOutputStream, string);
            ((OutputStream)fileOutputStream).close();
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    public static void writeLines(File file, Collection<?> collection, String string) throws IOException {
        FileUtils.writeLines(file, null, collection, string, false);
    }

    public static void writeLines(File file, Collection<?> collection, String string, boolean bl) throws IOException {
        FileUtils.writeLines(file, null, collection, string, bl);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void forceDelete(File file) throws IOException {
        block9: {
            boolean bl;
            block14: {
                File file2;
                boolean bl2;
                boolean bl3;
                block12: {
                    boolean bl4;
                    block11: {
                        block13: {
                            block10: {
                                bl3 = UIFactory.b;
                                bl4 = file.isDirectory();
                                if (!bl3) break block10;
                                bl2 = bl4;
                                file2 = file;
                                if (bl3) break block11;
                                break block12;
                            }
                            if (bl4) break block13;
                            bl4 = file.exists();
                            bl2 = bl4;
                            file2 = file;
                            if (bl3) break block11;
                            break block12;
                        }
                        file2 = file;
                    }
                    do {
                        FileUtils.deleteDirectory(file2);
                        if (!bl3) break block9;
                        bl4 = file.exists();
                        bl2 = bl4;
                        file2 = file;
                    } while (bl3);
                }
                bl = file2.delete();
                if (bl3 || bl3) break block14;
                if (bl) break block9;
                bl = bl2;
            }
            if (!bl) {
                throw new FileNotFoundException(FileUtils.a(-27900, 6859) + file);
            }
            String string = FileUtils.a(-27863, 14469) + file;
            throw new IOException(string);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void forceDeleteOnExit(File file) throws IOException {
        block3: {
            File file2;
            block4: {
                boolean bl;
                block6: {
                    block5: {
                        bl = UIFactory.b;
                        file2 = file;
                        if (bl) break block4;
                        if (file2.isDirectory()) break block5;
                        file2 = file;
                        if (bl) break block6;
                        break block4;
                    }
                    file2 = file;
                }
                do {
                    FileUtils.deleteDirectoryOnExit(file2);
                    if (!bl) break block3;
                    file2 = file;
                } while (bl);
            }
            file2.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        block11: {
            File file2;
            block10: {
                boolean bl;
                block8: {
                    boolean bl2;
                    block9: {
                        bl2 = UIFactory.b;
                        bl = file.exists();
                        if (bl2) break block8;
                        if (bl) break block9;
                        return;
                    }
                    file.deleteOnExit();
                    file2 = file;
                    if (bl2 || bl2) break block10;
                    bl = FileUtils.isSymlink(file2);
                }
                if (bl) break block11;
                file2 = file;
            }
            FileUtils.cleanDirectoryOnExit(file2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cleanDirectoryOnExit(File file) throws IOException {
        File[] fileArray;
        File file2;
        boolean bl;
        block18: {
            boolean bl2;
            block17: {
                bl = UIFactory.b;
                bl2 = file.exists();
                if (bl) break block17;
                if (!bl2) {
                    String string = file + FileUtils.a(-27889, 6032);
                    throw new IllegalArgumentException(string);
                }
                file2 = file;
                if (bl) break block18;
                bl2 = file2.isDirectory();
            }
            if (!bl2) {
                String string = file + FileUtils.a(-27860, 31222);
                throw new IllegalArgumentException(string);
            }
            file2 = file;
        }
        if ((fileArray = file2.listFiles()) == null) {
            throw new IOException(FileUtils.a(-27870, -12475) + file);
        }
        IOException iOException = null;
        for (File file3 : fileArray) {
            try {
                FileUtils.forceDeleteOnExit(file3);
                if (bl) return;
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (!bl) continue;
        }
        if (null == iOException) return;
        throw iOException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void forceMkdir(File file) throws IOException {
        boolean bl;
        block14: {
            boolean bl2;
            boolean bl3;
            block11: {
                block13: {
                    block12: {
                        bl3 = UIFactory.b;
                        bl2 = file.exists();
                        if (bl3) break block11;
                        if (!bl2) break block12;
                        bl2 = file.isDirectory();
                        break block13;
                    }
                    bl2 = file.mkdirs();
                    if (bl3) break block13;
                    if (bl3) break block14;
                    break block11;
                }
                if (bl2) return;
                String string = FileUtils.a(-27895, 4817) + file + FileUtils.a(-27892, -27509) + FileUtils.a(-27888, 12907);
                throw new IOException(string);
            }
            if (!bl3) {
                if (bl2) return;
                bl = file.isDirectory();
            }
        }
        if (bl) return;
        String string = FileUtils.a(-27886, 8794) + file;
        throw new IOException(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static long sizeOf(File file) {
        long l;
        File file2;
        boolean bl;
        block9: {
            boolean bl2;
            block8: {
                bl = UIFactory.b;
                bl2 = file.exists();
                if (bl) break block8;
                if (!bl2) {
                    String string = file + FileUtils.a(-27889, 6032);
                    throw new IllegalArgumentException(string);
                }
                file2 = file;
                if (bl) break block9;
                bl2 = file2.isDirectory();
            }
            if (bl2) {
                l = FileUtils.sizeOfDirectory(file);
                return l;
            }
            file2 = file;
        }
        l = file2.length();
        if (bl) return l;
        return l;
    }

    public static long sizeOfDirectory(File file) {
        long l;
        block13: {
            File[] fileArray;
            long l2;
            boolean bl;
            block11: {
                File[] fileArray2;
                block12: {
                    boolean bl2;
                    block9: {
                        block10: {
                            bl = UIFactory.b;
                            bl2 = file.exists();
                            if (bl) break block9;
                            if (bl2) break block10;
                            String string = file + FileUtils.a(-27889, 6032);
                            throw new IllegalArgumentException(string);
                        }
                        bl2 = file.isDirectory();
                    }
                    if (!bl2) {
                        String string = file + FileUtils.a(-27860, 31222);
                        throw new IllegalArgumentException(string);
                    }
                    l2 = 0L;
                    fileArray2 = file.listFiles();
                    fileArray = fileArray2;
                    if (bl) break block11;
                    if (fileArray != null) break block12;
                    return 0L;
                }
                fileArray = fileArray2;
            }
            for (File file2 : fileArray) {
                l = l2 + FileUtils.sizeOf(file2);
                if (!bl) {
                    l2 = l;
                    if (!bl) continue;
                }
                break block13;
            }
            l = l2;
        }
        return l;
    }

    public static boolean isFileNewer(File file, File file2) {
        boolean bl;
        block10: {
            block11: {
                File file3;
                boolean bl2;
                block8: {
                    block9: {
                        bl2 = UIFactory.b;
                        file3 = file2;
                        if (bl2) break block8;
                        if (file3 != null) break block9;
                        throw new IllegalArgumentException(FileUtils.a(-27857, -29770));
                    }
                    file3 = file2;
                }
                bl = file3.exists();
                if (bl2) break block10;
                if (bl) break block11;
                throw new IllegalArgumentException(FileUtils.a(-27903, 22536) + file2 + FileUtils.a(-27874, -26254));
            }
            bl = FileUtils.isFileNewer(file, file2.lastModified());
        }
        return bl;
    }

    public static boolean isFileNewer(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException(FileUtils.a(-27904, 10662));
        }
        return FileUtils.isFileNewer(file, date.getTime());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFileNewer(File file, long l) {
        boolean bl;
        boolean bl2 = UIFactory.b;
        File file2 = file;
        if (!bl2) {
            if (file2 == null) {
                throw new IllegalArgumentException(FileUtils.a(-27885, 28912));
            }
            file2 = file;
        }
        int n = file2.exists();
        if (!bl2) {
            if (n == 0) {
                return 0 != 0;
            }
            long l2 = file.lastModified() - l;
            n = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            if (bl2) return n != 0;
            if (bl2) return bl;
        }
        if (bl2) return bl;
        if (n <= 0) return false;
        return true;
    }

    public static boolean isFileOlder(File file, File file2) {
        boolean bl;
        block10: {
            block11: {
                File file3;
                boolean bl2;
                block8: {
                    block9: {
                        bl2 = UIFactory.b;
                        file3 = file2;
                        if (bl2) break block8;
                        if (file3 != null) break block9;
                        throw new IllegalArgumentException(FileUtils.a(-27857, -29770));
                    }
                    file3 = file2;
                }
                bl = file3.exists();
                if (bl2) break block10;
                if (bl) break block11;
                throw new IllegalArgumentException(FileUtils.a(-27903, 22536) + file2 + FileUtils.a(-27874, -26254));
            }
            bl = FileUtils.isFileOlder(file, file2.lastModified());
        }
        return bl;
    }

    public static boolean isFileOlder(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException(FileUtils.a(-27904, 10662));
        }
        return FileUtils.isFileOlder(file, date.getTime());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFileOlder(File file, long l) {
        boolean bl;
        boolean bl2 = UIFactory.b;
        File file2 = file;
        if (!bl2) {
            if (file2 == null) {
                throw new IllegalArgumentException(FileUtils.a(-27885, 28912));
            }
            file2 = file;
        }
        int n = file2.exists();
        if (!bl2) {
            if (n == 0) {
                return 0 != 0;
            }
            long l2 = file.lastModified() - l;
            n = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            if (bl2) return n != 0;
            if (bl2) return bl;
        }
        if (bl2) return bl;
        if (n >= 0) return false;
        return true;
    }

    public static long checksumCRC32(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        FileUtils.checksum(file, cRC32);
        return cRC32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Checksum checksum(File file, Checksum checksum) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(FileUtils.a(-27880, 5063));
        }
        CheckedInputStream checkedInputStream = null;
        try {
            checkedInputStream = new CheckedInputStream(new FileInputStream(file), checksum);
            IOUtils.copy((InputStream)checkedInputStream, (OutputStream)new NullOutputStream());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(checkedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(checkedInputStream);
        return checksum;
    }

    public static void moveDirectory(File file, File file2) throws IOException {
        block44: {
            boolean bl;
            block45: {
                block46: {
                    boolean bl2;
                    block43: {
                        boolean bl3;
                        block41: {
                            block42: {
                                block39: {
                                    block40: {
                                        block37: {
                                            block38: {
                                                File file3;
                                                block35: {
                                                    block36: {
                                                        block33: {
                                                            block34: {
                                                                bl2 = UIFactory.b;
                                                                file3 = file;
                                                                if (bl2) break block33;
                                                                if (file3 != null) break block34;
                                                                throw new NullPointerException(FileUtils.a(-27865, -8986));
                                                            }
                                                            file3 = file2;
                                                        }
                                                        if (bl2) break block35;
                                                        if (file3 != null) break block36;
                                                        throw new NullPointerException(FileUtils.a(-27850, 11417));
                                                    }
                                                    file3 = file;
                                                }
                                                bl3 = file3.exists();
                                                if (bl2) break block37;
                                                if (bl3) break block38;
                                                throw new FileNotFoundException(FileUtils.a(-27878, -27348) + file + FileUtils.a(-27859, -21363));
                                            }
                                            bl3 = file.isDirectory();
                                        }
                                        if (bl2) break block39;
                                        if (bl3) break block40;
                                        throw new IOException(FileUtils.a(-27878, -27348) + file + FileUtils.a(-27853, -32438));
                                    }
                                    bl3 = file2.exists();
                                }
                                if (bl2) break block41;
                                if (!bl3) break block42;
                                throw new FileExistsException(FileUtils.a(-27901, -2427) + file2 + FileUtils.a(-27849, -4713));
                            }
                            bl3 = file.renameTo(file2);
                        }
                        boolean bl4 = bl3;
                        bl = bl4;
                        if (bl2 || bl2) break block43;
                        if (bl) break block44;
                        bl = file2.getCanonicalPath().startsWith(file.getCanonicalPath());
                    }
                    if (bl2) break block45;
                    if (!bl) break block46;
                    throw new IOException(FileUtils.a(-27861, 4678) + file + FileUtils.a(-27883, 10780) + file2);
                }
                FileUtils.copyDirectory(file, file2);
                FileUtils.deleteDirectory(file);
                bl = file.exists();
            }
            if (bl) {
                throw new IOException(FileUtils.a(-27848, -28226) + file + FileUtils.a(-27851, -14078) + file2 + "'");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void moveDirectoryToDirectory(File var0, File var1_1, boolean var2_2) throws IOException {
        block32: {
            block30: {
                block31: {
                    block29: {
                        block27: {
                            block28: {
                                block25: {
                                    block26: {
                                        var3_3 = UIFactory.b;
                                        v0 = var0;
                                        if (var3_3) break block25;
                                        if (v0 != null) break block26;
                                        throw new NullPointerException(FileUtils.a(-27865, -8986));
                                    }
                                    v0 = var1_1;
                                }
                                if (var3_3) break block27;
                                if (v0 != null) break block28;
                                throw new NullPointerException(FileUtils.a(-27858, 2331));
                            }
                            v0 = var1_1;
                        }
                        v5 = v0.exists();
                        if (var3_3) break block29;
                        if (!v5) {
                        }
                        ** GOTO lbl45
                        v5 = var2_2;
                        block20: while (!var3_3) {
                            if (v5) {
                                var1_1.mkdirs();
                            }
lbl45:
                            // 2 sources

                            do {
                                v5 = var1_1.exists();
                                if (var3_3) continue block20;
                            } while (var3_3);
                        }
                    }
                    if (var3_3) break block30;
                    if (v5) break block31;
                    throw new FileNotFoundException(FileUtils.a(-27843, -3257) + var1_1 + FileUtils.a(-27893, 13784) + var2_2 + "]");
                }
                v10 = var1_1;
                if (var3_3) break block32;
                v11 = v10.isDirectory();
            }
            if (!v11) {
                throw new IOException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27853, -32438));
            }
            v10 = var0;
        }
        FileUtils.moveDirectory(v10, new File(var1_1, var0.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void moveFile(File file, File file2) throws IOException {
        block35: {
            block36: {
                boolean bl;
                boolean bl2;
                block34: {
                    block33: {
                        boolean bl3;
                        bl2 = UIFactory.b;
                        File file3 = file;
                        if (!bl2) {
                            if (file3 == null) {
                                throw new NullPointerException(FileUtils.a(-27865, -8986));
                            }
                            file3 = file2;
                        }
                        if (!bl2) {
                            if (file3 == null) {
                                throw new NullPointerException(FileUtils.a(-27850, 11417));
                            }
                            file3 = file;
                        }
                        boolean bl4 = file3.exists();
                        if (!bl2) {
                            if (!bl4) {
                                throw new FileNotFoundException(FileUtils.a(-27878, -27348) + file + FileUtils.a(-27859, -21363));
                            }
                            bl4 = file.isDirectory();
                        }
                        if (!bl2) {
                            if (bl4) {
                                throw new IOException(FileUtils.a(-27878, -27348) + file + FileUtils.a(-27781, 1364));
                            }
                            bl4 = file2.exists();
                        }
                        if (!bl2) {
                            if (bl4) {
                                throw new FileExistsException(FileUtils.a(-27901, -2427) + file2 + FileUtils.a(-27849, -4713));
                            }
                            bl4 = file2.isDirectory();
                        }
                        if (!bl2) {
                            if (bl4) {
                                throw new IOException(FileUtils.a(-27901, -2427) + file2 + FileUtils.a(-27781, 1364));
                            }
                            bl4 = file.renameTo(file2);
                        }
                        bl = bl3 = bl4;
                        if (bl2) break block33;
                        if (bl2) break block34;
                        if (bl) break block35;
                        FileUtils.copyFile(file, file2);
                        bl = file.delete();
                    }
                    if (bl2) break block36;
                }
                if (bl2) break block36;
                if (bl) break block35;
                bl = FileUtils.deleteQuietly(file2);
            }
            throw new IOException(FileUtils.a(-27847, -18984) + file + FileUtils.a(-27851, -14078) + file2 + "'");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void moveFileToDirectory(File var0, File var1_1, boolean var2_2) throws IOException {
        block32: {
            block30: {
                block31: {
                    block29: {
                        block27: {
                            block28: {
                                block25: {
                                    block26: {
                                        var3_3 = UIFactory.b;
                                        v0 = var0;
                                        if (var3_3) break block25;
                                        if (v0 != null) break block26;
                                        throw new NullPointerException(FileUtils.a(-27865, -8986));
                                    }
                                    v0 = var1_1;
                                }
                                if (var3_3) break block27;
                                if (v0 != null) break block28;
                                throw new NullPointerException(FileUtils.a(-27858, 2331));
                            }
                            v0 = var1_1;
                        }
                        v5 = v0.exists();
                        if (var3_3) break block29;
                        if (!v5) {
                        }
                        ** GOTO lbl45
                        v5 = var2_2;
                        block20: while (!var3_3) {
                            if (v5) {
                                var1_1.mkdirs();
                            }
lbl45:
                            // 2 sources

                            do {
                                v5 = var1_1.exists();
                                if (var3_3) continue block20;
                            } while (var3_3);
                        }
                    }
                    if (var3_3) break block30;
                    if (v5) break block31;
                    throw new FileNotFoundException(FileUtils.a(-27843, -3257) + var1_1 + FileUtils.a(-27893, 13784) + var2_2 + "]");
                }
                v10 = var1_1;
                if (var3_3) break block32;
                v11 = v10.isDirectory();
            }
            if (!v11) {
                throw new IOException(FileUtils.a(-27901, -2427) + var1_1 + FileUtils.a(-27853, -32438));
            }
            v10 = var0;
        }
        FileUtils.moveFile(v10, new File(var1_1, var0.getName()));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void moveToDirectory(File file, File file2, boolean bl) throws IOException {
        block14: {
            boolean bl2;
            File file3;
            File file4;
            block18: {
                boolean bl3;
                block17: {
                    block19: {
                        boolean bl4;
                        block15: {
                            block16: {
                                bl3 = UIFactory.b;
                                File file5 = file;
                                if (!bl3) {
                                    if (file5 == null) {
                                        throw new NullPointerException(FileUtils.a(-27865, -8986));
                                    }
                                    file5 = file2;
                                }
                                if (!bl3) {
                                    if (file5 == null) {
                                        throw new NullPointerException(FileUtils.a(-27850, 11417));
                                    }
                                    file5 = file;
                                }
                                bl4 = file5.exists();
                                if (bl3) break block15;
                                if (!bl4) {
                                    throw new FileNotFoundException(FileUtils.a(-27878, -27348) + file + FileUtils.a(-27859, -21363));
                                }
                                file4 = file;
                                if (!bl3) break block16;
                                file3 = file2;
                                bl2 = bl;
                                if (bl3) break block17;
                                break block18;
                            }
                            bl4 = file4.isDirectory();
                        }
                        if (bl4) break block19;
                        file4 = file;
                        file3 = file2;
                        bl2 = bl;
                        if (bl3) break block17;
                        break block18;
                    }
                    file4 = file;
                    file3 = file2;
                    bl2 = bl;
                }
                do {
                    FileUtils.moveDirectoryToDirectory(file4, file3, bl2);
                    if (!bl3) break block14;
                    file4 = file;
                    file3 = file2;
                    bl2 = bl;
                } while (bl3);
            }
            FileUtils.moveFileToDirectory(file4, file3, bl2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isSymlink(File var0) throws IOException {
        block20: {
            block21: {
                block19: {
                    block17: {
                        block18: {
                            block16: {
                                block15: {
                                    var1_1 = UIFactory.b;
                                    if (var0 == null) {
                                        throw new NullPointerException(FileUtils.a(-27896, -4359));
                                    }
                                    v1 = FilenameUtils.isSystemWindows();
                                    if (var1_1 || var1_1) break block15;
                                    if (!v1) break block16;
                                    v1 = false;
                                }
                                return v1;
                            }
                            var2_2 = null;
                            v4 = var0;
                            if (var1_1) break block17;
                            if (v4.getParent() != null) break block18;
                            v6 = var0;
lbl36:
                            // 2 sources

                            while (true) {
                                var2_2 = v6;
                                break block19;
                                break;
                            }
                        }
                        v4 = var0.getParentFile().getCanonicalFile();
                    }
                    var3_3 = v4;
                    v6 = new File(var3_3, var0.getName());
                    ** while (var1_1)
lbl45:
                    // 1 sources

                    var2_2 = v6;
                }
                v8 = var2_2.getCanonicalFile().equals(var2_2.getAbsoluteFile());
                if (var1_1) break block20;
                if (!v8) break block21;
                v8 = false;
lbl55:
                // 2 sources

                return v8;
            }
            v8 = true;
            ** while (var1_1)
        }
        return v8;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        int n;
        Object var6_6;
        String[] stringArray = new String[66];
        int n2 = 0;
        String string = "\u0006}\u00f7\u00d8\u00ca\u00b6K\u0093\u00f4\u00e7\u00b9\u0010}\u00cd\u0086\u00aa\u00daf\u00e5\u00d6x\u00cb\u0018\u001c\u00a8\u00b0\u0085\u00dd \u00c0\u001dv\u00d4\u0084\u000f\u000b\u00b0LE9\u0082\u00b3\u008e.\u001b\u0096\u0093\u00ef\u0089\u00d4\u00d1\u0019\u0096\u00ba\u00d4\u00c0\u00a5\u0013\u00f3*\u00c6%\u00b7\u008a\u0098&YQ\u00b0{;<\u00d7\u00adnk\u0095\u00a7\u00e1\u0004\u0001{\t\u008f\u00a2]\u00cd\u00ad,\u008a\u00d2\u0016\u008c)\u009a\u00bd\u00dafL\u0003\u00d7\u00a8\u0015\u00062\u0091x/\u00beP\u0017\u00e0\n*\u00aaZ\u00d1\u001c \u00c1\u0018D\u00ca_f\u00bc\u008bA\u009a#\u00cb\u00ed\u00a8\u00aa\u0003j\u0080\u00a2\u0014\u00cf$\u00da\u0085T\u00d3\u00b3`\u00b2\u001e\u0004\u0081\u00dd\u00d8W\"\u00der8\u00a5\u0016\u00fa&\u0018\u00ba\u00db\u00aeyI\u00fa\u000f4\u001e\u00ddf\u00d42R\u001e\u0086\u0082m*\u0003\u0003\u009b\u008f\u0006M\u0095}\u00be\u00f7N\u0010\u00f3)U;\u00fe\u00f3\u00f0\u001eL\u0082\u00ecg-\u009aX[\u001c|\u0095\u00b9Y(\u00afR\u00ef\b\u00e1}\u00f5q\u009dPz\u00be\u008d\u00f7v.\u009b\u00e2\u00f4\u00ad\u00a4jQ\u0011\u00aeW\u00fe\u00fe\u008d\u0000K$PF#X*[\u00c3\u00d7T\u0016\u00e9G\u0014\u00f5\u0093@\u00bf\u0004\u0017Bc\u0081\u00e4\u0003_\u00ac4\u00a9\u00b0\u0098L@\u0017\u00c2\u0013\u0094\u00175%v\u00fe\u00e3\u00e0\u00cd\u00ef\u0004\u00c2\u00d7\u001f,\b\u008e\u0099X\u00f8\u001b\u001f\u008d3\u009el\u0018\u0099A\u0090\u0094\u00e4\u0095\u00adYT\u00b1\u0088\u00cc\f%3M\u00af\u00e61\u0010lMB\u0004\u00a6\u00f2\u0017\u0013\u00bcu\u0000\u00e4[/\u001b\u00c80\u00a9,\u00a1[l\u00a1\u00de\u00cd\u00fdo\u00ec\u00fb\u0012&\u00fd\u00e3\u0085\u0012}\u0019\u00a7\u0000-Hu)i\u00f5x\u0099\u0088\u00cf1\u0088\u00a0\u001a\u00b8w\u0018\u001b\u00fa\u008d\u00d9\rQ\u00f3J#\u00d9\u0088\u0086q\u001b\u00fe\u00c5\u00f1\u001f\u0001\u008bO\u001c\u00e6'E\u00afQ\u001d\u00a6\u009f\u00f1}\u00f9\u00ed\u00e7\u00b6\u00b5\u00f0\u00ad\u00b3\u0084&I\u00bd\u001f\\\u00fc\u000f\u00c8\u00fb[c\u0017\u00a55\u008b\u00f16\u00e8-\u0016=Kv4\u0016c\u0006A&\u00aeu\u00fe`\u00f5\u0012k\u00de\u00c4\u00e5\u0010\u0006G\u00ee\u00f5;_\u00fcU\u00b2\u00f4\u00a2j\u0018\u009f\u00ca\u00a5\u0013\u009ft-\u00bc\u00bd\u00cc\u0012\u00f6\u00bfS\u0088L\u009b\u00da\u00e1\u0080\u00d5\u00ce*\u0016\u0012\u00ebkng\u00feR\u00c5\u008e\u00a9\u00c6Pv.\u00f3\u00eb\u00c7\u00b4\u0007oEk\u001b\u0087\u0011\u009eU\u0099?\u00a8\u00b68\u0085\u00bf\u0096u\u0090^\u00ed\t\u008a\u00bc\u0087q\u0080\u0098C7AT\u001d\u00be%\u00f9\u00bf\u00ce\u00c6\u00f4\u00a8\u0098\u0014\u00be\u00f5\u00f2\u0089\u00f2t\u001b\u000f\u00aaif\u00ee\u0000\u0002<v*\u0094\u0016\u0006\u0096p\u00b9y\u009d\u00d1\u0017j{\u0088\u00c9\u00c2p\u0005g\u0097\u00d6\u000b\u008c\u00e5\u00a8\u00a6\u00d1\u00c5-\u00dd\u0012\u0098@\u00c2-@\u00ba\u001f\u00c0\u00a9C\u0086\u0018\u00fdP\u0018 z\u009f\f\u00d9\u0097(<Pg\u00fe\u00b7\u00c1\u00eb\u00f7\u0086\u00020\u00ef\u00aa\u00d0\u001a\u009f\u001b\u009c\u00d2W\u009b\u00a0\u0083\u00c9\u00f6\u0087\u00f5\u001e/\u00a2D.\u00b2\u00fd\u0090\u00de\u00fc\u00bb\u00d2^\u00e0\u007f\u00f0.7q\u00bd\u00baMt\u00d3\u00ad{\u00ba\ft\u0083_#\u00b7[\u00e5\u001c\u0088.\u0003\u0080\u00fd\u00c1\u00d6\u00c9\u00eb\u0014\r\u0084\u00a0=c\u008cO\u00ef I\u00c6\t\u001f\u00f1\u00b6\u0019Q\u00d2\u0010\u0085\u00c7\u001a\u00c1\u00e0\u000fk\u00d5\u00c0\u00a8]\u0088>|\u00fd,bu\u00belVDB\u00bb\u008b\u00b6\u00a9O\u00e9\b\u0016\u00e2\u0007\u00fa3\u0016;\u00e1#\u0004\u00f5\u00ee\u00c9\u0097\u00aci\u00c4\u0000\u00cb\u00b7Y\u0099\u00a2\u00a0\u0002\u00cc\u00d0E\u00cbX\u00ff\f\u0080\u0011\u00ef\u008f_\u00e6\u00f6\u0003MZ\u001b\u00de*\u008aR\u0096\u001a\u001b/bX\u0082bxb~T\u00d5\u000f\u00ab\u00f6\u0010d;#\u00f3X\"\u00de\u00ca@\u0013$I\u0015\u000f(\u00b2\u0097\u008d\u001bo\u00e3\u00a49\u0011\u00e8xg\u00fb\u001ck\u00d8\u00ed\u00e7\u0015\u00f5t\u00cet\u00ef\u00ee\u0002\u000f?D\u00c9\u0095\u00dfS.\u009dt\u00d9G\fX\u00f7\u00f6\u001b\u0087\u001e\u00e7T\u00b6\u00d1eJ\u0081\u001a\u0080i\u0084\u00f3\u00c8\u00b4Jmo'\u00bev\f'_t\u00e7\u0003=AH\u0011\u00ceH\u00f7\u00ae\u00c1\u00bdW\u00da\u00e5\u00ff%\u00b4]j+\u00ed\u00cd\u001bt\u00a0\u0099\u0083y+\u009c\u0015\u00be\u00f1`\u0003vO\u00be\u00a7\u0084\u000f\u00b6k\u0085\u00ffk\u0016\u00b3Rz%l\u008eA\u00ed\u0094NyO+\u0092\u00925j\u00c8-2\u00b61\u00e2\u008bN4DV\u00e9D\u0010<\u0085\u000f\u00e3v'\u0093P\u009e\u00fe,v\u00ab\u0090\u0081\u00e2$\u0007\u0004\u001c(\u008a\u00d3!\u0080\u0012d\u00bdd\u0096\u0002a\u00ac\u0001\u00dd\u00cb\u009b\u00b3\u00e0\u00ed\u0010i\u00e9n\u00f7\u0012~\u00beg\u00de:\u00ab\u00bdC\u00c3\u0003\u00fc\"p\u0019\u009b\u00a3\\~@\u00dbJ\u00d8\u00f5\u00ed\u00b9\u008c\u00dcp\u0001\f\u00c6\u0096\u00eeo\u00cf\u00a7y\u0093\u00a3\u001e\u00e3\u0086\u00be\\_\u009f\u00a7o\u00ed\u00db\u00ac\u008a\u00a4|\u00e4\u0089\u009d\u009c\u00c4\u00ba\u00a88\u00b0\u00dew/\u008f8\u00e7\u00eb\u0005:\u00d1w\u009f3 \u00c4C\u00b6u0O\u009dW\u009e\u00b4'b\u00a8\u009e\u00dc\u0085/G\u00c9\u00ba!\u00c7\u00ffY\u0017\u00ecMR=\u00bf\u0090\u00d8\u0004L\u001e\u00c6\u00b4\u0005\u008bD\u001a\u00ff\u00e9\u0015\u00f5\u00e2\u00d5+\u0010\u00d1!D\u00ed<\u007f\u00a7($P\u00a3\u008d\u0085\u008bo\u00b4\u000f\u00fd'}?5\u001e\u00a7EE\u0083aG\u009c\u009en\u0013\u00ac@\u00be\u0014\u0095\u0011L\u00aet\u00e1\u00ac\u00c3\u00a0\u00dd\u00fdH\u001c\u00fdl\u000e\u0019\u00c5\b\u00b8B\u001b\u0087\u00e2\t\u0090\u00cd<\u00d9\u00dd\u000f\u00d8C\u00ce\u009e\u00b6\u00f3\u00caiC\u00ee\u00175s\u0083\u00c7\r)\u0098\u0013\u00f8}\u009b\u00f8i]1\u00d7\u00efn\u000e\u00c0\u00c3\u00c0\u0002\u00e5tJ)\u00d9*\u00e7\u008a\u00fb\u00b9\u0014\u0092Y`8\u00dcV\u00b3\u00ab\u00c8P\u001d\u00cbu$\u00cc\u00af\u00d6\u0082p\u00ae\u0011\u00edf\u0093kM\u0005\u00c6\u00cd\u00d7\u001dc\u00e8\u0095\u00e3:\u0086\u00e6\u001b(K*c\u008ex\u0093\u00ac\u00cec\u00de]0J\u009cKf;\u008e:9\u00ab\u001eA\u00f5\u00cbU(\u0094'3\u009e\\\u00ebM\u001cG\u00e3\u00a5W\u000e\u0002-y\u0091\u0019\u00d1\u00c8S\u00a2\u00a6\u008a\u00e6I\u0087\u008c\u009fl~\u00f2\u00e9\u00d4n\b\u0016\u00e8\u001c\u008d\u0003\r\u0097N\u0015\u009aa8[\u00ad\u00d6\u008c\u009a\u00063\u00e5F{\u0018=9\u008eu\u008a\u0099\u00f9";
        int n3 = "\u0006}\u00f7\u00d8\u00ca\u00b6K\u0093\u00f4\u00e7\u00b9\u0010}\u00cd\u0086\u00aa\u00daf\u00e5\u00d6x\u00cb\u0018\u001c\u00a8\u00b0\u0085\u00dd \u00c0\u001dv\u00d4\u0084\u000f\u000b\u00b0LE9\u0082\u00b3\u008e.\u001b\u0096\u0093\u00ef\u0089\u00d4\u00d1\u0019\u0096\u00ba\u00d4\u00c0\u00a5\u0013\u00f3*\u00c6%\u00b7\u008a\u0098&YQ\u00b0{;<\u00d7\u00adnk\u0095\u00a7\u00e1\u0004\u0001{\t\u008f\u00a2]\u00cd\u00ad,\u008a\u00d2\u0016\u008c)\u009a\u00bd\u00dafL\u0003\u00d7\u00a8\u0015\u00062\u0091x/\u00beP\u0017\u00e0\n*\u00aaZ\u00d1\u001c \u00c1\u0018D\u00ca_f\u00bc\u008bA\u009a#\u00cb\u00ed\u00a8\u00aa\u0003j\u0080\u00a2\u0014\u00cf$\u00da\u0085T\u00d3\u00b3`\u00b2\u001e\u0004\u0081\u00dd\u00d8W\"\u00der8\u00a5\u0016\u00fa&\u0018\u00ba\u00db\u00aeyI\u00fa\u000f4\u001e\u00ddf\u00d42R\u001e\u0086\u0082m*\u0003\u0003\u009b\u008f\u0006M\u0095}\u00be\u00f7N\u0010\u00f3)U;\u00fe\u00f3\u00f0\u001eL\u0082\u00ecg-\u009aX[\u001c|\u0095\u00b9Y(\u00afR\u00ef\b\u00e1}\u00f5q\u009dPz\u00be\u008d\u00f7v.\u009b\u00e2\u00f4\u00ad\u00a4jQ\u0011\u00aeW\u00fe\u00fe\u008d\u0000K$PF#X*[\u00c3\u00d7T\u0016\u00e9G\u0014\u00f5\u0093@\u00bf\u0004\u0017Bc\u0081\u00e4\u0003_\u00ac4\u00a9\u00b0\u0098L@\u0017\u00c2\u0013\u0094\u00175%v\u00fe\u00e3\u00e0\u00cd\u00ef\u0004\u00c2\u00d7\u001f,\b\u008e\u0099X\u00f8\u001b\u001f\u008d3\u009el\u0018\u0099A\u0090\u0094\u00e4\u0095\u00adYT\u00b1\u0088\u00cc\f%3M\u00af\u00e61\u0010lMB\u0004\u00a6\u00f2\u0017\u0013\u00bcu\u0000\u00e4[/\u001b\u00c80\u00a9,\u00a1[l\u00a1\u00de\u00cd\u00fdo\u00ec\u00fb\u0012&\u00fd\u00e3\u0085\u0012}\u0019\u00a7\u0000-Hu)i\u00f5x\u0099\u0088\u00cf1\u0088\u00a0\u001a\u00b8w\u0018\u001b\u00fa\u008d\u00d9\rQ\u00f3J#\u00d9\u0088\u0086q\u001b\u00fe\u00c5\u00f1\u001f\u0001\u008bO\u001c\u00e6'E\u00afQ\u001d\u00a6\u009f\u00f1}\u00f9\u00ed\u00e7\u00b6\u00b5\u00f0\u00ad\u00b3\u0084&I\u00bd\u001f\\\u00fc\u000f\u00c8\u00fb[c\u0017\u00a55\u008b\u00f16\u00e8-\u0016=Kv4\u0016c\u0006A&\u00aeu\u00fe`\u00f5\u0012k\u00de\u00c4\u00e5\u0010\u0006G\u00ee\u00f5;_\u00fcU\u00b2\u00f4\u00a2j\u0018\u009f\u00ca\u00a5\u0013\u009ft-\u00bc\u00bd\u00cc\u0012\u00f6\u00bfS\u0088L\u009b\u00da\u00e1\u0080\u00d5\u00ce*\u0016\u0012\u00ebkng\u00feR\u00c5\u008e\u00a9\u00c6Pv.\u00f3\u00eb\u00c7\u00b4\u0007oEk\u001b\u0087\u0011\u009eU\u0099?\u00a8\u00b68\u0085\u00bf\u0096u\u0090^\u00ed\t\u008a\u00bc\u0087q\u0080\u0098C7AT\u001d\u00be%\u00f9\u00bf\u00ce\u00c6\u00f4\u00a8\u0098\u0014\u00be\u00f5\u00f2\u0089\u00f2t\u001b\u000f\u00aaif\u00ee\u0000\u0002<v*\u0094\u0016\u0006\u0096p\u00b9y\u009d\u00d1\u0017j{\u0088\u00c9\u00c2p\u0005g\u0097\u00d6\u000b\u008c\u00e5\u00a8\u00a6\u00d1\u00c5-\u00dd\u0012\u0098@\u00c2-@\u00ba\u001f\u00c0\u00a9C\u0086\u0018\u00fdP\u0018 z\u009f\f\u00d9\u0097(<Pg\u00fe\u00b7\u00c1\u00eb\u00f7\u0086\u00020\u00ef\u00aa\u00d0\u001a\u009f\u001b\u009c\u00d2W\u009b\u00a0\u0083\u00c9\u00f6\u0087\u00f5\u001e/\u00a2D.\u00b2\u00fd\u0090\u00de\u00fc\u00bb\u00d2^\u00e0\u007f\u00f0.7q\u00bd\u00baMt\u00d3\u00ad{\u00ba\ft\u0083_#\u00b7[\u00e5\u001c\u0088.\u0003\u0080\u00fd\u00c1\u00d6\u00c9\u00eb\u0014\r\u0084\u00a0=c\u008cO\u00ef I\u00c6\t\u001f\u00f1\u00b6\u0019Q\u00d2\u0010\u0085\u00c7\u001a\u00c1\u00e0\u000fk\u00d5\u00c0\u00a8]\u0088>|\u00fd,bu\u00belVDB\u00bb\u008b\u00b6\u00a9O\u00e9\b\u0016\u00e2\u0007\u00fa3\u0016;\u00e1#\u0004\u00f5\u00ee\u00c9\u0097\u00aci\u00c4\u0000\u00cb\u00b7Y\u0099\u00a2\u00a0\u0002\u00cc\u00d0E\u00cbX\u00ff\f\u0080\u0011\u00ef\u008f_\u00e6\u00f6\u0003MZ\u001b\u00de*\u008aR\u0096\u001a\u001b/bX\u0082bxb~T\u00d5\u000f\u00ab\u00f6\u0010d;#\u00f3X\"\u00de\u00ca@\u0013$I\u0015\u000f(\u00b2\u0097\u008d\u001bo\u00e3\u00a49\u0011\u00e8xg\u00fb\u001ck\u00d8\u00ed\u00e7\u0015\u00f5t\u00cet\u00ef\u00ee\u0002\u000f?D\u00c9\u0095\u00dfS.\u009dt\u00d9G\fX\u00f7\u00f6\u001b\u0087\u001e\u00e7T\u00b6\u00d1eJ\u0081\u001a\u0080i\u0084\u00f3\u00c8\u00b4Jmo'\u00bev\f'_t\u00e7\u0003=AH\u0011\u00ceH\u00f7\u00ae\u00c1\u00bdW\u00da\u00e5\u00ff%\u00b4]j+\u00ed\u00cd\u001bt\u00a0\u0099\u0083y+\u009c\u0015\u00be\u00f1`\u0003vO\u00be\u00a7\u0084\u000f\u00b6k\u0085\u00ffk\u0016\u00b3Rz%l\u008eA\u00ed\u0094NyO+\u0092\u00925j\u00c8-2\u00b61\u00e2\u008bN4DV\u00e9D\u0010<\u0085\u000f\u00e3v'\u0093P\u009e\u00fe,v\u00ab\u0090\u0081\u00e2$\u0007\u0004\u001c(\u008a\u00d3!\u0080\u0012d\u00bdd\u0096\u0002a\u00ac\u0001\u00dd\u00cb\u009b\u00b3\u00e0\u00ed\u0010i\u00e9n\u00f7\u0012~\u00beg\u00de:\u00ab\u00bdC\u00c3\u0003\u00fc\"p\u0019\u009b\u00a3\\~@\u00dbJ\u00d8\u00f5\u00ed\u00b9\u008c\u00dcp\u0001\f\u00c6\u0096\u00eeo\u00cf\u00a7y\u0093\u00a3\u001e\u00e3\u0086\u00be\\_\u009f\u00a7o\u00ed\u00db\u00ac\u008a\u00a4|\u00e4\u0089\u009d\u009c\u00c4\u00ba\u00a88\u00b0\u00dew/\u008f8\u00e7\u00eb\u0005:\u00d1w\u009f3 \u00c4C\u00b6u0O\u009dW\u009e\u00b4'b\u00a8\u009e\u00dc\u0085/G\u00c9\u00ba!\u00c7\u00ffY\u0017\u00ecMR=\u00bf\u0090\u00d8\u0004L\u001e\u00c6\u00b4\u0005\u008bD\u001a\u00ff\u00e9\u0015\u00f5\u00e2\u00d5+\u0010\u00d1!D\u00ed<\u007f\u00a7($P\u00a3\u008d\u0085\u008bo\u00b4\u000f\u00fd'}?5\u001e\u00a7EE\u0083aG\u009c\u009en\u0013\u00ac@\u00be\u0014\u0095\u0011L\u00aet\u00e1\u00ac\u00c3\u00a0\u00dd\u00fdH\u001c\u00fdl\u000e\u0019\u00c5\b\u00b8B\u001b\u0087\u00e2\t\u0090\u00cd<\u00d9\u00dd\u000f\u00d8C\u00ce\u009e\u00b6\u00f3\u00caiC\u00ee\u00175s\u0083\u00c7\r)\u0098\u0013\u00f8}\u009b\u00f8i]1\u00d7\u00efn\u000e\u00c0\u00c3\u00c0\u0002\u00e5tJ)\u00d9*\u00e7\u008a\u00fb\u00b9\u0014\u0092Y`8\u00dcV\u00b3\u00ab\u00c8P\u001d\u00cbu$\u00cc\u00af\u00d6\u0082p\u00ae\u0011\u00edf\u0093kM\u0005\u00c6\u00cd\u00d7\u001dc\u00e8\u0095\u00e3:\u0086\u00e6\u001b(K*c\u008ex\u0093\u00ac\u00cec\u00de]0J\u009cKf;\u008e:9\u00ab\u001eA\u00f5\u00cbU(\u0094'3\u009e\\\u00ebM\u001cG\u00e3\u00a5W\u000e\u0002-y\u0091\u0019\u00d1\u00c8S\u00a2\u00a6\u008a\u00e6I\u0087\u008c\u009fl~\u00f2\u00e9\u00d4n\b\u0016\u00e8\u001c\u008d\u0003\r\u0097N\u0015\u009aa8[\u00ad\u00d6\u008c\u009a\u00063\u00e5F{\u0018=9\u008eu\u008a\u0099\u00f9".length();
        int n4 = 11;
        int n5 = -1;
        while (true) {
            char[] cArray;
            block26: {
                int n6;
                int n7;
                char[] cArray2;
                block25: {
                    int n8 = ++n5;
                    var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n4).toCharArray();
                    n = 0;
                    int n9 = cArray3.length;
                    cArray2 = cArray3;
                    n7 = n9;
                    if (n9 <= 1) break block25;
                    cArray = cArray2;
                    n6 = n7;
                    if (n7 <= n) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n10 = n;
                    while (true) {
                        int n11;
                        char c = cArray4[n10];
                        switch (n % 7) {
                            case 0: {
                                n11 = 6;
                                break;
                            }
                            case 1: {
                                n11 = 33;
                                break;
                            }
                            case 2: {
                                n11 = 73;
                                break;
                            }
                            case 3: {
                                n11 = 114;
                                break;
                            }
                            case 4: {
                                n11 = 66;
                                break;
                            }
                            case 5: {
                                n11 = 94;
                                break;
                            }
                            default: {
                                n11 = 58;
                            }
                        }
                        cArray4[n10] = (char)(c ^ n11);
                        ++n;
                        cArray2 = cArray5;
                        n7 = n7;
                        if (n7 != 0) break;
                        cArray5 = cArray2;
                        n6 = n7;
                        n10 = n7;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n6 = n7;
                } while (n7 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) break;
            n4 = string.charAt(n5);
        }
        string = "\\/\u00a8\u00e4\u001a\u00f05\u00fa\u008dL\u00c6\u00bdu\u00a5\u00eb)\t\u0085\u00a4\u0087\u00ad|\u00f1y\u00fb\u00ae";
        n3 = "\\/\u00a8\u00e4\u001a\u00f05\u00fa\u008dL\u00c6\u00bdu\u00a5\u00eb)\t\u0085\u00a4\u0087\u00ad|\u00f1y\u00fb\u00ae".length();
        n4 = 16;
        n5 = -1;
        while (true) {
            char[] cArray;
            block28: {
                int n12;
                int n13;
                char[] cArray6;
                block27: {
                    int n14 = ++n5;
                    var6_6 = null;
                    char[] cArray7 = string.substring(n14, n14 + n4).toCharArray();
                    n = 0;
                    int n15 = cArray7.length;
                    cArray6 = cArray7;
                    n13 = n15;
                    if (n15 <= 1) break block27;
                    cArray = cArray6;
                    n12 = n13;
                    if (n13 <= n) break block28;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n16 = n;
                    while (true) {
                        int n17;
                        char c = cArray8[n16];
                        switch (n % 7) {
                            case 0: {
                                n17 = 6;
                                break;
                            }
                            case 1: {
                                n17 = 33;
                                break;
                            }
                            case 2: {
                                n17 = 73;
                                break;
                            }
                            case 3: {
                                n17 = 114;
                                break;
                            }
                            case 4: {
                                n17 = 66;
                                break;
                            }
                            case 5: {
                                n17 = 94;
                                break;
                            }
                            default: {
                                n17 = 58;
                            }
                        }
                        cArray8[n16] = (char)(c ^ n17);
                        ++n;
                        cArray6 = cArray9;
                        n13 = n13;
                        if (n13 != 0) break;
                        cArray9 = cArray6;
                        n12 = n13;
                        n16 = n13;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n12 = n13;
                } while (n13 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) {
                a = stringArray;
                b = new String[66];
                ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
                ONE_YB = ONE_ZB.multiply(BigInteger.valueOf(0x1000000000000000L));
                EMPTY_FILE_ARRAY = new File[0];
                UTF8 = Charset.forName(FileUtils.a(-27884, -17279));
                return;
            }
            n4 = string.charAt(n5);
        }
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFF933B) & 0xFFFF;
        if (b[n3] == null) {
            int n4;
            int n5;
            char[] cArray = a[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 102;
                    break;
                }
                case 1: {
                    n5 = 194;
                    break;
                }
                case 2: {
                    n5 = 198;
                    break;
                }
                case 3: {
                    n5 = 184;
                    break;
                }
                case 4: {
                    n5 = 50;
                    break;
                }
                case 5: {
                    n5 = 41;
                    break;
                }
                case 6: {
                    n5 = 65;
                    break;
                }
                case 7: {
                    n5 = 249;
                    break;
                }
                case 8: {
                    n5 = 45;
                    break;
                }
                case 9: {
                    n5 = 2;
                    break;
                }
                case 10: {
                    n5 = 138;
                    break;
                }
                case 11: {
                    n5 = 154;
                    break;
                }
                case 12: {
                    n5 = 127;
                    break;
                }
                case 13: {
                    n5 = 66;
                    break;
                }
                case 14: {
                    n5 = 99;
                    break;
                }
                case 15: {
                    n5 = 124;
                    break;
                }
                case 16: {
                    n5 = 233;
                    break;
                }
                case 17: {
                    n5 = 225;
                    break;
                }
                case 18: {
                    n5 = 146;
                    break;
                }
                case 19: {
                    n5 = 96;
                    break;
                }
                case 20: {
                    n5 = 70;
                    break;
                }
                case 21: {
                    n5 = 69;
                    break;
                }
                case 22: {
                    n5 = 230;
                    break;
                }
                case 23: {
                    n5 = 81;
                    break;
                }
                case 24: {
                    n5 = 193;
                    break;
                }
                case 25: {
                    n5 = 94;
                    break;
                }
                case 26: {
                    n5 = 190;
                    break;
                }
                case 27: {
                    n5 = 23;
                    break;
                }
                case 28: {
                    n5 = 172;
                    break;
                }
                case 29: {
                    n5 = 195;
                    break;
                }
                case 30: {
                    n5 = 30;
                    break;
                }
                case 31: {
                    n5 = 179;
                    break;
                }
                case 32: {
                    n5 = 107;
                    break;
                }
                case 33: {
                    n5 = 112;
                    break;
                }
                case 34: {
                    n5 = 228;
                    break;
                }
                case 35: {
                    n5 = 27;
                    break;
                }
                case 36: {
                    n5 = 205;
                    break;
                }
                case 37: {
                    n5 = 187;
                    break;
                }
                case 38: {
                    n5 = 79;
                    break;
                }
                case 39: {
                    n5 = 242;
                    break;
                }
                case 40: {
                    n5 = 231;
                    break;
                }
                case 41: {
                    n5 = 116;
                    break;
                }
                case 42: {
                    n5 = 158;
                    break;
                }
                case 43: {
                    n5 = 135;
                    break;
                }
                case 44: {
                    n5 = 73;
                    break;
                }
                case 45: {
                    n5 = 156;
                    break;
                }
                case 46: {
                    n5 = 185;
                    break;
                }
                case 47: {
                    n5 = 26;
                    break;
                }
                case 48: {
                    n5 = 49;
                    break;
                }
                case 49: {
                    n5 = 40;
                    break;
                }
                case 50: {
                    n5 = 32;
                    break;
                }
                case 51: {
                    n5 = 196;
                    break;
                }
                case 52: {
                    n5 = 64;
                    break;
                }
                case 53: {
                    n5 = 82;
                    break;
                }
                case 54: {
                    n5 = 33;
                    break;
                }
                case 55: {
                    n5 = 166;
                    break;
                }
                case 56: {
                    n5 = 117;
                    break;
                }
                case 57: {
                    n5 = 84;
                    break;
                }
                case 58: {
                    n5 = 176;
                    break;
                }
                case 59: {
                    n5 = 18;
                    break;
                }
                case 60: {
                    n5 = 24;
                    break;
                }
                case 61: {
                    n5 = 203;
                    break;
                }
                case 62: {
                    n5 = 217;
                    break;
                }
                case 63: {
                    n5 = 93;
                    break;
                }
                case 64: {
                    n5 = 214;
                    break;
                }
                case 65: {
                    n5 = 34;
                    break;
                }
                case 66: {
                    n5 = 211;
                    break;
                }
                case 67: {
                    n5 = 255;
                    break;
                }
                case 68: {
                    n5 = 200;
                    break;
                }
                case 69: {
                    n5 = 149;
                    break;
                }
                case 70: {
                    n5 = 111;
                    break;
                }
                case 71: {
                    n5 = 157;
                    break;
                }
                case 72: {
                    n5 = 244;
                    break;
                }
                case 73: {
                    n5 = 220;
                    break;
                }
                case 74: {
                    n5 = 37;
                    break;
                }
                case 75: {
                    n5 = 20;
                    break;
                }
                case 76: {
                    n5 = 103;
                    break;
                }
                case 77: {
                    n5 = 56;
                    break;
                }
                case 78: {
                    n5 = 19;
                    break;
                }
                case 79: {
                    n5 = 16;
                    break;
                }
                case 80: {
                    n5 = 123;
                    break;
                }
                case 81: {
                    n5 = 245;
                    break;
                }
                case 82: {
                    n5 = 110;
                    break;
                }
                case 83: {
                    n5 = 177;
                    break;
                }
                case 84: {
                    n5 = 105;
                    break;
                }
                case 85: {
                    n5 = 168;
                    break;
                }
                case 86: {
                    n5 = 209;
                    break;
                }
                case 87: {
                    n5 = 125;
                    break;
                }
                case 88: {
                    n5 = 206;
                    break;
                }
                case 89: {
                    n5 = 173;
                    break;
                }
                case 90: {
                    n5 = 215;
                    break;
                }
                case 91: {
                    n5 = 100;
                    break;
                }
                case 92: {
                    n5 = 163;
                    break;
                }
                case 93: {
                    n5 = 38;
                    break;
                }
                case 94: {
                    n5 = 155;
                    break;
                }
                case 95: {
                    n5 = 62;
                    break;
                }
                case 96: {
                    n5 = 47;
                    break;
                }
                case 97: {
                    n5 = 159;
                    break;
                }
                case 98: {
                    n5 = 129;
                    break;
                }
                case 99: {
                    n5 = 162;
                    break;
                }
                case 100: {
                    n5 = 224;
                    break;
                }
                case 101: {
                    n5 = 218;
                    break;
                }
                case 102: {
                    n5 = 54;
                    break;
                }
                case 103: {
                    n5 = 80;
                    break;
                }
                case 104: {
                    n5 = 223;
                    break;
                }
                case 105: {
                    n5 = 160;
                    break;
                }
                case 106: {
                    n5 = 22;
                    break;
                }
                case 107: {
                    n5 = 250;
                    break;
                }
                case 108: {
                    n5 = 167;
                    break;
                }
                case 109: {
                    n5 = 78;
                    break;
                }
                case 110: {
                    n5 = 104;
                    break;
                }
                case 111: {
                    n5 = 239;
                    break;
                }
                case 112: {
                    n5 = 77;
                    break;
                }
                case 113: {
                    n5 = 240;
                    break;
                }
                case 114: {
                    n5 = 51;
                    break;
                }
                case 115: {
                    n5 = 151;
                    break;
                }
                case 116: {
                    n5 = 4;
                    break;
                }
                case 117: {
                    n5 = 9;
                    break;
                }
                case 118: {
                    n5 = 164;
                    break;
                }
                case 119: {
                    n5 = 58;
                    break;
                }
                case 120: {
                    n5 = 13;
                    break;
                }
                case 121: {
                    n5 = 207;
                    break;
                }
                case 122: {
                    n5 = 91;
                    break;
                }
                case 123: {
                    n5 = 74;
                    break;
                }
                case 124: {
                    n5 = 85;
                    break;
                }
                case 125: {
                    n5 = 153;
                    break;
                }
                case 126: {
                    n5 = 201;
                    break;
                }
                case 127: {
                    n5 = 247;
                    break;
                }
                case 128: {
                    n5 = 90;
                    break;
                }
                case 129: {
                    n5 = 126;
                    break;
                }
                case 130: {
                    n5 = 83;
                    break;
                }
                case 131: {
                    n5 = 101;
                    break;
                }
                case 132: {
                    n5 = 202;
                    break;
                }
                case 133: {
                    n5 = 246;
                    break;
                }
                case 134: {
                    n5 = 109;
                    break;
                }
                case 135: {
                    n5 = 208;
                    break;
                }
                case 136: {
                    n5 = 174;
                    break;
                }
                case 137: {
                    n5 = 36;
                    break;
                }
                case 138: {
                    n5 = 222;
                    break;
                }
                case 139: {
                    n5 = 221;
                    break;
                }
                case 140: {
                    n5 = 248;
                    break;
                }
                case 141: {
                    n5 = 6;
                    break;
                }
                case 142: {
                    n5 = 17;
                    break;
                }
                case 143: {
                    n5 = 108;
                    break;
                }
                case 144: {
                    n5 = 97;
                    break;
                }
                case 145: {
                    n5 = 3;
                    break;
                }
                case 146: {
                    n5 = 186;
                    break;
                }
                case 147: {
                    n5 = 7;
                    break;
                }
                case 148: {
                    n5 = 72;
                    break;
                }
                case 149: {
                    n5 = 188;
                    break;
                }
                case 150: {
                    n5 = 130;
                    break;
                }
                case 151: {
                    n5 = 136;
                    break;
                }
                case 152: {
                    n5 = 152;
                    break;
                }
                case 153: {
                    n5 = 61;
                    break;
                }
                case 154: {
                    n5 = 57;
                    break;
                }
                case 155: {
                    n5 = 52;
                    break;
                }
                case 156: {
                    n5 = 241;
                    break;
                }
                case 157: {
                    n5 = 121;
                    break;
                }
                case 158: {
                    n5 = 238;
                    break;
                }
                case 159: {
                    n5 = 43;
                    break;
                }
                case 160: {
                    n5 = 148;
                    break;
                }
                case 161: {
                    n5 = 71;
                    break;
                }
                case 162: {
                    n5 = 145;
                    break;
                }
                case 163: {
                    n5 = 144;
                    break;
                }
                case 164: {
                    n5 = 89;
                    break;
                }
                case 165: {
                    n5 = 21;
                    break;
                }
                case 166: {
                    n5 = 216;
                    break;
                }
                case 167: {
                    n5 = 229;
                    break;
                }
                case 168: {
                    n5 = 115;
                    break;
                }
                case 169: {
                    n5 = 213;
                    break;
                }
                case 170: {
                    n5 = 204;
                    break;
                }
                case 171: {
                    n5 = 119;
                    break;
                }
                case 172: {
                    n5 = 98;
                    break;
                }
                case 173: {
                    n5 = 15;
                    break;
                }
                case 174: {
                    n5 = 236;
                    break;
                }
                case 175: {
                    n5 = 122;
                    break;
                }
                case 176: {
                    n5 = 12;
                    break;
                }
                case 177: {
                    n5 = 199;
                    break;
                }
                case 178: {
                    n5 = 178;
                    break;
                }
                case 179: {
                    n5 = 150;
                    break;
                }
                case 180: {
                    n5 = 227;
                    break;
                }
                case 181: {
                    n5 = 29;
                    break;
                }
                case 182: {
                    n5 = 120;
                    break;
                }
                case 183: {
                    n5 = 75;
                    break;
                }
                case 184: {
                    n5 = 128;
                    break;
                }
                case 185: {
                    n5 = 210;
                    break;
                }
                case 186: {
                    n5 = 60;
                    break;
                }
                case 187: {
                    n5 = 131;
                    break;
                }
                case 188: {
                    n5 = 31;
                    break;
                }
                case 189: {
                    n5 = 253;
                    break;
                }
                case 190: {
                    n5 = 67;
                    break;
                }
                case 191: {
                    n5 = 42;
                    break;
                }
                case 192: {
                    n5 = 254;
                    break;
                }
                case 193: {
                    n5 = 95;
                    break;
                }
                case 194: {
                    n5 = 243;
                    break;
                }
                case 195: {
                    n5 = 8;
                    break;
                }
                case 196: {
                    n5 = 191;
                    break;
                }
                case 197: {
                    n5 = 189;
                    break;
                }
                case 198: {
                    n5 = 88;
                    break;
                }
                case 199: {
                    n5 = 140;
                    break;
                }
                case 200: {
                    n5 = 106;
                    break;
                }
                case 201: {
                    n5 = 92;
                    break;
                }
                case 202: {
                    n5 = 76;
                    break;
                }
                case 203: {
                    n5 = 44;
                    break;
                }
                case 204: {
                    n5 = 63;
                    break;
                }
                case 205: {
                    n5 = 139;
                    break;
                }
                case 206: {
                    n5 = 86;
                    break;
                }
                case 207: {
                    n5 = 14;
                    break;
                }
                case 208: {
                    n5 = 137;
                    break;
                }
                case 209: {
                    n5 = 237;
                    break;
                }
                case 210: {
                    n5 = 39;
                    break;
                }
                case 211: {
                    n5 = 170;
                    break;
                }
                case 212: {
                    n5 = 161;
                    break;
                }
                case 213: {
                    n5 = 53;
                    break;
                }
                case 214: {
                    n5 = 226;
                    break;
                }
                case 215: {
                    n5 = 46;
                    break;
                }
                case 216: {
                    n5 = 175;
                    break;
                }
                case 217: {
                    n5 = 234;
                    break;
                }
                case 218: {
                    n5 = 11;
                    break;
                }
                case 219: {
                    n5 = 235;
                    break;
                }
                case 220: {
                    n5 = 192;
                    break;
                }
                case 221: {
                    n5 = 118;
                    break;
                }
                case 222: {
                    n5 = 141;
                    break;
                }
                case 223: {
                    n5 = 182;
                    break;
                }
                case 224: {
                    n5 = 183;
                    break;
                }
                case 225: {
                    n5 = 133;
                    break;
                }
                case 226: {
                    n5 = 134;
                    break;
                }
                case 227: {
                    n5 = 113;
                    break;
                }
                case 228: {
                    n5 = 180;
                    break;
                }
                case 229: {
                    n5 = 87;
                    break;
                }
                case 230: {
                    n5 = 165;
                    break;
                }
                case 231: {
                    n5 = 169;
                    break;
                }
                case 232: {
                    n5 = 28;
                    break;
                }
                case 233: {
                    n5 = 252;
                    break;
                }
                case 234: {
                    n5 = 251;
                    break;
                }
                case 235: {
                    n5 = 1;
                    break;
                }
                case 236: {
                    n5 = 114;
                    break;
                }
                case 237: {
                    n5 = 10;
                    break;
                }
                case 238: {
                    n5 = 132;
                    break;
                }
                case 239: {
                    n5 = 212;
                    break;
                }
                case 240: {
                    n5 = 25;
                    break;
                }
                case 241: {
                    n5 = 232;
                    break;
                }
                case 242: {
                    n5 = 171;
                    break;
                }
                case 243: {
                    n5 = 68;
                    break;
                }
                case 244: {
                    n5 = 35;
                    break;
                }
                case 245: {
                    n5 = 197;
                    break;
                }
                case 246: {
                    n5 = 147;
                    break;
                }
                case 247: {
                    n5 = 142;
                    break;
                }
                case 248: {
                    n5 = 0;
                    break;
                }
                case 249: {
                    n5 = 5;
                    break;
                }
                case 250: {
                    n5 = 219;
                    break;
                }
                case 251: {
                    n5 = 181;
                    break;
                }
                case 252: {
                    n5 = 48;
                    break;
                }
                case 253: {
                    n5 = 55;
                    break;
                }
                case 254: {
                    n5 = 143;
                    break;
                }
                default: {
                    n5 = 59;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            FileUtils.b[n3] = new String(cArray).intern();
        }
        return b[n3];
    }
}

