/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import com.samsarasoftware.license.licenses.ProductLicense;
import com.samsarasoftware.license.ui.UIFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.ThreadMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE;
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int POSIX_UNIX = 3;
    private static final int OS;
    private static final String DF;
    private static final String[] a;
    private static final String[] b;

    @Deprecated
    public static long freeSpace(String string) throws IOException {
        return INSTANCE.freeSpaceOS(string, OS, false, -1L);
    }

    public static long freeSpaceKb(String string) throws IOException {
        return FileSystemUtils.freeSpaceKb(string, -1L);
    }

    public static long freeSpaceKb(String string, long l) throws IOException {
        return INSTANCE.freeSpaceOS(string, OS, true, l);
    }

    public static long freeSpaceKb() throws IOException {
        return FileSystemUtils.freeSpaceKb(-1L);
    }

    public static long freeSpaceKb(long l) throws IOException {
        return FileSystemUtils.freeSpaceKb(new File(".").getAbsolutePath(), l);
    }

    /*
     * Unable to fully structure code
     */
    long freeSpaceOS(String var1_1, int var2_2, boolean var3_3, long var4_4) throws IOException {
        var6_5 = UIFactory.b;
        if (var1_1 == null) {
            throw new IllegalArgumentException(FileSystemUtils.a(23308, -32079));
        }
        v1 = var2_2;
        if (!var6_5 && !var6_5) {
        }
        ** GOTO lbl22
        {
            ** switch (v1)
        }
lbl-1000:
        // 1 sources

        {
            case 1: {
                v1 = (int)var3_3;
lbl22:
                // 3 sources

                if (v1 != 0) {
                    v4 = this;
                    v5 = var1_1;
                    v6 = var4_4;
                }
                ** GOTO lbl33
                while (true) {
                    v8 = v4.freeSpaceWindows(v5, v6) / 1024L;
                    ** GOTO lbl38
                    break;
                }
lbl33:
                // 1 sources

                v4 = this;
                v5 = var1_1;
                v6 = var4_4;
                if (var6_5) ** continue;
                v8 = v4.freeSpaceWindows(v5, v6);
lbl38:
                // 2 sources

                return v8;
            }
lbl39:
            // 1 sources

            case 2: {
                return this.freeSpaceUnix(var1_1, var3_3, false, var4_4);
            }
lbl41:
            // 1 sources

            case 3: {
                return this.freeSpaceUnix(var1_1, var3_3, true, var4_4);
            }
lbl43:
            // 1 sources

            case 0: {
                throw new IllegalStateException(FileSystemUtils.a(23353, -25465));
            }
        }
lbl45:
        // 1 sources

        throw new IllegalStateException(FileSystemUtils.a(23324, 28882));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long freeSpaceWindows(String string, long l) throws IOException {
        int n;
        List<String> list;
        string = FilenameUtils.normalize(string, false);
        boolean bl = UIFactory.b;
        int n2 = string.length();
        boolean bl2 = true;
        do {
            block14: {
                block15: {
                    String string2;
                    block16: {
                        block13: {
                            if (!bl2 || (bl2 = false)) break block13;
                            if (bl) break block14;
                            if (n2 <= 0) break block15;
                            string2 = string;
                            if (bl) break block16;
                            n2 = string2.charAt(0);
                        }
                        if (bl) break block14;
                        if (n2 == 34) break block15;
                        string2 = "\"" + string + "\"";
                    }
                    string = string2;
                }
                n2 = 3;
            }
            String[] stringArray = new String[n2];
            stringArray[0] = FileSystemUtils.a(23312, 1072);
            stringArray[1] = FileSystemUtils.a(23314, 7732);
            stringArray[2] = FileSystemUtils.a(23302, 20352) + string;
            String[] stringArray2 = stringArray;
            list = this.performCommand(stringArray2, Integer.MAX_VALUE, l);
            n = list.size() - 1;
        } while (bl);
        int n3 = n;
        while (n3 >= 0) {
            String string3 = list.get(n3);
            if (!bl) {
                if (string3.length() > 0) {
                    return this.parseDir(string3, string);
                }
                --n3;
            }
            if (!bl) continue;
        }
        throw new IOException(FileSystemUtils.a(23327, -30171) + string + "'");
    }

    /*
     * Unable to fully structure code
     */
    long parseDir(String var1_1, String var2_2) throws IOException {
        block43: {
            var4_3 = 0;
            var5_4 = 0;
            var3_5 = UIFactory.b;
            var6_6 = var1_1.length() - 1;
            block30: while (var6_6 >= 0) {
                var7_7 = var1_1.charAt(var6_6);
                if (var3_5) ** GOTO lbl25
                v0 = (int)Character.isDigit((char)var7_7);
                if (!var3_5) {
                }
                ** GOTO lbl28
                if (v0 != 0) {
                }
                ** GOTO lbl-1000
                var5_4 = var6_6 + 1;
                while (var3_5) lbl-1000:
                // 2 sources

                {
                    --var6_6;
                    if (var3_5) continue;
lbl25:
                    // 2 sources

                    if (!var3_5) continue block30;
                }
                break block30;
            }
            block32: while (true) {
                block46: {
                    block45: {
                        block44: {
                            v0 = var6_6;
lbl28:
                            // 2 sources

                            if (v0 < 0) break;
                            var7_7 = var1_1.charAt(var6_6);
                            if (var3_5) continue;
                            v3 = (int)Character.isDigit((char)var7_7);
                            if (var3_5) break block43;
                            if (var3_5) break block44;
                            if (v3 == 0) {
                            }
                            ** GOTO lbl-1000
                            v7 = var7_7;
                        }
                        v8 = 44;
                        if (var3_5 || var3_5) break block45;
                        if (v7 != v8) {
                        }
                        ** GOTO lbl-1000
                        v7 = var7_7;
                        v8 = 46;
                    }
                    if (var3_5) break block46;
                    if (v7 != v8) {
                    }
                    ** GOTO lbl-1000
                    v7 = var6_6;
                    v8 = 1;
                }
                var4_3 = v7 + v8;
                while (var3_5) lbl-1000:
                // 4 sources

                {
                    --var6_6;
                    if (var3_5) continue;
                    if (!var3_5) continue block32;
                }
                break;
            }
            v3 = var6_6;
        }
        if (v3 < 0) {
            throw new IOException(FileSystemUtils.a(23303, -18855) + var2_2 + "'");
        }
        var7_8 = new StringBuilder(var1_1.substring(var4_3, var5_4));
        block34: for (var8_9 = 0; var8_9 < var7_8.length(); ++var8_9) {
            v15 = var7_8;
            v16 = var8_9;
            if (var3_5) ** GOTO lbl127
            if (v15.charAt(v16) != ',') {
            }
            ** GOTO lbl122
            v15 = var7_8;
            do {
                block47: {
                    v16 = var8_9;
                    if (var3_5) break block47;
                    if (var3_5) break block47;
                    if (v15.charAt(v16) != '.') continue block34;
lbl122:
                    // 2 sources

                    v15 = var7_8;
                    v16 = var8_9--;
                }
                v15.deleteCharAt(v16);
            } while (var3_5);
            if (!var3_5) continue;
        }
        return this.parseBytes(var7_8.toString(), var2_2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long freeSpaceUnix(String var1_1, boolean var2_2, boolean var3_3, long var4_4) throws IOException {
        block27: {
            block35: {
                block31: {
                    block34: {
                        block33: {
                            block32: {
                                block29: {
                                    block30: {
                                        block28: {
                                            var6_5 = UIFactory.b;
                                            v0 = var1_1;
                                            if (!var6_5) {
                                                if (v0.length() == 0) {
                                                    throw new IllegalArgumentException(FileSystemUtils.a(23308, -32079));
                                                }
                                                v0 = "-";
                                            }
                                            var7_6 = v0;
                                            v1 = var2_2;
                                            if (!var6_5) {
                                                if (v1 != 0) {
                                                    var7_6 = var7_6 + "k";
                                                }
                                                v1 = (int)var3_3;
                                            }
                                            if (var6_5) break block28;
                                            if (v1 == 0) ** GOTO lbl18
                                            v2 = var7_6 + "P";
                                            do {
                                                var7_6 = v2;
lbl18:
                                                // 2 sources

                                                v2 = var7_6;
                                            } while (var6_5);
                                            v1 = v2.length();
                                        }
                                        if (var6_5) break block29;
                                        if (v1 <= 1) break block30;
                                        v3 = new String[3];
                                        v3[0] = FileSystemUtils.DF;
                                        v3[1] = var7_6;
                                        v4 = v3;
                                        v5 = v3;
                                        v6 = 2;
                                        v7 = var1_1;
                                        ** GOTO lbl-1000
                                    }
                                    v1 = 2;
                                }
                                v8 = new String[v1];
                                v8[0] = FileSystemUtils.DF;
                                v4 = v8;
                                v5 = v8;
                                v6 = 1;
                                v7 = var1_1;
                                if (!var6_5) {
                                    v4[v6] = v7;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v4[v6] = v7;
                                }
                                var8_7 = v5;
                                var9_8 = this.performCommand(var8_7, 3, var4_4);
                                v9 = var9_8;
                                if (!var6_5) {
                                    if (v9.size() < 2) {
                                        throw new IOException(FileSystemUtils.a(23316, 23125) + FileSystemUtils.DF + FileSystemUtils.a(23325, 1793) + FileSystemUtils.a(23299, 29535) + var1_1 + FileSystemUtils.a(23313, -8377) + var9_8);
                                    }
                                    v9 = var9_8.get(1);
                                }
                                var10_9 = (String)v9;
                                v10 = var11_10 = new StringTokenizer(var10_9, " ");
                                if (var6_5) break block31;
                                if (v10.countTokens() >= 4) break block32;
                                v10 = var11_10;
                                break block33;
                            }
                            v10 = var11_10;
                            if (!var6_5) break block31;
                        }
                        v11 = v10.countTokens();
                        v12 = 1;
                        if (var6_5 || var6_5) break block34;
                        if (v11 != v12) ** GOTO lbl83
                        v13 = var9_8;
                        if (var6_5) break block35;
                        v11 = v13.size();
                        v12 = 3;
                    }
                    if (v11 < v12) ** GOTO lbl83
                    v13 = var9_8.get(2);
                    break block35;
                }
                v10.nextToken();
                break block27;
            }
            do {
                var12_11 = (String)v13;
                var11_10 = new StringTokenizer(var12_11, " ");
                if (!var6_5) break block27;
lbl83:
                // 3 sources

                v13 = new IOException(FileSystemUtils.a(23316, 23125) + FileSystemUtils.DF + FileSystemUtils.a(23320, 29800) + FileSystemUtils.a(23299, 29535) + var1_1 + FileSystemUtils.a(23323, -2033));
            } while (var6_5);
            throw v13;
        }
        var11_10.nextToken();
        var11_10.nextToken();
        var12_11 = var11_10.nextToken();
        return this.parseBytes(var12_11, var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long parseBytes(String string, String string2) throws IOException {
        boolean bl = UIFactory.b;
        try {
            long l2;
            long l = l2 = Long.parseLong(string);
            if (!bl) {
                if (l < 0L) {
                    throw new IOException(FileSystemUtils.a(23316, 23125) + DF + FileSystemUtils.a(23352, -8106) + FileSystemUtils.a(23299, 29535) + string2 + FileSystemUtils.a(23323, -2033));
                }
                l = l2;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOExceptionWithCause(FileSystemUtils.a(23316, 23125) + DF + FileSystemUtils.a(23306, -7614) + FileSystemUtils.a(23299, 29535) + string2 + FileSystemUtils.a(23323, -2033), numberFormatException);
        }
    }

    /*
     * Unable to fully structure code
     */
    List<String> performCommand(String[] var1_1, int var2_2, long var3_3) throws IOException {
        block37: {
            block39: {
                block38: {
                    block45: {
                        block36: {
                            block35: {
                                block44: {
                                    block34: {
                                        block32: {
                                            block33: {
                                                block43: {
                                                    var6_4 = new ArrayList<String>(20);
                                                    var7_5 = null;
                                                    var5_6 = UIFactory.b;
                                                    var8_7 = null;
                                                    var9_8 = null;
                                                    var10_9 = null;
                                                    var11_10 = null;
                                                    var12_11 = ThreadMonitor.start(var3_3);
                                                    var7_5 = this.openProcess(var1_1);
                                                    var8_7 = var7_5.getInputStream();
                                                    var9_8 = var7_5.getOutputStream();
                                                    var10_9 = var7_5.getErrorStream();
                                                    var11_10 = new BufferedReader(new InputStreamReader(var8_7));
                                                    var13_13 = var11_10.readLine();
                                                    block28: while (var13_13 != null) {
                                                        block42: {
                                                            v0 = var6_4.size();
                                                            if (var5_6) ** GOTO lbl40
                                                            if (var5_6) break;
                                                            break block42;
                                                            catch (InterruptedException v1) {
                                                                throw v1;
                                                            }
                                                        }
                                                        if (v0 < var2_2) {
                                                        }
                                                        ** GOTO lbl36
                                                        var13_13 = var13_13.toLowerCase(Locale.ENGLISH).trim();
                                                        v0 = (int)var6_4.add(var13_13);
                                                        do {
                                                            var13_13 = var11_10.readLine();
                                                            if (!var5_6) continue block28;
lbl36:
                                                            // 3 sources

                                                            var7_5.waitFor();
                                                            ThreadMonitor.stop(var12_11);
                                                            v0 = var7_5.exitValue();
lbl40:
                                                            // 2 sources

                                                        } while (var5_6);
                                                    }
                                                    if (var5_6) break block32;
                                                    if (v0 == 0) break block33;
                                                    break block43;
                                                    catch (InterruptedException v3) {
                                                        throw v3;
                                                    }
                                                }
                                                throw new IOException(FileSystemUtils.a(23296, 7126) + var7_5.exitValue() + FileSystemUtils.a(23359, -17413) + Arrays.asList(var1_1));
                                            }
                                            v5 = var6_4;
                                            if (var5_6) break block34;
                                            v6 = v5.isEmpty();
                                        }
                                        if (v6) {
                                            throw new IOException(FileSystemUtils.a(23321, -29752) + Arrays.asList(var1_1));
                                        }
                                        v5 = var6_4;
                                    }
                                    var14_14 = v5;
                                    IOUtils.closeQuietly(var8_7);
                                    IOUtils.closeQuietly(var9_8);
                                    IOUtils.closeQuietly(var10_9);
                                    IOUtils.closeQuietly(var11_10);
                                    v9 = var7_5;
                                    if (var5_6) break block35;
                                    if (var5_6) break block35;
                                    break block44;
                                    catch (InterruptedException v10) {
                                        throw v10;
                                    }
                                }
                                if (v9 == null) break block36;
                                v9 = var7_5;
                            }
                            v9.destroy();
                        }
                        v12 = var14_14;
                        if (!ProductLicense.b) break block37;
                        if (!var5_6) break block38;
                        break block45;
                        catch (InterruptedException v13) {
                            throw v13;
                        }
                    }
                    v14 = false;
                    break block39;
                }
                v14 = true;
            }
            UIFactory.b = v14;
        }
        return v12;
        catch (InterruptedException var12_12) {
            try {
                throw new IOExceptionWithCause(FileSystemUtils.a(23307, 22621) + Arrays.asList(var1_1) + FileSystemUtils.a(23356, 28453) + var3_3, var12_12);
            }
            catch (Throwable var15_15) {
                block41: {
                    block40: {
                        IOUtils.closeQuietly(var8_7);
                        IOUtils.closeQuietly(var9_8);
                        IOUtils.closeQuietly(var10_9);
                        IOUtils.closeQuietly(var11_10);
                        v16 = var7_5;
                        if (var5_6 || var5_6) break block40;
                        if (v16 == null) break block41;
                        v16 = var7_5;
                    }
                    v16.destroy();
                }
                throw var15_15;
            }
        }
    }

    Process openProcess(String[] stringArray) throws IOException {
        return Runtime.getRuntime().exec(stringArray);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        int n;
        block43: {
            int n2;
            Object var6_6;
            String[] stringArray = new String[38];
            int n3 = 0;
            String string2 = "*\u0092\u00ca\u00ec1$\u00be\u00fc{<\u0003\u00d5\u001e\u001f\u009d\u009a\u00f7r\u00a5\u00b60\u00d2G\u001a\u00d8\u00f8\u00974J\u00aee\u00b4\u0098\u0011x\u009bn~\u00c9\u0090\u0019\t\u00ed$Du\u00f1\u0088\u00c9k\"\u0007aF\u00cdS\u00d9c\u009d=\u0010\u0083T<\u00b9\u00e2\u0004A\u00e6u\u00fa\u00ed8\u00d8Q\u00daE\u0003\u009e\u009fHO\u00cf`\u0014\u0006{\u00fc\u00cbb\u00ce\u00fa9\u00e5\u0013\u00fb!\u00c9\u008e\u009f\u00bf\u00f1\u00bb\u001dA$I)\u0005\u00beh\u00d3\u0000\\B\"\u00ee\u00a5F\u00d4\u00c1<i$\t\u00d2mi\u00c8\u001e\u0004\u00ad\u00dd\u0085\u00b7b:o'p\u0004\u00ca\u00b5}\u00fbFb\u00e9\u0019\u0092\"B6\u00ee'F\u0084\u00c16ie\t\u00faml\u00c8\u00be\u0004\u00bc\u00d2\u000f\u00f9\u00d6\u0095\u008cs\u00fe6\u00e99\u00a6\u009b\u0012\u00fa\u00af1?\u00b7\u00a0\u00b5\u00a2\u001c\u00f2\u00ed\\\u00f1\u00a8\b\u0092#\u00f2n;\u00e7;/J\u0080\u008eY\u00c1\u00b4\u0089\u0005\u001el\u00f6\u00a2\u00f6\u001asbb\u00a9\u00ab\u00fa\u00d3\u008f\u00dc\u0015u\u00af\u0017\u00d8\u00ee\u0006\u00a3\u00f8\u0006H\u001bZ\u0016Q%\u00c8\u00e3B\u0012\u00c1\r\u0091\u00d6\u00db\u00c7Z\u00ad\u00aad0KT\u00b9!_\u000e\rK\u00e6*j\u00ef\u00eb\u0093\u007f>\u00cc\u00f1\u001e_\u0010\u009f%K\u00a1Lt\u00bcs[\u00cb\u0017\u00cd\u00a6]\u00fe\u0081\u0005\u0085\u008d>,\u000b\u0005\u00b7(\u00bf\u00a2\u0010\u0007\u00d5\u0090\u00d0P\u0080\u009d3\u0010~\u00ab-#\u00f3/Hz\u009f\u00bf\u0099\u00dd\u0089q6\u00c5\u0002\u0089\u00b4\b\u00f3+\u00dc\u00a4\u00ec\u00c7\u00b0p\u0016$C\u00ab\u00e1\u00b80\u00c9X\u00107:\u00ba\u0094z\u00e7\u0088\u00f3\u0011 \u009f?\u0019\u0007\u0010\u008a\u00af\u008eh\u001b\u00aa\u0011\u00ff\u00e2R\u0083\u00d7\u00ba]Z\u008a\u0001*\u0095\u00ddv\u0089\u00a4\u008f\u0002&+\u0007\u00dd\u0096u'\u0012Z\u0087\u0007\u00c3\u009e\b\u009c\u0085\u00b3p*)\u00e9\u0083\u00dc\u00eb\u00fbt\u00d9\u00df\u0098\u00dfE\u00b7\u009b\u0093@oi\u00ab\u00e7D\u00a3\u00ae*\u001d9\u00e24\u009d\u00da\u009e\u00a0\u00a9h\u00e6YH7\u0018\u009b\u0099\u00157V\u0018\u008d@\u0007\u00a2F:\u00ca\u000bzW\u00c8\u00d8\u00b8\u0015\u0016E<TB\n$\n<\u0090\u000b&\u00c5\u000e\u0016vKFv\u00abZ\u000bZa\u00da\u0089\u0014r\u00c8:\u00ac\u001cQ\fC!j\u001a\u00ca\u0007\u00c6\u00ad.9\u001e\u00bc\u00bd\f\u00f19\u00b0\u00a6\u00fe\u00f5\u00c6>\u00ca\u008cG]\u000b+\u0090\u00fe\u00da\u00db\u001a\u001e\u00ccL1\u008d;X\u00f0L]?\u0001AN*\u0085f\u0086K\u00b1\u00c4\u001a\u0003\u008bd|\u00aa\u00cd\u00fc\u001f~x\u00af\u0006S\u0091\u00c9\u0016o\u008e\u00de\u00b4\u00e8\u008bd#\\\u00cf\u00e3\u001b\u00fc\u0085\u00aaxP\u0006\u00c7\u0019\u00f6x\u009f\u008a;\r$%-+\u00e2&\u00ean\u00fb\u00a3}8\u008c1\u0016\u0012n\u008cp\u00b5\u00ac\u00eb\u00ddy\u009aYy`}8\u0011\u00cf\u0081\nl.\u00e5\u00e0\u00d4\u0004bs`\u0086\u0005\u0000[rs\u0089\n\u0096\u008c\u000b\u009f:\u00b2\u00c2\u009e\u0004\u0090\t\u00a5L\u00f8\u00b2)\u00fd\u0016\u00a4\u00a2\u0004\u0012\u009f\u00f1\u0084\u0003\u00ca\u0004m\u000e\u0093\u00b3\u00d6\u0091\u0015\u0094r4\u00aahX\u00b4&\u009a";
            int n4 = "*\u0092\u00ca\u00ec1$\u00be\u00fc{<\u0003\u00d5\u001e\u001f\u009d\u009a\u00f7r\u00a5\u00b60\u00d2G\u001a\u00d8\u00f8\u00974J\u00aee\u00b4\u0098\u0011x\u009bn~\u00c9\u0090\u0019\t\u00ed$Du\u00f1\u0088\u00c9k\"\u0007aF\u00cdS\u00d9c\u009d=\u0010\u0083T<\u00b9\u00e2\u0004A\u00e6u\u00fa\u00ed8\u00d8Q\u00daE\u0003\u009e\u009fHO\u00cf`\u0014\u0006{\u00fc\u00cbb\u00ce\u00fa9\u00e5\u0013\u00fb!\u00c9\u008e\u009f\u00bf\u00f1\u00bb\u001dA$I)\u0005\u00beh\u00d3\u0000\\B\"\u00ee\u00a5F\u00d4\u00c1<i$\t\u00d2mi\u00c8\u001e\u0004\u00ad\u00dd\u0085\u00b7b:o'p\u0004\u00ca\u00b5}\u00fbFb\u00e9\u0019\u0092\"B6\u00ee'F\u0084\u00c16ie\t\u00faml\u00c8\u00be\u0004\u00bc\u00d2\u000f\u00f9\u00d6\u0095\u008cs\u00fe6\u00e99\u00a6\u009b\u0012\u00fa\u00af1?\u00b7\u00a0\u00b5\u00a2\u001c\u00f2\u00ed\\\u00f1\u00a8\b\u0092#\u00f2n;\u00e7;/J\u0080\u008eY\u00c1\u00b4\u0089\u0005\u001el\u00f6\u00a2\u00f6\u001asbb\u00a9\u00ab\u00fa\u00d3\u008f\u00dc\u0015u\u00af\u0017\u00d8\u00ee\u0006\u00a3\u00f8\u0006H\u001bZ\u0016Q%\u00c8\u00e3B\u0012\u00c1\r\u0091\u00d6\u00db\u00c7Z\u00ad\u00aad0KT\u00b9!_\u000e\rK\u00e6*j\u00ef\u00eb\u0093\u007f>\u00cc\u00f1\u001e_\u0010\u009f%K\u00a1Lt\u00bcs[\u00cb\u0017\u00cd\u00a6]\u00fe\u0081\u0005\u0085\u008d>,\u000b\u0005\u00b7(\u00bf\u00a2\u0010\u0007\u00d5\u0090\u00d0P\u0080\u009d3\u0010~\u00ab-#\u00f3/Hz\u009f\u00bf\u0099\u00dd\u0089q6\u00c5\u0002\u0089\u00b4\b\u00f3+\u00dc\u00a4\u00ec\u00c7\u00b0p\u0016$C\u00ab\u00e1\u00b80\u00c9X\u00107:\u00ba\u0094z\u00e7\u0088\u00f3\u0011 \u009f?\u0019\u0007\u0010\u008a\u00af\u008eh\u001b\u00aa\u0011\u00ff\u00e2R\u0083\u00d7\u00ba]Z\u008a\u0001*\u0095\u00ddv\u0089\u00a4\u008f\u0002&+\u0007\u00dd\u0096u'\u0012Z\u0087\u0007\u00c3\u009e\b\u009c\u0085\u00b3p*)\u00e9\u0083\u00dc\u00eb\u00fbt\u00d9\u00df\u0098\u00dfE\u00b7\u009b\u0093@oi\u00ab\u00e7D\u00a3\u00ae*\u001d9\u00e24\u009d\u00da\u009e\u00a0\u00a9h\u00e6YH7\u0018\u009b\u0099\u00157V\u0018\u008d@\u0007\u00a2F:\u00ca\u000bzW\u00c8\u00d8\u00b8\u0015\u0016E<TB\n$\n<\u0090\u000b&\u00c5\u000e\u0016vKFv\u00abZ\u000bZa\u00da\u0089\u0014r\u00c8:\u00ac\u001cQ\fC!j\u001a\u00ca\u0007\u00c6\u00ad.9\u001e\u00bc\u00bd\f\u00f19\u00b0\u00a6\u00fe\u00f5\u00c6>\u00ca\u008cG]\u000b+\u0090\u00fe\u00da\u00db\u001a\u001e\u00ccL1\u008d;X\u00f0L]?\u0001AN*\u0085f\u0086K\u00b1\u00c4\u001a\u0003\u008bd|\u00aa\u00cd\u00fc\u001f~x\u00af\u0006S\u0091\u00c9\u0016o\u008e\u00de\u00b4\u00e8\u008bd#\\\u00cf\u00e3\u001b\u00fc\u0085\u00aaxP\u0006\u00c7\u0019\u00f6x\u009f\u008a;\r$%-+\u00e2&\u00ean\u00fb\u00a3}8\u008c1\u0016\u0012n\u008cp\u00b5\u00ac\u00eb\u00ddy\u009aYy`}8\u0011\u00cf\u0081\nl.\u00e5\u00e0\u00d4\u0004bs`\u0086\u0005\u0000[rs\u0089\n\u0096\u008c\u000b\u009f:\u00b2\u00c2\u009e\u0004\u0090\t\u00a5L\u00f8\u00b2)\u00fd\u0016\u00a4\u00a2\u0004\u0012\u009f\u00f1\u0084\u0003\u00ca\u0004m\u000e\u0093\u00b3\u00d6\u0091\u0015\u0094r4\u00aahX\u00b4&\u009a".length();
            int n5 = 50;
            int n6 = -1;
            while (true) {
                char[] cArray;
                block45: {
                    int n7;
                    int n8;
                    char[] cArray2;
                    block44: {
                        int n9 = ++n6;
                        var6_6 = null;
                        char[] cArray3 = string2.substring(n9, n9 + n5).toCharArray();
                        n2 = 0;
                        int n10 = cArray3.length;
                        cArray2 = cArray3;
                        n8 = n10;
                        if (n10 <= 1) break block44;
                        cArray = cArray2;
                        n7 = n8;
                        if (n8 <= n2) break block45;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n11 = n2;
                        while (true) {
                            int n12;
                            char c = cArray4[n11];
                            switch (n2 % 7) {
                                case 0: {
                                    n12 = 72;
                                    break;
                                }
                                case 1: {
                                    n12 = 47;
                                    break;
                                }
                                case 2: {
                                    n12 = 8;
                                    break;
                                }
                                case 3: {
                                    n12 = 73;
                                    break;
                                }
                                case 4: {
                                    n12 = 22;
                                    break;
                                }
                                case 5: {
                                    n12 = 45;
                                    break;
                                }
                                default: {
                                    n12 = 77;
                                }
                            }
                            cArray4[n11] = (char)(c ^ n12);
                            ++n2;
                            cArray2 = cArray5;
                            n8 = n8;
                            if (n8 != 0) break;
                            cArray5 = cArray2;
                            n7 = n8;
                            n11 = n8;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n7 = n8;
                    } while (n8 > n2);
                }
                stringArray[n3++] = new String(cArray).intern();
                if ((n6 += n5) >= n4) break;
                n5 = string2.charAt(n6);
            }
            string2 = "/\u00c5CY\u00f3Kw\u00cf\u00bfZ\u00c7\u00118\u008di\u00b9zT\u0001g\u0015UX\u00b6\u008f\u00eeU\u0018#T$i*[\u00daw\u001b\u00d2\u001cs\u00c2\u00e3\"\u0006\u00eb^\u009c\u00bb\u00cbE\u0087++o\u00efD\u0019\u00bb\u00b3\u00db\u0018\u0005_b\u00de0\u00c3";
            n4 = "/\u00c5CY\u00f3Kw\u00cf\u00bfZ\u00c7\u00118\u008di\u00b9zT\u0001g\u0015UX\u00b6\u008f\u00eeU\u0018#T$i*[\u00daw\u001b\u00d2\u001cs\u00c2\u00e3\"\u0006\u00eb^\u009c\u00bb\u00cbE\u0087++o\u00efD\u0019\u00bb\u00b3\u00db\u0018\u0005_b\u00de0\u00c3".length();
            n5 = 38;
            n6 = -1;
            while (true) {
                char[] cArray;
                block47: {
                    int n13;
                    int n14;
                    char[] cArray6;
                    block46: {
                        int n15 = ++n6;
                        var6_6 = null;
                        char[] cArray7 = string2.substring(n15, n15 + n5).toCharArray();
                        n2 = 0;
                        int n16 = cArray7.length;
                        cArray6 = cArray7;
                        n14 = n16;
                        if (n16 <= 1) break block46;
                        cArray = cArray6;
                        n13 = n14;
                        if (n14 <= n2) break block47;
                    }
                    do {
                        char[] cArray8 = cArray6;
                        char[] cArray9 = cArray6;
                        int n17 = n2;
                        while (true) {
                            int n18;
                            char c = cArray8[n17];
                            switch (n2 % 7) {
                                case 0: {
                                    n18 = 72;
                                    break;
                                }
                                case 1: {
                                    n18 = 47;
                                    break;
                                }
                                case 2: {
                                    n18 = 8;
                                    break;
                                }
                                case 3: {
                                    n18 = 73;
                                    break;
                                }
                                case 4: {
                                    n18 = 22;
                                    break;
                                }
                                case 5: {
                                    n18 = 45;
                                    break;
                                }
                                default: {
                                    n18 = 77;
                                }
                            }
                            cArray8[n17] = (char)(c ^ n18);
                            ++n2;
                            cArray6 = cArray9;
                            n14 = n14;
                            if (n14 != 0) break;
                            cArray9 = cArray6;
                            n13 = n14;
                            n17 = n14;
                            cArray8 = cArray6;
                        }
                        cArray = cArray6;
                        n13 = n14;
                    } while (n14 > n2);
                }
                stringArray[n3++] = new String(cArray).intern();
                if ((n6 += n5) >= n4) break;
                n5 = string2.charAt(n6);
            }
            a = stringArray;
            b = new String[38];
            INSTANCE = new FileSystemUtils();
            n = 0;
            string = FileSystemUtils.a(23311, -11911);
            try {
                String string3 = System.getProperty(FileSystemUtils.a(23309, 10634));
                if (string3 == null) {
                    throw new IOException(FileSystemUtils.a(23310, -7428));
                }
                if ((string3 = string3.toLowerCase(Locale.ENGLISH)).indexOf(FileSystemUtils.a(23300, -3327)) != -1) {
                    n = 1;
                    break block43;
                }
                if (string3.indexOf(FileSystemUtils.a(23318, -27799)) != -1 || string3.indexOf(FileSystemUtils.a(23326, 17406)) != -1 || string3.indexOf(FileSystemUtils.a(23304, -13839)) != -1 || string3.indexOf(FileSystemUtils.a(23297, -19512)) != -1 || string3.indexOf(FileSystemUtils.a(23301, 6776)) != -1 || string3.indexOf(FileSystemUtils.a(23357, 22954)) != -1 || string3.indexOf(FileSystemUtils.a(23315, -2457)) != -1) {
                    n = 2;
                    break block43;
                }
                if (string3.indexOf(FileSystemUtils.a(23322, 24148)) != -1 || string3.indexOf(FileSystemUtils.a(23298, -21531)) != -1 || string3.indexOf(FileSystemUtils.a(23305, 6708)) != -1) {
                    n = 3;
                    string = FileSystemUtils.a(23317, 30447);
                } else {
                    n = string3.indexOf(FileSystemUtils.a(23319, -17702)) != -1 || string3.indexOf(FileSystemUtils.a(23358, -11918)) != -1 ? 3 : 0;
                }
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        OS = n;
        DF = string;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x5B1C) & 0xFFFF;
        if (b[n3] == null) {
            int n4;
            int n5;
            char[] cArray = a[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 17;
                    break;
                }
                case 1: {
                    n5 = 94;
                    break;
                }
                case 2: {
                    n5 = 202;
                    break;
                }
                case 3: {
                    n5 = 30;
                    break;
                }
                case 4: {
                    n5 = 2;
                    break;
                }
                case 5: {
                    n5 = 136;
                    break;
                }
                case 6: {
                    n5 = 105;
                    break;
                }
                case 7: {
                    n5 = 223;
                    break;
                }
                case 8: {
                    n5 = 218;
                    break;
                }
                case 9: {
                    n5 = 76;
                    break;
                }
                case 10: {
                    n5 = 59;
                    break;
                }
                case 11: {
                    n5 = 57;
                    break;
                }
                case 12: {
                    n5 = 135;
                    break;
                }
                case 13: {
                    n5 = 241;
                    break;
                }
                case 14: {
                    n5 = 3;
                    break;
                }
                case 15: {
                    n5 = 10;
                    break;
                }
                case 16: {
                    n5 = 6;
                    break;
                }
                case 17: {
                    n5 = 184;
                    break;
                }
                case 18: {
                    n5 = 5;
                    break;
                }
                case 19: {
                    n5 = 107;
                    break;
                }
                case 20: {
                    n5 = 114;
                    break;
                }
                case 21: {
                    n5 = 158;
                    break;
                }
                case 22: {
                    n5 = 56;
                    break;
                }
                case 23: {
                    n5 = 216;
                    break;
                }
                case 24: {
                    n5 = 169;
                    break;
                }
                case 25: {
                    n5 = 209;
                    break;
                }
                case 26: {
                    n5 = 238;
                    break;
                }
                case 27: {
                    n5 = 29;
                    break;
                }
                case 28: {
                    n5 = 205;
                    break;
                }
                case 29: {
                    n5 = 180;
                    break;
                }
                case 30: {
                    n5 = 0;
                    break;
                }
                case 31: {
                    n5 = 203;
                    break;
                }
                case 32: {
                    n5 = 190;
                    break;
                }
                case 33: {
                    n5 = 122;
                    break;
                }
                case 34: {
                    n5 = 237;
                    break;
                }
                case 35: {
                    n5 = 211;
                    break;
                }
                case 36: {
                    n5 = 213;
                    break;
                }
                case 37: {
                    n5 = 144;
                    break;
                }
                case 38: {
                    n5 = 73;
                    break;
                }
                case 39: {
                    n5 = 228;
                    break;
                }
                case 40: {
                    n5 = 78;
                    break;
                }
                case 41: {
                    n5 = 235;
                    break;
                }
                case 42: {
                    n5 = 133;
                    break;
                }
                case 43: {
                    n5 = 13;
                    break;
                }
                case 44: {
                    n5 = 129;
                    break;
                }
                case 45: {
                    n5 = 124;
                    break;
                }
                case 46: {
                    n5 = 146;
                    break;
                }
                case 47: {
                    n5 = 40;
                    break;
                }
                case 48: {
                    n5 = 33;
                    break;
                }
                case 49: {
                    n5 = 72;
                    break;
                }
                case 50: {
                    n5 = 91;
                    break;
                }
                case 51: {
                    n5 = 160;
                    break;
                }
                case 52: {
                    n5 = 250;
                    break;
                }
                case 53: {
                    n5 = 149;
                    break;
                }
                case 54: {
                    n5 = 54;
                    break;
                }
                case 55: {
                    n5 = 42;
                    break;
                }
                case 56: {
                    n5 = 93;
                    break;
                }
                case 57: {
                    n5 = 198;
                    break;
                }
                case 58: {
                    n5 = 61;
                    break;
                }
                case 59: {
                    n5 = 25;
                    break;
                }
                case 60: {
                    n5 = 212;
                    break;
                }
                case 61: {
                    n5 = 215;
                    break;
                }
                case 62: {
                    n5 = 119;
                    break;
                }
                case 63: {
                    n5 = 104;
                    break;
                }
                case 64: {
                    n5 = 77;
                    break;
                }
                case 65: {
                    n5 = 186;
                    break;
                }
                case 66: {
                    n5 = 51;
                    break;
                }
                case 67: {
                    n5 = 197;
                    break;
                }
                case 68: {
                    n5 = 41;
                    break;
                }
                case 69: {
                    n5 = 79;
                    break;
                }
                case 70: {
                    n5 = 96;
                    break;
                }
                case 71: {
                    n5 = 110;
                    break;
                }
                case 72: {
                    n5 = 170;
                    break;
                }
                case 73: {
                    n5 = 240;
                    break;
                }
                case 74: {
                    n5 = 179;
                    break;
                }
                case 75: {
                    n5 = 154;
                    break;
                }
                case 76: {
                    n5 = 192;
                    break;
                }
                case 77: {
                    n5 = 103;
                    break;
                }
                case 78: {
                    n5 = 174;
                    break;
                }
                case 79: {
                    n5 = 153;
                    break;
                }
                case 80: {
                    n5 = 106;
                    break;
                }
                case 81: {
                    n5 = 32;
                    break;
                }
                case 82: {
                    n5 = 208;
                    break;
                }
                case 83: {
                    n5 = 65;
                    break;
                }
                case 84: {
                    n5 = 90;
                    break;
                }
                case 85: {
                    n5 = 147;
                    break;
                }
                case 86: {
                    n5 = 199;
                    break;
                }
                case 87: {
                    n5 = 141;
                    break;
                }
                case 88: {
                    n5 = 83;
                    break;
                }
                case 89: {
                    n5 = 28;
                    break;
                }
                case 90: {
                    n5 = 123;
                    break;
                }
                case 91: {
                    n5 = 131;
                    break;
                }
                case 92: {
                    n5 = 187;
                    break;
                }
                case 93: {
                    n5 = 20;
                    break;
                }
                case 94: {
                    n5 = 47;
                    break;
                }
                case 95: {
                    n5 = 63;
                    break;
                }
                case 96: {
                    n5 = 226;
                    break;
                }
                case 97: {
                    n5 = 252;
                    break;
                }
                case 98: {
                    n5 = 171;
                    break;
                }
                case 99: {
                    n5 = 121;
                    break;
                }
                case 100: {
                    n5 = 244;
                    break;
                }
                case 101: {
                    n5 = 176;
                    break;
                }
                case 102: {
                    n5 = 48;
                    break;
                }
                case 103: {
                    n5 = 22;
                    break;
                }
                case 104: {
                    n5 = 53;
                    break;
                }
                case 105: {
                    n5 = 120;
                    break;
                }
                case 106: {
                    n5 = 4;
                    break;
                }
                case 107: {
                    n5 = 229;
                    break;
                }
                case 108: {
                    n5 = 117;
                    break;
                }
                case 109: {
                    n5 = 82;
                    break;
                }
                case 110: {
                    n5 = 111;
                    break;
                }
                case 111: {
                    n5 = 243;
                    break;
                }
                case 112: {
                    n5 = 43;
                    break;
                }
                case 113: {
                    n5 = 27;
                    break;
                }
                case 114: {
                    n5 = 19;
                    break;
                }
                case 115: {
                    n5 = 217;
                    break;
                }
                case 116: {
                    n5 = 92;
                    break;
                }
                case 117: {
                    n5 = 52;
                    break;
                }
                case 118: {
                    n5 = 21;
                    break;
                }
                case 119: {
                    n5 = 148;
                    break;
                }
                case 120: {
                    n5 = 210;
                    break;
                }
                case 121: {
                    n5 = 35;
                    break;
                }
                case 122: {
                    n5 = 152;
                    break;
                }
                case 123: {
                    n5 = 26;
                    break;
                }
                case 124: {
                    n5 = 11;
                    break;
                }
                case 125: {
                    n5 = 23;
                    break;
                }
                case 126: {
                    n5 = 18;
                    break;
                }
                case 127: {
                    n5 = 71;
                    break;
                }
                case 128: {
                    n5 = 142;
                    break;
                }
                case 129: {
                    n5 = 182;
                    break;
                }
                case 130: {
                    n5 = 143;
                    break;
                }
                case 131: {
                    n5 = 183;
                    break;
                }
                case 132: {
                    n5 = 39;
                    break;
                }
                case 133: {
                    n5 = 245;
                    break;
                }
                case 134: {
                    n5 = 58;
                    break;
                }
                case 135: {
                    n5 = 81;
                    break;
                }
                case 136: {
                    n5 = 64;
                    break;
                }
                case 137: {
                    n5 = 68;
                    break;
                }
                case 138: {
                    n5 = 189;
                    break;
                }
                case 139: {
                    n5 = 60;
                    break;
                }
                case 140: {
                    n5 = 34;
                    break;
                }
                case 141: {
                    n5 = 44;
                    break;
                }
                case 142: {
                    n5 = 8;
                    break;
                }
                case 143: {
                    n5 = 116;
                    break;
                }
                case 144: {
                    n5 = 191;
                    break;
                }
                case 145: {
                    n5 = 24;
                    break;
                }
                case 146: {
                    n5 = 127;
                    break;
                }
                case 147: {
                    n5 = 45;
                    break;
                }
                case 148: {
                    n5 = 31;
                    break;
                }
                case 149: {
                    n5 = 254;
                    break;
                }
                case 150: {
                    n5 = 249;
                    break;
                }
                case 151: {
                    n5 = 101;
                    break;
                }
                case 152: {
                    n5 = 232;
                    break;
                }
                case 153: {
                    n5 = 150;
                    break;
                }
                case 154: {
                    n5 = 195;
                    break;
                }
                case 155: {
                    n5 = 9;
                    break;
                }
                case 156: {
                    n5 = 128;
                    break;
                }
                case 157: {
                    n5 = 50;
                    break;
                }
                case 158: {
                    n5 = 134;
                    break;
                }
                case 159: {
                    n5 = 95;
                    break;
                }
                case 160: {
                    n5 = 118;
                    break;
                }
                case 161: {
                    n5 = 194;
                    break;
                }
                case 162: {
                    n5 = 196;
                    break;
                }
                case 163: {
                    n5 = 157;
                    break;
                }
                case 164: {
                    n5 = 16;
                    break;
                }
                case 165: {
                    n5 = 130;
                    break;
                }
                case 166: {
                    n5 = 86;
                    break;
                }
                case 167: {
                    n5 = 214;
                    break;
                }
                case 168: {
                    n5 = 246;
                    break;
                }
                case 169: {
                    n5 = 69;
                    break;
                }
                case 170: {
                    n5 = 161;
                    break;
                }
                case 171: {
                    n5 = 140;
                    break;
                }
                case 172: {
                    n5 = 207;
                    break;
                }
                case 173: {
                    n5 = 55;
                    break;
                }
                case 174: {
                    n5 = 177;
                    break;
                }
                case 175: {
                    n5 = 87;
                    break;
                }
                case 176: {
                    n5 = 113;
                    break;
                }
                case 177: {
                    n5 = 115;
                    break;
                }
                case 178: {
                    n5 = 151;
                    break;
                }
                case 179: {
                    n5 = 49;
                    break;
                }
                case 180: {
                    n5 = 221;
                    break;
                }
                case 181: {
                    n5 = 46;
                    break;
                }
                case 182: {
                    n5 = 224;
                    break;
                }
                case 183: {
                    n5 = 36;
                    break;
                }
                case 184: {
                    n5 = 66;
                    break;
                }
                case 185: {
                    n5 = 155;
                    break;
                }
                case 186: {
                    n5 = 89;
                    break;
                }
                case 187: {
                    n5 = 145;
                    break;
                }
                case 188: {
                    n5 = 74;
                    break;
                }
                case 189: {
                    n5 = 99;
                    break;
                }
                case 190: {
                    n5 = 173;
                    break;
                }
                case 191: {
                    n5 = 206;
                    break;
                }
                case 192: {
                    n5 = 163;
                    break;
                }
                case 193: {
                    n5 = 70;
                    break;
                }
                case 194: {
                    n5 = 239;
                    break;
                }
                case 195: {
                    n5 = 159;
                    break;
                }
                case 196: {
                    n5 = 165;
                    break;
                }
                case 197: {
                    n5 = 80;
                    break;
                }
                case 198: {
                    n5 = 125;
                    break;
                }
                case 199: {
                    n5 = 204;
                    break;
                }
                case 200: {
                    n5 = 37;
                    break;
                }
                case 201: {
                    n5 = 185;
                    break;
                }
                case 202: {
                    n5 = 126;
                    break;
                }
                case 203: {
                    n5 = 168;
                    break;
                }
                case 204: {
                    n5 = 201;
                    break;
                }
                case 205: {
                    n5 = 200;
                    break;
                }
                case 206: {
                    n5 = 166;
                    break;
                }
                case 207: {
                    n5 = 164;
                    break;
                }
                case 208: {
                    n5 = 1;
                    break;
                }
                case 209: {
                    n5 = 132;
                    break;
                }
                case 210: {
                    n5 = 181;
                    break;
                }
                case 211: {
                    n5 = 233;
                    break;
                }
                case 212: {
                    n5 = 139;
                    break;
                }
                case 213: {
                    n5 = 102;
                    break;
                }
                case 214: {
                    n5 = 248;
                    break;
                }
                case 215: {
                    n5 = 247;
                    break;
                }
                case 216: {
                    n5 = 219;
                    break;
                }
                case 217: {
                    n5 = 108;
                    break;
                }
                case 218: {
                    n5 = 230;
                    break;
                }
                case 219: {
                    n5 = 255;
                    break;
                }
                case 220: {
                    n5 = 62;
                    break;
                }
                case 221: {
                    n5 = 100;
                    break;
                }
                case 222: {
                    n5 = 167;
                    break;
                }
                case 223: {
                    n5 = 12;
                    break;
                }
                case 224: {
                    n5 = 193;
                    break;
                }
                case 225: {
                    n5 = 75;
                    break;
                }
                case 226: {
                    n5 = 251;
                    break;
                }
                case 227: {
                    n5 = 162;
                    break;
                }
                case 228: {
                    n5 = 225;
                    break;
                }
                case 229: {
                    n5 = 84;
                    break;
                }
                case 230: {
                    n5 = 242;
                    break;
                }
                case 231: {
                    n5 = 7;
                    break;
                }
                case 232: {
                    n5 = 236;
                    break;
                }
                case 233: {
                    n5 = 156;
                    break;
                }
                case 234: {
                    n5 = 15;
                    break;
                }
                case 235: {
                    n5 = 188;
                    break;
                }
                case 236: {
                    n5 = 222;
                    break;
                }
                case 237: {
                    n5 = 88;
                    break;
                }
                case 238: {
                    n5 = 172;
                    break;
                }
                case 239: {
                    n5 = 38;
                    break;
                }
                case 240: {
                    n5 = 85;
                    break;
                }
                case 241: {
                    n5 = 112;
                    break;
                }
                case 242: {
                    n5 = 138;
                    break;
                }
                case 243: {
                    n5 = 109;
                    break;
                }
                case 244: {
                    n5 = 175;
                    break;
                }
                case 245: {
                    n5 = 14;
                    break;
                }
                case 246: {
                    n5 = 98;
                    break;
                }
                case 247: {
                    n5 = 253;
                    break;
                }
                case 248: {
                    n5 = 220;
                    break;
                }
                case 249: {
                    n5 = 227;
                    break;
                }
                case 250: {
                    n5 = 178;
                    break;
                }
                case 251: {
                    n5 = 231;
                    break;
                }
                case 252: {
                    n5 = 137;
                    break;
                }
                case 253: {
                    n5 = 234;
                    break;
                }
                case 254: {
                    n5 = 97;
                    break;
                }
                default: {
                    n5 = 67;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            FileSystemUtils.b[n3] = new String(cArray).intern();
        }
        return b[n3];
    }
}

