/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import com.samsarasoftware.license.licenses.ProductLicense;
import com.samsarasoftware.license.licenses.SamsaraSoftwareArchitectProductTrialLicense;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.XmlStreamReaderException;

public class XmlStreamReader
extends Reader {
    private static final int BUFFER_SIZE = 4096;
    private static final String UTF_8;
    private static final String US_ASCII;
    private static final String UTF_16BE;
    private static final String UTF_16LE;
    private static final String UTF_16;
    private static final String EBCDIC;
    private static final ByteOrderMark[] BOMS;
    private static final ByteOrderMark[] XML_GUESS_BYTES;
    private final Reader reader;
    private final String encoding;
    private final String defaultEncoding;
    private static final Pattern CHARSET_PATTERN;
    public static final Pattern ENCODING_PATTERN;
    private static final String RAW_EX_1;
    private static final String RAW_EX_2;
    private static final String HTTP_EX_1;
    private static final String HTTP_EX_2;
    private static final String HTTP_EX_3;
    private static final String[] a;
    private static final String[] b;

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public XmlStreamReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public XmlStreamReader(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public XmlStreamReader(InputStream inputStream, boolean bl) throws IOException {
        this(inputStream, bl, null);
    }

    public XmlStreamReader(InputStream inputStream, boolean bl, String string) throws IOException {
        this.defaultEncoding = string;
        BOMInputStream bOMInputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, BOMS);
        BOMInputStream bOMInputStream2 = new BOMInputStream((InputStream)bOMInputStream, true, XML_GUESS_BYTES);
        this.encoding = this.doRawStream(bOMInputStream, bOMInputStream2, bl);
        this.reader = new InputStreamReader((InputStream)bOMInputStream2, this.encoding);
    }

    public XmlStreamReader(URL uRL) throws IOException {
        this(uRL.openConnection(), null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlStreamReader(URLConnection var1_1, String var2_2) throws IOException {
        block6: {
            super();
            this.defaultEncoding = var2_2;
            var4_3 = true;
            var5_4 = var1_1.getContentType();
            var6_5 = var1_1.getInputStream();
            var7_6 = new BOMInputStream((InputStream)new BufferedInputStream(var6_5, 4096), false, XmlStreamReader.BOMS);
            var8_7 = new BOMInputStream((InputStream)var7_6, true, XmlStreamReader.XML_GUESS_BYTES);
            var3_8 = SamsaraSoftwareArchitectProductTrialLicense.c;
            if (var3_8 != 0) break block6;
            if (!(var1_1 instanceof HttpURLConnection) && var5_4 == null) ** GOTO lbl-1000
            v0 = this;
            v1 = v0.encoding = this.doHttpStream(var7_6, var8_7, var5_4, var4_3);
        }
        while (var3_8 != 0) lbl-1000:
        // 2 sources

        {
            v0 = this;
            v1 = this.doRawStream(var7_6, var8_7, var4_3);
            if (var3_8 != 0) continue;
            v0.encoding = v1;
            break;
        }
        this.reader = new InputStreamReader((InputStream)var8_7, this.encoding);
        if (ProductLicense.b == false) return;
        SamsaraSoftwareArchitectProductTrialLicense.c = ++var3_8;
    }

    public XmlStreamReader(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, true);
    }

    public XmlStreamReader(InputStream inputStream, String string, boolean bl, String string2) throws IOException {
        this.defaultEncoding = string2;
        BOMInputStream bOMInputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, BOMS);
        BOMInputStream bOMInputStream2 = new BOMInputStream((InputStream)bOMInputStream, true, XML_GUESS_BYTES);
        this.encoding = this.doHttpStream(bOMInputStream, bOMInputStream2, string, bl);
        this.reader = new InputStreamReader((InputStream)bOMInputStream2, this.encoding);
    }

    public XmlStreamReader(InputStream inputStream, String string, boolean bl) throws IOException {
        this(inputStream, string, bl, null);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.reader.read(cArray, n, n2);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private String doRawStream(BOMInputStream bOMInputStream, BOMInputStream bOMInputStream2, boolean bl) throws IOException {
        String string = bOMInputStream.getBOMCharsetName();
        String string2 = bOMInputStream2.getBOMCharsetName();
        String string3 = XmlStreamReader.getXmlProlog(bOMInputStream2, string2);
        try {
            return this.calculateRawEncoding(string, string2, string3);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl) {
                return this.doLenientDetection(null, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String doHttpStream(BOMInputStream bOMInputStream, BOMInputStream bOMInputStream2, String string, boolean bl) throws IOException {
        String string2 = bOMInputStream.getBOMCharsetName();
        String string3 = bOMInputStream2.getBOMCharsetName();
        String string4 = XmlStreamReader.getXmlProlog(bOMInputStream2, string3);
        try {
            return this.calculateHttpEncoding(string, string2, string3, string4, bl);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl) {
                return this.doLenientDetection(string, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String doLenientDetection(String var1_1, XmlStreamReaderException var2_2) throws IOException {
        block36: {
            block35: {
                var3_3 = SamsaraSoftwareArchitectProductTrialLicense.c;
                v0 = var1_1;
                if (var3_3 != 0) ** GOTO lbl23
                if (v0 != null) {
                }
                ** GOTO lbl22
                v0 = var1_1;
                do {
                    block37: {
                        if (var3_3 != 0) break block37;
                        if (v0.startsWith(XmlStreamReader.a(31213, 23722))) {
                            var1_1 = var1_1.substring(XmlStreamReader.a(31213, 23722).length());
                            var1_1 = XmlStreamReader.a(31212, 17385) + var1_1;
                            try {
                                v2 = this.calculateHttpEncoding(var1_1, var2_2.getBomEncoding(), var2_2.getXmlGuessEncoding(), var2_2.getXmlEncoding(), true);
lbl18:
                                // 2 sources

                                return v2;
                            }
                            catch (XmlStreamReaderException var4_5) {
                                var2_2 = var4_5;
                            }
                        }
lbl22:
                        // 4 sources

                        v0 = var2_2.getXmlEncoding();
                    }
                    v3 = var4_4 = v0;
                } while (var3_3 != 0);
                ** while (var3_3 != 0)
lbl29:
                // 3 sources

                if (var3_3 != 0) break block35;
                if (v3 == null) {
                }
                ** GOTO lbl41
                v5 = var2_2.getContentTypeEncoding();
                do {
                    var4_4 = v5;
lbl41:
                    // 2 sources

                    v5 = var4_4;
                } while (var3_3 != 0);
            }
            if (var3_3 != 0) break block36;
            if (v5 == null) {
            }
            ** GOTO lbl72
            v8 = this;
            if (var3_3 == 0) {
            }
            ** GOTO lbl69
            v10 = v8.defaultEncoding;
            do {
                block38: {
                    if (var3_3 != 0) break block38;
                    if (v10 == null) {
                        v10 = XmlStreamReader.a(31226, 3452);
                    } else {
                        v8 = this;
lbl69:
                        // 2 sources

                        v10 = v8.defaultEncoding;
                    }
                }
                var4_4 = v10;
lbl72:
                // 2 sources

                v12 = var4_4;
            } while (var3_3 != 0);
        }
        return v12;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String calculateRawEncoding(String var1_1, String var2_2, String var3_3) throws IOException {
        block46: {
            block44: {
                block45: {
                    block56: {
                        block43: {
                            block54: {
                                block55: {
                                    block50: {
                                        block51: {
                                            block53: {
                                                block52: {
                                                    block47: {
                                                        block49: {
                                                            block48: {
                                                                var4_4 = SamsaraSoftwareArchitectProductTrialLicense.c;
                                                                v0 = var1_1;
                                                                if (var4_4 != 0) break block47;
                                                                if (v0 != null) break block48;
                                                                v0 = var2_2;
                                                                break block49;
                                                            }
                                                            v0 = var1_1;
                                                            if (var4_4 == 0) break block47;
                                                        }
                                                        if (var4_4 != 0) ** GOTO lbl49
                                                        if (v0 == null) ** GOTO lbl39
                                                        v0 = var3_3;
                                                        break block50;
                                                    }
                                                    v1 = v0.equals(XmlStreamReader.a(31226, 3452));
                                                    if (var4_4 != 0) break block51;
                                                    if (!v1) break block52;
                                                    v2 = var2_2;
                                                    break block53;
                                                }
                                                v2 = var1_1;
                                                if (var4_4 != 0) break block53;
                                                if (var4_4 != 0) ** GOTO lbl108
                                                v1 = v2.equals(XmlStreamReader.a(31230, 10687));
                                                break block51;
                                            }
                                            if (var4_4 != 0) break block54;
                                            if (v2 == null) ** GOTO lbl-1000
                                            v2 = var2_2;
                                            break block55;
                                        }
                                        if (v1) ** GOTO lbl-1000
                                        v3 = var1_1;
                                        break block56;
                                    }
                                    while (var4_4 == 0) {
                                        block58: {
                                            block59: {
                                                block57: {
                                                    if (v0 != null) break block57;
lbl39:
                                                    // 2 sources

                                                    v4 = this;
                                                    if (var4_4 != 0) break block58;
                                                    v0 = v4.defaultEncoding;
                                                    if (var4_4 != 0) continue;
                                                    break block59;
                                                }
                                                v0 = var3_3;
                                                if (var4_4 == 0) break;
                                            }
                                            if (var4_4 != 0) return v5;
lbl49:
                                            // 2 sources

                                            if (v0 == null) {
                                                v5 = XmlStreamReader.a(31226, 3452);
                                                return v5;
                                            }
                                            v4 = this;
                                        }
                                        v5 = v4.defaultEncoding;
                                        return v5;
                                    }
                                    if (var4_4 != 0) return v6;
                                    if (!v0.equals(XmlStreamReader.a(31183, -31627))) ** GOTO lbl69
                                    v7 = var2_2;
                                    do {
                                        block42: {
                                            if (var4_4 != 0) return v7;
                                            if (v7.equals(XmlStreamReader.a(31230, 10687))) ** GOTO lbl66
                                            v6 = var2_2;
                                            do {
                                                if (var4_4 != 0) return v6;
                                                if (!v6.equals(XmlStreamReader.a(31221, 13001))) break block42;
lbl66:
                                                // 2 sources

                                                v7 = var2_2;
                                            } while (var4_4 != 0);
                                            return v7;
                                        }
                                        v6 = var3_3;
                                    } while (var4_4 != 0);
                                    if (var4_4 != 0) return v7;
                                    return v6;
                                }
                                while (var4_4 == 0) {
                                    if (!v2.equals(XmlStreamReader.a(31226, 3452))) {
                                        v8 = MessageFormat.format(XmlStreamReader.a(31180, -14896), new Object[]{var1_1, var2_2, var3_3});
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v2 = var3_3;
                                        if (var4_4 != 0) continue;
                                        if (var4_4 == 0) break;
                                    }
                                    var5_5 = v8;
                                    throw new XmlStreamReaderException((String)var5_5, var1_1, var2_2, var3_3);
                                }
                            }
                            if (var4_4 != 0) return v9;
                            if (v2 == null) ** GOTO lbl93
                            v9 = var3_3;
                            do {
                                if (var4_4 != 0) return v9;
                                if (!v9.equals(XmlStreamReader.a(31226, 3452))) {
                                    v10 = MessageFormat.format(XmlStreamReader.a(31180, -14896), new Object[]{var1_1, var2_2, var3_3});
                                    break block43;
                                }
lbl93:
                                // 3 sources

                                v9 = var1_1;
                            } while (var4_4 != 0);
                            if (var4_4 == 0) {
                                return v9;
                            }
                        }
                        var5_6 = v10;
                        throw new XmlStreamReaderException((String)var5_6, var1_1, var2_2, var3_3);
                    }
                    while (var4_4 == 0) {
                        if (v3.equals(XmlStreamReader.a(31221, 13001))) lbl-1000:
                        // 2 sources

                        {
                            v3 = var2_2;
                            if (var4_4 != 0) continue;
                        } else {
                            v3 = MessageFormat.format(XmlStreamReader.a(31217, 27293), new Object[]{var1_1, var2_2, var3_3});
                            if (var4_4 == 0) break;
                        }
lbl108:
                        // 3 sources

                        if (var4_4 != 0) break block44;
                        if (v3 != null) {
                            v11 = var2_2;
                            break block45;
                        }
                        ** GOTO lbl-1000
                    }
                    var5_9 = v3;
                    throw new XmlStreamReaderException(var5_9, var1_1, var2_2, var3_3);
                }
                while (var4_4 == 0) {
                    if (!v11.equals(var1_1)) {
                        v12 = MessageFormat.format(XmlStreamReader.a(31180, -14896), new Object[]{var1_1, var2_2, var3_3});
                    } else lbl-1000:
                    // 2 sources

                    {
                        v11 = var3_3;
                        if (var4_4 != 0) continue;
                        if (var4_4 == 0) break;
                    }
                    var5_7 = v12;
                    throw new XmlStreamReaderException((String)var5_7, var1_1, var2_2, var3_3);
                }
            }
            if (var4_4 != 0) return v13;
            if (v11 == null) ** GOTO lbl138
            v13 = var3_3;
            block28: while (true) {
                if (var4_4 != 0) return v13;
                if (v13.equals(XmlStreamReader.a(31183, -31627))) ** GOTO lbl138
                v13 = var3_3;
                do {
                    if (var4_4 != 0) return v13;
                    if (!v13.equals(var1_1)) {
                        v14 = MessageFormat.format(XmlStreamReader.a(31180, -14896), new Object[]{var1_1, var2_2, var3_3});
                        break block46;
                    }
lbl138:
                    // 4 sources

                    v13 = var1_1;
                    if (var4_4 != 0) continue block28;
                } while (var4_4 != 0);
                break;
            }
            if (var4_4 == 0) {
                return v13;
            }
        }
        var5_8 = v14;
        throw new XmlStreamReaderException((String)var5_8, var1_1, var2_2, var3_3);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String calculateHttpEncoding(String var1_1, String var2_2, String var3_3, String var4_4, boolean var5_5) throws IOException {
        block42: {
            block32: {
                block33: {
                    block41: {
                        block40: {
                            block38: {
                                block39: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                var6_6 = SamsaraSoftwareArchitectProductTrialLicense.c;
                                                if (!var5_5) ** GOTO lbl10
                                                v0 = var4_4;
                                                do {
                                                    block34: {
                                                        if (var6_6 == 0) {
                                                            if (v0 != null) {
                                                                v1 = var4_4;
                                                                return v1;
                                                            } else {
                                                                ** GOTO lbl10
                                                            }
                                                        }
                                                        break block34;
lbl10:
                                                        // 3 sources

                                                        v0 = XmlStreamReader.getContentTypeMime(var1_1);
                                                    }
                                                    var7_7 = v0;
                                                    var8_8 = XmlStreamReader.getContentTypeEncoding(var1_1);
                                                    var9_9 = XmlStreamReader.isAppXml(var7_7);
                                                    v2 = var7_7;
                                                } while (var6_6 != 0);
                                                if (var6_6 != 0) return v1;
                                                var10_10 = XmlStreamReader.isTextXml(v2);
                                                v3 = var9_9;
                                                if (var6_6 != 0 || var6_6 != 0) break block35;
                                                if (v3) break block36;
                                                v3 = var10_10;
                                            }
                                            if (v3) break block36;
                                            v4 = MessageFormat.format(XmlStreamReader.a(31224, -31228), new Object[]{var7_7, var8_8, var2_2, var3_3, var4_4});
                                            break block37;
                                        }
                                        v4 = var8_8;
                                        if (var6_6 != 0) break block37;
                                        if (var6_6 != 0) break block38;
                                        if (v4 != null) break block39;
                                        v5 = var9_9;
                                        break block40;
                                    }
                                    var11_11 = v4;
                                    throw new XmlStreamReaderException(var11_11, var7_7, var8_8, var2_2, var3_3, var4_4);
                                }
                                v6 = var8_8;
                            }
                            if (var6_6 != 0) ** GOTO lbl-1000
                            v5 = v6.equals(XmlStreamReader.a(31230, 10687));
                            if (var6_6 != 0) break block40;
                            if (v5) ** GOTO lbl66
                            break block41;
                        }
                        if (v5) {
                            v7 = this.calculateRawEncoding(var2_2, var3_3, var4_4);
                            return v7;
                        }
                        v8 = this;
                        if (var6_6 == 0) {
                            v7 = v8.defaultEncoding;
                            if (var6_6 != 0) return v7;
                            if (var6_6 != 0) return v9;
                            if (v7 == null) {
                                v9 = XmlStreamReader.a(31228, 29172);
                                return v9;
                            }
                            v8 = this;
                        }
                        v9 = v8.defaultEncoding;
                        return v9;
                    }
                    v6 = var8_8;
                    do {
                        v10 = v6.equals(XmlStreamReader.a(31221, 13001));
                        if (var6_6 != 0) break block32;
                        if (!v10) break block33;
lbl66:
                        // 2 sources

                        v6 = var2_2;
                    } while (var6_6 != 0);
                    ** GOTO lbl-1000
                }
                v6 = var8_8;
                if (var6_6 == 0) {
                    if (var6_6 != 0) return v11;
                    v10 = v6.equals(XmlStreamReader.a(31183, -31627));
                } else lbl-1000:
                // 3 sources

                {
                    if (var6_6 != 0) return v12;
                    if (v6 != null) {
                        v12 = MessageFormat.format(XmlStreamReader.a(31225, -29081), new Object[]{var7_7, var8_8, var2_2, var3_3, var4_4});
                    } else {
                        v12 = var8_8;
                        if (var6_6 == 0) {
                            return v12;
                        }
                    }
                    var11_12 = v12;
                    throw new XmlStreamReaderException(var11_12, var7_7, var8_8, var2_2, var3_3, var4_4);
                }
            }
            if (v10) {
                v11 = var2_2;
            } else {
                v11 = var8_8;
                if (var6_6 == 0) {
                    return v11;
                }
            }
            if (var6_6 != 0) break block42;
            if (v11 == null) ** GOTO lbl98
            v11 = var2_2;
            while (var6_6 == 0) {
                if (v11.startsWith(XmlStreamReader.a(31183, -31627))) {
                    v13 = var2_2;
                    return v13;
                }
lbl98:
                // 3 sources

                v11 = MessageFormat.format(XmlStreamReader.a(31205, -6508), new Object[]{var7_7, var8_8, var2_2, var3_3, var4_4});
                if (var6_6 != 0) continue;
                if (var6_6 != 0) return v13;
                break;
            }
        }
        var11_13 = v11;
        throw new XmlStreamReaderException(var11_13, var7_7, var8_8, var2_2, var3_3, var4_4);
    }

    /*
     * Unable to fully structure code
     */
    static String getContentTypeMime(String var0) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        var2_1 = null;
                        var1_2 = SamsaraSoftwareArchitectProductTrialLicense.c;
                        v0 = var0;
                        if (var1_2 != 0 || var1_2 != 0) break block7;
                        if (v0 == null) break block8;
                        v0 = var0;
                    }
                    var3_3 = v0.indexOf(";");
                    if (var3_3 < 0) break block9;
                    v3 = var0.substring(0, var3_3);
lbl23:
                    // 2 sources

                    while (true) {
                        var2_1 = v3;
                        break block10;
                        break;
                    }
                }
                v3 = var0;
                ** while (var1_2 != 0)
lbl29:
                // 1 sources

                var2_1 = v3;
            }
            var2_1 = var2_1.trim();
        }
        return var2_1;
    }

    static String getContentTypeEncoding(String string) {
        String string2;
        block17: {
            String string3;
            block20: {
                block21: {
                    String string4;
                    int n;
                    block22: {
                        block19: {
                            Matcher matcher;
                            block18: {
                                int n2;
                                String string5;
                                block16: {
                                    string2 = null;
                                    n = SamsaraSoftwareArchitectProductTrialLicense.c;
                                    string5 = string;
                                    if (n != 0 || n != 0) break block16;
                                    if (string5 == null) break block17;
                                    string5 = string;
                                }
                                if ((n2 = string5.indexOf(";")) <= -1) break block17;
                                String string6 = string.substring(n2 + 1);
                                Matcher matcher2 = CHARSET_PATTERN.matcher(string6);
                                matcher = matcher2;
                                if (n != 0 || n != 0) break block18;
                                if (!matcher.find()) break block19;
                                matcher = matcher2;
                            }
                            string4 = matcher.group(1);
                            break block22;
                        }
                        string4 = null;
                    }
                    string2 = string4;
                    string3 = string2;
                    if (n != 0 || n != 0) break block20;
                    if (string3 == null) break block21;
                    string3 = string2.toUpperCase(Locale.US);
                    break block20;
                }
                string3 = null;
            }
            string2 = string3;
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private static String getXmlProlog(InputStream var0, String var1_1) throws IOException {
        block34: {
            block35: {
                block33: {
                    block31: {
                        var3_2 = null;
                        var2_3 = SamsaraSoftwareArchitectProductTrialLicense.c;
                        if (var1_1 == null) break block34;
                        var4_4 = new byte[4096];
                        var0.mark(4096);
                        var5_5 = 0;
                        var6_6 = 4096;
                        var7_7 = var0.read(var4_4, var5_5, var6_6);
                        var8_8 = -1;
                        var9_9 = null;
                        block22: while (var7_7 != -1) {
                            v0 = var8_8;
                            v1 = -1;
                            if (var2_3 == 0) {
                                if (var2_3 != 0) break;
                            }
                            ** GOTO lbl51
                            if (v0 == v1) {
                            }
                            ** GOTO lbl45
                            v0 = var5_5;
                            v1 = 4096;
                            block23: while (var2_3 == 0) {
                                if (v0 >= v1) ** GOTO lbl45
                                var5_5 += var7_7;
                                v5 = var6_6;
                                v6 = var7_7;
                                do {
                                    var6_6 = v5 - v6;
                                    var7_7 = var0.read(var4_4, var5_5, var6_6);
                                    var9_9 = new String(var4_4, 0, var5_5, var1_1);
                                    var8_8 = var9_9.indexOf(62);
                                    if (var2_3 == 0) continue block22;
lbl45:
                                    // 5 sources

                                    v0 = var8_8;
                                    if (var2_3 != 0) break block31;
                                    v1 = -1;
lbl51:
                                    // 2 sources

                                    if (var2_3 != 0) continue block23;
                                } while (var2_3 != 0);
                            }
                            break block22;
                        }
                        if (v0 == v1) {
                            v8 = var7_7;
                            while (true) {
                                block32: {
                                    if (v8 != -1) break block32;
                                    v9 = new IOException(XmlStreamReader.a(31214, 21805));
                                    throw v9;
                                }
                                v9 = new IOException(XmlStreamReader.a(31215, -9040) + var5_5 + XmlStreamReader.a(31222, 22444));
                                if (var2_3 != 0) ** continue;
                                throw v9;
                            }
                        }
                        v0 = var5_5;
                    }
                    var10_10 = v0;
                    if (var2_3 != 0 || var2_3 != 0) break block33;
                    v8 = var10_10;
                    if (var2_3 != 0) ** continue;
                    if (v8 <= 0) break block34;
                    var0.reset();
                }
                var11_11 = new BufferedReader(new StringReader(var9_9.substring(0, var8_8 + 1)));
                var12_12 = new StringBuffer();
                var13_13 = var11_11.readLine();
                while (var13_13 != null) {
                    var12_12.append(var13_13);
                    var13_13 = var11_11.readLine();
                    if (var2_3 == 0) continue;
                }
                var14_14 = XmlStreamReader.ENCODING_PATTERN.matcher(var12_12);
                v14 = var14_14;
                if (var2_3 != 0 || var2_3 != 0) break block35;
                if (!v14.find()) break block34;
                v14 = var14_14;
            }
            var3_2 = v14.group(1).toUpperCase();
            var3_2 = var3_2.substring(1, var3_2.length() - 1);
        }
        return var3_2;
    }

    /*
     * Unable to fully structure code
     */
    static boolean isAppXml(String var0) {
        block31: {
            block30: {
                var1_1 = SamsaraSoftwareArchitectProductTrialLicense.c;
                v0 = var0;
                if (var1_1 != 0 || var1_1 != 0) break block30;
                if (v0 != null) {
                }
                ** GOTO lbl80
                v0 = var0;
            }
            v3 = v0.equals(XmlStreamReader.a(31216, 14933));
            if (var1_1 != 0) break block31;
            if (!v3) {
            }
            ** GOTO lbl72
            v3 = var0.equals(XmlStreamReader.a(31211, 26207));
            block22: while (var1_1 == 0) {
                if (!v3) {
                    v3 = var0.equals(XmlStreamReader.a(31223, 20642));
                }
                ** GOTO lbl72
                block23: while (var1_1 == 0) {
                    block32: {
                        if (!v3) {
                            v3 = var0.startsWith(XmlStreamReader.a(31202, 8806));
                        }
                        ** GOTO lbl72
                        do {
                            block33: {
                                if (var1_1 != 0) break block33;
                                if (var1_1 == 0) {
                                    if (!v3) break block32;
                                }
                                ** GOTO lbl64
                                v3 = var0.endsWith(XmlStreamReader.a(31229, -10248));
                            }
                            if (var1_1 != 0) break block22;
lbl64:
                            // 2 sources

                            if (var1_1 != 0) break block22;
                            if (!v3) break block32;
lbl72:
                            // 4 sources

                            v3 = true;
                            if (var1_1 != 0) continue block22;
                            if (var1_1 != 0) continue block23;
                        } while (var1_1 != 0);
                        break block22;
                    }
                    v3 = false;
                    break;
                }
                break;
            }
        }
        return v3;
    }

    /*
     * Unable to fully structure code
     */
    static boolean isTextXml(String var0) {
        block27: {
            block26: {
                var1_1 = SamsaraSoftwareArchitectProductTrialLicense.c;
                v0 = var0;
                if (var1_1 != 0 || var1_1 != 0) break block26;
                if (v0 != null) {
                }
                ** GOTO lbl71
                v0 = var0;
            }
            v3 = v0.equals(XmlStreamReader.a(31212, 17385));
            if (var1_1 != 0) break block27;
            if (!v3) {
            }
            ** GOTO lbl64
            v3 = var0.equals(XmlStreamReader.a(31209, 1255));
            block20: while (var1_1 == 0) {
                block28: {
                    if (!v3) {
                        v3 = var0.startsWith(XmlStreamReader.a(31182, -26506));
                    }
                    ** GOTO lbl64
                    do {
                        block29: {
                            if (var1_1 != 0) break block29;
                            if (var1_1 == 0) {
                                if (!v3) break block28;
                            }
                            ** GOTO lbl56
                            v3 = var0.endsWith(XmlStreamReader.a(31229, -10248));
                        }
                        if (var1_1 != 0) break block20;
lbl56:
                        // 2 sources

                        if (var1_1 != 0) break block20;
                        if (!v3) break block28;
lbl64:
                        // 3 sources

                        v3 = true;
                        if (var1_1 != 0) continue block20;
                    } while (var1_1 != 0);
                    break;
                }
                v3 = false;
                break;
            }
        }
        return v3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        int n;
        Object var6_6;
        String[] stringArray = new String[36];
        int n2 = 0;
        String string = "\u00f6\u009a\u009c\u0002G\u00be\u00f5y\u00c5\u00f4\u008f\u001b\u000f\u00cdqD$\u00efc\u00ee(\u008f\u001f\u0000\u00d8\u00dc0\u0003\u00b3!\u0089-\u001b\u00d2\u0083\u001be\u00b9s\u00f4\u0003\u00dfFZ\u00dd\u00e3\u001cjD\u008a\u00c6\u0089b \u000f\u00f8\"c\u00a8\u008e\u00b4\u00ac\u0087\u008a\u00c7\u00c29K\u001dI\u00ae\u00d3+\u008f\u00cd\t\u0084\u000eO\u00e9\u00d0\u0007\u00a8\u0016\u0015\b\u0010\u00ca\u00ddq\u0082\u0004\u00fbe\u0013/\u00ec\u0085\u001a\u00c6i\u00f1\u00a8\u008c\u00dd.w\u00b6E3\u00d3\u00be\u0013:\bF\u00f8,y[9<l\u001fTUU\u0082\u0093z\u00d9\u00aa@\u008cmM\u0017-\u00bbn\u00e58LF\u0089\b\u00fe%\u00aeH\u009b\u00b8G\u000f\u0088j&\u00ab\u008f\"D\u00c8\u0001\u0083;gXA\u00c8\u00cfaL\u00fe\u00b7T.\u0080\u00a8G\u00e1X\u0099\u0015`\\\u00f3\u00bd\u0019c\u00fbf\u001a\u00bc\u0090\u0081'\u00c7\u00e9o\u00e1B\u001dBL\u00c2\u00c8\u0091F\u00ce\u0080\u0083\u00b2\u00e7\u00dfe\u00cc\u009c\u00df7\u00bfM\u00ecc\u00ff\u00ad\u00fb\u00b9G\u0003b\u00c5Q\u00e2\u00c5\u009a\b@\u00c2p\u000b\u00f4\u009e,\u00b82s\u0000:Zq5\u00c9-\u00b6\u00bd\rY\u001d6\u00bf\u00e4\u009b\u0006w'\u00a9\u001bw\u00ca\b\u00cdm]\u00cbuo\u00f7\u00a6j\u00ff\u00a7\u00b4\u00a3#\u00f8\u00ed\u0085\u00a6\u00a7\u00ebY\u00be\u00cc\u00af,'\u00bbo\u00af\u00e7\u0098\u00ab\u00e7\u00c5Y\u00a6x*\u00f0sy\u00ba\u00f7]\u009b\u00db\u00a0m!Z)\u00dc\u00f94\u001e\u008c,\u001b\u00c4\u00aa\u00c7\u00a9\u00b0o\u00b4z\u001f\u00d6\u00d4\u00ea\u00dc\u00f9\u00df\u0094\u00e0X~\u00ca\u00cbUA\u009e\u00a2vI\u0094\u00c6Th\u0099\u00ceK\u008a\u0093\u00ae\u00c0\u00be\u00af\u00b3\u00b3\",r\u00fb\u00a9\u00f4\u00ba\u0086\u008c>-\u00da\u00b9y[\u0005\u00fe&;\u00a2\u00b0\b\u00b5\u009c9~\u009dM\u00cf5\f\u000b{\u0001\u00e8V7\u00e3c\u00ce\u00a4fXN\u00e3\u00117uS\"\u00e3\u00deg\u00cc\u00d34\u00b9aO\u0099;\r\u00edb\u00f64\u00f7\u0084k\u0098\u00ae\u00ed\u0085B\u00f2\u0019\u009d\u00daQ\r\u0006\u00c1\u0013\u0006\u00cb\u00a5\u00cd\u00d0J\u00e67\u00b0_\u00bel\u00da\u00f5\u00bc\u00b4K7\u00fd\u00d2\u0003\u00c9[\u007f?\u00b5\u00d1\u00c8\u00dd\u00924J]\u00a7\u0017\u00e9\u00fe\u001f\u00b3i\tVj\u009d\u00f8?\u0096}\u00c9\u00b8\u0006\u00ba\u0003\u00b0\u0018\u00a3\u00d1J\u00b1\u0091<_\u00d0\u001f\u00aaFK\u009b\u0097\u008c\u00c4\u00f6L\u0006\u0083\u00a5\u0000g\u0016\u00d9561\u001a\u0089b;\u00a3\u00ed5t\u00f9rw\u0014L\u0015\u0000;7W\u00a0NPb\u0011\u0086@\u0011\f.\u00b9\u00f1\u00bd\u009b\u00aa)\u00ba\u00e3\u00e7o?\u0095\u00b4Hi\u00bbF\u00c0\u008b\u007f\u00c8\u00ff\u00cd;k`\\j\\\u001e\u0099\u00d3P\u00c5e#2/\u0011P\u00ae\u0083Ok\u00feRr\u0089\u00a9I\u0080\u00fb.\u00f4\u001d\u0094\u00ce\u00c5-\b\u0000\u001fS\u001d\u0095\u0095\u00d5fb\u00c6)\u00a8\u00f6\u0003\u00eb\u0097pe\u00d2\u0003{j\u0080\u00c7Q1u\u00da\u00e6\u0001~\u00b7Fo\u00ff\u00dd\u00b9\u001fsHu\u00c3\u00cc\u00b9\u009d;\u008bS\u00fb\u00cfb\u00a3\u00a3\u00b2\u00c4E[\u00d08\u00e0\u00f8\u00aetb\u00c6\n0\u0015\u008f\u0013\u0015\u00ae\u000bF^\u00b0\b~\u00c8+\u007f\u00bb\u00f9.t\u0004\u00a1\u00f0J\u0090\b\u00d9w\u00b4\u0003,\u00e2\u00f9\u00c0\u0006\u00bdH\u00f0\u00f6\\w\u0005\u00d2\r\u00be\u00c7\u0000i\u00ce\u00ad\u0092\u00e2\u00e7\u00d0u\u0080\u00b5\u0007\u0089M\u00f2N&|\u0016\u00b1I\u00ee#\u00b03\u00e2\u00d6\u00f9\u00c4lfr\u00fa)\u008b\u00fd{\u00da\u001f\u0088\u00f5$I\u0089\u00be\u00edx\u009c\u0005|*\u00ce\u008c\u0086m\u0098\u00f7\u00b1i\u00bf\u00b4\u00c0\u00a6^p\u008f\u00a5\u00ea~?\u000e\u00e3\u00cdD\u008d\u0002\u0014]\u00d8D\u00dd8\u00a8\u00c4m\u00cbW\u0086X\u00bb\u00bc4\u00f0?\u000e3\u0005\u00b4\u00a7\u00a7\u0092#\u0001v0\u00ad\u00b9eT\u00c0\u00c1O\u008de86\u001c\u00d1\u00bc\u0097T\u0015\u00f2\u0017\u008c\u00dc\u001aCI\u0005~T\u007f/\u00f1\u00b6\u00c0).B\u0011\u0090(wu=\u00b8\u0092\u00e0_\u008b7\u00de\u00c7\u00d1\u0017\u00b0\u00a3\u00df+\u0007-\u00ba\u0007\u00c0i\u0081\u001a\u0000\u0005\u00a4\u00e4?\u0087-\u0092dV\u0080\u00f2$\u00d4!\u0087~\u001f\tS2\u00a9>f=3\u0015\r\u0015\u00e9\u00e4\u00d5\u00c83\u00a8\u0082\u00d9\u00f9\u00a8\u0000m&A\u00afHr\u007fd\u00c6\tj\u00e9\u00f2\u00f1-\u0095@\u00c9\u00d1\\\u00e61X\u007f\u00c0}\u00ed_\u00fc\u00eb_\u00b2\u00cf'\u0015\u00aa\u0013azL\u0006^\u008a\u00cb\u009e+\u00f2\b\u00fbN\u009b\u00af\u00ad\u00e3\u00e27\u001f\u00c2\u008dk32\u0097#\u00f8S\u00fa\u00e8\u0005IrT\u00db\u00bc[\u00fdv\u00cd3\u0014\u00a5\u00cb\n\u00e5cU\u00c1\u000b\u0006\u00d39\u009eA\r>H\u0018\u0080HG\u00bcd\u001e\u0016\u00d8\u00d5$\u0017G\u0005\u0090\u0015\u00c0\u009c\u0092P\u0019r\nL\u00d4\u0081Y\u00ce{&-\u0095fK.?\u00e9\u0087\u00ee\u00cet\u00bc:\u00f3\u00b4\u0082\u00e8<\u00a4/\u0013\u00e8\u001a\u00faI\u0083\u0088\u00e4% 7/\u00a0\u00abOA\u00a8\u00a5\u0004Y\u0015\u00faH9~l\u00988\u009f\u008ei\u00ca:f\u00ea\u000f\u00ba\u0099\u00e2\u00e1b\u00b6\u008f\u009d\u0089\u009a3\u00c6n\u001b33\u0099$bG\u00b5\n\u00e0m|~\u00b1fSx\u000e\u00fc=\u00e1\u00cb\u0085\u00d177\u009e\u0001\u00d9\u00fc\u009a\u000bg\u00dd\u007f\u0090\u00a9\\n\u00bf\u008cz\u0080\u00a2\u0085\u0085\u000f\u00b1\u00a8V\u0092\u00bcx\u00be\u008ae\u0099\u0013\u00ff\u0011T\u00c7\u0006\u00e1\u00de\u00d8\u00bd\u00c5\u00a1\u0005_A4\u0000\u00bf";
        int n3 = "\u00f6\u009a\u009c\u0002G\u00be\u00f5y\u00c5\u00f4\u008f\u001b\u000f\u00cdqD$\u00efc\u00ee(\u008f\u001f\u0000\u00d8\u00dc0\u0003\u00b3!\u0089-\u001b\u00d2\u0083\u001be\u00b9s\u00f4\u0003\u00dfFZ\u00dd\u00e3\u001cjD\u008a\u00c6\u0089b \u000f\u00f8\"c\u00a8\u008e\u00b4\u00ac\u0087\u008a\u00c7\u00c29K\u001dI\u00ae\u00d3+\u008f\u00cd\t\u0084\u000eO\u00e9\u00d0\u0007\u00a8\u0016\u0015\b\u0010\u00ca\u00ddq\u0082\u0004\u00fbe\u0013/\u00ec\u0085\u001a\u00c6i\u00f1\u00a8\u008c\u00dd.w\u00b6E3\u00d3\u00be\u0013:\bF\u00f8,y[9<l\u001fTUU\u0082\u0093z\u00d9\u00aa@\u008cmM\u0017-\u00bbn\u00e58LF\u0089\b\u00fe%\u00aeH\u009b\u00b8G\u000f\u0088j&\u00ab\u008f\"D\u00c8\u0001\u0083;gXA\u00c8\u00cfaL\u00fe\u00b7T.\u0080\u00a8G\u00e1X\u0099\u0015`\\\u00f3\u00bd\u0019c\u00fbf\u001a\u00bc\u0090\u0081'\u00c7\u00e9o\u00e1B\u001dBL\u00c2\u00c8\u0091F\u00ce\u0080\u0083\u00b2\u00e7\u00dfe\u00cc\u009c\u00df7\u00bfM\u00ecc\u00ff\u00ad\u00fb\u00b9G\u0003b\u00c5Q\u00e2\u00c5\u009a\b@\u00c2p\u000b\u00f4\u009e,\u00b82s\u0000:Zq5\u00c9-\u00b6\u00bd\rY\u001d6\u00bf\u00e4\u009b\u0006w'\u00a9\u001bw\u00ca\b\u00cdm]\u00cbuo\u00f7\u00a6j\u00ff\u00a7\u00b4\u00a3#\u00f8\u00ed\u0085\u00a6\u00a7\u00ebY\u00be\u00cc\u00af,'\u00bbo\u00af\u00e7\u0098\u00ab\u00e7\u00c5Y\u00a6x*\u00f0sy\u00ba\u00f7]\u009b\u00db\u00a0m!Z)\u00dc\u00f94\u001e\u008c,\u001b\u00c4\u00aa\u00c7\u00a9\u00b0o\u00b4z\u001f\u00d6\u00d4\u00ea\u00dc\u00f9\u00df\u0094\u00e0X~\u00ca\u00cbUA\u009e\u00a2vI\u0094\u00c6Th\u0099\u00ceK\u008a\u0093\u00ae\u00c0\u00be\u00af\u00b3\u00b3\",r\u00fb\u00a9\u00f4\u00ba\u0086\u008c>-\u00da\u00b9y[\u0005\u00fe&;\u00a2\u00b0\b\u00b5\u009c9~\u009dM\u00cf5\f\u000b{\u0001\u00e8V7\u00e3c\u00ce\u00a4fXN\u00e3\u00117uS\"\u00e3\u00deg\u00cc\u00d34\u00b9aO\u0099;\r\u00edb\u00f64\u00f7\u0084k\u0098\u00ae\u00ed\u0085B\u00f2\u0019\u009d\u00daQ\r\u0006\u00c1\u0013\u0006\u00cb\u00a5\u00cd\u00d0J\u00e67\u00b0_\u00bel\u00da\u00f5\u00bc\u00b4K7\u00fd\u00d2\u0003\u00c9[\u007f?\u00b5\u00d1\u00c8\u00dd\u00924J]\u00a7\u0017\u00e9\u00fe\u001f\u00b3i\tVj\u009d\u00f8?\u0096}\u00c9\u00b8\u0006\u00ba\u0003\u00b0\u0018\u00a3\u00d1J\u00b1\u0091<_\u00d0\u001f\u00aaFK\u009b\u0097\u008c\u00c4\u00f6L\u0006\u0083\u00a5\u0000g\u0016\u00d9561\u001a\u0089b;\u00a3\u00ed5t\u00f9rw\u0014L\u0015\u0000;7W\u00a0NPb\u0011\u0086@\u0011\f.\u00b9\u00f1\u00bd\u009b\u00aa)\u00ba\u00e3\u00e7o?\u0095\u00b4Hi\u00bbF\u00c0\u008b\u007f\u00c8\u00ff\u00cd;k`\\j\\\u001e\u0099\u00d3P\u00c5e#2/\u0011P\u00ae\u0083Ok\u00feRr\u0089\u00a9I\u0080\u00fb.\u00f4\u001d\u0094\u00ce\u00c5-\b\u0000\u001fS\u001d\u0095\u0095\u00d5fb\u00c6)\u00a8\u00f6\u0003\u00eb\u0097pe\u00d2\u0003{j\u0080\u00c7Q1u\u00da\u00e6\u0001~\u00b7Fo\u00ff\u00dd\u00b9\u001fsHu\u00c3\u00cc\u00b9\u009d;\u008bS\u00fb\u00cfb\u00a3\u00a3\u00b2\u00c4E[\u00d08\u00e0\u00f8\u00aetb\u00c6\n0\u0015\u008f\u0013\u0015\u00ae\u000bF^\u00b0\b~\u00c8+\u007f\u00bb\u00f9.t\u0004\u00a1\u00f0J\u0090\b\u00d9w\u00b4\u0003,\u00e2\u00f9\u00c0\u0006\u00bdH\u00f0\u00f6\\w\u0005\u00d2\r\u00be\u00c7\u0000i\u00ce\u00ad\u0092\u00e2\u00e7\u00d0u\u0080\u00b5\u0007\u0089M\u00f2N&|\u0016\u00b1I\u00ee#\u00b03\u00e2\u00d6\u00f9\u00c4lfr\u00fa)\u008b\u00fd{\u00da\u001f\u0088\u00f5$I\u0089\u00be\u00edx\u009c\u0005|*\u00ce\u008c\u0086m\u0098\u00f7\u00b1i\u00bf\u00b4\u00c0\u00a6^p\u008f\u00a5\u00ea~?\u000e\u00e3\u00cdD\u008d\u0002\u0014]\u00d8D\u00dd8\u00a8\u00c4m\u00cbW\u0086X\u00bb\u00bc4\u00f0?\u000e3\u0005\u00b4\u00a7\u00a7\u0092#\u0001v0\u00ad\u00b9eT\u00c0\u00c1O\u008de86\u001c\u00d1\u00bc\u0097T\u0015\u00f2\u0017\u008c\u00dc\u001aCI\u0005~T\u007f/\u00f1\u00b6\u00c0).B\u0011\u0090(wu=\u00b8\u0092\u00e0_\u008b7\u00de\u00c7\u00d1\u0017\u00b0\u00a3\u00df+\u0007-\u00ba\u0007\u00c0i\u0081\u001a\u0000\u0005\u00a4\u00e4?\u0087-\u0092dV\u0080\u00f2$\u00d4!\u0087~\u001f\tS2\u00a9>f=3\u0015\r\u0015\u00e9\u00e4\u00d5\u00c83\u00a8\u0082\u00d9\u00f9\u00a8\u0000m&A\u00afHr\u007fd\u00c6\tj\u00e9\u00f2\u00f1-\u0095@\u00c9\u00d1\\\u00e61X\u007f\u00c0}\u00ed_\u00fc\u00eb_\u00b2\u00cf'\u0015\u00aa\u0013azL\u0006^\u008a\u00cb\u009e+\u00f2\b\u00fbN\u009b\u00af\u00ad\u00e3\u00e27\u001f\u00c2\u008dk32\u0097#\u00f8S\u00fa\u00e8\u0005IrT\u00db\u00bc[\u00fdv\u00cd3\u0014\u00a5\u00cb\n\u00e5cU\u00c1\u000b\u0006\u00d39\u009eA\r>H\u0018\u0080HG\u00bcd\u001e\u0016\u00d8\u00d5$\u0017G\u0005\u0090\u0015\u00c0\u009c\u0092P\u0019r\nL\u00d4\u0081Y\u00ce{&-\u0095fK.?\u00e9\u0087\u00ee\u00cet\u00bc:\u00f3\u00b4\u0082\u00e8<\u00a4/\u0013\u00e8\u001a\u00faI\u0083\u0088\u00e4% 7/\u00a0\u00abOA\u00a8\u00a5\u0004Y\u0015\u00faH9~l\u00988\u009f\u008ei\u00ca:f\u00ea\u000f\u00ba\u0099\u00e2\u00e1b\u00b6\u008f\u009d\u0089\u009a3\u00c6n\u001b33\u0099$bG\u00b5\n\u00e0m|~\u00b1fSx\u000e\u00fc=\u00e1\u00cb\u0085\u00d177\u009e\u0001\u00d9\u00fc\u009a\u000bg\u00dd\u007f\u0090\u00a9\\n\u00bf\u008cz\u0080\u00a2\u0085\u0085\u000f\u00b1\u00a8V\u0092\u00bcx\u00be\u008ae\u0099\u0013\u00ff\u0011T\u00c7\u0006\u00e1\u00de\u00d8\u00bd\u00c5\u00a1\u0005_A4\u0000\u00bf".length();
        int n4 = 46;
        int n5 = -1;
        while (true) {
            char[] cArray;
            block26: {
                int n6;
                int n7;
                char[] cArray2;
                block25: {
                    int n8 = ++n5;
                    var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n4).toCharArray();
                    n = 0;
                    int n9 = cArray3.length;
                    cArray2 = cArray3;
                    n7 = n9;
                    if (n9 <= 1) break block25;
                    cArray = cArray2;
                    n6 = n7;
                    if (n7 <= n) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n10 = n;
                    while (true) {
                        int n11;
                        char c = cArray4[n10];
                        switch (n % 7) {
                            case 0: {
                                n11 = 50;
                                break;
                            }
                            case 1: {
                                n11 = 31;
                                break;
                            }
                            case 2: {
                                n11 = 27;
                                break;
                            }
                            case 3: {
                                n11 = 118;
                                break;
                            }
                            case 4: {
                                n11 = 2;
                                break;
                            }
                            case 5: {
                                n11 = 102;
                                break;
                            }
                            default: {
                                n11 = 76;
                            }
                        }
                        cArray4[n10] = (char)(c ^ n11);
                        ++n;
                        cArray2 = cArray5;
                        n7 = n7;
                        if (n7 != 0) break;
                        cArray5 = cArray2;
                        n6 = n7;
                        n10 = n7;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n6 = n7;
                } while (n7 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) break;
            n4 = string.charAt(n5);
        }
        string = "n\u009c\u0014\u00a9V\u0086(\u00e5\u001d\u00e0\u009c\u00b1P\u00d1r\u008f\u00eb\u00b3_T\u00d0\u00bf\u00b8l\u00c1f\u00a7\u001eMG\u00e3\u0087Nep@P\u0019K\u0004\u00db\u00a8I\u0094\u008bT\u0088\u0097\n\u00c4>\u0014\u0014\tN\u00b8\u00c9\\n>AN\u00b2\u00d2Ae\u0085oW\u0095_`\u00d5\u0086y\u009bWZ\u00e8\u00de\u0015\u0018\\St(\u00df\u00c6\u0002:\u0016k\u00a2\u00bej~({a\u009c\u00d0\u00edv\u0004f\u0007\u00c1\u0098\u00df\u0019'\u0082pd\u00b2\u001fm\u00a5\u00f9\u00ee\t\u00a3\u00c6\u00ffW\u00e71\u0012\u009a_O\u00c9\u0085";
        n3 = "n\u009c\u0014\u00a9V\u0086(\u00e5\u001d\u00e0\u009c\u00b1P\u00d1r\u008f\u00eb\u00b3_T\u00d0\u00bf\u00b8l\u00c1f\u00a7\u001eMG\u00e3\u0087Nep@P\u0019K\u0004\u00db\u00a8I\u0094\u008bT\u0088\u0097\n\u00c4>\u0014\u0014\tN\u00b8\u00c9\\n>AN\u00b2\u00d2Ae\u0085oW\u0095_`\u00d5\u0086y\u009bWZ\u00e8\u00de\u0015\u0018\\St(\u00df\u00c6\u0002:\u0016k\u00a2\u00bej~({a\u009c\u00d0\u00edv\u0004f\u0007\u00c1\u0098\u00df\u0019'\u0082pd\u00b2\u001fm\u00a5\u00f9\u00ee\t\u00a3\u00c6\u00ffW\u00e71\u0012\u009a_O\u00c9\u0085".length();
        n4 = 54;
        n5 = -1;
        while (true) {
            char[] cArray;
            block28: {
                int n12;
                int n13;
                char[] cArray6;
                block27: {
                    int n14 = ++n5;
                    var6_6 = null;
                    char[] cArray7 = string.substring(n14, n14 + n4).toCharArray();
                    n = 0;
                    int n15 = cArray7.length;
                    cArray6 = cArray7;
                    n13 = n15;
                    if (n15 <= 1) break block27;
                    cArray = cArray6;
                    n12 = n13;
                    if (n13 <= n) break block28;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n16 = n;
                    while (true) {
                        int n17;
                        char c = cArray8[n16];
                        switch (n % 7) {
                            case 0: {
                                n17 = 50;
                                break;
                            }
                            case 1: {
                                n17 = 31;
                                break;
                            }
                            case 2: {
                                n17 = 27;
                                break;
                            }
                            case 3: {
                                n17 = 118;
                                break;
                            }
                            case 4: {
                                n17 = 2;
                                break;
                            }
                            case 5: {
                                n17 = 102;
                                break;
                            }
                            default: {
                                n17 = 76;
                            }
                        }
                        cArray8[n16] = (char)(c ^ n17);
                        ++n;
                        cArray6 = cArray9;
                        n13 = n13;
                        if (n13 != 0) break;
                        cArray9 = cArray6;
                        n12 = n13;
                        n16 = n13;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n12 = n13;
                } while (n13 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) {
                a = stringArray;
                b = new String[36];
                HTTP_EX_1 = XmlStreamReader.a(31200, 21406);
                RAW_EX_2 = XmlStreamReader.a(31217, 27293);
                UTF_16LE = XmlStreamReader.a(31210, -22506);
                HTTP_EX_3 = XmlStreamReader.a(31231, -27736);
                US_ASCII = XmlStreamReader.a(31203, -2569);
                UTF_8 = XmlStreamReader.a(31226, 3452);
                UTF_16 = XmlStreamReader.a(31183, -31627);
                EBCDIC = XmlStreamReader.a(31207, 1443);
                UTF_16BE = XmlStreamReader.a(31206, 24290);
                RAW_EX_1 = XmlStreamReader.a(31180, -14896);
                HTTP_EX_2 = XmlStreamReader.a(31205, -6508);
                BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE};
                XML_GUESS_BYTES = new ByteOrderMark[]{new ByteOrderMark(XmlStreamReader.a(31226, 3452), 60, 63, 120, 109), new ByteOrderMark(XmlStreamReader.a(31230, 10687), 0, 60, 0, 63), new ByteOrderMark(XmlStreamReader.a(31221, 13001), 60, 0, 63, 0), new ByteOrderMark(XmlStreamReader.a(31227, 9192), 76, 111, 167, 148)};
                CHARSET_PATTERN = Pattern.compile(XmlStreamReader.a(31220, -3702));
                ENCODING_PATTERN = Pattern.compile(XmlStreamReader.a(31181, 27885), 8);
                return;
            }
            n4 = string.charAt(n5);
        }
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x79EF) & 0xFFFF;
        if (b[n3] == null) {
            int n4;
            int n5;
            char[] cArray = a[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 58;
                    break;
                }
                case 1: {
                    n5 = 230;
                    break;
                }
                case 2: {
                    n5 = 153;
                    break;
                }
                case 3: {
                    n5 = 135;
                    break;
                }
                case 4: {
                    n5 = 203;
                    break;
                }
                case 5: {
                    n5 = 195;
                    break;
                }
                case 6: {
                    n5 = 43;
                    break;
                }
                case 7: {
                    n5 = 134;
                    break;
                }
                case 8: {
                    n5 = 106;
                    break;
                }
                case 9: {
                    n5 = 191;
                    break;
                }
                case 10: {
                    n5 = 182;
                    break;
                }
                case 11: {
                    n5 = 91;
                    break;
                }
                case 12: {
                    n5 = 155;
                    break;
                }
                case 13: {
                    n5 = 124;
                    break;
                }
                case 14: {
                    n5 = 189;
                    break;
                }
                case 15: {
                    n5 = 171;
                    break;
                }
                case 16: {
                    n5 = 62;
                    break;
                }
                case 17: {
                    n5 = 80;
                    break;
                }
                case 18: {
                    n5 = 249;
                    break;
                }
                case 19: {
                    n5 = 114;
                    break;
                }
                case 20: {
                    n5 = 109;
                    break;
                }
                case 21: {
                    n5 = 46;
                    break;
                }
                case 22: {
                    n5 = 76;
                    break;
                }
                case 23: {
                    n5 = 108;
                    break;
                }
                case 24: {
                    n5 = 4;
                    break;
                }
                case 25: {
                    n5 = 240;
                    break;
                }
                case 26: {
                    n5 = 7;
                    break;
                }
                case 27: {
                    n5 = 154;
                    break;
                }
                case 28: {
                    n5 = 99;
                    break;
                }
                case 29: {
                    n5 = 227;
                    break;
                }
                case 30: {
                    n5 = 75;
                    break;
                }
                case 31: {
                    n5 = 79;
                    break;
                }
                case 32: {
                    n5 = 206;
                    break;
                }
                case 33: {
                    n5 = 90;
                    break;
                }
                case 34: {
                    n5 = 147;
                    break;
                }
                case 35: {
                    n5 = 119;
                    break;
                }
                case 36: {
                    n5 = 164;
                    break;
                }
                case 37: {
                    n5 = 29;
                    break;
                }
                case 38: {
                    n5 = 98;
                    break;
                }
                case 39: {
                    n5 = 67;
                    break;
                }
                case 40: {
                    n5 = 38;
                    break;
                }
                case 41: {
                    n5 = 130;
                    break;
                }
                case 42: {
                    n5 = 122;
                    break;
                }
                case 43: {
                    n5 = 215;
                    break;
                }
                case 44: {
                    n5 = 167;
                    break;
                }
                case 45: {
                    n5 = 243;
                    break;
                }
                case 46: {
                    n5 = 208;
                    break;
                }
                case 47: {
                    n5 = 196;
                    break;
                }
                case 48: {
                    n5 = 158;
                    break;
                }
                case 49: {
                    n5 = 18;
                    break;
                }
                case 50: {
                    n5 = 36;
                    break;
                }
                case 51: {
                    n5 = 218;
                    break;
                }
                case 52: {
                    n5 = 128;
                    break;
                }
                case 53: {
                    n5 = 170;
                    break;
                }
                case 54: {
                    n5 = 161;
                    break;
                }
                case 55: {
                    n5 = 121;
                    break;
                }
                case 56: {
                    n5 = 23;
                    break;
                }
                case 57: {
                    n5 = 14;
                    break;
                }
                case 58: {
                    n5 = 183;
                    break;
                }
                case 59: {
                    n5 = 44;
                    break;
                }
                case 60: {
                    n5 = 100;
                    break;
                }
                case 61: {
                    n5 = 172;
                    break;
                }
                case 62: {
                    n5 = 26;
                    break;
                }
                case 63: {
                    n5 = 133;
                    break;
                }
                case 64: {
                    n5 = 214;
                    break;
                }
                case 65: {
                    n5 = 84;
                    break;
                }
                case 66: {
                    n5 = 137;
                    break;
                }
                case 67: {
                    n5 = 198;
                    break;
                }
                case 68: {
                    n5 = 41;
                    break;
                }
                case 69: {
                    n5 = 157;
                    break;
                }
                case 70: {
                    n5 = 83;
                    break;
                }
                case 71: {
                    n5 = 11;
                    break;
                }
                case 72: {
                    n5 = 19;
                    break;
                }
                case 73: {
                    n5 = 31;
                    break;
                }
                case 74: {
                    n5 = 52;
                    break;
                }
                case 75: {
                    n5 = 123;
                    break;
                }
                case 76: {
                    n5 = 166;
                    break;
                }
                case 77: {
                    n5 = 235;
                    break;
                }
                case 78: {
                    n5 = 193;
                    break;
                }
                case 79: {
                    n5 = 173;
                    break;
                }
                case 80: {
                    n5 = 87;
                    break;
                }
                case 81: {
                    n5 = 2;
                    break;
                }
                case 82: {
                    n5 = 35;
                    break;
                }
                case 83: {
                    n5 = 57;
                    break;
                }
                case 84: {
                    n5 = 194;
                    break;
                }
                case 85: {
                    n5 = 89;
                    break;
                }
                case 86: {
                    n5 = 101;
                    break;
                }
                case 87: {
                    n5 = 53;
                    break;
                }
                case 88: {
                    n5 = 32;
                    break;
                }
                case 89: {
                    n5 = 131;
                    break;
                }
                case 90: {
                    n5 = 223;
                    break;
                }
                case 91: {
                    n5 = 217;
                    break;
                }
                case 92: {
                    n5 = 141;
                    break;
                }
                case 93: {
                    n5 = 175;
                    break;
                }
                case 94: {
                    n5 = 126;
                    break;
                }
                case 95: {
                    n5 = 25;
                    break;
                }
                case 96: {
                    n5 = 34;
                    break;
                }
                case 97: {
                    n5 = 65;
                    break;
                }
                case 98: {
                    n5 = 103;
                    break;
                }
                case 99: {
                    n5 = 33;
                    break;
                }
                case 100: {
                    n5 = 66;
                    break;
                }
                case 101: {
                    n5 = 0;
                    break;
                }
                case 102: {
                    n5 = 213;
                    break;
                }
                case 103: {
                    n5 = 221;
                    break;
                }
                case 104: {
                    n5 = 241;
                    break;
                }
                case 105: {
                    n5 = 185;
                    break;
                }
                case 106: {
                    n5 = 231;
                    break;
                }
                case 107: {
                    n5 = 204;
                    break;
                }
                case 108: {
                    n5 = 96;
                    break;
                }
                case 109: {
                    n5 = 93;
                    break;
                }
                case 110: {
                    n5 = 197;
                    break;
                }
                case 111: {
                    n5 = 159;
                    break;
                }
                case 112: {
                    n5 = 48;
                    break;
                }
                case 113: {
                    n5 = 50;
                    break;
                }
                case 114: {
                    n5 = 112;
                    break;
                }
                case 115: {
                    n5 = 144;
                    break;
                }
                case 116: {
                    n5 = 245;
                    break;
                }
                case 117: {
                    n5 = 1;
                    break;
                }
                case 118: {
                    n5 = 70;
                    break;
                }
                case 119: {
                    n5 = 205;
                    break;
                }
                case 120: {
                    n5 = 81;
                    break;
                }
                case 121: {
                    n5 = 162;
                    break;
                }
                case 122: {
                    n5 = 6;
                    break;
                }
                case 123: {
                    n5 = 27;
                    break;
                }
                case 124: {
                    n5 = 211;
                    break;
                }
                case 125: {
                    n5 = 9;
                    break;
                }
                case 126: {
                    n5 = 148;
                    break;
                }
                case 127: {
                    n5 = 139;
                    break;
                }
                case 128: {
                    n5 = 209;
                    break;
                }
                case 129: {
                    n5 = 88;
                    break;
                }
                case 130: {
                    n5 = 212;
                    break;
                }
                case 131: {
                    n5 = 115;
                    break;
                }
                case 132: {
                    n5 = 181;
                    break;
                }
                case 133: {
                    n5 = 47;
                    break;
                }
                case 134: {
                    n5 = 142;
                    break;
                }
                case 135: {
                    n5 = 37;
                    break;
                }
                case 136: {
                    n5 = 5;
                    break;
                }
                case 137: {
                    n5 = 219;
                    break;
                }
                case 138: {
                    n5 = 13;
                    break;
                }
                case 139: {
                    n5 = 236;
                    break;
                }
                case 140: {
                    n5 = 120;
                    break;
                }
                case 141: {
                    n5 = 229;
                    break;
                }
                case 142: {
                    n5 = 202;
                    break;
                }
                case 143: {
                    n5 = 28;
                    break;
                }
                case 144: {
                    n5 = 174;
                    break;
                }
                case 145: {
                    n5 = 180;
                    break;
                }
                case 146: {
                    n5 = 190;
                    break;
                }
                case 147: {
                    n5 = 64;
                    break;
                }
                case 148: {
                    n5 = 254;
                    break;
                }
                case 149: {
                    n5 = 237;
                    break;
                }
                case 150: {
                    n5 = 92;
                    break;
                }
                case 151: {
                    n5 = 69;
                    break;
                }
                case 152: {
                    n5 = 233;
                    break;
                }
                case 153: {
                    n5 = 252;
                    break;
                }
                case 154: {
                    n5 = 113;
                    break;
                }
                case 155: {
                    n5 = 187;
                    break;
                }
                case 156: {
                    n5 = 138;
                    break;
                }
                case 157: {
                    n5 = 253;
                    break;
                }
                case 158: {
                    n5 = 97;
                    break;
                }
                case 159: {
                    n5 = 39;
                    break;
                }
                case 160: {
                    n5 = 136;
                    break;
                }
                case 161: {
                    n5 = 129;
                    break;
                }
                case 162: {
                    n5 = 63;
                    break;
                }
                case 163: {
                    n5 = 72;
                    break;
                }
                case 164: {
                    n5 = 143;
                    break;
                }
                case 165: {
                    n5 = 51;
                    break;
                }
                case 166: {
                    n5 = 224;
                    break;
                }
                case 167: {
                    n5 = 250;
                    break;
                }
                case 168: {
                    n5 = 165;
                    break;
                }
                case 169: {
                    n5 = 207;
                    break;
                }
                case 170: {
                    n5 = 238;
                    break;
                }
                case 171: {
                    n5 = 150;
                    break;
                }
                case 172: {
                    n5 = 179;
                    break;
                }
                case 173: {
                    n5 = 102;
                    break;
                }
                case 174: {
                    n5 = 111;
                    break;
                }
                case 175: {
                    n5 = 132;
                    break;
                }
                case 176: {
                    n5 = 22;
                    break;
                }
                case 177: {
                    n5 = 228;
                    break;
                }
                case 178: {
                    n5 = 242;
                    break;
                }
                case 179: {
                    n5 = 146;
                    break;
                }
                case 180: {
                    n5 = 248;
                    break;
                }
                case 181: {
                    n5 = 118;
                    break;
                }
                case 182: {
                    n5 = 232;
                    break;
                }
                case 183: {
                    n5 = 216;
                    break;
                }
                case 184: {
                    n5 = 78;
                    break;
                }
                case 185: {
                    n5 = 125;
                    break;
                }
                case 186: {
                    n5 = 145;
                    break;
                }
                case 187: {
                    n5 = 152;
                    break;
                }
                case 188: {
                    n5 = 222;
                    break;
                }
                case 189: {
                    n5 = 188;
                    break;
                }
                case 190: {
                    n5 = 127;
                    break;
                }
                case 191: {
                    n5 = 85;
                    break;
                }
                case 192: {
                    n5 = 149;
                    break;
                }
                case 193: {
                    n5 = 105;
                    break;
                }
                case 194: {
                    n5 = 3;
                    break;
                }
                case 195: {
                    n5 = 42;
                    break;
                }
                case 196: {
                    n5 = 20;
                    break;
                }
                case 197: {
                    n5 = 60;
                    break;
                }
                case 198: {
                    n5 = 251;
                    break;
                }
                case 199: {
                    n5 = 201;
                    break;
                }
                case 200: {
                    n5 = 68;
                    break;
                }
                case 201: {
                    n5 = 45;
                    break;
                }
                case 202: {
                    n5 = 246;
                    break;
                }
                case 203: {
                    n5 = 15;
                    break;
                }
                case 204: {
                    n5 = 61;
                    break;
                }
                case 205: {
                    n5 = 16;
                    break;
                }
                case 206: {
                    n5 = 186;
                    break;
                }
                case 207: {
                    n5 = 59;
                    break;
                }
                case 208: {
                    n5 = 40;
                    break;
                }
                case 209: {
                    n5 = 107;
                    break;
                }
                case 210: {
                    n5 = 255;
                    break;
                }
                case 211: {
                    n5 = 239;
                    break;
                }
                case 212: {
                    n5 = 77;
                    break;
                }
                case 213: {
                    n5 = 210;
                    break;
                }
                case 214: {
                    n5 = 116;
                    break;
                }
                case 215: {
                    n5 = 140;
                    break;
                }
                case 216: {
                    n5 = 168;
                    break;
                }
                case 217: {
                    n5 = 234;
                    break;
                }
                case 218: {
                    n5 = 8;
                    break;
                }
                case 219: {
                    n5 = 74;
                    break;
                }
                case 220: {
                    n5 = 192;
                    break;
                }
                case 221: {
                    n5 = 30;
                    break;
                }
                case 222: {
                    n5 = 55;
                    break;
                }
                case 223: {
                    n5 = 184;
                    break;
                }
                case 224: {
                    n5 = 199;
                    break;
                }
                case 225: {
                    n5 = 177;
                    break;
                }
                case 226: {
                    n5 = 169;
                    break;
                }
                case 227: {
                    n5 = 86;
                    break;
                }
                case 228: {
                    n5 = 176;
                    break;
                }
                case 229: {
                    n5 = 17;
                    break;
                }
                case 230: {
                    n5 = 104;
                    break;
                }
                case 231: {
                    n5 = 151;
                    break;
                }
                case 232: {
                    n5 = 24;
                    break;
                }
                case 233: {
                    n5 = 225;
                    break;
                }
                case 234: {
                    n5 = 10;
                    break;
                }
                case 235: {
                    n5 = 54;
                    break;
                }
                case 236: {
                    n5 = 73;
                    break;
                }
                case 237: {
                    n5 = 117;
                    break;
                }
                case 238: {
                    n5 = 156;
                    break;
                }
                case 239: {
                    n5 = 12;
                    break;
                }
                case 240: {
                    n5 = 247;
                    break;
                }
                case 241: {
                    n5 = 49;
                    break;
                }
                case 242: {
                    n5 = 220;
                    break;
                }
                case 243: {
                    n5 = 94;
                    break;
                }
                case 244: {
                    n5 = 163;
                    break;
                }
                case 245: {
                    n5 = 71;
                    break;
                }
                case 246: {
                    n5 = 160;
                    break;
                }
                case 247: {
                    n5 = 110;
                    break;
                }
                case 248: {
                    n5 = 226;
                    break;
                }
                case 249: {
                    n5 = 95;
                    break;
                }
                case 250: {
                    n5 = 244;
                    break;
                }
                case 251: {
                    n5 = 200;
                    break;
                }
                case 252: {
                    n5 = 178;
                    break;
                }
                case 253: {
                    n5 = 21;
                    break;
                }
                case 254: {
                    n5 = 82;
                    break;
                }
                default: {
                    n5 = 56;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            XmlStreamReader.b[n3] = new String(cArray).intern();
        }
        return b[n3];
    }
}

