/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import com.samsarasoftware.license.licenses.SamsaraSoftwareArchitectProductTrialLicense;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.ProxyInputStream;

public class BOMInputStream
extends ProxyInputStream {
    private final boolean include;
    private final List<ByteOrderMark> boms;
    private ByteOrderMark byteOrderMark;
    private int[] firstBytes;
    private int fbLength;
    private int fbIndex;
    private int markFbIndex;
    private boolean markedAtStart;
    private static final String[] a;
    private static final String[] b;

    public BOMInputStream(InputStream inputStream) {
        this(inputStream, false, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, boolean bl) {
        this(inputStream, bl, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, ByteOrderMark ... byteOrderMarkArray) {
        this(inputStream, false, byteOrderMarkArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BOMInputStream(InputStream inputStream, boolean bl, ByteOrderMark ... byteOrderMarkArray) {
        ByteOrderMark[] byteOrderMarkArray2;
        block7: {
            super(inputStream);
            int n = SamsaraSoftwareArchitectProductTrialLicense.c;
            byteOrderMarkArray2 = byteOrderMarkArray;
            if (n != 0 || n != 0) break block7;
            if (byteOrderMarkArray2 == null) throw new IllegalArgumentException(BOMInputStream.a(-11954, -32767));
            byteOrderMarkArray2 = byteOrderMarkArray;
        }
        if (byteOrderMarkArray2.length == 0) {
            throw new IllegalArgumentException(BOMInputStream.a(-11954, -32767));
        }
        this.include = bl;
        this.boms = Arrays.asList(byteOrderMarkArray);
    }

    public boolean hasBOM() throws IOException {
        boolean bl = this.getBOM() != null;
        return bl;
    }

    public boolean hasBOM(ByteOrderMark byteOrderMark) throws IOException {
        boolean bl;
        block18: {
            block17: {
                ByteOrderMark byteOrderMark2;
                int n;
                block16: {
                    BOMInputStream bOMInputStream;
                    block14: {
                        block15: {
                            n = SamsaraSoftwareArchitectProductTrialLicense.c;
                            bOMInputStream = this;
                            if (n != 0) break block14;
                            if (bOMInputStream.boms.contains(byteOrderMark)) break block15;
                            throw new IllegalArgumentException(BOMInputStream.a(-11953, 28585) + byteOrderMark);
                        }
                        bOMInputStream = this;
                    }
                    byteOrderMark2 = bOMInputStream.byteOrderMark;
                    if (n != 0 || n != 0) break block16;
                    if (byteOrderMark2 == null) break block17;
                    byteOrderMark2 = this.getBOM();
                }
                bl = byteOrderMark2.equals(byteOrderMark);
                if (n != 0 || n != 0) break block18;
                if (!bl) break block17;
                bl = true;
                break block18;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteOrderMark getBOM() throws IOException {
        int n = SamsaraSoftwareArchitectProductTrialLicense.c;
        BOMInputStream bOMInputStream = this;
        if (n != 0) return bOMInputStream.byteOrderMark;
        if (bOMInputStream.firstBytes != null) {
            bOMInputStream = this;
            if (n == 0) {
                return bOMInputStream.byteOrderMark;
            }
        } else {
            bOMInputStream = this;
        }
        block14: do {
            block28: {
                bOMInputStream.fbLength = 0;
                int n2 = 0;
                for (ByteOrderMark byteOrderMark : this.boms) {
                    n2 = Math.max(n2, byteOrderMark.length());
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break block28;
                }
                this.firstBytes = new int[n2];
            }
            int n3 = 0;
            while (n3 < this.firstBytes.length) {
                block30: {
                    block32: {
                        BOMInputStream bOMInputStream2;
                        block31: {
                            block29: {
                                this.firstBytes[n3] = this.in.read();
                                ++this.fbLength;
                                bOMInputStream = this;
                                if (n != 0) continue block14;
                                if (n != 0) break block29;
                                if (bOMInputStream.firstBytes[n3] < 0 && n == 0) break;
                                this.byteOrderMark = this.find();
                                if (n != 0) break block30;
                                bOMInputStream2 = this;
                                if (n != 0) break block31;
                            }
                            if (bOMInputStream2.byteOrderMark == null) break block32;
                            bOMInputStream2 = this;
                        }
                        if (n == 0) {
                            if (n != 0) return bOMInputStream.byteOrderMark;
                            if (bOMInputStream2.include) break;
                            bOMInputStream2 = this;
                        }
                        bOMInputStream2.fbLength = 0;
                        if (n == 0) break;
                    }
                    ++n3;
                }
                if (n == 0) continue;
            }
            bOMInputStream = this;
        } while (n != 0);
        return bOMInputStream.byteOrderMark;
    }

    public String getBOMCharsetName() throws IOException {
        String string;
        block6: {
            ByteOrderMark byteOrderMark;
            block4: {
                block5: {
                    this.getBOM();
                    int n = SamsaraSoftwareArchitectProductTrialLicense.c;
                    byteOrderMark = this.byteOrderMark;
                    if (n != 0) break block4;
                    if (byteOrderMark != null) break block5;
                    string = null;
                    break block6;
                }
                byteOrderMark = this.byteOrderMark;
            }
            string = byteOrderMark.getCharsetName();
        }
        return string;
    }

    private int readFirstBytes() throws IOException {
        int n;
        block6: {
            block7: {
                this.getBOM();
                int n2 = SamsaraSoftwareArchitectProductTrialLicense.c;
                n = this.fbIndex;
                if (n2 != 0 || n2 != 0) break block6;
                if (n >= this.fbLength) break block7;
                n = this.firstBytes[this.fbIndex++];
                break block6;
            }
            n = -1;
        }
        return n;
    }

    private ByteOrderMark find() {
        Iterator<ByteOrderMark> iterator = this.boms.iterator();
        int n = SamsaraSoftwareArchitectProductTrialLicense.c;
        while (iterator.hasNext()) {
            ByteOrderMark byteOrderMark = iterator.next();
            if (this.matches(byteOrderMark)) {
                return byteOrderMark;
            }
            if (n == 0) continue;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matches(ByteOrderMark byteOrderMark) {
        int n;
        int n2;
        block13: {
            block14: {
                n2 = SamsaraSoftwareArchitectProductTrialLicense.c;
                n = byteOrderMark.length();
                if (n2 != 0) break block13;
                if (n == this.fbLength) break block14;
                return 0 != 0;
            }
            n = 0;
            if (n2 != 0) return n != 0;
        }
        int n3 = n;
        do {
            block15: {
                boolean bl;
                if (n3 >= byteOrderMark.length()) return 1 != 0;
                int n4 = byteOrderMark.get(n3);
                if (n2 != 0) return n4 != 0;
                if (n2 != 0) return bl;
                if (n2 != 0) return bl;
                if (n4 == this.firstBytes[n3]) break block15;
                return false;
            }
            ++n3;
        } while (n2 == 0);
        return 1 != 0;
    }

    public int read() throws IOException {
        int n;
        block4: {
            block5: {
                int n2 = this.readFirstBytes();
                int n3 = SamsaraSoftwareArchitectProductTrialLicense.c;
                n = n2;
                if (n3 != 0 || n3 != 0) break block4;
                if (n < 0) break block5;
                n = n2;
                break block4;
            }
            n = this.in.read();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        block19: {
            block17: {
                block18: {
                    block16: {
                        var5_4 = 0;
                        var4_5 = SamsaraSoftwareArchitectProductTrialLicense.c;
                        var6_6 = 0;
                        block10: while (true) {
                            v0 = var3_3;
                            while (v0 > 0) {
                                v1 = var6_6;
                                if (var4_5 != 0 || var4_5 != 0) break block16;
                                if (v1 < 0) break block10;
                                var6_6 = this.readFirstBytes();
                                if (var4_5 == 0) {
                                    v0 = var6_6;
                                }
                                ** GOTO lbl31
lbl26:
                                // 2 sources

                                while (var4_5 == 0) {
                                    if (v0 < 0) continue block10;
                                    var1_1[var2_2++] = (byte)(var6_6 & 255);
                                    --var3_3;
                                    ++var5_4;
lbl31:
                                    // 2 sources

                                    if (var4_5 != 0) break block10;
                                    continue block10;
                                }
                            }
                            break;
                        }
                        v1 = this.in.read(var1_1, var2_2, var3_3);
                    }
                    v5 = var7_7 = v1;
                    if (var4_5 != 0) ** GOTO lbl26
                    if (var4_5 != 0) break block17;
                    if (v5 >= 0) break block18;
                    v7 = var5_4;
lbl46:
                    // 2 sources

                    while (true) {
                        block20: {
                            if (var4_5 != 0) break block19;
                            if (v7 <= 0) break block20;
                            v7 = var5_4;
                            break block19;
                        }
                        v7 = -1;
                        if (var4_5 == 0) {
                            // empty if block
                        }
                        break block19;
                        break;
                    }
                }
                v7 = var5_4;
                ** while (var4_5 != 0)
            }
            v7 = v7 + var7_7;
        }
        return v7;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized void mark(int n) {
        int n2;
        block6: {
            block7: {
                int n3 = SamsaraSoftwareArchitectProductTrialLicense.c;
                BOMInputStream bOMInputStream = this;
                n2 = this.fbIndex;
                if (n3 != 0 || n3 != 0) break block6;
                bOMInputStream.markFbIndex = n2;
                bOMInputStream = this;
                if (this.firstBytes != null) break block7;
                n2 = 1;
                break block6;
            }
            n2 = 0;
        }
        bOMInputStream.markedAtStart = n2;
        this.in.mark(n);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reset() throws IOException {
        InputStream inputStream;
        block3: {
            BOMInputStream bOMInputStream;
            block6: {
                int n;
                block5: {
                    block4: {
                        this.fbIndex = this.markFbIndex;
                        n = SamsaraSoftwareArchitectProductTrialLicense.c;
                        inputStream = this;
                        if (n != 0) break block3;
                        if (inputStream.markedAtStart) break block4;
                        bOMInputStream = this;
                        if (n != 0) break block5;
                        break block6;
                    }
                    bOMInputStream = this;
                }
                do {
                    bOMInputStream.firstBytes = null;
                    bOMInputStream = this;
                } while (n != 0);
            }
            inputStream = bOMInputStream.in;
        }
        ((InputStream)inputStream).reset();
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long var1_1) throws IOException {
        var3_2 = SamsaraSoftwareArchitectProductTrialLicense.c;
        block6: while (var1_1 > 0L) {
            v0 = this;
            if (var3_2 == 0 && var3_2 == 0) {
            }
            ** GOTO lbl25
            if (super.readFirstBytes() >= 0) {
            }
            ** GOTO lbl24
            v3 = var1_1 - 1L;
            do {
                var1_1 = v3;
                if (var3_2 == 0) continue block6;
lbl24:
                // 3 sources

                v0 = this.in;
lbl25:
                // 2 sources

                v3 = v0.skip(var1_1);
            } while (var3_2 != 0);
        }
        return v3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = "\u00f1OW\u00bc\u001f N\u001c\u00c3\u0019\u0095\u00a0\u00e2\u0005\u00ad\u000b[\u001f\u008a\u00e7\u00d4\u00f6Y\u008a>#\u00e8}*\u00a8\u00fe\f\u00e7/\u00ffA\u0098fw\u00ad\u00c1\u00a1K\u00eb\u0005\u00a9\u00e5\u00ec]";
        int n2 = "\u00f1OW\u00bc\u001f N\u001c\u00c3\u0019\u0095\u00a0\u00e2\u0005\u00ad\u000b[\u001f\u008a\u00e7\u00d4\u00f6Y\u008a>#\u00e8}*\u00a8\u00fe\f\u00e7/\u00ffA\u0098fw\u00ad\u00c1\u00a1K\u00eb\u0005\u00a9\u00e5\u00ec]".length();
        int n3 = 17;
        int n4 = -1;
        while (true) {
            char[] cArray;
            block14: {
                int n5;
                int n6;
                char[] cArray2;
                int n7;
                block13: {
                    int n8 = ++n4;
                    Object var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                    n7 = 0;
                    int n9 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n9;
                    if (n9 <= 1) break block13;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n7) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n10 = n7;
                    while (true) {
                        int n11;
                        char c = cArray4[n10];
                        switch (n7 % 7) {
                            case 0: {
                                n11 = 23;
                                break;
                            }
                            case 1: {
                                n11 = 7;
                                break;
                            }
                            case 2: {
                                n11 = 44;
                                break;
                            }
                            case 3: {
                                n11 = 117;
                                break;
                            }
                            case 4: {
                                n11 = 27;
                                break;
                            }
                            case 5: {
                                n11 = 94;
                                break;
                            }
                            default: {
                                n11 = 27;
                            }
                        }
                        cArray4[n10] = (char)(c ^ n11);
                        ++n7;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n10 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n7);
            }
            stringArray[n++] = new String(cArray).intern();
            if ((n4 += n3) >= n2) {
                a = stringArray;
                b = new String[2];
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFD14E) & 0xFFFF;
        if (b[n3] == null) {
            int n4;
            int n5;
            char[] cArray = a[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 200;
                    break;
                }
                case 1: {
                    n5 = 221;
                    break;
                }
                case 2: {
                    n5 = 242;
                    break;
                }
                case 3: {
                    n5 = 121;
                    break;
                }
                case 4: {
                    n5 = 21;
                    break;
                }
                case 5: {
                    n5 = 66;
                    break;
                }
                case 6: {
                    n5 = 92;
                    break;
                }
                case 7: {
                    n5 = 156;
                    break;
                }
                case 8: {
                    n5 = 211;
                    break;
                }
                case 9: {
                    n5 = 71;
                    break;
                }
                case 10: {
                    n5 = 82;
                    break;
                }
                case 11: {
                    n5 = 123;
                    break;
                }
                case 12: {
                    n5 = 176;
                    break;
                }
                case 13: {
                    n5 = 206;
                    break;
                }
                case 14: {
                    n5 = 136;
                    break;
                }
                case 15: {
                    n5 = 196;
                    break;
                }
                case 16: {
                    n5 = 141;
                    break;
                }
                case 17: {
                    n5 = 168;
                    break;
                }
                case 18: {
                    n5 = 108;
                    break;
                }
                case 19: {
                    n5 = 69;
                    break;
                }
                case 20: {
                    n5 = 93;
                    break;
                }
                case 21: {
                    n5 = 125;
                    break;
                }
                case 22: {
                    n5 = 106;
                    break;
                }
                case 23: {
                    n5 = 126;
                    break;
                }
                case 24: {
                    n5 = 208;
                    break;
                }
                case 25: {
                    n5 = 28;
                    break;
                }
                case 26: {
                    n5 = 67;
                    break;
                }
                case 27: {
                    n5 = 90;
                    break;
                }
                case 28: {
                    n5 = 39;
                    break;
                }
                case 29: {
                    n5 = 20;
                    break;
                }
                case 30: {
                    n5 = 173;
                    break;
                }
                case 31: {
                    n5 = 59;
                    break;
                }
                case 32: {
                    n5 = 228;
                    break;
                }
                case 33: {
                    n5 = 253;
                    break;
                }
                case 34: {
                    n5 = 148;
                    break;
                }
                case 35: {
                    n5 = 1;
                    break;
                }
                case 36: {
                    n5 = 236;
                    break;
                }
                case 37: {
                    n5 = 216;
                    break;
                }
                case 38: {
                    n5 = 87;
                    break;
                }
                case 39: {
                    n5 = 227;
                    break;
                }
                case 40: {
                    n5 = 110;
                    break;
                }
                case 41: {
                    n5 = 134;
                    break;
                }
                case 42: {
                    n5 = 13;
                    break;
                }
                case 43: {
                    n5 = 83;
                    break;
                }
                case 44: {
                    n5 = 160;
                    break;
                }
                case 45: {
                    n5 = 243;
                    break;
                }
                case 46: {
                    n5 = 57;
                    break;
                }
                case 47: {
                    n5 = 230;
                    break;
                }
                case 48: {
                    n5 = 109;
                    break;
                }
                case 49: {
                    n5 = 49;
                    break;
                }
                case 50: {
                    n5 = 204;
                    break;
                }
                case 51: {
                    n5 = 172;
                    break;
                }
                case 52: {
                    n5 = 94;
                    break;
                }
                case 53: {
                    n5 = 104;
                    break;
                }
                case 54: {
                    n5 = 45;
                    break;
                }
                case 55: {
                    n5 = 117;
                    break;
                }
                case 56: {
                    n5 = 151;
                    break;
                }
                case 57: {
                    n5 = 50;
                    break;
                }
                case 58: {
                    n5 = 250;
                    break;
                }
                case 59: {
                    n5 = 122;
                    break;
                }
                case 60: {
                    n5 = 75;
                    break;
                }
                case 61: {
                    n5 = 48;
                    break;
                }
                case 62: {
                    n5 = 248;
                    break;
                }
                case 63: {
                    n5 = 73;
                    break;
                }
                case 64: {
                    n5 = 150;
                    break;
                }
                case 65: {
                    n5 = 222;
                    break;
                }
                case 66: {
                    n5 = 238;
                    break;
                }
                case 67: {
                    n5 = 255;
                    break;
                }
                case 68: {
                    n5 = 163;
                    break;
                }
                case 69: {
                    n5 = 72;
                    break;
                }
                case 70: {
                    n5 = 0;
                    break;
                }
                case 71: {
                    n5 = 9;
                    break;
                }
                case 72: {
                    n5 = 64;
                    break;
                }
                case 73: {
                    n5 = 127;
                    break;
                }
                case 74: {
                    n5 = 74;
                    break;
                }
                case 75: {
                    n5 = 188;
                    break;
                }
                case 76: {
                    n5 = 180;
                    break;
                }
                case 77: {
                    n5 = 103;
                    break;
                }
                case 78: {
                    n5 = 23;
                    break;
                }
                case 79: {
                    n5 = 145;
                    break;
                }
                case 80: {
                    n5 = 175;
                    break;
                }
                case 81: {
                    n5 = 181;
                    break;
                }
                case 82: {
                    n5 = 55;
                    break;
                }
                case 83: {
                    n5 = 197;
                    break;
                }
                case 84: {
                    n5 = 140;
                    break;
                }
                case 85: {
                    n5 = 186;
                    break;
                }
                case 86: {
                    n5 = 95;
                    break;
                }
                case 87: {
                    n5 = 177;
                    break;
                }
                case 88: {
                    n5 = 234;
                    break;
                }
                case 89: {
                    n5 = 112;
                    break;
                }
                case 90: {
                    n5 = 209;
                    break;
                }
                case 91: {
                    n5 = 61;
                    break;
                }
                case 92: {
                    n5 = 157;
                    break;
                }
                case 93: {
                    n5 = 12;
                    break;
                }
                case 94: {
                    n5 = 237;
                    break;
                }
                case 95: {
                    n5 = 247;
                    break;
                }
                case 96: {
                    n5 = 220;
                    break;
                }
                case 97: {
                    n5 = 98;
                    break;
                }
                case 98: {
                    n5 = 158;
                    break;
                }
                case 99: {
                    n5 = 25;
                    break;
                }
                case 100: {
                    n5 = 203;
                    break;
                }
                case 101: {
                    n5 = 147;
                    break;
                }
                case 102: {
                    n5 = 146;
                    break;
                }
                case 103: {
                    n5 = 31;
                    break;
                }
                case 104: {
                    n5 = 19;
                    break;
                }
                case 105: {
                    n5 = 212;
                    break;
                }
                case 106: {
                    n5 = 132;
                    break;
                }
                case 107: {
                    n5 = 40;
                    break;
                }
                case 108: {
                    n5 = 128;
                    break;
                }
                case 109: {
                    n5 = 6;
                    break;
                }
                case 110: {
                    n5 = 43;
                    break;
                }
                case 111: {
                    n5 = 133;
                    break;
                }
                case 112: {
                    n5 = 119;
                    break;
                }
                case 113: {
                    n5 = 169;
                    break;
                }
                case 114: {
                    n5 = 207;
                    break;
                }
                case 115: {
                    n5 = 32;
                    break;
                }
                case 116: {
                    n5 = 46;
                    break;
                }
                case 117: {
                    n5 = 187;
                    break;
                }
                case 118: {
                    n5 = 3;
                    break;
                }
                case 119: {
                    n5 = 60;
                    break;
                }
                case 120: {
                    n5 = 241;
                    break;
                }
                case 121: {
                    n5 = 202;
                    break;
                }
                case 122: {
                    n5 = 137;
                    break;
                }
                case 123: {
                    n5 = 138;
                    break;
                }
                case 124: {
                    n5 = 26;
                    break;
                }
                case 125: {
                    n5 = 113;
                    break;
                }
                case 126: {
                    n5 = 129;
                    break;
                }
                case 127: {
                    n5 = 214;
                    break;
                }
                case 128: {
                    n5 = 30;
                    break;
                }
                case 129: {
                    n5 = 10;
                    break;
                }
                case 130: {
                    n5 = 164;
                    break;
                }
                case 131: {
                    n5 = 171;
                    break;
                }
                case 132: {
                    n5 = 36;
                    break;
                }
                case 133: {
                    n5 = 130;
                    break;
                }
                case 134: {
                    n5 = 8;
                    break;
                }
                case 135: {
                    n5 = 116;
                    break;
                }
                case 136: {
                    n5 = 179;
                    break;
                }
                case 137: {
                    n5 = 225;
                    break;
                }
                case 138: {
                    n5 = 120;
                    break;
                }
                case 139: {
                    n5 = 192;
                    break;
                }
                case 140: {
                    n5 = 170;
                    break;
                }
                case 141: {
                    n5 = 27;
                    break;
                }
                case 142: {
                    n5 = 244;
                    break;
                }
                case 143: {
                    n5 = 155;
                    break;
                }
                case 144: {
                    n5 = 54;
                    break;
                }
                case 145: {
                    n5 = 84;
                    break;
                }
                case 146: {
                    n5 = 35;
                    break;
                }
                case 147: {
                    n5 = 142;
                    break;
                }
                case 148: {
                    n5 = 107;
                    break;
                }
                case 149: {
                    n5 = 24;
                    break;
                }
                case 150: {
                    n5 = 91;
                    break;
                }
                case 151: {
                    n5 = 111;
                    break;
                }
                case 152: {
                    n5 = 235;
                    break;
                }
                case 153: {
                    n5 = 159;
                    break;
                }
                case 154: {
                    n5 = 77;
                    break;
                }
                case 155: {
                    n5 = 16;
                    break;
                }
                case 156: {
                    n5 = 22;
                    break;
                }
                case 157: {
                    n5 = 219;
                    break;
                }
                case 158: {
                    n5 = 29;
                    break;
                }
                case 159: {
                    n5 = 37;
                    break;
                }
                case 160: {
                    n5 = 217;
                    break;
                }
                case 161: {
                    n5 = 11;
                    break;
                }
                case 162: {
                    n5 = 56;
                    break;
                }
                case 163: {
                    n5 = 239;
                    break;
                }
                case 164: {
                    n5 = 165;
                    break;
                }
                case 165: {
                    n5 = 215;
                    break;
                }
                case 166: {
                    n5 = 153;
                    break;
                }
                case 167: {
                    n5 = 184;
                    break;
                }
                case 168: {
                    n5 = 62;
                    break;
                }
                case 169: {
                    n5 = 81;
                    break;
                }
                case 170: {
                    n5 = 99;
                    break;
                }
                case 171: {
                    n5 = 86;
                    break;
                }
                case 172: {
                    n5 = 223;
                    break;
                }
                case 173: {
                    n5 = 185;
                    break;
                }
                case 174: {
                    n5 = 205;
                    break;
                }
                case 175: {
                    n5 = 100;
                    break;
                }
                case 176: {
                    n5 = 53;
                    break;
                }
                case 177: {
                    n5 = 135;
                    break;
                }
                case 178: {
                    n5 = 115;
                    break;
                }
                case 179: {
                    n5 = 178;
                    break;
                }
                case 180: {
                    n5 = 68;
                    break;
                }
                case 181: {
                    n5 = 183;
                    break;
                }
                case 182: {
                    n5 = 144;
                    break;
                }
                case 183: {
                    n5 = 76;
                    break;
                }
                case 184: {
                    n5 = 101;
                    break;
                }
                case 185: {
                    n5 = 167;
                    break;
                }
                case 186: {
                    n5 = 249;
                    break;
                }
                case 187: {
                    n5 = 189;
                    break;
                }
                case 188: {
                    n5 = 139;
                    break;
                }
                case 189: {
                    n5 = 152;
                    break;
                }
                case 190: {
                    n5 = 231;
                    break;
                }
                case 191: {
                    n5 = 233;
                    break;
                }
                case 192: {
                    n5 = 15;
                    break;
                }
                case 193: {
                    n5 = 174;
                    break;
                }
                case 194: {
                    n5 = 194;
                    break;
                }
                case 195: {
                    n5 = 17;
                    break;
                }
                case 196: {
                    n5 = 97;
                    break;
                }
                case 197: {
                    n5 = 149;
                    break;
                }
                case 198: {
                    n5 = 226;
                    break;
                }
                case 199: {
                    n5 = 232;
                    break;
                }
                case 200: {
                    n5 = 79;
                    break;
                }
                case 201: {
                    n5 = 190;
                    break;
                }
                case 202: {
                    n5 = 252;
                    break;
                }
                case 203: {
                    n5 = 63;
                    break;
                }
                case 204: {
                    n5 = 161;
                    break;
                }
                case 205: {
                    n5 = 14;
                    break;
                }
                case 206: {
                    n5 = 5;
                    break;
                }
                case 207: {
                    n5 = 143;
                    break;
                }
                case 208: {
                    n5 = 70;
                    break;
                }
                case 209: {
                    n5 = 18;
                    break;
                }
                case 210: {
                    n5 = 34;
                    break;
                }
                case 211: {
                    n5 = 195;
                    break;
                }
                case 212: {
                    n5 = 80;
                    break;
                }
                case 213: {
                    n5 = 105;
                    break;
                }
                case 214: {
                    n5 = 240;
                    break;
                }
                case 215: {
                    n5 = 166;
                    break;
                }
                case 216: {
                    n5 = 210;
                    break;
                }
                case 217: {
                    n5 = 41;
                    break;
                }
                case 218: {
                    n5 = 118;
                    break;
                }
                case 219: {
                    n5 = 198;
                    break;
                }
                case 220: {
                    n5 = 254;
                    break;
                }
                case 221: {
                    n5 = 58;
                    break;
                }
                case 222: {
                    n5 = 114;
                    break;
                }
                case 223: {
                    n5 = 229;
                    break;
                }
                case 224: {
                    n5 = 47;
                    break;
                }
                case 225: {
                    n5 = 7;
                    break;
                }
                case 226: {
                    n5 = 102;
                    break;
                }
                case 227: {
                    n5 = 201;
                    break;
                }
                case 228: {
                    n5 = 154;
                    break;
                }
                case 229: {
                    n5 = 42;
                    break;
                }
                case 230: {
                    n5 = 89;
                    break;
                }
                case 231: {
                    n5 = 191;
                    break;
                }
                case 232: {
                    n5 = 4;
                    break;
                }
                case 233: {
                    n5 = 85;
                    break;
                }
                case 234: {
                    n5 = 44;
                    break;
                }
                case 235: {
                    n5 = 131;
                    break;
                }
                case 236: {
                    n5 = 245;
                    break;
                }
                case 237: {
                    n5 = 52;
                    break;
                }
                case 238: {
                    n5 = 96;
                    break;
                }
                case 239: {
                    n5 = 124;
                    break;
                }
                case 240: {
                    n5 = 213;
                    break;
                }
                case 241: {
                    n5 = 51;
                    break;
                }
                case 242: {
                    n5 = 65;
                    break;
                }
                case 243: {
                    n5 = 182;
                    break;
                }
                case 244: {
                    n5 = 2;
                    break;
                }
                case 245: {
                    n5 = 218;
                    break;
                }
                case 246: {
                    n5 = 38;
                    break;
                }
                case 247: {
                    n5 = 33;
                    break;
                }
                case 248: {
                    n5 = 199;
                    break;
                }
                case 249: {
                    n5 = 78;
                    break;
                }
                case 250: {
                    n5 = 193;
                    break;
                }
                case 251: {
                    n5 = 88;
                    break;
                }
                case 252: {
                    n5 = 162;
                    break;
                }
                case 253: {
                    n5 = 246;
                    break;
                }
                case 254: {
                    n5 = 251;
                    break;
                }
                default: {
                    n5 = 224;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            BOMInputStream.b[n3] = new String(cArray).intern();
        }
        return b[n3];
    }
}

