/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import com.samsarasoftware.license.ui.UIFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS;
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static char[] SKIP_CHAR_BUFFER;
    private static byte[] SKIP_BYTE_BUFFER;
    private static final String[] a;
    private static final String[] b;

    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    public static void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        boolean bl = UIFactory.b;
        try {
            Closeable closeable2 = closeable;
            if (!bl && !bl) {
                if (closeable2 == null) return;
                closeable2 = closeable;
            }
            closeable2.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void closeQuietly(Socket var0) {
        block6: {
            block7: {
                var1_1 = UIFactory.b;
                v0 = var0;
                if (var1_1) ** GOTO lbl17
                if (var1_1) ** GOTO lbl17
                break block7;
                catch (IOException v1) {
                    throw v1;
                }
            }
            if (v0 == null) break block6;
            try {
                v0 = var0;
lbl17:
                // 3 sources

                v0.close();
            }
            catch (IOException var2_2) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void closeQuietly(Selector var0) {
        block6: {
            block7: {
                var1_1 = UIFactory.b;
                v0 = var0;
                if (var1_1) ** GOTO lbl17
                if (var1_1) ** GOTO lbl17
                break block7;
                catch (IOException v1) {
                    throw v1;
                }
            }
            if (v0 == null) break block6;
            try {
                v0 = var0;
lbl17:
                // 3 sources

                v0.close();
            }
            catch (IOException var2_2) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void closeQuietly(ServerSocket var0) {
        block6: {
            block7: {
                var1_1 = UIFactory.b;
                v0 = var0;
                if (var1_1) ** GOTO lbl17
                if (var1_1) ** GOTO lbl17
                break block7;
                catch (IOException v1) {
                    throw v1;
                }
            }
            if (v0 == null) break block6;
            try {
                v0 = var0;
lbl17:
                // 3 sources

                v0.close();
            }
            catch (IOException var2_2) {
                // empty catch block
            }
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        BufferedReader bufferedReader;
        block8: {
            block7: {
                Reader reader2;
                block6: {
                    boolean bl = UIFactory.b;
                    reader2 = reader;
                    if (bl || bl) break block6;
                    if (!(reader2 instanceof BufferedReader)) break block7;
                    reader2 = reader;
                }
                bufferedReader = (BufferedReader)reader2;
                break block8;
            }
            bufferedReader = new BufferedReader(reader);
        }
        return bufferedReader;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(InputStream inputStream, long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(IOUtils.a(4943, -17547) + l);
        }
        return IOUtils.toByteArray(inputStream, (int)l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        block17: {
            int n5;
            boolean bl = UIFactory.b;
            int n6 = n;
            if (!bl) {
                if (n6 < 0) {
                    throw new IllegalArgumentException(IOUtils.a(4931, 13234) + n);
                }
                n6 = n;
            }
            if (!bl) {
                if (n6 == 0) {
                    n5 = 0;
                    return new byte[n5];
                }
                n6 = n;
            }
            byArray = new byte[n6];
            n5 = 0;
            if (bl) return new byte[n5];
            n4 = n5;
            while (n4 < n) {
                int n7;
                int n8;
                n3 = inputStream.read(byArray, n4, n - n4);
                n2 = -1;
                if (bl) break block17;
                if (!bl) {
                    int n9;
                    if (bl) break block17;
                    if (n3 == n2) break;
                    n8 = n4;
                    n7 = n9;
                }
                n4 = n8 + n7;
                if (!bl) continue;
            }
            n3 = n4;
            n2 = n;
        }
        if (n3 == n2) return byArray;
        throw new IOException(IOUtils.a(4938, 21136) + n4 + IOUtils.a(4939, 17618) + n);
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    @Deprecated
    public static byte[] toByteArray(String string) throws IOException {
        return string.getBytes();
    }

    public static char[] toCharArray(InputStream inputStream) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, charArrayWriter, string);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        IOUtils.copy(inputStream, stringBuilderWriter, string);
        return stringBuilderWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        IOUtils.copy(reader, (Writer)stringBuilderWriter);
        return stringBuilderWriter.toString();
    }

    public static String toString(URI uRI) throws IOException {
        return IOUtils.toString(uRI, null);
    }

    public static String toString(URI uRI, String string) throws IOException {
        return IOUtils.toString(uRI.toURL(), string);
    }

    public static String toString(URL uRL) throws IOException {
        return IOUtils.toString(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(URL uRL, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            String string2 = IOUtils.toString(inputStream, string);
            return string2;
        }
        finally {
            inputStream.close();
        }
    }

    @Deprecated
    public static String toString(byte[] byArray) throws IOException {
        return new String(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static String toString(byte[] byArray, String string) throws IOException {
        boolean bl = UIFactory.b;
        String string2 = string;
        if (bl) return string2;
        if (string2 == null) {
            string2 = new String(byArray);
            return string2;
        }
        string2 = new String(byArray, string);
        if (!bl) return string2;
        return string2;
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return IOUtils.readLines(inputStreamReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(InputStream inputStream, String string) throws IOException {
        List<String> list;
        boolean bl = UIFactory.b;
        if (string == null) {
            list = IOUtils.readLines(inputStream);
            return list;
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            list = IOUtils.readLines(inputStreamReader);
            if (bl) return list;
            return list;
        }
    }

    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> arrayList;
        block2: {
            BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
            boolean bl = UIFactory.b;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList = arrayList2;
                if (!bl) {
                    arrayList.add(string);
                    string = bufferedReader.readLine();
                    if (!bl) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LineIterator lineIterator(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader;
        InputStreamReader inputStreamReader2 = null;
        boolean bl = UIFactory.b;
        if (string == null) {
            inputStreamReader = new InputStreamReader(inputStream);
        } else {
            inputStreamReader = new InputStreamReader(inputStream, string);
            if (!bl) {
                inputStreamReader2 = inputStreamReader;
                return new LineIterator(inputStreamReader2);
            }
        }
        inputStreamReader2 = inputStreamReader;
        return new LineIterator(inputStreamReader2);
    }

    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(((Object)charSequence).toString());
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) throws IOException {
        return IOUtils.toInputStream(((Object)charSequence).toString(), string);
    }

    public static InputStream toInputStream(String string) {
        byte[] byArray = string.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    /*
     * Unable to fully structure code
     */
    public static InputStream toInputStream(String var0, String var1_1) throws IOException {
        block5: {
            block3: {
                block4: {
                    var2_2 = UIFactory.b;
                    v0 = var1_1;
                    if (var2_2) break block3;
                    if (v0 == null) break block4;
                    v0 = var0;
lbl10:
                    // 2 sources

                    while (true) {
                        v2 = v0.getBytes(var1_1);
                        break block5;
                        break;
                    }
                }
                v0 = var0;
                ** while (var2_2)
            }
            v2 = v0.getBytes();
        }
        var3_3 = v2;
        return new ByteArrayInputStream(var3_3);
    }

    public static void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) throws IOException {
        if (byArray != null) {
            writer.write(new String(byArray));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) throws IOException {
        block6: {
            block7: {
                boolean bl = UIFactory.b;
                if (byArray == null) break block6;
                if (string != null) break block7;
                IOUtils.write(byArray, writer);
                if (!bl) break block6;
            }
            writer.write(new String(byArray, string));
        }
    }

    public static void write(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream) throws IOException {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes());
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) throws IOException {
        block6: {
            block7: {
                boolean bl = UIFactory.b;
                if (cArray == null) break block6;
                if (string != null) break block7;
                IOUtils.write(cArray, outputStream);
                if (!bl) break block6;
            }
            outputStream.write(new String(cArray).getBytes(string));
        }
    }

    public static void write(CharSequence charSequence, Writer writer) throws IOException {
        block5: {
            CharSequence charSequence2;
            block4: {
                boolean bl = UIFactory.b;
                charSequence2 = charSequence;
                if (bl || bl) break block4;
                if (charSequence2 == null) break block5;
                charSequence2 = charSequence;
            }
            IOUtils.write(((Object)charSequence2).toString(), writer);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream) throws IOException {
        block5: {
            CharSequence charSequence2;
            block4: {
                boolean bl = UIFactory.b;
                charSequence2 = charSequence;
                if (bl || bl) break block4;
                if (charSequence2 == null) break block5;
                charSequence2 = charSequence;
            }
            IOUtils.write(((Object)charSequence2).toString(), outputStream);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) throws IOException {
        block5: {
            CharSequence charSequence2;
            block4: {
                boolean bl = UIFactory.b;
                charSequence2 = charSequence;
                if (bl || bl) break block4;
                if (charSequence2 == null) break block5;
                charSequence2 = charSequence;
            }
            IOUtils.write(((Object)charSequence2).toString(), outputStream, string);
        }
    }

    public static void write(String string, Writer writer) throws IOException {
        if (string != null) {
            writer.write(string);
        }
    }

    public static void write(String string, OutputStream outputStream) throws IOException {
        if (string != null) {
            outputStream.write(string.getBytes());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(String string, OutputStream outputStream, String string2) throws IOException {
        block10: {
            String string3;
            boolean bl;
            block9: {
                block8: {
                    block7: {
                        bl = UIFactory.b;
                        string3 = string;
                        if (bl) break block7;
                        if (bl) break block8;
                        if (string3 == null) return;
                        string3 = string2;
                    }
                    if (bl) break block9;
                }
                if (bl) break block9;
                if (string3 != null) break block10;
                string3 = string;
            }
            IOUtils.write(string3, outputStream);
            if (!bl) return;
        }
        outputStream.write(string.getBytes(string2));
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) throws IOException {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes());
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) throws IOException {
        block6: {
            block7: {
                boolean bl = UIFactory.b;
                if (stringBuffer == null) break block6;
                if (string != null) break block7;
                IOUtils.write(stringBuffer, outputStream);
                if (!bl) break block6;
            }
            outputStream.write(stringBuffer.toString().getBytes(string));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream) throws IOException {
        boolean bl;
        block12: {
            String string2;
            block11: {
                bl = UIFactory.b;
                if (collection == null) {
                    return;
                }
                string2 = string;
                if (bl || bl) break block11;
                if (string2 != null) break block12;
                string2 = LINE_SEPARATOR;
            }
            string = string2;
        }
        for (Object obj : collection) {
            block13: {
                byte[] byArray;
                OutputStream outputStream2;
                block16: {
                    block15: {
                        block14: {
                            if (bl) break block13;
                            if (obj != null) break block14;
                            outputStream2 = outputStream;
                            byArray = string.getBytes();
                            if (bl) break block15;
                            break block16;
                        }
                        outputStream2 = outputStream;
                        byArray = obj.toString().getBytes();
                    }
                    do {
                        outputStream2.write(byArray);
                        outputStream2 = outputStream;
                        byArray = string.getBytes();
                    } while (bl);
                }
                outputStream2.write(byArray);
            }
            if (!bl) continue;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, String string2) throws IOException {
        block21: {
            boolean bl;
            block25: {
                String string3;
                block24: {
                    Collection<?> collection2;
                    boolean bl2 = true;
                    do {
                        block23: {
                            block22: {
                                if (!bl2 || (bl2 = false)) break block22;
                                bl = UIFactory.b;
                                if (bl) break block23;
                                if (string2 != null) {
                                    collection2 = collection;
                                    if (!bl) {
                                        break;
                                    }
                                } else {
                                    collection2 = collection;
                                }
                            }
                            IOUtils.writeLines(collection2, string, outputStream);
                        }
                        if (!bl) break block21;
                        collection2 = collection;
                    } while (bl);
                    if (collection2 == null) {
                        return;
                    }
                    string3 = string;
                    if (bl || bl) break block24;
                    if (string3 != null) break block25;
                    string3 = LINE_SEPARATOR;
                }
                string = string3;
            }
            for (Object obj : collection) {
                block26: {
                    byte[] byArray;
                    OutputStream outputStream2;
                    block29: {
                        block28: {
                            block27: {
                                if (bl) break block26;
                                if (obj != null) break block27;
                                outputStream2 = outputStream;
                                byArray = string.getBytes(string2);
                                if (bl) break block28;
                                break block29;
                            }
                            outputStream2 = outputStream;
                            byArray = obj.toString().getBytes(string2);
                        }
                        do {
                            outputStream2.write(byArray);
                            outputStream2 = outputStream;
                            byArray = string.getBytes(string2);
                        } while (bl);
                    }
                    outputStream2.write(byArray);
                }
                if (!bl) continue;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeLines(Collection<?> collection, String string, Writer writer) throws IOException {
        boolean bl;
        block12: {
            String string2;
            block11: {
                bl = UIFactory.b;
                if (collection == null) {
                    return;
                }
                string2 = string;
                if (bl || bl) break block11;
                if (string2 != null) break block12;
                string2 = LINE_SEPARATOR;
            }
            string = string2;
        }
        for (Object obj : collection) {
            block13: {
                String string3;
                Writer writer2;
                block16: {
                    block15: {
                        block14: {
                            if (bl) break block13;
                            if (obj != null) break block14;
                            writer2 = writer;
                            string3 = string;
                            if (bl) break block15;
                            break block16;
                        }
                        writer2 = writer;
                        string3 = obj.toString();
                    }
                    do {
                        writer2.write(string3);
                        writer2 = writer;
                        string3 = string;
                    } while (bl);
                }
                writer2.write(string3);
            }
            if (!bl) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = IOUtils.copyLarge(inputStream, outputStream);
        boolean bl = UIFactory.b;
        long l2 = l - Integer.MAX_VALUE;
        int n = l2 == 0L ? (int)0 : (l2 < 0L ? (int)-1 : 1);
        if (bl) return n;
        if (n > 0) {
            n = -1;
            return n;
        }
        n = (int)l;
        if (!bl) return n;
        return n;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, new byte[4096]);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l;
        block2: {
            long l2 = 0L;
            boolean bl = UIFactory.b;
            int n = 0;
            while (-1 != (n = inputStream.read(byArray))) {
                outputStream.write(byArray, 0, n);
                l = l2 + (long)n;
                if (!bl) {
                    l2 = l;
                    if (!bl) continue;
                }
                break block2;
            }
            l = l2;
        }
        return l;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l, long l2) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, l, l2, new byte[4096]);
    }

    /*
     * Unable to fully structure code
     */
    public static long copyLarge(InputStream var0, OutputStream var1_1, long var2_2, long var4_3, byte[] var6_4) throws IOException {
        block25: {
            block23: {
                block24: {
                    block21: {
                        block22: {
                            var7_5 = UIFactory.b;
                            cfr_temp_0 = var2_2 - 0L;
                            v0 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                            if (var7_5) break block21;
                            if (v0 <= 0) break block22;
                            IOUtils.skipFully(var0, var2_2);
                        }
                        v0 = (cfr_temp_1 = var4_3 - 0L) == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                    }
                    if (var7_5) break block23;
                    if (v0 != false) break block24;
                    v4 = 0L;
lbl25:
                    // 2 sources

                    return v4;
                }
                v0 = var6_4.length;
            }
            var9_7 = var8_6 = v0;
            v4 = var4_3;
            ** while (var7_5)
lbl35:
            // 3 sources

            if (var7_5) break block25;
            if (v4 > 0L) {
            }
            ** GOTO lbl55
            v6 = var4_3;
            block15: while (!var7_5) {
                if (v6 < (long)var8_6) {
                    v8 = var4_3;
                }
                ** GOTO lbl55
                do {
                    var9_7 = (int)v8;
lbl55:
                    // 3 sources

                    v6 = 0L;
                    if (var7_5) continue block15;
                } while (var7_5);
            }
        }
        var11_8 = v6;
        block17: while (true) {
            v10 = var9_7;
            while (v10 > 0 && -1 != (var10_9 = var0.read(var6_4, 0, (int)var9_7))) {
                block26: {
                    var1_1.write(var6_4, 0, var10_9);
                    var11_8 += (long)var10_9;
                    cfr_temp_2 = var4_3 - 0L;
                    v10 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                    if (var7_5) break block26;
                    if (v10 <= 0) continue block17;
                    v10 = (int)Math.min(var4_3 - var11_8, var8_6);
                    if (var7_5) continue;
                }
                var9_7 = v10;
                if (var7_5) break block17;
                continue block17;
            }
            break;
        }
        return (long)var11_8;
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        IOUtils.copy((Reader)inputStreamReader, writer);
    }

    /*
     * Unable to fully structure code
     */
    public static void copy(InputStream var0, Writer var1_1, String var2_2) throws IOException {
        block6: {
            var3_3 = UIFactory.b;
            if (var3_3) break block6;
            if (var2_2 == null) {
            }
            ** GOTO lbl-1000
            IOUtils.copy(var0, var1_1);
        }
        while (var3_3) lbl-1000:
        // 2 sources

        {
            var4_4 = new InputStreamReader(var0, var2_2);
            if (var3_3) continue;
            IOUtils.copy((Reader)var4_4, var1_1);
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        long l = IOUtils.copyLarge(reader, writer);
        boolean bl = UIFactory.b;
        long l2 = l - Integer.MAX_VALUE;
        int n = l2 == 0L ? (int)0 : (l2 < 0L ? (int)-1 : 1);
        if (bl) return n;
        if (n > 0) {
            n = -1;
            return n;
        }
        n = (int)l;
        if (!bl) return n;
        return n;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        return IOUtils.copyLarge(reader, writer, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) throws IOException {
        long l;
        block2: {
            long l2 = 0L;
            boolean bl = UIFactory.b;
            int n = 0;
            while (-1 != (n = reader.read(cArray))) {
                writer.write(cArray, 0, n);
                l = l2 + (long)n;
                if (!bl) {
                    l2 = l;
                    if (!bl) continue;
                }
                break block2;
            }
            l = l2;
        }
        return l;
    }

    public static long copyLarge(Reader reader, Writer writer, long l, long l2) throws IOException {
        return IOUtils.copyLarge(reader, writer, l, l2, new char[4096]);
    }

    /*
     * Unable to fully structure code
     */
    public static long copyLarge(Reader var0, Writer var1_1, long var2_2, long var4_3, char[] var6_4) throws IOException {
        block25: {
            block23: {
                block24: {
                    block21: {
                        block22: {
                            var7_5 = UIFactory.b;
                            cfr_temp_0 = var2_2 - 0L;
                            v0 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                            if (var7_5) break block21;
                            if (v0 <= 0) break block22;
                            IOUtils.skipFully(var0, var2_2);
                        }
                        v0 = (cfr_temp_1 = var4_3 - 0L) == 0L ? 0 : (cfr_temp_1 < 0L ? -1 : 1);
                    }
                    if (var7_5) break block23;
                    if (v0 != false) break block24;
                    v4 = 0L;
lbl25:
                    // 2 sources

                    return v4;
                }
                v0 = var6_4.length;
            }
            var8_6 = v0;
            v4 = var4_3;
            ** while (var7_5)
lbl35:
            // 3 sources

            if (var7_5) break block25;
            if (v4 > 0L) {
            }
            ** GOTO lbl55
            v6 = var4_3;
            block15: while (!var7_5) {
                if (v6 < (long)var6_4.length) {
                    v8 = var4_3;
                }
                ** GOTO lbl55
                do {
                    var8_6 = (int)v8;
lbl55:
                    // 3 sources

                    v6 = 0L;
                    if (var7_5) continue block15;
                } while (var7_5);
            }
        }
        var10_7 = v6;
        block17: while (true) {
            v10 = var8_6;
            while (v10 > 0 && -1 != (var9_8 = var0.read(var6_4, 0, (int)var8_6))) {
                block26: {
                    var1_1.write(var6_4, 0, var9_8);
                    var10_7 += (long)var9_8;
                    cfr_temp_2 = var4_3 - 0L;
                    v10 = cfr_temp_2 == 0L ? 0 : (cfr_temp_2 < 0L ? -1 : 1);
                    if (var7_5) break block26;
                    if (v10 <= 0) continue block17;
                    v10 = (int)Math.min(var4_3 - var10_7, (long)var6_4.length);
                    if (var7_5) continue;
                }
                var8_6 = v10;
                if (var7_5) break block17;
                continue block17;
            }
            break;
        }
        return (long)var10_7;
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void copy(Reader var0, OutputStream var1_1, String var2_2) throws IOException {
        block6: {
            var3_3 = UIFactory.b;
            if (var3_3) break block6;
            if (var2_2 == null) {
            }
            ** GOTO lbl-1000
            IOUtils.copy(var0, var1_1);
        }
        while (var3_3) lbl-1000:
        // 2 sources

        {
            var4_4 = new OutputStreamWriter(var1_1, var2_2);
            IOUtils.copy(var0, (Writer)var4_4);
            if (var3_3) continue;
            var4_4.flush();
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        int n2;
        block18: {
            int n3;
            int n4;
            boolean bl;
            block15: {
                int n5;
                block16: {
                    block13: {
                        block14: {
                            bl = UIFactory.b;
                            n5 = inputStream instanceof BufferedInputStream;
                            if (bl) break block13;
                            if (n5 != 0) break block14;
                            inputStream = new BufferedInputStream(inputStream);
                        }
                        n5 = inputStream2 instanceof BufferedInputStream;
                    }
                    if (bl) break block15;
                    if (n5 != 0) break block16;
                    inputStream2 = new BufferedInputStream(inputStream2);
                }
                n5 = n4 = inputStream.read();
            }
            while (-1 != n4) {
                int n6;
                block17: {
                    block19: {
                        n3 = inputStream2.read();
                        n6 = n4;
                        if (bl) break block17;
                        n2 = n3;
                        if (bl) break block18;
                        if (n6 == n2) break block19;
                        return 0 != 0;
                    }
                    n6 = inputStream.read();
                    if (bl) return n6 != 0;
                }
                n4 = n6;
                if (!bl) continue;
            }
            n3 = inputStream2.read();
            n = n3;
            if (bl) return n != 0;
            if (bl) return n != 0;
            n2 = -1;
        }
        if (n != n2) return 0 != 0;
        return 1 != 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        int n;
        int n2;
        block10: {
            void var3_3;
            reader = IOUtils.toBufferedReader(reader);
            reader2 = IOUtils.toBufferedReader(reader2);
            int n3 = reader.read();
            boolean bl = UIFactory.b;
            while (-1 != var3_3) {
                int n4;
                block9: {
                    block11: {
                        int n5 = reader2.read();
                        n4 = var3_3;
                        if (bl) break block9;
                        n2 = n5;
                        if (bl) break block10;
                        if (n4 == n2) break block11;
                        return 0 != 0;
                    }
                    n4 = reader.read();
                    if (bl) return n4 != 0;
                }
                var3_3 = n4;
                if (!bl) continue;
            }
            int n6 = reader2.read();
            n = n6;
            if (bl) return n != 0;
            if (bl) return n != 0;
            n2 = -1;
        }
        if (n != n2) return 0 != 0;
        return 1 != 0;
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEqualsIgnoreEOL(Reader var0, Reader var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long skip(InputStream inputStream, long l) throws IOException {
        long l2;
        long l3;
        block20: {
            boolean bl;
            block19: {
                byte[] byArray;
                block18: {
                    bl = UIFactory.b;
                    if (l < 0L) {
                        throw new IllegalArgumentException(IOUtils.a(4942, -26501) + l);
                    }
                    byArray = SKIP_BYTE_BUFFER;
                    if (bl || bl) break block18;
                    if (byArray != null) break block19;
                    byArray = new byte[2048];
                }
                SKIP_BYTE_BUFFER = byArray;
            }
            long l4 = l;
            while (l4 > 0L) {
                long l5;
                long l6;
                block21: {
                    long l7;
                    block22: {
                        l7 = inputStream.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(l4, 2048L));
                        l3 = l7;
                        l2 = 0L;
                        if (bl) break block20;
                        if (bl) break block21;
                        if (l3 >= l2) break block22;
                        if (!bl) break;
                    }
                    l6 = l4;
                    l5 = l7;
                }
                l4 = l6 - l5;
                if (!bl) continue;
            }
            l3 = l;
            l2 = l4;
        }
        return l3 - l2;
    }

    public static long skip(Reader reader, long l) throws IOException {
        long l2;
        long l3;
        block20: {
            boolean bl;
            block19: {
                char[] cArray;
                block18: {
                    bl = UIFactory.b;
                    if (l < 0L) {
                        throw new IllegalArgumentException(IOUtils.a(4942, -26501) + l);
                    }
                    cArray = SKIP_CHAR_BUFFER;
                    if (bl || bl) break block18;
                    if (cArray != null) break block19;
                    cArray = new char[2048];
                }
                SKIP_CHAR_BUFFER = cArray;
            }
            long l4 = l;
            while (l4 > 0L) {
                long l5;
                long l6;
                block21: {
                    long l7;
                    block22: {
                        l7 = reader.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(l4, 2048L));
                        l3 = l7;
                        l2 = 0L;
                        if (bl) break block20;
                        if (bl) break block21;
                        if (l3 >= l2) break block22;
                        if (!bl) break;
                    }
                    l6 = l4;
                    l5 = l7;
                }
                l4 = l6 - l5;
                if (!bl) continue;
            }
            l3 = l;
            l2 = l4;
        }
        return l3 - l2;
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        long l2;
        block7: {
            block8: {
                boolean bl = UIFactory.b;
                l2 = l;
                if (bl) break block7;
                if (l2 >= 0L) break block8;
                throw new IllegalArgumentException(IOUtils.a(4940, 17592) + l);
            }
            l2 = IOUtils.skip(inputStream, l);
        }
        long l3 = l2;
        if (l3 != l) {
            throw new EOFException(IOUtils.a(4929, -27321) + l + IOUtils.a(4941, 14151) + l3);
        }
    }

    public static void skipFully(Reader reader, long l) throws IOException {
        long l2 = IOUtils.skip(reader, l);
        if (l2 != l) {
            throw new EOFException(IOUtils.a(4928, -2724) + l + IOUtils.a(4941, 14151) + l2);
        }
    }

    public static int read(Reader reader, char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        block15: {
            int n5;
            boolean bl;
            block13: {
                int n6;
                block14: {
                    bl = UIFactory.b;
                    n6 = n2;
                    if (bl) break block13;
                    if (n6 >= 0) break block14;
                    throw new IllegalArgumentException(IOUtils.a(4936, -5966) + n2);
                }
                n6 = n5 = n2;
            }
            while (n5 > 0) {
                int n7;
                int n8;
                block16: {
                    int n9;
                    block17: {
                        int n10 = n2 - n5;
                        n9 = reader.read(cArray, n + n10, n5);
                        n4 = -1;
                        n3 = n9;
                        if (bl) break block15;
                        if (bl) break block16;
                        if (n4 != n3) break block17;
                        if (!bl) break;
                    }
                    n8 = n5;
                    n7 = n9;
                }
                n5 = n8 - n7;
                if (!bl) continue;
            }
            n4 = n2;
            n3 = n5;
        }
        return n4 - n3;
    }

    public static int read(Reader reader, char[] cArray) throws IOException {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        block15: {
            int n5;
            boolean bl;
            block13: {
                int n6;
                block14: {
                    bl = UIFactory.b;
                    n6 = n2;
                    if (bl) break block13;
                    if (n6 >= 0) break block14;
                    throw new IllegalArgumentException(IOUtils.a(4936, -5966) + n2);
                }
                n6 = n5 = n2;
            }
            while (n5 > 0) {
                int n7;
                int n8;
                block16: {
                    int n9;
                    block17: {
                        int n10 = n2 - n5;
                        n9 = inputStream.read(byArray, n + n10, n5);
                        n4 = -1;
                        n3 = n9;
                        if (bl) break block15;
                        if (bl) break block16;
                        if (n4 != n3) break block17;
                        if (!bl) break;
                    }
                    n8 = n5;
                    n7 = n9;
                }
                n5 = n8 - n7;
                if (!bl) continue;
            }
            n4 = n2;
            n3 = n5;
        }
        return n4 - n3;
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(Reader reader, char[] cArray, int n, int n2) throws IOException {
        int n3 = IOUtils.read(reader, cArray, n, n2);
        if (n3 != n2) {
            throw new EOFException(IOUtils.a(4937, -20047) + n2 + IOUtils.a(4941, 14151) + n3);
        }
    }

    public static void readFully(Reader reader, char[] cArray) throws IOException {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = IOUtils.read(inputStream, byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException(IOUtils.a(4937, -20047) + n2 + IOUtils.a(4941, 14151) + n3);
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        int n;
        Object var6_6;
        String[] stringArray = new String[12];
        int n2 = 0;
        String string = "\r/\u00c1\u00c9\u00f6\u00d0\u00fe\u00a0%p\u00ba\u00e3\u00ed\u001c\u0017;\u0094y~\u0099\u0095\u00159\u00b1X\u0010\u008d\u0096\u00ef\u0010\u00bal\u00fa\fl\u00c9\u00bb\u0092\u00aa\u00bb\u0017\u00cdi\u00dd)\u0004\u001dlP\u00dcS;r\u0080A\u00d1abf#\u00ba\u00b4e\u00f4\u001a\u00e7\u001f\u0080 (\u0001\u00d6\u00db\u0000\u00c4\u00ee\u0010\u00e3\u0091-k\u0005uG\u00b837a\u00d0\u008a\u008a!\t)\u00bb=\u00dd&\u00a8\"c9\u0010rv\u00aed[$\u00c6\u00e6n\u00a5\u0091\u00c2\u00f8g(\u00f6\u00b6\u008d\u0014\u0092\u009e\u0089\u00b0\u00af%\u008f\u009a\u001b2#F^/WpS\u00d8\bJy/\u009c\u00d3\u00b3\u00af\u0015\u0089\u00ab\u000f\u00d9\u00f8\u0011Y7\u00a4\u009f&H(\u00f9U\u00d2p\u00b4?|\u00b0K\u00f8\u00a8\u00a0Z\u000e\u00b1\u00b9\u00e5\u009f\u00c2\u00e5\u00c6$`\u0094\u0088V\u00ef\u00d8\u00a9W\u007f\u00e1W?g\u00be\u00f8\u0016V\u009a\u0080<fW\u00fe\u0088ihqq\u00ed\u0016\u00b8\u0011\u00ec\u00f8\"\u00f1\tPZ\u00b7\u0085\u00fb\u00d0\u00f5j\u00ef\u0002\u00f5j)\u0001\u00e1\u0099\u00eaQ\u0002F\u00f4\u00f7Y\u0091\u001d\u00c72\u00aaj\u0091\r(\u00d4n?\u0006K\u00d9C}} \u00d6\u00b6a:\u00dc\u0017E3\u00157\u00d3\u00bf";
        int n3 = "\r/\u00c1\u00c9\u00f6\u00d0\u00fe\u00a0%p\u00ba\u00e3\u00ed\u001c\u0017;\u0094y~\u0099\u0095\u00159\u00b1X\u0010\u008d\u0096\u00ef\u0010\u00bal\u00fa\fl\u00c9\u00bb\u0092\u00aa\u00bb\u0017\u00cdi\u00dd)\u0004\u001dlP\u00dcS;r\u0080A\u00d1abf#\u00ba\u00b4e\u00f4\u001a\u00e7\u001f\u0080 (\u0001\u00d6\u00db\u0000\u00c4\u00ee\u0010\u00e3\u0091-k\u0005uG\u00b837a\u00d0\u008a\u008a!\t)\u00bb=\u00dd&\u00a8\"c9\u0010rv\u00aed[$\u00c6\u00e6n\u00a5\u0091\u00c2\u00f8g(\u00f6\u00b6\u008d\u0014\u0092\u009e\u0089\u00b0\u00af%\u008f\u009a\u001b2#F^/WpS\u00d8\bJy/\u009c\u00d3\u00b3\u00af\u0015\u0089\u00ab\u000f\u00d9\u00f8\u0011Y7\u00a4\u009f&H(\u00f9U\u00d2p\u00b4?|\u00b0K\u00f8\u00a8\u00a0Z\u000e\u00b1\u00b9\u00e5\u009f\u00c2\u00e5\u00c6$`\u0094\u0088V\u00ef\u00d8\u00a9W\u007f\u00e1W?g\u00be\u00f8\u0016V\u009a\u0080<fW\u00fe\u0088ihqq\u00ed\u0016\u00b8\u0011\u00ec\u00f8\"\u00f1\tPZ\u00b7\u0085\u00fb\u00d0\u00f5j\u00ef\u0002\u00f5j)\u0001\u00e1\u0099\u00eaQ\u0002F\u00f4\u00f7Y\u0091\u001d\u00c72\u00aaj\u0091\r(\u00d4n?\u0006K\u00d9C}} \u00d6\u00b6a:\u00dc\u0017E3\u00157\u00d3\u00bf".length();
        int n4 = 33;
        int n5 = -1;
        while (true) {
            char[] cArray;
            block26: {
                int n6;
                int n7;
                char[] cArray2;
                block25: {
                    int n8 = ++n5;
                    var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n4).toCharArray();
                    n = 0;
                    int n9 = cArray3.length;
                    cArray2 = cArray3;
                    n7 = n9;
                    if (n9 <= 1) break block25;
                    cArray = cArray2;
                    n6 = n7;
                    if (n7 <= n) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n10 = n;
                    while (true) {
                        int n11;
                        char c = cArray4[n10];
                        switch (n % 7) {
                            case 0: {
                                n11 = 12;
                                break;
                            }
                            case 1: {
                                n11 = 87;
                                break;
                            }
                            case 2: {
                                n11 = 123;
                                break;
                            }
                            case 3: {
                                n11 = 29;
                                break;
                            }
                            case 4: {
                                n11 = 24;
                                break;
                            }
                            case 5: {
                                n11 = 88;
                                break;
                            }
                            default: {
                                n11 = 62;
                            }
                        }
                        cArray4[n10] = (char)(c ^ n11);
                        ++n;
                        cArray2 = cArray5;
                        n7 = n7;
                        if (n7 != 0) break;
                        cArray5 = cArray2;
                        n6 = n7;
                        n10 = n7;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n6 = n7;
                } while (n7 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) break;
            n4 = string.charAt(n5);
        }
        string = "k\u0082\u00dd\u00b0\u00f2\u00f1\nr\u000bE\u00d9\u00ab\u00b66\u008f\u000f\u001e\u00b0G\u00d2\u0016H\u0096E\u0098\u00a3\u00abw\u00f8\u00adF";
        n3 = "k\u0082\u00dd\u00b0\u00f2\u00f1\nr\u000bE\u00d9\u00ab\u00b66\u008f\u000f\u001e\u00b0G\u00d2\u0016H\u0096E\u0098\u00a3\u00abw\u00f8\u00adF".length();
        n4 = 15;
        n5 = -1;
        while (true) {
            char[] cArray;
            block28: {
                int n12;
                int n13;
                char[] cArray6;
                block27: {
                    int n14 = ++n5;
                    var6_6 = null;
                    char[] cArray7 = string.substring(n14, n14 + n4).toCharArray();
                    n = 0;
                    int n15 = cArray7.length;
                    cArray6 = cArray7;
                    n13 = n15;
                    if (n15 <= 1) break block27;
                    cArray = cArray6;
                    n12 = n13;
                    if (n13 <= n) break block28;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n16 = n;
                    while (true) {
                        int n17;
                        char c = cArray8[n16];
                        switch (n % 7) {
                            case 0: {
                                n17 = 12;
                                break;
                            }
                            case 1: {
                                n17 = 87;
                                break;
                            }
                            case 2: {
                                n17 = 123;
                                break;
                            }
                            case 3: {
                                n17 = 29;
                                break;
                            }
                            case 4: {
                                n17 = 24;
                                break;
                            }
                            case 5: {
                                n17 = 88;
                                break;
                            }
                            default: {
                                n17 = 62;
                            }
                        }
                        cArray8[n16] = (char)(c ^ n17);
                        ++n;
                        cArray6 = cArray9;
                        n13 = n13;
                        if (n13 != 0) break;
                        cArray9 = cArray6;
                        n12 = n13;
                        n16 = n13;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n12 = n13;
                } while (n13 > n);
            }
            stringArray[n2++] = new String(cArray).intern();
            if ((n5 += n4) >= n3) {
                a = stringArray;
                b = new String[12];
                LINE_SEPARATOR_WINDOWS = IOUtils.a(4930, -10862);
                DIR_SEPARATOR = File.separatorChar;
                StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(4);
                PrintWriter printWriter = new PrintWriter(stringBuilderWriter);
                printWriter.println();
                LINE_SEPARATOR = stringBuilderWriter.toString();
                printWriter.close();
                return;
            }
            n4 = string.charAt(n5);
        }
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x134A) & 0xFFFF;
        if (b[n3] == null) {
            int n4;
            int n5;
            char[] cArray = a[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 18;
                    break;
                }
                case 1: {
                    n5 = 60;
                    break;
                }
                case 2: {
                    n5 = 50;
                    break;
                }
                case 3: {
                    n5 = 146;
                    break;
                }
                case 4: {
                    n5 = 241;
                    break;
                }
                case 5: {
                    n5 = 10;
                    break;
                }
                case 6: {
                    n5 = 74;
                    break;
                }
                case 7: {
                    n5 = 226;
                    break;
                }
                case 8: {
                    n5 = 196;
                    break;
                }
                case 9: {
                    n5 = 77;
                    break;
                }
                case 10: {
                    n5 = 188;
                    break;
                }
                case 11: {
                    n5 = 166;
                    break;
                }
                case 12: {
                    n5 = 232;
                    break;
                }
                case 13: {
                    n5 = 84;
                    break;
                }
                case 14: {
                    n5 = 178;
                    break;
                }
                case 15: {
                    n5 = 62;
                    break;
                }
                case 16: {
                    n5 = 227;
                    break;
                }
                case 17: {
                    n5 = 51;
                    break;
                }
                case 18: {
                    n5 = 247;
                    break;
                }
                case 19: {
                    n5 = 173;
                    break;
                }
                case 20: {
                    n5 = 202;
                    break;
                }
                case 21: {
                    n5 = 122;
                    break;
                }
                case 22: {
                    n5 = 144;
                    break;
                }
                case 23: {
                    n5 = 215;
                    break;
                }
                case 24: {
                    n5 = 105;
                    break;
                }
                case 25: {
                    n5 = 129;
                    break;
                }
                case 26: {
                    n5 = 67;
                    break;
                }
                case 27: {
                    n5 = 87;
                    break;
                }
                case 28: {
                    n5 = 0;
                    break;
                }
                case 29: {
                    n5 = 79;
                    break;
                }
                case 30: {
                    n5 = 41;
                    break;
                }
                case 31: {
                    n5 = 91;
                    break;
                }
                case 32: {
                    n5 = 127;
                    break;
                }
                case 33: {
                    n5 = 42;
                    break;
                }
                case 34: {
                    n5 = 195;
                    break;
                }
                case 35: {
                    n5 = 132;
                    break;
                }
                case 36: {
                    n5 = 22;
                    break;
                }
                case 37: {
                    n5 = 223;
                    break;
                }
                case 38: {
                    n5 = 164;
                    break;
                }
                case 39: {
                    n5 = 222;
                    break;
                }
                case 40: {
                    n5 = 194;
                    break;
                }
                case 41: {
                    n5 = 71;
                    break;
                }
                case 42: {
                    n5 = 135;
                    break;
                }
                case 43: {
                    n5 = 201;
                    break;
                }
                case 44: {
                    n5 = 108;
                    break;
                }
                case 45: {
                    n5 = 230;
                    break;
                }
                case 46: {
                    n5 = 175;
                    break;
                }
                case 47: {
                    n5 = 86;
                    break;
                }
                case 48: {
                    n5 = 120;
                    break;
                }
                case 49: {
                    n5 = 5;
                    break;
                }
                case 50: {
                    n5 = 176;
                    break;
                }
                case 51: {
                    n5 = 171;
                    break;
                }
                case 52: {
                    n5 = 219;
                    break;
                }
                case 53: {
                    n5 = 88;
                    break;
                }
                case 54: {
                    n5 = 101;
                    break;
                }
                case 55: {
                    n5 = 205;
                    break;
                }
                case 56: {
                    n5 = 133;
                    break;
                }
                case 57: {
                    n5 = 204;
                    break;
                }
                case 58: {
                    n5 = 186;
                    break;
                }
                case 59: {
                    n5 = 233;
                    break;
                }
                case 60: {
                    n5 = 231;
                    break;
                }
                case 61: {
                    n5 = 190;
                    break;
                }
                case 62: {
                    n5 = 250;
                    break;
                }
                case 63: {
                    n5 = 209;
                    break;
                }
                case 64: {
                    n5 = 208;
                    break;
                }
                case 65: {
                    n5 = 66;
                    break;
                }
                case 66: {
                    n5 = 181;
                    break;
                }
                case 67: {
                    n5 = 182;
                    break;
                }
                case 68: {
                    n5 = 163;
                    break;
                }
                case 69: {
                    n5 = 206;
                    break;
                }
                case 70: {
                    n5 = 100;
                    break;
                }
                case 71: {
                    n5 = 200;
                    break;
                }
                case 72: {
                    n5 = 167;
                    break;
                }
                case 73: {
                    n5 = 76;
                    break;
                }
                case 74: {
                    n5 = 1;
                    break;
                }
                case 75: {
                    n5 = 116;
                    break;
                }
                case 76: {
                    n5 = 26;
                    break;
                }
                case 77: {
                    n5 = 145;
                    break;
                }
                case 78: {
                    n5 = 106;
                    break;
                }
                case 79: {
                    n5 = 174;
                    break;
                }
                case 80: {
                    n5 = 183;
                    break;
                }
                case 81: {
                    n5 = 99;
                    break;
                }
                case 82: {
                    n5 = 155;
                    break;
                }
                case 83: {
                    n5 = 150;
                    break;
                }
                case 84: {
                    n5 = 78;
                    break;
                }
                case 85: {
                    n5 = 143;
                    break;
                }
                case 86: {
                    n5 = 95;
                    break;
                }
                case 87: {
                    n5 = 159;
                    break;
                }
                case 88: {
                    n5 = 126;
                    break;
                }
                case 89: {
                    n5 = 123;
                    break;
                }
                case 90: {
                    n5 = 3;
                    break;
                }
                case 91: {
                    n5 = 109;
                    break;
                }
                case 92: {
                    n5 = 203;
                    break;
                }
                case 93: {
                    n5 = 152;
                    break;
                }
                case 94: {
                    n5 = 137;
                    break;
                }
                case 95: {
                    n5 = 115;
                    break;
                }
                case 96: {
                    n5 = 134;
                    break;
                }
                case 97: {
                    n5 = 16;
                    break;
                }
                case 98: {
                    n5 = 113;
                    break;
                }
                case 99: {
                    n5 = 213;
                    break;
                }
                case 100: {
                    n5 = 254;
                    break;
                }
                case 101: {
                    n5 = 224;
                    break;
                }
                case 102: {
                    n5 = 40;
                    break;
                }
                case 103: {
                    n5 = 56;
                    break;
                }
                case 104: {
                    n5 = 61;
                    break;
                }
                case 105: {
                    n5 = 253;
                    break;
                }
                case 106: {
                    n5 = 64;
                    break;
                }
                case 107: {
                    n5 = 218;
                    break;
                }
                case 108: {
                    n5 = 138;
                    break;
                }
                case 109: {
                    n5 = 217;
                    break;
                }
                case 110: {
                    n5 = 220;
                    break;
                }
                case 111: {
                    n5 = 156;
                    break;
                }
                case 112: {
                    n5 = 45;
                    break;
                }
                case 113: {
                    n5 = 104;
                    break;
                }
                case 114: {
                    n5 = 102;
                    break;
                }
                case 115: {
                    n5 = 44;
                    break;
                }
                case 116: {
                    n5 = 47;
                    break;
                }
                case 117: {
                    n5 = 240;
                    break;
                }
                case 118: {
                    n5 = 70;
                    break;
                }
                case 119: {
                    n5 = 239;
                    break;
                }
                case 120: {
                    n5 = 238;
                    break;
                }
                case 121: {
                    n5 = 139;
                    break;
                }
                case 122: {
                    n5 = 236;
                    break;
                }
                case 123: {
                    n5 = 111;
                    break;
                }
                case 124: {
                    n5 = 52;
                    break;
                }
                case 125: {
                    n5 = 192;
                    break;
                }
                case 126: {
                    n5 = 57;
                    break;
                }
                case 127: {
                    n5 = 24;
                    break;
                }
                case 128: {
                    n5 = 193;
                    break;
                }
                case 129: {
                    n5 = 68;
                    break;
                }
                case 130: {
                    n5 = 35;
                    break;
                }
                case 131: {
                    n5 = 184;
                    break;
                }
                case 132: {
                    n5 = 130;
                    break;
                }
                case 133: {
                    n5 = 125;
                    break;
                }
                case 134: {
                    n5 = 212;
                    break;
                }
                case 135: {
                    n5 = 83;
                    break;
                }
                case 136: {
                    n5 = 65;
                    break;
                }
                case 137: {
                    n5 = 19;
                    break;
                }
                case 138: {
                    n5 = 243;
                    break;
                }
                case 139: {
                    n5 = 29;
                    break;
                }
                case 140: {
                    n5 = 32;
                    break;
                }
                case 141: {
                    n5 = 141;
                    break;
                }
                case 142: {
                    n5 = 63;
                    break;
                }
                case 143: {
                    n5 = 147;
                    break;
                }
                case 144: {
                    n5 = 118;
                    break;
                }
                case 145: {
                    n5 = 21;
                    break;
                }
                case 146: {
                    n5 = 244;
                    break;
                }
                case 147: {
                    n5 = 117;
                    break;
                }
                case 148: {
                    n5 = 198;
                    break;
                }
                case 149: {
                    n5 = 153;
                    break;
                }
                case 150: {
                    n5 = 165;
                    break;
                }
                case 151: {
                    n5 = 58;
                    break;
                }
                case 152: {
                    n5 = 136;
                    break;
                }
                case 153: {
                    n5 = 33;
                    break;
                }
                case 154: {
                    n5 = 207;
                    break;
                }
                case 155: {
                    n5 = 255;
                    break;
                }
                case 156: {
                    n5 = 252;
                    break;
                }
                case 157: {
                    n5 = 237;
                    break;
                }
                case 158: {
                    n5 = 97;
                    break;
                }
                case 159: {
                    n5 = 9;
                    break;
                }
                case 160: {
                    n5 = 114;
                    break;
                }
                case 161: {
                    n5 = 214;
                    break;
                }
                case 162: {
                    n5 = 59;
                    break;
                }
                case 163: {
                    n5 = 39;
                    break;
                }
                case 164: {
                    n5 = 55;
                    break;
                }
                case 165: {
                    n5 = 210;
                    break;
                }
                case 166: {
                    n5 = 197;
                    break;
                }
                case 167: {
                    n5 = 199;
                    break;
                }
                case 168: {
                    n5 = 25;
                    break;
                }
                case 169: {
                    n5 = 31;
                    break;
                }
                case 170: {
                    n5 = 46;
                    break;
                }
                case 171: {
                    n5 = 187;
                    break;
                }
                case 172: {
                    n5 = 80;
                    break;
                }
                case 173: {
                    n5 = 23;
                    break;
                }
                case 174: {
                    n5 = 234;
                    break;
                }
                case 175: {
                    n5 = 245;
                    break;
                }
                case 176: {
                    n5 = 142;
                    break;
                }
                case 177: {
                    n5 = 221;
                    break;
                }
                case 178: {
                    n5 = 228;
                    break;
                }
                case 179: {
                    n5 = 119;
                    break;
                }
                case 180: {
                    n5 = 7;
                    break;
                }
                case 181: {
                    n5 = 2;
                    break;
                }
                case 182: {
                    n5 = 121;
                    break;
                }
                case 183: {
                    n5 = 151;
                    break;
                }
                case 184: {
                    n5 = 93;
                    break;
                }
                case 185: {
                    n5 = 82;
                    break;
                }
                case 186: {
                    n5 = 229;
                    break;
                }
                case 187: {
                    n5 = 246;
                    break;
                }
                case 188: {
                    n5 = 170;
                    break;
                }
                case 189: {
                    n5 = 30;
                    break;
                }
                case 190: {
                    n5 = 81;
                    break;
                }
                case 191: {
                    n5 = 69;
                    break;
                }
                case 192: {
                    n5 = 157;
                    break;
                }
                case 193: {
                    n5 = 189;
                    break;
                }
                case 194: {
                    n5 = 216;
                    break;
                }
                case 195: {
                    n5 = 124;
                    break;
                }
                case 196: {
                    n5 = 169;
                    break;
                }
                case 197: {
                    n5 = 98;
                    break;
                }
                case 198: {
                    n5 = 248;
                    break;
                }
                case 199: {
                    n5 = 162;
                    break;
                }
                case 200: {
                    n5 = 179;
                    break;
                }
                case 201: {
                    n5 = 37;
                    break;
                }
                case 202: {
                    n5 = 172;
                    break;
                }
                case 203: {
                    n5 = 89;
                    break;
                }
                case 204: {
                    n5 = 168;
                    break;
                }
                case 205: {
                    n5 = 38;
                    break;
                }
                case 206: {
                    n5 = 90;
                    break;
                }
                case 207: {
                    n5 = 160;
                    break;
                }
                case 208: {
                    n5 = 15;
                    break;
                }
                case 209: {
                    n5 = 4;
                    break;
                }
                case 210: {
                    n5 = 72;
                    break;
                }
                case 211: {
                    n5 = 249;
                    break;
                }
                case 212: {
                    n5 = 103;
                    break;
                }
                case 213: {
                    n5 = 34;
                    break;
                }
                case 214: {
                    n5 = 235;
                    break;
                }
                case 215: {
                    n5 = 27;
                    break;
                }
                case 216: {
                    n5 = 53;
                    break;
                }
                case 217: {
                    n5 = 191;
                    break;
                }
                case 218: {
                    n5 = 75;
                    break;
                }
                case 219: {
                    n5 = 251;
                    break;
                }
                case 220: {
                    n5 = 149;
                    break;
                }
                case 221: {
                    n5 = 17;
                    break;
                }
                case 222: {
                    n5 = 225;
                    break;
                }
                case 223: {
                    n5 = 154;
                    break;
                }
                case 224: {
                    n5 = 36;
                    break;
                }
                case 225: {
                    n5 = 180;
                    break;
                }
                case 226: {
                    n5 = 13;
                    break;
                }
                case 227: {
                    n5 = 131;
                    break;
                }
                case 228: {
                    n5 = 110;
                    break;
                }
                case 229: {
                    n5 = 161;
                    break;
                }
                case 230: {
                    n5 = 242;
                    break;
                }
                case 231: {
                    n5 = 85;
                    break;
                }
                case 232: {
                    n5 = 92;
                    break;
                }
                case 233: {
                    n5 = 94;
                    break;
                }
                case 234: {
                    n5 = 54;
                    break;
                }
                case 235: {
                    n5 = 20;
                    break;
                }
                case 236: {
                    n5 = 11;
                    break;
                }
                case 237: {
                    n5 = 6;
                    break;
                }
                case 238: {
                    n5 = 107;
                    break;
                }
                case 239: {
                    n5 = 14;
                    break;
                }
                case 240: {
                    n5 = 28;
                    break;
                }
                case 241: {
                    n5 = 96;
                    break;
                }
                case 242: {
                    n5 = 148;
                    break;
                }
                case 243: {
                    n5 = 185;
                    break;
                }
                case 244: {
                    n5 = 12;
                    break;
                }
                case 245: {
                    n5 = 49;
                    break;
                }
                case 246: {
                    n5 = 8;
                    break;
                }
                case 247: {
                    n5 = 73;
                    break;
                }
                case 248: {
                    n5 = 43;
                    break;
                }
                case 249: {
                    n5 = 158;
                    break;
                }
                case 250: {
                    n5 = 211;
                    break;
                }
                case 251: {
                    n5 = 177;
                    break;
                }
                case 252: {
                    n5 = 48;
                    break;
                }
                case 253: {
                    n5 = 128;
                    break;
                }
                case 254: {
                    n5 = 140;
                    break;
                }
                default: {
                    n5 = 112;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            IOUtils.b[n3] = new String(cArray).intern();
        }
        return b[n3];
    }
}

